/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avdmanager;

import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.devices.Storage;
import com.android.sdklib.internal.avd.EmulatorPackage;
import com.android.sdklib.internal.avd.EmulatorPackages;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.avdmanager.AccelerationErrorCode;
import com.android.tools.idea.avdmanager.EmulatorAccelerationChecks;
import com.android.tools.idea.memorysettings.MemorySettingsUtil;
import com.android.tools.idea.progress.StudioLoggerProgressIndicator;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingAnsiEscapesAwareProcessHandler;
import com.intellij.openapi.diagnostic.Logger;
import java.nio.file.Path;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0003H\u0002\u001a\f\u0010\u0006\u001a\u00020\u0005*\u00020\u0003H\u0002\"\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\f\u001a\n \u000b*\u0004\u0018\u00010\n0\n8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"checkAcceleration", "Lcom/android/tools/idea/avdmanager/AccelerationErrorCode;", "sdk", "Lcom/android/sdklib/repository/AndroidSdkHandler;", "hasPlatformToolsForQemu2Installed", "", "hasSystemImagesForQemu2Installed", "progressIndicator", "Lcom/android/tools/idea/progress/StudioLoggerProgressIndicator;", "PLATFORM_TOOLS_REVISION_WITH_FIRST_QEMU2", "Lcom/android/repository/Revision;", "kotlin.jvm.PlatformType", "MINIMUM_EMULATOR_VERSION", "intellij.android.core"})
@JvmName(name="EmulatorAccelerationCheck")
@SourceDebugExtension(value={"SMAP\nEmulatorAccelerationCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmulatorAccelerationCheck.kt\ncom/android/tools/idea/avdmanager/EmulatorAccelerationCheck\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,96:1\n14#2:97\n*S KotlinDebug\n*F\n+ 1 EmulatorAccelerationCheck.kt\ncom/android/tools/idea/avdmanager/EmulatorAccelerationCheck\n*L\n64#1:97\n*E\n"})
public final class EmulatorAccelerationCheck {
    @NotNull
    private static final StudioLoggerProgressIndicator progressIndicator = new StudioLoggerProgressIndicator(EmulatorAccelerationChecks.class);
    private static final Revision PLATFORM_TOOLS_REVISION_WITH_FIRST_QEMU2 = Revision.parseRevision((String)"23.1.0");
    @JvmField
    public static final Revision MINIMUM_EMULATOR_VERSION = Revision.parseRevision((String)"35.6.11");

    @NotNull
    public static final AccelerationErrorCode checkAcceleration(@NotNull AndroidSdkHandler sdk) {
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        EmulatorPackage emulator = EmulatorPackages.getEmulatorPackage((AndroidSdkHandler)sdk, (ProgressIndicator)((ProgressIndicator)progressIndicator));
        Object object = emulator;
        if (object == null || (object = object.getEmulatorBinary()) == null) {
            return AccelerationErrorCode.NO_EMULATOR_INSTALLED;
        }
        Object emulatorBinary = object;
        if (emulator.getVersion().compareTo(MINIMUM_EMULATOR_VERSION) < 0) {
            return AccelerationErrorCode.EMULATOR_UPDATE_REQUIRED;
        }
        Long memoryBytes = MemorySettingsUtil.getMachineMemoryBytes();
        if (memoryBytes != null && memoryBytes < Storage.Unit.GiB.getNumberOfBytes()) {
            return AccelerationErrorCode.NOT_ENOUGH_MEMORY;
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        Path checkBinary = emulator.getEmulatorCheckBinary();
        if (checkBinary != null) {
            commandLine.setExePath(((Object)checkBinary).toString());
            commandLine.addParameter("accel");
        } else {
            commandLine.setExePath(emulatorBinary.toString());
            commandLine.addParameter("-accel-check");
        }
        try {
            int exitCode2 = new CapturingAnsiEscapesAwareProcessHandler(commandLine).runProcess().getExitCode();
            if (exitCode2 != 0) {
                AccelerationErrorCode accelerationErrorCode = AccelerationErrorCode.fromExitCode(exitCode2);
                Intrinsics.checkNotNullExpressionValue((Object)((Object)accelerationErrorCode), (String)"fromExitCode(...)");
                return accelerationErrorCode;
            }
        }
        catch (ExecutionException e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(EmulatorAccelerationChecks.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn((Throwable)e);
            return AccelerationErrorCode.UNKNOWN_ERROR;
        }
        if (!EmulatorAccelerationCheck.hasPlatformToolsForQemu2Installed(sdk)) {
            return AccelerationErrorCode.PLATFORM_TOOLS_UPDATE_ADVISED;
        }
        if (!EmulatorAccelerationCheck.hasSystemImagesForQemu2Installed(sdk)) {
            return AccelerationErrorCode.SYSTEM_IMAGE_UPDATE_ADVISED;
        }
        return AccelerationErrorCode.ALREADY_INSTALLED;
    }

    private static final boolean hasPlatformToolsForQemu2Installed(AndroidSdkHandler $this$hasPlatformToolsForQemu2Installed) {
        LocalPackage localPackage = $this$hasPlatformToolsForQemu2Installed.getLocalPackage("platform-tools", (ProgressIndicator)progressIndicator);
        if (localPackage == null) {
            return false;
        }
        LocalPackage platformTools = localPackage;
        return platformTools.getVersion().compareTo(PLATFORM_TOOLS_REVISION_WITH_FIRST_QEMU2) >= 0;
    }

    private static final boolean hasSystemImagesForQemu2Installed(AndroidSdkHandler $this$hasSystemImagesForQemu2Installed) {
        EmulatorPackage emulatorPackage = EmulatorPackages.getEmulatorPackage((AndroidSdkHandler)$this$hasSystemImagesForQemu2Installed, (ProgressIndicator)((ProgressIndicator)progressIndicator));
        if (emulatorPackage == null) {
            return false;
        }
        EmulatorPackage emulator = emulatorPackage;
        Collection images = $this$hasSystemImagesForQemu2Installed.getSystemImageManager((ProgressIndicator)progressIndicator).getImages();
        return images.stream().noneMatch(emulator.getSystemImageUpdateRequiredPredicate());
    }
}

