/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.avd;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.avdmanager.SkinUtils;
import java.nio.file.Path;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0004\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/avd/DeviceSkinResolver;", "", "<init>", "()V", "resolve", "Ljava/nio/file/Path;", "deviceSkin", "imageSkins", "", "sdk", "deviceArtResources", "convertWearOsFileName", "intellij.android.avd"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nDeviceSkinResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceSkinResolver.kt\ncom/android/tools/idea/avd/DeviceSkinResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n1#2:72\n*E\n"})
public final class DeviceSkinResolver {
    @NotNull
    public static final DeviceSkinResolver INSTANCE = new DeviceSkinResolver();
    public static final int $stable;

    private DeviceSkinResolver() {
    }

    @NotNull
    public final Path resolve(@NotNull Path deviceSkin, @NotNull Iterable<? extends Path> imageSkins, @Nullable Path sdk, @Nullable Path deviceArtResources) {
        Path path;
        Path path2;
        block9: {
            Intrinsics.checkNotNullParameter((Object)deviceSkin, (String)"deviceSkin");
            Intrinsics.checkNotNullParameter(imageSkins, (String)"imageSkins");
            if (deviceSkin.isAbsolute()) {
                return deviceSkin;
            }
            if (Intrinsics.areEqual((Object)deviceSkin, (Object)Path.of("", new String[0]))) {
                return deviceSkin;
            }
            if (Intrinsics.areEqual((Object)deviceSkin, (Object)SkinUtils.noSkin())) {
                return deviceSkin;
            }
            Iterable<? extends Path> iterable = imageSkins;
            Iterator<? extends Path> iterator2 = iterable.iterator();
            while (iterator2.hasNext()) {
                Path path3;
                Path it = path3 = iterator2.next();
                boolean bl = false;
                if (!it.endsWith(deviceSkin)) continue;
                path2 = path3;
                break block9;
            }
            path2 = null;
        }
        Path imageSkin = path2;
        if (imageSkin != null) {
            return imageSkin;
        }
        Path path4 = sdk;
        if (path4 != null) {
            Path path5 = path4.resolve("skins").resolve(deviceSkin);
            path = path5;
            Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"resolve(...)");
        } else {
            Path path6 = deviceArtResources;
            if (path6 != null) {
                Path path7 = path6.resolve(this.convertWearOsFileName(deviceSkin));
                path = path7;
                Intrinsics.checkNotNullExpressionValue((Object)path7, (String)"resolve(...)");
            } else {
                path = deviceSkin;
            }
        }
        return path;
    }

    private final Path convertWearOsFileName(Path deviceSkin) {
        Path path;
        Path path2 = deviceSkin.getFileName();
        if (Intrinsics.areEqual((Object)path2, (Object)Path.of("WearLargeRound", new String[0]))) {
            Path path3 = Path.of("wearos_large_round", new String[0]);
            path = path3;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"of(...)");
        } else if (Intrinsics.areEqual((Object)path2, (Object)Path.of("WearRect", new String[0]))) {
            Path path4 = Path.of("wearos_rect", new String[0]);
            path = path4;
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"of(...)");
        } else if (Intrinsics.areEqual((Object)path2, (Object)Path.of("WearSmallRound", new String[0]))) {
            Path path5 = Path.of("wearos_small_round", new String[0]);
            path = path5;
            Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"of(...)");
        } else if (Intrinsics.areEqual((Object)path2, (Object)Path.of("WearSquare", new String[0]))) {
            Path path6 = Path.of("wearos_square", new String[0]);
            path = path6;
            Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"of(...)");
        } else {
            Path path7 = deviceSkin.getFileName();
            path = path7;
            Intrinsics.checkNotNullExpressionValue((Object)path7, (String)"getFileName(...)");
        }
        return path;
    }
}

