/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.appinspection.inspectors.network.view;

import com.android.tools.adtui.chart.statechart.StateChart;
import com.android.tools.adtui.chart.statechart.StateChartColorProvider;
import com.android.tools.adtui.common.EnumColors;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.DefaultDataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.StateChartModel;
import com.android.tools.idea.appinspection.inspectors.network.model.connections.ConnectionData;
import com.android.tools.idea.appinspection.inspectors.network.view.NetworkState;
import com.android.tools.idea.appinspection.inspectors.network.view.constants.ColorsKt;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u001e\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0019\b\u0016\u0012\u0006\u0010\t\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\nJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J$\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\u00132\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u001b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002R$\u0010\u000b\u001a\u0015\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r0\f\u00a2\u0006\u0002\b\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/appinspection/inspectors/network/view/ConnectionsStateChart;", "", "dataList", "", "Lcom/android/tools/idea/appinspection/inspectors/network/model/connections/ConnectionData;", "range", "Lcom/android/tools/adtui/model/Range;", "<init>", "(Ljava/util/List;Lcom/android/tools/adtui/model/Range;)V", "data", "(Lcom/android/tools/idea/appinspection/inspectors/network/model/connections/ConnectionData;Lcom/android/tools/adtui/model/Range;)V", "colors", "Lcom/android/tools/adtui/common/EnumColors;", "Lcom/android/tools/idea/appinspection/inspectors/network/view/NetworkState;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getColors", "()Lcom/android/tools/adtui/common/EnumColors;", "component", "Lcom/android/tools/adtui/chart/statechart/StateChart;", "getComponent", "()Lcom/android/tools/adtui/chart/statechart/StateChart;", "setHeightGap", "", "gap", "", "createChart", "", "app-inspection.inspectors.network.view"})
public final class ConnectionsStateChart {
    @NotNull
    private final EnumColors<NetworkState> colors;
    @NotNull
    private final StateChart<NetworkState> component;

    public ConnectionsStateChart(@NotNull List<? extends ConnectionData> dataList, @NotNull Range range) {
        Intrinsics.checkNotNullParameter(dataList, (String)"dataList");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Color[] colorArray = new Color[]{ColorsKt.getNETWORK_SENDING_COLOR(), ColorsKt.getNETWORK_SENDING_COLOR()};
        EnumColors.Builder builder = new EnumColors.Builder(2).add((Enum)NetworkState.SENDING, colorArray);
        colorArray = new Color[]{ColorsKt.getNETWORK_RECEIVING_COLOR(), ColorsKt.getNETWORK_RECEIVING_SELECTED_COLOR()};
        EnumColors.Builder builder2 = builder.add((Enum)NetworkState.RECEIVING, colorArray);
        colorArray = new Color[]{ColorsKt.getNETWORK_WAITING_COLOR(), ColorsKt.getNETWORK_WAITING_COLOR()};
        EnumColors.Builder builder3 = builder2.add((Enum)NetworkState.WAITING, colorArray);
        colorArray = new Color[]{ColorsKt.getTRANSPARENT_COLOR(), ColorsKt.getTRANSPARENT_COLOR()};
        EnumColors enumColors = builder3.add((Enum)NetworkState.NONE, colorArray).build();
        Intrinsics.checkNotNullExpressionValue((Object)enumColors, (String)"build(...)");
        this.colors = enumColors;
        this.component = this.createChart((Collection<? extends ConnectionData>)dataList, range);
    }

    public ConnectionsStateChart(@NotNull ConnectionData data2, @NotNull Range range) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        this(CollectionsKt.listOf((Object)data2), range);
    }

    @NotNull
    public final EnumColors<NetworkState> getColors() {
        return this.colors;
    }

    @NotNull
    public final StateChart<NetworkState> getComponent() {
        return this.component;
    }

    public final void setHeightGap(float gap) {
        this.component.setHeightGap(gap);
    }

    private final StateChart<NetworkState> createChart(Collection<? extends ConnectionData> dataList, Range range) {
        DefaultDataSeries series = new DefaultDataSeries();
        series.add(0L, (Object)NetworkState.NONE);
        for (ConnectionData connectionData : dataList) {
            if (connectionData.getConnectionEndTimeUs() == 0L) continue;
            series.add(connectionData.getRequestStartTimeUs(), (Object)NetworkState.SENDING);
            if (connectionData.getResponseStartTimeUs() > 0L) {
                series.add(connectionData.getResponseStartTimeUs(), (Object)NetworkState.RECEIVING);
            }
            series.add(connectionData.getConnectionEndTimeUs(), (Object)NetworkState.NONE);
        }
        StateChartModel stateModel = new StateChartModel();
        StateChart stateChart2 = new StateChart(stateModel, (StateChartColorProvider)new StateChartColorProvider<NetworkState>(this){
            final /* synthetic */ ConnectionsStateChart this$0;
            {
                this.this$0 = $receiver;
            }

            public Color getColor(boolean isMouseOver, NetworkState value2) {
                Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
                Color color = this.this$0.getColors().getColor((Enum)value2);
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getColor(...)");
                return color;
            }
        }, null, 4, null);
        stateModel.addSeries(new RangedSeries(range, (DataSeries)series, null, 4, null));
        return stateChart2;
    }
}

