/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.appinspection.inspectors.backgroundtask.model.entries;

import androidx.work.inspection.WorkManagerInspectorProtocol;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.EventWrapper;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.entries.BackgroundTaskCallStack;
import com.android.tools.idea.appinspection.inspectors.backgroundtask.model.entries.BackgroundTaskEntry;
import com.android.tools.idea.protobuf.ProtocolStringList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\"\u001a\u00020#J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0007R\u0014\u0010\u000e\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0007R\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\"\u0010\u0014\u001a\u0010\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\u00030\u00030\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0018R\u0014\u0010\u001c\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0016\u0010 \u001a\n \u0016*\u0004\u0018\u00010!0!X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/entries/WorkEntry;", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/entries/BackgroundTaskEntry;", "id", "", "<init>", "(Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "_isValid", "", "isValid", "()Z", "className", "getClassName", "status", "getStatus", "startTimeMs", "", "getStartTimeMs", "()J", "tags", "", "kotlin.jvm.PlatformType", "getTags", "()Ljava/util/List;", "callstacks", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/entries/BackgroundTaskCallStack;", "getCallstacks", "retries", "", "getRetries", "()I", "work", "Landroidx/work/inspection/WorkManagerInspectorProtocol$WorkInfo$Builder;", "getWorkInfo", "Landroidx/work/inspection/WorkManagerInspectorProtocol$WorkInfo;", "consume", "", "eventWrapper", "Lcom/android/tools/idea/appinspection/inspectors/backgroundtask/model/EventWrapper;", "app-inspection.inspectors.backgroundtask.model"})
@SourceDebugExtension(value={"SMAP\nWorkEntry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkEntry.kt\ncom/android/tools/idea/appinspection/inspectors/backgroundtask/model/entries/WorkEntry\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n1#2:80\n*E\n"})
public final class WorkEntry
implements BackgroundTaskEntry {
    @NotNull
    private final String id;
    private boolean _isValid;
    @NotNull
    private final List<BackgroundTaskCallStack> callstacks;
    private WorkManagerInspectorProtocol.WorkInfo.Builder work;

    public WorkEntry(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        this.id = id2;
        this.callstacks = CollectionsKt.emptyList();
        this.work = WorkManagerInspectorProtocol.WorkInfo.newBuilder();
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isValid() {
        return this._isValid;
    }

    @Override
    @NotNull
    public String getClassName() {
        String string = this.work.getWorkerClassName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getWorkerClassName(...)");
        return string;
    }

    @Override
    @NotNull
    public String getStatus() {
        return this.work.getState().name();
    }

    @Override
    public long getStartTimeMs() {
        return this.work.getScheduleRequestedAt();
    }

    @Override
    @NotNull
    public List<String> getTags() {
        ProtocolStringList protocolStringList = this.work.getTagsList();
        Intrinsics.checkNotNullExpressionValue((Object)protocolStringList, (String)"getTagsList(...)");
        return CollectionsKt.toList((Iterable)((Iterable)protocolStringList));
    }

    @Override
    @NotNull
    public List<BackgroundTaskCallStack> getCallstacks() {
        return this.callstacks;
    }

    @Override
    public int getRetries() {
        Integer n = this.work.getRunAttemptCount() - 1;
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n2 = it >= 0 ? n : null;
        return n2 != null ? n2 : 0;
    }

    @NotNull
    public final WorkManagerInspectorProtocol.WorkInfo getWorkInfo() {
        WorkManagerInspectorProtocol.WorkInfo workInfo = this.work.build();
        Intrinsics.checkNotNull((Object)workInfo);
        return workInfo;
    }

    @Override
    public void consume(@NotNull EventWrapper eventWrapper) {
        Intrinsics.checkNotNullParameter((Object)eventWrapper, (String)"eventWrapper");
        WorkManagerInspectorProtocol.Event event = eventWrapper.getWorkEvent();
        WorkManagerInspectorProtocol.Event.OneOfCase oneOfCase = event.getOneOfCase();
        block0 : switch (oneOfCase == null ? -1 : WhenMappings.$EnumSwitchMapping$1[oneOfCase.ordinal()]) {
            case 1: {
                this.work = event.getWorkAdded().getWork().toBuilder();
                this._isValid = true;
                break;
            }
            case 2: {
                WorkManagerInspectorProtocol.WorkUpdatedEvent.OneOfCase oneOfCase2 = event.getWorkUpdated().getOneOfCase();
                Intrinsics.checkNotNull((Object)oneOfCase2);
                switch (WhenMappings.$EnumSwitchMapping$0[oneOfCase2.ordinal()]) {
                    case 1: {
                        this.work.setState(event.getWorkUpdated().getState());
                        break block0;
                    }
                    case 2: {
                        this.work.setScheduleRequestedAt(event.getWorkUpdated().getScheduleRequestedAt());
                        break block0;
                    }
                    case 3: {
                        this.work.setData(event.getWorkUpdated().getData());
                        break block0;
                    }
                    case 4: {
                        this.work.setRunAttemptCount(event.getWorkUpdated().getRunAttemptCount());
                        break block0;
                    }
                }
                throw new RuntimeException();
            }
            case 3: {
                this._isValid = false;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[WorkManagerInspectorProtocol.WorkUpdatedEvent.OneOfCase.values().length];
            try {
                nArray[WorkManagerInspectorProtocol.WorkUpdatedEvent.OneOfCase.STATE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WorkManagerInspectorProtocol.WorkUpdatedEvent.OneOfCase.SCHEDULE_REQUESTED_AT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WorkManagerInspectorProtocol.WorkUpdatedEvent.OneOfCase.DATA.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WorkManagerInspectorProtocol.WorkUpdatedEvent.OneOfCase.RUN_ATTEMPT_COUNT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[WorkManagerInspectorProtocol.Event.OneOfCase.values().length];
            try {
                nArray[WorkManagerInspectorProtocol.Event.OneOfCase.WORK_ADDED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WorkManagerInspectorProtocol.Event.OneOfCase.WORK_UPDATED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WorkManagerInspectorProtocol.Event.OneOfCase.WORK_REMOVED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

