/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer;

import com.android.tools.idea.apk.viewer.ApkVirtualFolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.BinaryLightVirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ApkVirtualFile {
    private ApkVirtualFile() {
    }

    @Nullable
    public static VirtualFile create(@NotNull Path path, byte @NotNull [] content2) {
        boolean isBinary;
        Path fileName = path.getFileName();
        if (fileName == null) {
            return null;
        }
        final Path parent = path.getParent();
        boolean bl = isBinary = !path.toString().matches("/META-INF/.*\\.version");
        if (isBinary) {
            return new BinaryLightVirtualFile(fileName.toString(), content2){

                public VirtualFile getParent() {
                    return ApkVirtualFolder.getDirectory(parent);
                }
            };
        }
        return ApkVirtualFile.createText(path, new String(content2, StandardCharsets.UTF_8));
    }

    @Nullable
    public static VirtualFile createText(@NotNull Path path, @NotNull String content2) {
        Path fileName = path.getFileName();
        if (fileName == null) {
            return null;
        }
        final Path parent = path.getParent();
        return new LightVirtualFile(fileName.toString(), content2){

            public VirtualFile getParent() {
                return ApkVirtualFolder.getDirectory(parent);
            }
        };
    }
}

