/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer;

import com.android.tools.adtui.common.ColumnTreeBuilder;
import com.android.tools.adtui.util.HumanReadableUtil;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.apk.analyzer.AndroidApplicationInfo;
import com.android.tools.apk.analyzer.ArchiveEntry;
import com.android.tools.apk.analyzer.ArchiveErrorEntry;
import com.android.tools.apk.analyzer.ArchiveNode;
import com.android.tools.apk.analyzer.ArchiveTreeStructure;
import com.android.tools.apk.analyzer.Archives;
import com.android.tools.apk.analyzer.internal.ApkArchive;
import com.android.tools.apk.analyzer.internal.ArchiveTreeNode;
import com.android.tools.apk.analyzer.internal.InstantAppBundleArchive;
import com.android.tools.idea.apk.viewer.AndroidApplicationInfoProvider;
import com.android.tools.idea.apk.viewer.ApkParser;
import com.android.tools.idea.apk.viewer.PercentRenderer;
import com.android.tools.idea.apk.viewer.pagealign.AlignmentCellRenderer;
import com.android.tools.idea.apk.viewer.pagealign.AlignmentFindingKt;
import com.android.tools.idea.stats.AnonymizerUtil;
import com.google.common.primitives.Longs;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.ApkAnalyzerStats;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.IconManager;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.PlatformIcons;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.AnimatedIcon;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.nio.file.ClosedFileSystemException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class ApkViewPanel
implements TreeSelectionListener {
    private static final Logger LOG = Logger.getInstance(ApkViewPanel.class);
    private JPanel myContainer;
    private JComponent myColumnTreePane;
    private SimpleColoredComponent myNameComponent;
    private SimpleColoredComponent mySizeComponent;
    private AnimatedIcon myNameAsyncIcon;
    private AnimatedIcon mySizeAsyncIcon;
    private JButton myCompareWithButton;
    private Tree myTree;
    private ApkTreeModel myTreeModel;
    private Listener myListener;
    @NotNull
    private final ApkParser myApkParser;
    private final boolean myIsPageAlignFeatureEnabled;
    private boolean myArchiveDisposed = false;
    private static final int TEXT_RENDERER_HORIZ_PADDING = 6;
    private static final int TEXT_RENDERER_VERT_PADDING = 4;

    private void setupUI() {
        this.createUIComponents();
        this.myContainer = new JPanel();
        this.myContainer.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1));
        Spacer spacer1 = new Spacer();
        this.myContainer.add((Component)spacer1, new GridConstraints(0, 1, 1, 1, 0, 1, 4, 1, null, null, null, 0, false));
        this.myContainer.add((Component)this.myColumnTreePane, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, false));
        JPanel panel1 = new JPanel();
        panel1.setLayout(new FlowLayout(0, 5, 0));
        this.myContainer.add((Component)panel1, new GridConstraints(0, 0, 1, 1, 0, 3, 0, 0, null, null, null, 0, false));
        this.myNameComponent = new SimpleColoredComponent();
        panel1.add((Component)this.myNameComponent);
        panel1.add((Component)this.myNameAsyncIcon);
        JPanel panel2 = new JPanel();
        panel2.setLayout(new FlowLayout(0, 5, 0));
        this.myContainer.add((Component)panel2, new GridConstraints(1, 0, 1, 1, 0, 3, 0, 0, null, null, null, 0, false));
        this.mySizeComponent = new SimpleColoredComponent();
        panel2.add((Component)this.mySizeComponent);
        panel2.add((Component)this.mySizeAsyncIcon);
        this.myCompareWithButton = new JButton();
        this.myCompareWithButton.setText("Compare with previous APK...");
        this.myContainer.add((Component)this.myCompareWithButton, new GridConstraints(1, 1, 1, 1, 4, 0, 0, 0, null, null, null, 0, false));
    }

    public JComponent getRootComponent() {
        return this.myContainer;
    }

    public ApkViewPanel(@NotNull ApkParser apkParser, @NotNull String apkName, @NotNull AndroidApplicationInfoProvider applicationInfoProvider, final boolean isPageAlignFeatureEnabled) {
        this.myApkParser = apkParser;
        this.myIsPageAlignFeatureEnabled = isPageAlignFeatureEnabled;
        this.setupUI();
        Futures.addCallback(apkParser.constructTreeStructure(), (FutureCallback)new FutureCallBackAdapter<ArchiveNode>(){

            @Override
            public void onSuccess(ArchiveNode result2) {
                if (ApkViewPanel.this.myArchiveDisposed) {
                    return;
                }
                ApkViewPanel.this.setRootNode(result2);
            }
        }, (Executor)EdtExecutorService.getInstance());
        Futures.addCallback(apkParser.updateTreeWithDownloadSizes(), (FutureCallback)new FutureCallBackAdapter<ArchiveNode>(){

            @Override
            public void onSuccess(ArchiveNode result2) {
                block4: {
                    if (ApkViewPanel.this.myArchiveDisposed) {
                        return;
                    }
                    ArchiveTreeStructure.sort((ArchiveNode)result2, (o1, o2) -> Longs.compare((long)o2.getData().getDownloadFileSize(), (long)o1.getData().getDownloadFileSize()));
                    try {
                        ApkViewPanel.this.refreshTree();
                        if (isPageAlignFeatureEnabled) {
                            ApkViewPanel.this.myTree.expandPaths(AlignmentFindingKt.findPageAlignWarningsPaths(result2, ApkViewPanel.this.myTreeModel.getExtractNativeLibs()));
                        }
                    }
                    catch (Exception e) {
                        if (ApkViewPanel.this.myArchiveDisposed) break block4;
                        throw e;
                    }
                }
            }
        }, (Executor)EdtExecutorService.getInstance());
        this.myContainer.setBorder(IdeBorderFactory.createBorder((int)8));
        this.myCompareWithButton.addActionListener(e -> {
            if (this.myListener != null) {
                this.myListener.selectApkAndCompare();
            }
        });
        this.myNameAsyncIcon.setVisible(true);
        this.myNameComponent.append("Parsing Manifest");
        ListenableFuture applicationInfo = Futures.transformAsync(apkParser.constructTreeStructure(), input2 -> {
            assert (input2 != null);
            ArchiveEntry entry = Archives.getFirstManifestArchiveEntry((ArchiveNode)input2);
            if (entry == null) {
                this.setToZipMode(apkName);
                return Futures.immediateFailedFuture((Throwable)new Exception("Regular .zip, not valid .apk file."));
            }
            try {
                return applicationInfoProvider.getApplicationInfo(apkParser, entry);
            }
            catch (Exception e) {
                this.setToZipMode(apkName);
                LOG.warn((Throwable)e);
                return Futures.immediateFailedFuture((Throwable)e);
            }
        }, (Executor)PooledThreadExecutor.INSTANCE);
        ListenableFuture<Long> uncompressedApkSize = apkParser.getUncompressedApkSize();
        ListenableFuture<Long> compressedFullApkSize = apkParser.getCompressedFullApkSize();
        ListenableFuture<ApkParser.Align16kbCompliance> align16kbCompliance = apkParser.getAlign16kbCompliance();
        Futures.addCallback((ListenableFuture)applicationInfo, (FutureCallback)new FutureCallBackAdapter<AndroidApplicationInfo>(){

            @Override
            public void onSuccess(AndroidApplicationInfo result2) {
                if (ApkViewPanel.this.myArchiveDisposed) {
                    return;
                }
                ApkViewPanel.this.setAppInfo(result2);
            }
        }, (Executor)EdtExecutorService.getInstance());
        this.mySizeAsyncIcon.setVisible(true);
        this.mySizeComponent.append("Estimating download size..");
        Futures.addCallback((ListenableFuture)Futures.successfulAsList((ListenableFuture[])new ListenableFuture[]{uncompressedApkSize, compressedFullApkSize}), (FutureCallback)new FutureCallBackAdapter<List<Long>>(){

            @Override
            public void onSuccess(List<Long> result2) {
                if (ApkViewPanel.this.myArchiveDisposed) {
                    return;
                }
                if (result2 != null) {
                    Long uncompressed = result2.get(0);
                    Long compressed = result2.get(1);
                    ApkViewPanel.this.setApkSizes(uncompressed == null ? 0L : uncompressed, compressed == null ? 0L : compressed);
                }
            }
        }, (Executor)EdtExecutorService.getInstance());
        Futures.FutureCombiner combiner = Futures.whenAllComplete((ListenableFuture[])new ListenableFuture[]{uncompressedApkSize, compressedFullApkSize, applicationInfo});
        combiner.call(() -> {
            String applicationId2 = ((AndroidApplicationInfo)applicationInfo.get()).packageId;
            ApkAnalyzerStats.Builder stats = ApkAnalyzerStats.newBuilder().setCompressedSize(((Long)compressedFullApkSize.get()).longValue()).setUncompressedSize(((Long)uncompressedApkSize.get()).longValue());
            if (align16kbCompliance.get() != ApkParser.Align16kbCompliance.NO_ELF_FILES) {
                stats.setAlign16Type(align16kbCompliance.get() == ApkParser.Align16kbCompliance.COMPLIANT ? ApkAnalyzerStats.ApkAnalyzerAlignNative16kbEventType.ALIGN_NATIVE_COMPLIANT_APK_ANALYZED : ApkAnalyzerStats.ApkAnalyzerAlignNative16kbEventType.ALIGN_NATIVE_NON_COMPLIANT_APK_ANALYZED);
            }
            UsageTracker.log((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.APK_ANALYZER_STATS).setProjectId(AnonymizerUtil.anonymizeUtf8((String)applicationId2)).setRawProjectId(applicationId2).setApkAnalyzerStats(stats));
            return null;
        }, MoreExecutors.directExecutor()).addListener(() -> {}, MoreExecutors.directExecutor());
        this.myContainer.setName("ApkViewPanel");
    }

    private void setToZipMode(@NotNull String fileName) {
        this.myCompareWithButton.setEnabled(false);
        this.myCompareWithButton.setVisible(false);
        this.myNameAsyncIcon.setVisible(false);
        this.myNameComponent.clear();
        this.myNameComponent.append(fileName);
    }

    private void createUIComponents() {
        this.myNameAsyncIcon = new AsyncProcessIcon("aapt xmltree manifest");
        this.mySizeAsyncIcon = new AsyncProcessIcon("estimating apk size");
        this.myTreeModel = new ApkTreeModel((TreeNode)new LoadingNode());
        this.myTree = new Tree((TreeModel)this.myTreeModel);
        this.myTree.setName("nodeTree");
        this.myTree.setShowsRootHandles(true);
        this.myTree.setRootVisible(true);
        this.myTree.setPaintBusy(true);
        TreeSpeedSearch treeSpeedSearch = TreeSpeedSearch.installOn((JTree)this.myTree, (boolean)true, path -> {
            Object lastPathComponent = path.getLastPathComponent();
            if (!(lastPathComponent instanceof ArchiveTreeNode)) {
                return null;
            }
            return ((ArchiveTreeNode)lastPathComponent).getData().getPath().toString();
        });
        PercentRenderer.PercentProvider percentProvider = (jTree, value2, row) -> {
            if (!(value2 instanceof ArchiveTreeNode)) {
                return 0.0;
            }
            ArchiveTreeNode entry = (ArchiveTreeNode)value2;
            ArchiveTreeNode rootEntry = (ArchiveTreeNode)jTree.getModel().getRoot();
            if (entry.getData().getDownloadFileSize() < 0L) {
                return 0.0;
            }
            return (double)entry.getData().getDownloadFileSize() / (double)rootEntry.getData().getDownloadFileSize();
        };
        ColumnTreeBuilder builder = new ColumnTreeBuilder((JTree)this.myTree).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("File").setPreferredWidth(JBUI.scale((int)270)).setHeaderAlignment(10).setHeaderBorder((Border)JBUI.Borders.empty((int)4, (int)6)).setRenderer((ColoredTreeCellRenderer)new NameRenderer(this.myApkParser, treeSpeedSearch))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Size").setPreferredWidth(JBUI.scale((int)80)).setHeaderAlignment(11).setHeaderBorder((Border)JBUI.Borders.empty((int)4, (int)6)).setRenderer((ColoredTreeCellRenderer)new SizeRenderer(false))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Download Size").setPreferredWidth(JBUI.scale((int)80)).setHeaderAlignment(11).setHeaderBorder((Border)JBUI.Borders.empty((int)4, (int)6)).setRenderer((ColoredTreeCellRenderer)new SizeRenderer(true))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("% of Download Size").setPreferredWidth(JBUI.scale((int)150)).setHeaderAlignment(10).setHeaderBorder((Border)JBUI.Borders.empty((int)4, (int)6)).setRenderer((ColoredTreeCellRenderer)new PercentRenderer(percentProvider))).addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Compressed").setPreferredWidth(JBUI.scale((int)110)).setHeaderAlignment(10).setHeaderBorder((Border)JBUI.Borders.empty((int)4, (int)6)).setRenderer((ColoredTreeCellRenderer)new CompressionRenderer()));
        if (this.myIsPageAlignFeatureEnabled) {
            builder.addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Alignment").setPreferredWidth(JBUI.scale((int)320)).setHeaderAlignment(10).setHeaderBorder((Border)JBUI.Borders.empty((int)4, (int)6)).setRenderer((ColoredTreeCellRenderer)new AlignmentCellRenderer()));
        } else {
            builder.addColumn(new ColumnTreeBuilder.ColumnBuilder().setName("Alignment").setPreferredWidth(JBUI.scale((int)200)).setHeaderAlignment(10).setHeaderBorder((Border)JBUI.Borders.empty((int)4, (int)6)).setRenderer((ColoredTreeCellRenderer)new ZipAlignmentRenderer()));
        }
        this.myColumnTreePane = builder.build();
        this.myTree.addTreeSelectionListener((TreeSelectionListener)this);
    }

    public void setListener(@NotNull Listener listener2) {
        this.myListener = listener2;
    }

    public void clearArchive() {
        this.myArchiveDisposed = true;
        this.myApkParser.cancelAll();
        ApplicationManager.getApplication().invokeLater(() -> this.setRootNode(null));
        LOG.info("Cleared Archive on ApkViewPanel: " + String.valueOf(this));
    }

    private void setRootNode(@Nullable ArchiveNode root) {
        block3: {
            try {
                this.myTreeModel = new ApkTreeModel((TreeNode)root);
                if (root != null) {
                    this.myTree.setPaintBusy(root.getData().getDownloadFileSize() < 0L);
                }
                this.myTree.setModel((TreeModel)this.myTreeModel);
            }
            catch (Exception e) {
                if (this.myArchiveDisposed) break block3;
                throw e;
            }
        }
    }

    private void refreshTree() {
        this.myTree.setPaintBusy(false);
        this.myTree.removeTreeSelectionListener((TreeSelectionListener)this);
        TreePath[] selected = this.myTree.getSelectionPaths();
        this.myTreeModel.reload();
        this.myTree.setSelectionPaths(selected);
        this.myTree.addTreeSelectionListener((TreeSelectionListener)this);
    }

    private void setApkSizes(long uncompressed, long compressedFullApk) {
        this.mySizeComponent.clear();
        if (this.mySizeAsyncIcon != null) {
            this.mySizeAsyncIcon.setVisible(false);
            Disposer.dispose((Disposable)this.mySizeAsyncIcon);
            this.mySizeAsyncIcon = null;
        }
        this.mySizeComponent.setIcon(AllIcons.General.BalloonInformation);
        if (this.myApkParser.getArchive() instanceof ApkArchive) {
            this.mySizeComponent.append("APK size: ");
            this.mySizeComponent.append(HumanReadableUtil.getHumanizedSize((long)uncompressed), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            this.mySizeComponent.append(", Download Size: ");
            this.mySizeComponent.setToolTipText("1. The <b>APK size</b> reflects the actual size of the file, and is the minimum amount of space it will consume on the disk after installation.\n2. The <b>download size</b> is the estimated size of the file for new installations (Google Play serves a highly compressed version of the file).\nFor application updates, Google Play serves patches that are typically much smaller.\nThe installation size may be higher than the APK size depending on various other factors.");
        } else if (this.myApkParser.getArchive() instanceof InstantAppBundleArchive) {
            this.mySizeComponent.append("Zip file size: ");
            this.mySizeComponent.setToolTipText("The <b>zip file size</b> reflects the actual size of the zip file on disk.\n");
        } else {
            this.mySizeComponent.append("Raw File Size: ");
        }
        this.mySizeComponent.append(HumanReadableUtil.getHumanizedSize((long)compressedFullApk), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
    }

    private void setAppInfo(@NotNull AndroidApplicationInfo appInfo) {
        this.myNameComponent.clear();
        if (this.myNameAsyncIcon != null) {
            this.myNameAsyncIcon.setVisible(false);
            Disposer.dispose((Disposable)this.myNameAsyncIcon);
            this.myNameAsyncIcon = null;
        }
        this.myNameComponent.append(appInfo.packageId, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        this.myNameComponent.append(" (Version Name: ", SimpleTextAttributes.GRAY_ATTRIBUTES);
        this.myNameComponent.append(appInfo.versionName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        this.myNameComponent.append(", Version Code: ", SimpleTextAttributes.GRAY_ATTRIBUTES);
        this.myNameComponent.append(String.valueOf(appInfo.versionCode), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        this.myNameComponent.append(")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        this.myTreeModel.setExtractNativeLibs(appInfo.extractNativeLibs);
    }

    @NotNull
    public ApkTreeModel getTreeModel() {
        return this.myTreeModel;
    }

    @NotNull
    public JComponent getContainer() {
        return this.myContainer;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (this.myListener != null) {
            ArchiveTreeNode[] components;
            TreePath[] paths = ((Tree)e.getSource()).getSelectionPaths();
            if (paths == null) {
                components = null;
            } else {
                components = new ArchiveTreeNode[paths.length];
                for (int i = 0; i < paths.length; ++i) {
                    if (!(paths[i].getLastPathComponent() instanceof ArchiveTreeNode)) {
                        this.myListener.selectionChanged(null);
                        return;
                    }
                    components[i] = (ArchiveTreeNode)paths[i].getLastPathComponent();
                }
            }
            this.myListener.selectionChanged(components);
        }
    }

    public static class ApkTreeModel
    extends DefaultTreeModel {
        private Boolean myExtractNativeLibs = null;
        private boolean myExtractNativeLibsSet = false;

        public ApkTreeModel(TreeNode root) {
            super(root);
        }

        public void setExtractNativeLibs(Boolean extractNativeLibs) {
            this.myExtractNativeLibs = extractNativeLibs;
            this.myExtractNativeLibsSet = true;
        }

        public Boolean getExtractNativeLibs() {
            if (!this.myExtractNativeLibsSet) {
                return true;
            }
            return this.myExtractNativeLibs;
        }
    }

    public static class NameRenderer
    extends ColoredTreeCellRenderer {
        private final ApkParser myApkParser;
        private final TreeSpeedSearch mySpeedSearch;

        public NameRenderer(@NotNull ApkParser apkParser, @NotNull TreeSpeedSearch speedSearch2) {
            this.myApkParser = apkParser;
            this.mySpeedSearch = speedSearch2;
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            block3: {
                try {
                    if (!(value2 instanceof ArchiveNode)) {
                        this.append(value2.toString());
                        return;
                    }
                    ArchiveEntry entry = ((ArchiveNode)value2).getData();
                    this.setIcon(NameRenderer.getIconFor(entry));
                    String name2 = entry.getNodeDisplayString();
                    SimpleTextAttributes attr = entry instanceof ArchiveErrorEntry ? SimpleTextAttributes.ERROR_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES;
                    SearchUtil.appendFragments((String)this.mySpeedSearch.getEnteredPrefix(), (String)name2, (int)attr.getStyle(), (Color)attr.getFgColor(), (Color)attr.getBgColor(), (SimpleColoredComponent)this);
                }
                catch (Exception e) {
                    if (!Files.exists(this.myApkParser.getArchive().getPath(), new LinkOption[0])) break block3;
                    throw e;
                }
            }
        }

        @NotNull
        private static Icon getIconFor(@NotNull ArchiveEntry entry) {
            if (entry instanceof ArchiveErrorEntry) {
                return StudioIcons.Common.WARNING;
            }
            Path path = entry.getPath();
            Path base = path.getFileName();
            String fileName = base == null ? "" : base.toString();
            boolean isDirectory = false;
            try {
                Files.isDirectory(path, new LinkOption[0]);
            }
            catch (ClosedFileSystemException e) {
                LOG.warn((Throwable)e);
            }
            if (!isDirectory) {
                if (fileName.equals("AndroidManifest.xml")) {
                    return StudioIcons.Shell.Filetree.MANIFEST_FILE;
                }
                if (fileName.endsWith(".dex")) {
                    return AllIcons.FileTypes.JavaClass;
                }
                if (fileName.equals("baseline.prof") || fileName.equals("baseline.profm")) {
                    return AllIcons.FileTypes.Hprof;
                }
                if (entry.getIsElf()) {
                    return AllIcons.FileTypes.BinaryData;
                }
                FileType fileType = FileTypeRegistry.getInstance().getFileTypeByFileName(fileName);
                Icon ftIcon = fileType.getIcon();
                return ftIcon == null ? AllIcons.FileTypes.Any_type : ftIcon;
            }
            if ((fileName = StringUtil.trimEnd((String)fileName, (String)"/")).equals("res")) {
                return AllIcons.Modules.ResourcesRoot;
            }
            if (path.toString().equals("/lib")) {
                return AllIcons.Nodes.NativeLibrariesFolder;
            }
            return IconManager.getInstance().getPlatformIcon(PlatformIcons.Package);
        }
    }

    private static class SizeRenderer
    extends ColoredTreeCellRenderer {
        private final boolean myUseDownloadSize;

        public SizeRenderer(boolean useDownloadSize) {
            this.myUseDownloadSize = useDownloadSize;
            this.setTextAlign(4);
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            long size;
            if (!(value2 instanceof ArchiveTreeNode)) {
                return;
            }
            ArchiveEntry data2 = ((ArchiveTreeNode)value2).getData();
            long l = size = this.myUseDownloadSize ? data2.getDownloadFileSize() : data2.getRawFileSize();
            if (size > 0L) {
                this.append(HumanReadableUtil.getHumanizedSize((long)size));
            }
        }
    }

    private static class CompressionRenderer
    extends ColoredTreeCellRenderer {
        public CompressionRenderer() {
            this.setTextAlign(2);
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (!(value2 instanceof ArchiveTreeNode)) {
                return;
            }
            ArchiveEntry data2 = ((ArchiveTreeNode)value2).getData();
            try {
                if (!Files.isDirectory(data2.getPath(), new LinkOption[0])) {
                    if (data2.isFileCompressed()) {
                        this.append("Yes");
                    } else {
                        this.append("No");
                    }
                }
            }
            catch (ClosedFileSystemException closedFileSystemException) {
                // empty catch block
            }
        }
    }

    private static class ZipAlignmentRenderer
    extends ColoredTreeCellRenderer {
        ZipAlignmentRenderer() {
            this.setTextAlign(2);
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (!(value2 instanceof ArchiveTreeNode)) {
                return;
            }
            ArchiveEntry data2 = ((ArchiveTreeNode)value2).getData();
            this.append(data2.getFileAlignment().text);
        }
    }

    public static interface Listener {
        public void selectionChanged(ArchiveTreeNode @Nullable [] var1);

        public void selectApkAndCompare();
    }

    public static class FutureCallBackAdapter<V>
    implements FutureCallback<V> {
        public void onSuccess(V result2) {
        }

        public void onFailure(@NotNull Throwable t) {
        }
    }
}

