/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.debugging;

import com.android.sdklib.devices.Abi;
import com.android.tools.idea.apk.debugging.DebuggableSharedObjectFile;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.serialization.ClassUtil;
import com.intellij.util.xmlb.annotations.Transient;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NativeLibrary {
    @NotNull
    public String name = "";
    @NotNull
    public Map<Abi, DebuggableSharedObjectFile> debuggableSharedObjectFilesByAbi = new HashMap<Abi, DebuggableSharedObjectFile>();
    @NotNull
    public Map<String, String> pathMappings = new HashMap<String, String>();
    @NotNull
    private List<String> mySharedObjectFilePaths = Collections.emptyList();
    @Transient
    @NotNull
    public final Map<Abi, VirtualFile> sharedObjectFilesByAbi = new LinkedHashMap<Abi, VirtualFile>();
    @Transient
    @NotNull
    public final List<Abi> abis = new ArrayList<Abi>();
    @Transient
    @VisibleForTesting
    @Nullable
    List<String> sourceFolderPaths;
    public boolean hasDebugSymbols;

    public NativeLibrary() {
    }

    public NativeLibrary(@NotNull String name2) {
        this.name = name2;
    }

    @NotNull
    public List<String> getSharedObjectFilePaths() {
        return this.mySharedObjectFilePaths;
    }

    @NotNull
    public List<VirtualFile> getSharedObjectFiles() {
        return new ArrayList<VirtualFile>(this.sharedObjectFilesByAbi.values());
    }

    public void setSharedObjectFilePaths(@NotNull List<String> sharedObjectFilePaths) {
        this.mySharedObjectFilePaths = sharedObjectFilePaths;
        this.abis.clear();
        this.sharedObjectFilesByAbi.clear();
        ArrayList<String> nonExistingPaths = new ArrayList<String>();
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        for (String path : sharedObjectFilePaths) {
            VirtualFile file = fileSystem.findFileByPath(path);
            if (file != null) {
                Abi abi = NativeLibrary.extractAbiFrom(file);
                this.sharedObjectFilesByAbi.put(abi, file);
                this.abis.add(abi);
                continue;
            }
            nonExistingPaths.add(path);
        }
        this.sortAbis();
        if (!nonExistingPaths.isEmpty()) {
            this.mySharedObjectFilePaths.removeAll(nonExistingPaths);
        }
    }

    public void clearDebugSymbols() {
        this.debuggableSharedObjectFilesByAbi.clear();
        this.pathMappings.clear();
        this.hasDebugSymbols = false;
        this.clearSourceFolderCache();
    }

    public boolean containsMappingForRemotePath(@NotNull String remotePath) {
        return this.pathMappings.containsKey(remotePath);
    }

    public void addPathMapping(@NotNull String remotePath, @NotNull String localPath) {
        this.pathMappings.put(remotePath, localPath);
        this.clearSourceFolderCache();
    }

    public void removePathMapping(@NotNull String remotePath) {
        this.pathMappings.remove(remotePath);
        this.clearSourceFolderCache();
    }

    public void replacePathMappingsWith(@NotNull Map<String, String> newPathMappings) {
        this.pathMappings.clear();
        this.pathMappings.putAll(newPathMappings);
        this.clearSourceFolderCache();
    }

    public boolean needsPathMappings() {
        return !this.pathMappings.isEmpty();
    }

    public void addSharedObjectFiles(@NotNull Collection<VirtualFile> files2) {
        for (VirtualFile file : files2) {
            this.doAddSharedObjectFile(file);
        }
        this.sortAbis();
    }

    private void sortAbis() {
        if (this.abis.size() > 1) {
            this.abis.sort(Comparator.comparing(Abi::toString));
        }
    }

    private void doAddSharedObjectFile(@NotNull VirtualFile file) {
        Abi abi = NativeLibrary.extractAbiFrom(file);
        this.sharedObjectFilesByAbi.put(abi, file);
        this.abis.add(abi);
        if (!ClassUtil.isMutableCollection(this.mySharedObjectFilePaths)) {
            this.mySharedObjectFilePaths = new ArrayList<String>();
        }
        this.mySharedObjectFilePaths.add(file.getPath());
    }

    @NotNull
    private static Abi extractAbiFrom(@NotNull VirtualFile file) {
        VirtualFile parent = file.getParent();
        assert (parent != null);
        String folderName = parent.getName();
        Abi abi = Abi.getEnum((String)folderName);
        if (abi == null) {
            throw new IllegalArgumentException("Failed to find ABI for file: '" + FileUtil.toSystemDependentName((String)file.getPath()) + "'");
        }
        return abi;
    }

    public boolean isMissingPathMappings() {
        for (String mappedPath : this.pathMappings.values()) {
            if (!StringUtil.isEmpty((String)mappedPath)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public DebuggableSharedObjectFile addDebuggableSharedObjectFile(@NotNull Abi abi, @NotNull VirtualFile file) {
        this.hasDebugSymbols = true;
        DebuggableSharedObjectFile sharedObjectFile = new DebuggableSharedObjectFile(file);
        this.debuggableSharedObjectFilesByAbi.put(abi, sharedObjectFile);
        this.clearSourceFolderCache();
        return sharedObjectFile;
    }

    private void clearSourceFolderCache() {
        this.sourceFolderPaths = null;
    }

    @NotNull
    public List<String> getUserSelectedPathsInMappings() {
        Collection<String> values = this.pathMappings.values();
        return values.isEmpty() ? Collections.emptyList() : values.stream().filter(StringUtil::isNotEmpty).collect(Collectors.toList());
    }

    public String toString() {
        return this.name;
    }

    @NotNull
    public List<String> getSourceFolderPaths() {
        if (this.sourceFolderPaths != null) {
            return this.sourceFolderPaths;
        }
        this.recalculateSourceFolderPaths();
        return this.sourceFolderPaths;
    }

    public void recalculateSourceFolderPaths() {
        if (this.debuggableSharedObjectFilesByAbi.isEmpty()) {
            this.sourceFolderPaths = Collections.emptyList();
            return;
        }
        this.sourceFolderPaths = new ArrayList<String>();
        for (DebuggableSharedObjectFile sharedObjectFile : this.debuggableSharedObjectFilesByAbi.values()) {
            for (String debugSymbolPath : sharedObjectFile.debugSymbolPaths) {
                File path = new File(debugSymbolPath);
                if (path.toPath().isAbsolute() && path.exists()) {
                    this.sourceFolderPaths.add(debugSymbolPath);
                    continue;
                }
                String mappedPath = this.pathMappings.get(debugSymbolPath);
                if (!StringUtil.isNotEmpty((String)mappedPath) || !(path = new File(mappedPath)).toPath().isAbsolute() || !path.exists()) continue;
                this.sourceFolderPaths.add(mappedPath);
            }
        }
        if (this.sourceFolderPaths.size() > 1) {
            this.sourceFolderPaths.sort(Comparator.naturalOrder());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NativeLibrary library = (NativeLibrary)o;
        return this.hasDebugSymbols == library.hasDebugSymbols && Objects.equals(this.name, library.name) && Objects.equals(this.pathMappings, library.pathMappings) && Objects.equals(this.mySharedObjectFilePaths, library.mySharedObjectFilePaths) && Objects.equals(this.debuggableSharedObjectFilesByAbi, library.debuggableSharedObjectFilesByAbi);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.pathMappings, this.mySharedObjectFilePaths, this.debuggableSharedObjectFilesByAbi, this.hasDebugSymbols);
    }
}

