/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.analytics;

import com.android.repository.Revision;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.internal.avd.EmulatorPackage;
import com.android.sdklib.internal.avd.EmulatorPackages;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.AndroidSdks;
import com.google.common.base.Joiner;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.EmulatorHost;
import com.google.wireless.android.sdk.stats.Hypervisor;
import com.intellij.concurrency.JobScheduler;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingAnsiEscapesAwareProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SystemInfoStatsMonitor {
    private static final Logger LOG = Logger.getInstance(SystemInfoStatsMonitor.class);
    private static final int UPLOAD_INTERVAL_HOURS = 6;
    private static final Revision LOWEST_EMULATOR_REVISION_HYPERV = new Revision(25, 0, 3);
    private static final Revision LOWEST_EMULATOR_REVISION_CPU_INFO = new Revision(25, 1, 1);
    private static final int EMULATOR_CHECK_ERROR_EXIT_CODE = 100;
    private AndroidSdkHandler mySdkHandler = null;
    private ScheduledFuture<?> myUploadTask = null;
    private Hypervisor.HyperVState myHyperVState = Hypervisor.HyperVState.UNKNOWN_HYPERV_STATE;
    private EnumSet<CpuInfoFlags> myCpuInfo = EnumSet.noneOf(CpuInfoFlags.class);

    public void start() {
        if (!AnalyticsSettings.getOptedIn()) {
            return;
        }
        this.myUploadTask = JobScheduler.getScheduler().scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                SystemInfoStatsMonitor.this.updateAndUploadStats();
            }
        }, 5L, 360L, TimeUnit.MINUTES);
    }

    private void updateAndUploadStats() {
        if (!AnalyticsSettings.getOptedIn()) {
            this.myUploadTask.cancel(true);
            return;
        }
        if (this.mySdkHandler == null) {
            this.mySdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        }
        if (SystemInfo.isWindows) {
            this.updateHyperVState();
        }
        this.updateCpuInfo();
        this.sendStats();
    }

    private void sendStats() {
        if (this.myHyperVState == Hypervisor.HyperVState.UNKNOWN_HYPERV_STATE || this.myHyperVState != Hypervisor.HyperVState.HYPERV_CHECK_ERROR) {
            // empty if block
        }
        if (this.myCpuInfo.contains((Object)CpuInfoFlags.UNKNOWN) || !this.myCpuInfo.contains((Object)CpuInfoFlags.ERROR)) {
            // empty if block
        }
        UsageTracker.log((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.SYSTEM).setKind(AndroidStudioEvent.EventKind.HYPERVISOR).setHypervisor(Hypervisor.newBuilder().setHyperVState(this.myHyperVState)));
        UsageTracker.log((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.SYSTEM).setKind(AndroidStudioEvent.EventKind.EMULATOR_HOST).setEmulatorHost(EmulatorHost.newBuilder().setCpuManufacturer(Joiner.on((char)',').join(this.myCpuInfo))));
    }

    private void updateHyperVState() {
        if (this.myHyperVState != Hypervisor.HyperVState.UNKNOWN_HYPERV_STATE && this.myHyperVState != Hypervisor.HyperVState.HYPERV_CHECK_ERROR) {
            return;
        }
        this.myHyperVState = SystemInfoStatsMonitor.calcHyperVState(this.mySdkHandler);
    }

    private void updateCpuInfo() {
        if (!(this.myCpuInfo.isEmpty() || this.myCpuInfo.contains((Object)CpuInfoFlags.ERROR) || this.myCpuInfo.contains((Object)CpuInfoFlags.UNKNOWN))) {
            return;
        }
        this.myCpuInfo = SystemInfoStatsMonitor.calcCpuInfo(this.mySdkHandler);
    }

    @Nullable
    private static Integer runEmulatorCheck(@NotNull String argument, @NotNull Revision lowestEmulatorRevision, @NotNull AndroidSdkHandler handler2) throws ExecutionException {
        EmulatorPackage emulatorPackage = EmulatorPackages.getEmulatorPackage((AndroidSdkHandler)handler2, (ProgressIndicator)new StudioLoggerProgressIndicator(SystemInfoStatsMonitor.class));
        if (emulatorPackage == null) {
            throw new ExecutionException("No SDK emulator package");
        }
        Revision emulatorRevision = emulatorPackage.getVersion();
        if (emulatorRevision.compareTo(lowestEmulatorRevision) < 0) {
            return null;
        }
        Path checkBinary = emulatorPackage.getEmulatorCheckBinary();
        if (checkBinary == null) {
            throw new ExecutionException("No emulator-check binary in the SDK emulator package");
        }
        GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{checkBinary.toString(), argument});
        CapturingAnsiEscapesAwareProcessHandler process2 = new CapturingAnsiEscapesAwareProcessHandler(commandLine);
        ProcessOutput output = process2.runProcess();
        int exitCode2 = output.getExitCode();
        if (exitCode2 == 100) {
            throw new ExecutionException(String.format("Emulator-check failed to check for '%s' with a generic error code %d", argument, 100));
        }
        return exitCode2;
    }

    @NotNull
    private static Hypervisor.HyperVState calcHyperVState(@NotNull AndroidSdkHandler handler2) {
        try {
            Integer res2 = SystemInfoStatsMonitor.runEmulatorCheck("hyper-v", LOWEST_EMULATOR_REVISION_HYPERV, handler2);
            if (res2 == null) {
                return Hypervisor.HyperVState.UNKNOWN_HYPERV_STATE;
            }
            return SystemInfoStatsMonitor.exitCodeToHyperVState(res2);
        }
        catch (ExecutionException e) {
            LOG.warn("Exception during Hyper-V state calculation", (Throwable)e);
            return Hypervisor.HyperVState.HYPERV_CHECK_ERROR;
        }
    }

    private static Hypervisor.HyperVState exitCodeToHyperVState(int exitCode2) {
        switch (exitCode2) {
            case 0: {
                return Hypervisor.HyperVState.HYPERV_ABSENT;
            }
            case 1: {
                return Hypervisor.HyperVState.HYPERV_INSTALLED;
            }
            case 2: {
                return Hypervisor.HyperVState.HYPERV_RUNNING;
            }
            case 100: {
                return Hypervisor.HyperVState.HYPERV_CHECK_ERROR;
            }
        }
        return Hypervisor.HyperVState.UNKNOWN_HYPERV_STATE;
    }

    @NotNull
    private static EnumSet<CpuInfoFlags> calcCpuInfo(@NotNull AndroidSdkHandler handler2) {
        try {
            Integer res2 = SystemInfoStatsMonitor.runEmulatorCheck("cpu-info", LOWEST_EMULATOR_REVISION_CPU_INFO, handler2);
            if (res2 == null) {
                return EnumSet.of(CpuInfoFlags.UNKNOWN);
            }
            return CpuInfoFlags.fromExitCode(res2);
        }
        catch (ExecutionException e) {
            LOG.warn("Exception during CPU information calculation", (Throwable)e);
            return EnumSet.of(CpuInfoFlags.ERROR);
        }
    }

    public static enum CpuInfoFlags {
        ERROR(0),
        AMD(1),
        INTEL(2),
        OTHER_CPU(4),
        IN_VM(8),
        SUPPORTS_VIRT(16),
        UNKNOWN(0x40000000);

        private final int myValue;

        private CpuInfoFlags(int value2) {
            this.myValue = value2;
        }

        public static EnumSet<CpuInfoFlags> fromExitCode(int code) {
            if (code == 0) {
                return EnumSet.of(ERROR);
            }
            EnumSet<CpuInfoFlags> result2 = EnumSet.noneOf(CpuInfoFlags.class);
            for (CpuInfoFlags flag : CpuInfoFlags.values()) {
                if (flag == ERROR || (code & flag.myValue) == 0) continue;
                result2.add(flag);
                code &= ~flag.myValue;
            }
            if (code != 0) {
                LOG.warn(String.format("CpuInfoFlags.fromExitCode(): unknown flag values '0x%x'", code));
            }
            return result2;
        }
    }
}

