/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adb.wireless;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.adb.wireless.AdbOnlineDevice;
import com.android.tools.idea.adb.wireless.PairingCodePairingDialog;
import com.android.tools.idea.adb.wireless.PairingCodePairingModel;
import com.android.tools.idea.adb.wireless.PairingCodePairingView;
import com.android.tools.idea.adb.wireless.PairingMdnsService;
import com.android.tools.idea.adb.wireless.PairingResult;
import com.android.tools.idea.adb.wireless.WiFiPairingNotificationService;
import com.android.tools.idea.adb.wireless.WiFiPairingNotificationServiceKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@UiThread
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0010H\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0010H\u0016J\b\u0010\u0019\u001a\u00020\u0015H\u0016J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0018\u0010\"\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00100\u000fj\b\u0012\u0004\u0012\u00020\u0010`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/android/tools/idea/adb/wireless/PairingCodePairingViewImpl;", "Lcom/android/tools/idea/adb/wireless/PairingCodePairingView;", "project", "Lcom/intellij/openapi/project/Project;", "notificationService", "Lcom/android/tools/idea/adb/wireless/WiFiPairingNotificationService;", "model", "Lcom/android/tools/idea/adb/wireless/PairingCodePairingModel;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/adb/wireless/WiFiPairingNotificationService;Lcom/android/tools/idea/adb/wireless/PairingCodePairingModel;)V", "getModel", "()Lcom/android/tools/idea/adb/wireless/PairingCodePairingModel;", "dlg", "Lcom/android/tools/idea/adb/wireless/PairingCodePairingDialog;", "listeners", "Ljava/util/ArrayList;", "Lcom/android/tools/idea/adb/wireless/PairingCodePairingView$Listener;", "Lkotlin/collections/ArrayList;", "allowPairAction", "", "showDialog", "", "addListener", "listener", "removeListener", "showPairingInProgress", "showWaitingForDeviceProgress", "pairingResult", "Lcom/android/tools/idea/adb/wireless/PairingResult;", "showPairingSuccess", "service", "Lcom/android/tools/idea/adb/wireless/PairingMdnsService;", "device", "Lcom/android/tools/idea/adb/wireless/AdbOnlineDevice;", "showPairingError", "error", "", "intellij.android.adb"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPairingCodePairingViewImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PairingCodePairingViewImpl.kt\ncom/android/tools/idea/adb/wireless/PairingCodePairingViewImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n1869#2,2:83\n*S KotlinDebug\n*F\n+ 1 PairingCodePairingViewImpl.kt\ncom/android/tools/idea/adb/wireless/PairingCodePairingViewImpl\n*L\n44#1:83,2\n*E\n"})
public final class PairingCodePairingViewImpl
implements PairingCodePairingView {
    @NotNull
    private final WiFiPairingNotificationService notificationService;
    @NotNull
    private final PairingCodePairingModel model;
    @NotNull
    private final PairingCodePairingDialog dlg;
    @NotNull
    private final ArrayList<PairingCodePairingView.Listener> listeners;
    private boolean allowPairAction;
    public static final int $stable = 8;

    public PairingCodePairingViewImpl(@NotNull Project project, @NotNull WiFiPairingNotificationService notificationService, @NotNull PairingCodePairingModel model) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)notificationService, (String)"notificationService");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this.notificationService = notificationService;
        this.model = model;
        this.dlg = new PairingCodePairingDialog(project);
        this.listeners = new ArrayList();
        this.allowPairAction = true;
    }

    @Override
    @NotNull
    public PairingCodePairingModel getModel() {
        return this.model;
    }

    @Override
    public void showDialog() {
        this.dlg.setDevice(this.getModel().getService());
        this.dlg.setValidationHandler((Function0<ValidationInfo>)((Function0)() -> PairingCodePairingViewImpl.showDialog$lambda$0(this)));
        this.dlg.setOkButtonHandler((Function0<Boolean>)((Function0)() -> PairingCodePairingViewImpl.showDialog$lambda$2(this)));
        this.dlg.show();
    }

    @Override
    public void addListener(@NotNull PairingCodePairingView.Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    @Override
    public void removeListener(@NotNull PairingCodePairingView.Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.remove(listener2);
    }

    @Override
    public void showPairingInProgress() {
        this.dlg.showPairingInProgress("Pairing with device...");
        this.allowPairAction = false;
    }

    @Override
    public void showWaitingForDeviceProgress(@NotNull PairingResult pairingResult) {
        Intrinsics.checkNotNullParameter((Object)pairingResult, (String)"pairingResult");
        this.dlg.showPairingInProgress("Connecting to device. This takes up to 2 minutes.");
        this.allowPairAction = false;
    }

    @Override
    public void showPairingSuccess(@NotNull PairingMdnsService service, @NotNull AdbOnlineDevice device2) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        this.dlg.showPairingSuccess(device2);
        this.allowPairAction = false;
        WiFiPairingNotificationServiceKt.showPairingSuccessBalloon(this.notificationService, device2);
    }

    @Override
    public void showPairingError(@NotNull PairingMdnsService service, @NotNull Throwable error) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        this.dlg.showPairingError();
        this.allowPairAction = true;
    }

    private static final ValidationInfo showDialog$lambda$0(PairingCodePairingViewImpl this$0) {
        return this$0.dlg.isPairingCodeValid() ? null : new ValidationInfo("Pairing code must be exactly 6 digits", this$0.dlg.getPairingCodeComponent());
    }

    private static final boolean showDialog$lambda$2(PairingCodePairingViewImpl this$0) {
        boolean bl;
        if (this$0.allowPairAction) {
            this$0.getModel().setPairingCode(this$0.dlg.getCurrentPairingCode());
            Iterable $this$forEach$iv = this$0.listeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PairingCodePairingView.Listener it = (PairingCodePairingView.Listener)element$iv;
                boolean bl2 = false;
                it.onPairInvoked();
            }
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }
}

