/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.adb.processnamemonitor;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.adblib.AdbLogger;
import com.android.adblib.AdbSession;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.processmonitor.agenttracker.AgentProcessTrackerConfig;
import com.android.processmonitor.common.ProcessEvent;
import com.android.processmonitor.monitor.ProcessNameMonitor;
import com.android.processmonitor.monitor.ProcessNameMonitorImpl;
import com.android.processmonitor.monitor.ProcessNames;
import com.android.processmonitor.monitor.ddmlib.AdbAdapter;
import com.android.processmonitor.monitor.ddmlib.AdbAdapterImpl;
import com.android.sdklib.deviceprovisioner.DeviceProvisioner;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.adb.AdbService;
import com.android.tools.idea.adblib.AdbLibService;
import com.android.tools.idea.adblib.AndroidAdbLogger;
import com.android.tools.idea.concurrency.CoroutineUtilsKt;
import com.android.tools.idea.deviceprovisioner.DeviceProvisionerService;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.util.StudioPathManager;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PluginPathManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0096@\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u000bH\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0002R\u0016\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/adb/processnamemonitor/ProcessNameMonitorService;", "Lcom/android/processmonitor/monitor/ProcessNameMonitor;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "delegate", "Lcom/android/processmonitor/monitor/ProcessNameMonitorImpl;", "", "start", "", "getProcessNames", "Lcom/android/processmonitor/monitor/ProcessNames;", "serialNumber", "", "pid", "", "trackDeviceProcesses", "Lkotlinx/coroutines/flow/Flow;", "Lcom/android/processmonitor/common/ProcessEvent;", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dispose", "getAgentPath", "Ljava/nio/file/Path;", "intellij.android.adb"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nProcessNameMonitorService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessNameMonitorService.kt\ncom/android/tools/idea/adb/processnamemonitor/ProcessNameMonitorService\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,107:1\n30#2,2:108\n24#3:110\n*S KotlinDebug\n*F\n+ 1 ProcessNameMonitorService.kt\ncom/android/tools/idea/adb/processnamemonitor/ProcessNameMonitorService\n*L\n49#1:108,2\n50#1:110\n*E\n"})
public final class ProcessNameMonitorService
implements ProcessNameMonitor,
Disposable {
    @NotNull
    private final ProcessNameMonitorImpl<? extends Object> delegate;
    public static final int $stable = 8;

    public ProcessNameMonitorService(@NotNull Project project) {
        ProcessNameMonitorImpl processNameMonitorImpl;
        AgentProcessTrackerConfig agentProcessTrackerConfig;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ProcessNameMonitorService processNameMonitorService = this;
        ProcessNameMonitorService processNameMonitorService2 = this;
        boolean bl = false;
        CoroutineScope parentScope = CoroutineUtilsKt.AndroidCoroutineScope$default((Disposable)this, null, (int)2, null);
        AdbSession adbSession = AdbLibService.Companion.getSession(project);
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<DeviceProvisionerService> serviceClass$iv = DeviceProvisionerService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        DeviceProvisioner deviceProvisioner = ((DeviceProvisionerService)object).getDeviceProvisioner();
        ProcessNameMonitorService $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(ProcessNameMonitorService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        AndroidAdbLogger adbLogger = new AndroidAdbLogger(logger);
        ListenableFuture<AndroidDebugBridge> listenableFuture = AdbService.getInstance().getDebugBridge(project);
        Intrinsics.checkNotNullExpressionValue(listenableFuture, (String)"getDebugBridge(...)");
        AdbAdapterImpl adbAdapter = new AdbAdapterImpl(listenableFuture);
        Integer pollingIntervalMs = (Integer)StudioFlags.PROCESS_NAME_TRACKER_AGENT_INTERVAL_MS.get();
        Function1 shouldUseAgentForSdk = ProcessNameMonitorService::delegate$lambda$1$lambda$0;
        Boolean bl2 = (Boolean)StudioFlags.PROCESS_NAME_TRACKER_AGENT_ENABLE.get();
        if (Intrinsics.areEqual((Object)bl2, (Object)true)) {
            Path path = this.getAgentPath();
            Intrinsics.checkNotNull((Object)pollingIntervalMs);
            agentProcessTrackerConfig = new AgentProcessTrackerConfig(path, pollingIntervalMs.intValue(), shouldUseAgentForSdk);
        } else if (Intrinsics.areEqual((Object)bl2, (Object)false)) {
            agentProcessTrackerConfig = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        AgentProcessTrackerConfig trackerAgentConfig = agentProcessTrackerConfig;
        Object t = StudioFlags.PROCESS_NAME_MONITOR_MAX_RETENTION.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        ProcessNameMonitor.Config config = new ProcessNameMonitor.Config(((Number)t).intValue(), trackerAgentConfig);
        boolean bl3 = (Boolean)StudioFlags.PROCESS_NAME_MONITOR_ADBLIB_ENABLED.get() != false && (Boolean)StudioFlags.ADBLIB_MIGRATION_DDMLIB_CLIENT_MANAGER.get() != false;
        if (bl3) {
            processNameMonitorImpl = ProcessNameMonitorImpl.Companion.forAdblib(parentScope, adbSession, deviceProvisioner, config, (AdbLogger)adbLogger);
        } else if (!bl3) {
            processNameMonitorImpl = ProcessNameMonitorImpl.Companion.forDdmlib(parentScope, adbSession, (AdbAdapter)adbAdapter, config, (AdbLogger)adbLogger);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        processNameMonitorService2.delegate = processNameMonitorImpl;
    }

    public void start() {
        this.delegate.start();
    }

    @Nullable
    public ProcessNames getProcessNames(@NotNull String serialNumber, int pid) {
        Intrinsics.checkNotNullParameter((Object)serialNumber, (String)"serialNumber");
        return this.delegate.getProcessNames(serialNumber, pid);
    }

    @Nullable
    public Object trackDeviceProcesses(@NotNull String serialNumber, @NotNull Continuation<? super Flow<? extends ProcessEvent>> $completion) {
        return this.delegate.trackDeviceProcesses(serialNumber, $completion);
    }

    public void dispose() {
        this.delegate.close();
    }

    private final Path getAgentPath() {
        Path path;
        boolean bl = StudioPathManager.isRunningFromSources() && (IdeInfo.getInstance().isAndroidStudio() || IdeInfo.getInstance().isGameTools());
        if (bl) {
            Path path2 = Paths.get(StudioPathManager.getBinariesRoot(), new String[0]).resolve("tools/base/process-monitor/process-tracker-agent");
            path = path2;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        } else if (!bl) {
            Path path3 = PluginPathManager.getPluginHome((String)"android").toPath().resolve("resources/process-tracker-agent");
            path = path3;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return path;
    }

    private static final boolean delegate$lambda$1$lambda$0(int sdk) {
        return sdk < 36 || (Boolean)StudioFlags.LOGCAT_PROTOBUF_ENABLED.get() == false;
    }
}

