/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.actions;

import com.android.tools.idea.model.AndroidModel;
import com.intellij.ide.IdeView;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import icons.StudioIcons;
import org.jetbrains.android.actions.NewAndroidComponentDialog;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class LegacyNewAndroidComponentAction
extends AnAction {
    protected LegacyNewAndroidComponentAction() {
        super(AndroidBundle.message("android.new.component.action.title.non.gradle", new Object[0]), AndroidBundle.message("android.new.component.action.description", new Object[0]), StudioIcons.Common.ANDROID_HEAD);
    }

    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setVisible(LegacyNewAndroidComponentAction.isAvailable(e.getDataContext()));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private static boolean isAvailable(DataContext dataContext) {
        Module module = (Module)PlatformCoreDataKeys.MODULE.getData(dataContext);
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (module == null || view == null || view.getDirectories().length == 0) {
            return false;
        }
        AndroidFacet facet = AndroidFacet.getInstance((Module)module);
        if (facet == null || AndroidModel.isRequired(facet)) {
            return false;
        }
        ProjectFileIndex projectIndex = ProjectRootManager.getInstance((Project)module.getProject()).getFileIndex();
        JavaDirectoryService dirService = JavaDirectoryService.getInstance();
        for (PsiDirectory dir : view.getDirectories()) {
            if (!projectIndex.isUnderSourceRootOfType(dir.getVirtualFile(), JavaModuleSourceRootTypes.SOURCES) || dirService.getPackage(dir) == null) continue;
            return true;
        }
        return false;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        PsiElement[] createdElements;
        DataContext dataContext = e.getDataContext();
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (view == null) {
            return;
        }
        Module module = (Module)PlatformCoreDataKeys.MODULE.getData(dataContext);
        if (module == null) {
            return;
        }
        AndroidFacet facet = AndroidFacet.getInstance((Module)module);
        assert (facet != null);
        PsiDirectory dir = view.getOrChooseDirectory();
        if (dir == null) {
            return;
        }
        NewAndroidComponentDialog dialog2 = new NewAndroidComponentDialog(module, dir);
        dialog2.show();
        if (dialog2.getExitCode() != 0) {
            return;
        }
        for (PsiElement createdElement : createdElements = dialog2.getCreatedElements()) {
            view.selectElement(createdElement);
        }
    }
}

