/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.dom.attrs;

import com.android.ide.common.rendering.api.ResourceReference;
import com.android.tools.dom.attrs.AttributeDefinition;
import com.android.tools.dom.attrs.AttributeDefinitions;
import com.android.tools.dom.attrs.StyleableDefinition;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FilteredAttributeDefinitions
implements AttributeDefinitions {
    private final AttributeDefinitions myWrappee;

    protected FilteredAttributeDefinitions(@NotNull AttributeDefinitions wrappee) {
        this.myWrappee = wrappee;
    }

    protected abstract boolean isAttributeAcceptable(@NotNull ResourceReference var1);

    @Override
    @Nullable
    public StyleableDefinition getStyleableDefinition(@NotNull ResourceReference styleable) {
        StyleableDefinition styleableDef = this.myWrappee.getStyleableDefinition(styleable);
        return styleableDef != null ? new MyStyleableDefinition(styleableDef) : null;
    }

    @Override
    @Deprecated
    @Nullable
    public StyleableDefinition getStyleableByName(@NotNull String name2) {
        StyleableDefinition styleable = this.myWrappee.getStyleableByName(name2);
        return styleable != null ? new MyStyleableDefinition(styleable) : null;
    }

    @Override
    @NotNull
    public Set<ResourceReference> getAttrs() {
        HashSet<ResourceReference> result2 = new HashSet<ResourceReference>();
        for (ResourceReference attrRef : this.myWrappee.getAttrs()) {
            if (!this.isAttributeAcceptable(attrRef)) continue;
            result2.add(attrRef);
        }
        return result2;
    }

    @Override
    @Nullable
    public AttributeDefinition getAttrDefinition(@NotNull ResourceReference attr) {
        AttributeDefinition attribute2 = this.myWrappee.getAttrDefinition(attr);
        return attribute2 != null && this.isAttributeAcceptable(attr) ? attribute2 : null;
    }

    @Override
    @Deprecated
    @Nullable
    public AttributeDefinition getAttrDefByName(@NotNull String name2) {
        AttributeDefinition attribute2 = this.myWrappee.getAttrDefByName(name2);
        return attribute2 != null && this.isAttributeAcceptable(attribute2.getResourceReference()) ? attribute2 : null;
    }

    @Override
    @Nullable
    public String getAttrGroup(@NotNull ResourceReference attr) {
        return this.myWrappee.getAttrGroup(attr);
    }

    private class MyStyleableDefinition
    implements StyleableDefinition {
        private final StyleableDefinition myWrappee;

        private MyStyleableDefinition(StyleableDefinition wrappee) {
            this.myWrappee = wrappee;
        }

        @Override
        @NotNull
        public ResourceReference getResourceReference() {
            return this.myWrappee.getResourceReference();
        }

        @Override
        @NotNull
        public String getName() {
            return this.myWrappee.getName();
        }

        @Override
        @NotNull
        public List<AttributeDefinition> getAttributes() {
            ArrayList<AttributeDefinition> result2 = new ArrayList<AttributeDefinition>();
            for (AttributeDefinition definition : this.myWrappee.getAttributes()) {
                if (!FilteredAttributeDefinitions.this.isAttributeAcceptable(definition.getResourceReference())) continue;
                result2.add(definition);
            }
            return result2;
        }
    }
}

