/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.configurations;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceRepositoryUtil;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.ResourceValueMap;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.ide.common.util.DisjointUnionMap;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.configurations.ConfigurationSettings;
import com.android.tools.res.CacheableResourceRepository;
import com.android.tools.res.FrameworkOverlay;
import com.android.tools.res.ResourceRepositoryManager;
import com.android.tools.sdk.AndroidPlatform;
import com.android.tools.sdk.AndroidTargetData;
import com.android.tools.sdk.CompatibilityRenderTarget;
import com.android.utils.SparseArray;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Table;
import com.intellij.openapi.util.text.Strings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceResolverCache {
    private final ConfigurationSettings mySettings;
    private final Object myLock = new Object();
    @VisibleForTesting
    public final Map<String, ResourceResolver> myResolverMap = new HashMap<String, ResourceResolver>();
    @VisibleForTesting
    public final Map<String, Table<ResourceNamespace, ResourceType, ResourceValueMap>> myAppResourceMap = new HashMap<String, Table<ResourceNamespace, ResourceType, ResourceValueMap>>();
    @VisibleForTesting
    public final Map<String, Map<ResourceType, ResourceValueMap>> myFrameworkResourceMap = new HashMap<String, Map<ResourceType, ResourceValueMap>>();
    private long myCachedGeneration;
    private final SparseArray<AndroidTargetData> myFrameworkResources = new SparseArray();
    private String myCustomConfigurationKey;
    private String myCustomOverlaysKey;
    private String myCustomResolverKey;

    public ResourceResolverCache(ConfigurationSettings settings) {
        this.mySettings = settings;
    }

    @Nullable
    ResourceResolver getCachedResourceResolver(@Nullable IAndroidTarget target2, @NotNull String themeStyle, @NotNull FolderConfiguration fullConfiguration, @NotNull List<FrameworkOverlay> overlays) {
        ResourceRepositoryManager repositoryManager = this.mySettings.getConfigModule().getResourceRepositoryManager();
        if (repositoryManager == null) {
            return null;
        }
        String qualifierString = fullConfiguration.getQualifierString();
        String resolverKey = ResourceResolverCache.getResolverKey(themeStyle, qualifierString, overlays);
        return this.getCachedResolver(resolverKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Slow
    @NotNull
    public ResourceResolver getResourceResolver(@Nullable IAndroidTarget target2, @NotNull String themeStyle, @NotNull FolderConfiguration fullConfiguration, @NotNull List<FrameworkOverlay> overlays) {
        ResourceRepositoryManager repositoryManager = this.mySettings.getConfigModule().getResourceRepositoryManager();
        if (repositoryManager == null) {
            return ResourceResolver.create(Collections.emptyMap(), null);
        }
        CacheableResourceRepository resources = repositoryManager.getAppResources();
        Object object = this.myLock;
        synchronized (object) {
            if (this.myCachedGeneration != resources.getModificationCount()) {
                this.myResolverMap.clear();
                this.myAppResourceMap.clear();
            }
            this.myCachedGeneration = resources.getModificationCount();
        }
        String qualifierString = fullConfiguration.getQualifierString();
        String resolverKey = ResourceResolverCache.getResolverKey(themeStyle, qualifierString, overlays);
        ResourceResolver resolver = this.getCachedResolver(resolverKey);
        if (resolver == null) {
            if (target2 == null) {
                target2 = this.mySettings.getTarget();
            }
            Map frameworkResources = target2 == null ? Collections.emptyMap() : this.getConfiguredFrameworkResources(target2, fullConfiguration, overlays);
            Table configuredAppRes = this.getCachedAppResources(qualifierString);
            if (configuredAppRes == null) {
                configuredAppRes = ResourceRepositoryUtil.getConfiguredResources((ResourceRepository)resources, (FolderConfiguration)fullConfiguration);
                this.cacheAppResources(qualifierString, (Table<ResourceNamespace, ResourceType, ResourceValueMap>)configuredAppRes);
            }
            DisjointUnionMap allResources = new DisjointUnionMap(Collections.singletonMap(ResourceNamespace.ANDROID, frameworkResources), configuredAppRes.rowMap());
            assert (themeStyle.startsWith("@")) : themeStyle;
            ResourceReference theme = null;
            ResourceUrl themeUrl = ResourceUrl.parse((String)themeStyle);
            if (themeUrl != null) {
                ResourceNamespace contextNamespace = repositoryManager.getNamespace();
                theme = themeUrl.resolve(contextNamespace, ResourceNamespace.Resolver.EMPTY_RESOLVER);
            }
            resolver = ResourceResolver.create((Map)allResources, theme);
            if (target2 instanceof CompatibilityRenderTarget) {
                int apiLevel = target2.getVersion().getFeatureLevel();
                if (apiLevel >= 21) {
                    resolver.setDeviceDefaults("Material");
                } else if (apiLevel >= 14) {
                    resolver.setDeviceDefaults("Holo");
                } else {
                    resolver.setDeviceDefaults("");
                }
            }
            this.cacheResourceResolver(resolverKey, resolver);
        }
        return resolver;
    }

    @Slow
    @NotNull
    public Map<ResourceType, ResourceValueMap> getConfiguredFrameworkResources(@NotNull IAndroidTarget target2, @NotNull FolderConfiguration fullConfiguration, @NotNull List<FrameworkOverlay> overlays) {
        ResourceRepository resourceRepository = this.getFrameworkResources(fullConfiguration, target2, overlays);
        if (resourceRepository == null) {
            return Collections.emptyMap();
        }
        String keyString = fullConfiguration.getQualifierString() + ResourceResolverCache.getOverlaysString(overlays);
        Map frameworkResources = this.getCachedFrameworkResources(keyString);
        if (frameworkResources == null) {
            frameworkResources = ResourceRepositoryUtil.getConfiguredResources((ResourceRepository)resourceRepository, (FolderConfiguration)fullConfiguration).row((Object)ResourceNamespace.ANDROID);
            this.cacheFrameworkResources(keyString, frameworkResources);
        }
        return frameworkResources;
    }

    @NotNull
    private static String getResolverKey(@NotNull String themeStyle, @NotNull String qualifierString, @NotNull List<FrameworkOverlay> overlays) {
        return (String)(qualifierString.isEmpty() ? themeStyle : themeStyle + "-" + qualifierString) + ResourceResolverCache.getOverlaysString(overlays);
    }

    @NotNull
    private static String getOverlaysString(@NotNull List<FrameworkOverlay> overlays) {
        return "-Overlays:" + Strings.join(overlays, (String)"-");
    }

    @Slow
    @Nullable
    public ResourceRepository getFrameworkResources(@NotNull FolderConfiguration configuration2, @NotNull IAndroidTarget target2, @NotNull List<FrameworkOverlay> overlays) {
        String language;
        LocaleQualifier locale;
        int apiLevel = target2.getVersion().getFeatureLevel();
        AndroidTargetData targetData = this.getCachedTargetData(apiLevel);
        if (targetData == null) {
            AndroidPlatform platform = this.mySettings.getConfigModule().getAndroidPlatform();
            if (platform == null) {
                return null;
            }
            targetData = AndroidTargetData.get(platform.getSdkData(), target2);
            this.cacheTargetData(apiLevel, targetData);
        }
        if ((locale = configuration2.getLocaleQualifier()) == null) {
            locale = this.mySettings.getLocale().qualifier;
        }
        ImmutableSet languages = (language = locale.getLanguage()) == null ? ImmutableSet.of() : ImmutableSet.of((Object)language);
        return targetData.getFrameworkResources((Set<String>)languages, overlays);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.myLock;
        synchronized (object) {
            this.myCachedGeneration = 0L;
            this.myAppResourceMap.clear();
            this.myResolverMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceCustomConfig(@NotNull String themeStyle, @NotNull FolderConfiguration fullConfiguration, @NotNull List<FrameworkOverlay> overlays) {
        String overlayString = ResourceResolverCache.getOverlaysString(overlays);
        String qualifierString = fullConfiguration.getQualifierString();
        String newCustomResolverKey = ResourceResolverCache.getResolverKey(themeStyle, qualifierString, overlays);
        Object object = this.myLock;
        synchronized (object) {
            if (newCustomResolverKey.equals(this.myCustomResolverKey)) {
                return;
            }
            if (this.myCustomConfigurationKey != null) {
                this.myFrameworkResourceMap.remove(this.myCustomConfigurationKey + this.myCustomOverlaysKey);
                this.myAppResourceMap.remove(this.myCustomConfigurationKey);
            }
            if (this.myCustomResolverKey != null) {
                this.myResolverMap.remove(this.myCustomResolverKey);
            }
            this.myCustomConfigurationKey = qualifierString;
            this.myCustomOverlaysKey = overlayString;
            this.myCustomResolverKey = newCustomResolverKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheTargetData(int apiLevel, @NotNull AndroidTargetData targetData) {
        Object object = this.myLock;
        synchronized (object) {
            this.myFrameworkResources.put(apiLevel, (Object)targetData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private AndroidTargetData getCachedTargetData(int apiLevel) {
        Object object = this.myLock;
        synchronized (object) {
            return (AndroidTargetData)this.myFrameworkResources.get(apiLevel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheFrameworkResources(@NotNull String qualifierString, @NotNull Map<ResourceType, ResourceValueMap> frameworkResources) {
        Object object = this.myLock;
        synchronized (object) {
            this.myFrameworkResourceMap.put(qualifierString, frameworkResources);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Map<ResourceType, ResourceValueMap> getCachedFrameworkResources(@NotNull String qualifierString) {
        Object object = this.myLock;
        synchronized (object) {
            return this.myFrameworkResourceMap.get(qualifierString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheAppResources(@NotNull String qualifierString, @NotNull Table<ResourceNamespace, ResourceType, ResourceValueMap> configuredAppResources) {
        Object object = this.myLock;
        synchronized (object) {
            this.myAppResourceMap.put(qualifierString, configuredAppResources);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Table<ResourceNamespace, ResourceType, ResourceValueMap> getCachedAppResources(@NotNull String qualifierString) {
        Object object = this.myLock;
        synchronized (object) {
            return this.myAppResourceMap.get(qualifierString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheResourceResolver(@NotNull String resolverKey, @NotNull ResourceResolver resolver) {
        Object object = this.myLock;
        synchronized (object) {
            this.myResolverMap.put(resolverKey, resolver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ResourceResolver getCachedResolver(@NotNull String resolverKey) {
        Object object = this.myLock;
        synchronized (object) {
            return this.myResolverMap.get(resolverKey);
        }
    }
}

