/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.analytics;

import com.android.ddmlib.IDevice;
import com.android.ide.common.util.DeviceUtils;
import com.android.tools.analytics.CommonMetricsData;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.stats.AnonymizerUtil;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.DeviceInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\"\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"withProjectId", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$Builder;", "project", "Lcom/intellij/openapi/project/Project;", "getApplicationId", "", "deviceToDeviceInfo", "Lcom/google/wireless/android/sdk/stats/DeviceInfo;", "device", "Lcom/android/ddmlib/IDevice;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "analytics"})
@JvmName(name="UsageTrackerUtils")
@SourceDebugExtension(value={"SMAP\nextensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 extensions.kt\ncom/android/tools/analytics/UsageTrackerUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,119:1\n1#2:120\n14#3:121\n*S KotlinDebug\n*F\n+ 1 extensions.kt\ncom/android/tools/analytics/UsageTrackerUtils\n*L\n118#1:121\n*E\n"})
public final class UsageTrackerUtils {
    @NotNull
    private static final Logger LOG;

    @NotNull
    public static final AndroidStudioEvent.Builder withProjectId(@NotNull AndroidStudioEvent.Builder $this$withProjectId, @Nullable Project project) {
        block5: {
            Object object;
            String string;
            Intrinsics.checkNotNullParameter((Object)$this$withProjectId, (String)"<this>");
            Project project2 = project;
            if (project2 == null) break block5;
            Project it = project2;
            boolean bl = false;
            if (project.isDefault()) {
                string = "DEFAULT";
            } else {
                String string2 = project.getBasePath();
                Intrinsics.checkNotNull((Object)string2);
                String string3 = AnonymizerUtil.anonymizeUtf8((String)string2);
                Intrinsics.checkNotNull((Object)string3);
                string = string3;
            }
            $this$withProjectId.setProjectId(string);
            try {
                boolean bl2 = false;
                object = Result.constructor-impl((Object)UsageTrackerUtils.getApplicationId(it));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            String appId = (String)LoggerKt.getOrLogException((Object)object, (Logger)LOG);
            if (appId != null) {
                $this$withProjectId.setRawProjectId(appId);
            }
        }
        return $this$withProjectId;
    }

    private static final String getApplicationId(Project project) {
        if (project.isDisposed()) {
            return null;
        }
        ModuleManager moduleManager = ModuleManager.Companion.getInstance(project);
        for (Module module : moduleManager.getModules()) {
            AndroidFacet facet;
            AndroidModel androidModel;
            if (module.isDisposed() || (androidModel = AndroidModel.Companion.get(module)) == null || (facet = AndroidFacet.getInstance((Module)module)) == null || facet.getProperties().PROJECT_TYPE != 0) continue;
            return androidModel.getApplicationId();
        }
        return null;
    }

    @NotNull
    public static final DeviceInfo deviceToDeviceInfo(@NotNull IDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        DeviceInfo.Builder builder = DeviceInfo.newBuilder().setAnonymizedSerialNumber(AnonymizerUtil.anonymizeUtf8((String)device2.getSerialNumber()));
        String string = device2.getProperty("ro.build.tags");
        if (string == null) {
            string = "";
        }
        DeviceInfo.Builder builder2 = builder.setBuildTags(string);
        String string2 = device2.getProperty("ro.build.type");
        if (string2 == null) {
            string2 = "";
        }
        DeviceInfo.Builder builder3 = builder2.setBuildType(string2);
        String string3 = device2.getProperty("ro.build.version.release");
        if (string3 == null) {
            string3 = "";
        }
        DeviceInfo.Builder builder4 = builder3.setBuildVersionRelease(string3);
        String string4 = device2.getProperty("ro.build.version.sdk_full");
        if (string4 == null && (string4 = device2.getProperty("ro.build.version.sdk")) == null) {
            string4 = "";
        }
        DeviceInfo.Builder builder5 = builder4.setBuildApiLevelFull(string4).setCpuAbi(CommonMetricsData.applicationBinaryInterfaceFromString((String)device2.getProperty("ro.product.cpu.abi")));
        String string5 = device2.getProperty("ro.product.manufacturer");
        if (string5 == null) {
            string5 = "";
        }
        DeviceInfo.Builder builder6 = builder5.setManufacturer(string5).setDeviceType(device2.isEmulator() ? DeviceInfo.DeviceType.LOCAL_EMULATOR : DeviceInfo.DeviceType.LOCAL_PHYSICAL).setMdnsConnectionType(DeviceUtils.isMdnsAutoConnectUnencrypted((IDevice)device2) ? DeviceInfo.MdnsConnectionType.MDNS_AUTO_CONNECT_UNENCRYPTED : (DeviceUtils.isMdnsAutoConnectTls((IDevice)device2) ? DeviceInfo.MdnsConnectionType.MDNS_AUTO_CONNECT_TLS : DeviceInfo.MdnsConnectionType.MDNS_NONE)).addAllCharacteristics((Iterable)device2.getHardwareCharacteristics());
        String string6 = device2.getProperty("ro.product.model");
        if (string6 == null) {
            string6 = "";
        }
        DeviceInfo deviceInfo2 = builder6.setModel(string6).build();
        Intrinsics.checkNotNullExpressionValue((Object)deviceInfo2, (String)"build(...)");
        return deviceInfo2;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AndroidStudioEvent.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

