/*
 * Decompiled with CFR 0.152.
 */
package com.android.flags;

import com.android.flags.BooleanFlag;
import com.android.flags.DebugFlag;
import com.android.flags.EnumFlag;
import com.android.flags.FlagDefault;
import com.android.flags.FlagGroup;
import com.android.flags.IntFlag;
import com.android.flags.LongFlag;
import com.android.flags.MendelFlag;
import com.android.flags.StringFlag;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 (*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002'(BE\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u000b\u0010\u001f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001cJ\u0013\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\"J\u0006\u0010#\u001a\u00020\u001eR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012R\u0012\u0010\u0018\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u0014\u0010\u001a\u001a\u00028\u00008BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010$\u001a\u00020%8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010&\u0082\u0001\u0007)*+,-./\u00a8\u00060"}, d2={"Lcom/android/flags/Flag;", "T", "", "group", "Lcom/android/flags/FlagGroup;", "name", "", "displayName", "description", "default", "Lcom/android/flags/FlagDefault;", "valueConverter", "Lcom/android/flags/Flag$ValueConverter;", "<init>", "(Lcom/android/flags/FlagGroup;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/android/flags/FlagDefault;Lcom/android/flags/Flag$ValueConverter;)V", "getGroup", "()Lcom/android/flags/FlagGroup;", "getDisplayName", "()Ljava/lang/String;", "getDescription", "getDefault", "()Lcom/android/flags/FlagDefault;", "id", "getId", "_defaultValue", "Ljava/lang/Object;", "defaultValue", "getDefaultValue", "()Ljava/lang/Object;", "validate", "", "get", "override", "overrideValue", "(Ljava/lang/Object;)V", "clearOverride", "isUserOverridden", "", "()Z", "ValueConverter", "Companion", "Lcom/android/flags/BooleanFlag;", "Lcom/android/flags/DebugFlag;", "Lcom/android/flags/EnumFlag;", "Lcom/android/flags/IntFlag;", "Lcom/android/flags/LongFlag;", "Lcom/android/flags/MendelFlag;", "Lcom/android/flags/StringFlag;", "android.sdktools.flags"})
@SourceDebugExtension(value={"SMAP\nFlag.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Flag.kt\ncom/android/flags/Flag\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,318:1\n1#2:319\n*E\n"})
public abstract sealed class Flag<T>
permits BooleanFlag, DebugFlag, EnumFlag, IntFlag, LongFlag, MendelFlag, StringFlag {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FlagGroup group;
    @NotNull
    private final String displayName;
    @NotNull
    private final String description;
    @NotNull
    private final FlagDefault<T> default;
    @NotNull
    private final ValueConverter<T> valueConverter;
    @NotNull
    private final String id;
    @Nullable
    private T _defaultValue;

    private Flag(FlagGroup group2, String name2, String displayName, String description2, FlagDefault<T> flagDefault, ValueConverter<T> valueConverter) {
        this.group = group2;
        this.displayName = displayName;
        this.description = description2;
        this.default = flagDefault;
        this.valueConverter = valueConverter;
        this.id = this.group.getName() + "." + name2;
        this.group.getFlags().register(this);
    }

    @NotNull
    public final FlagGroup getGroup() {
        return this.group;
    }

    @NotNull
    public final String getDisplayName() {
        return this.displayName;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    @NotNull
    public final FlagDefault<T> getDefault() {
        return this.default;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    private final T getDefaultValue() {
        T t = this._defaultValue;
        if (t == null) {
            Object t2;
            Object it = t2 = this.default.get();
            boolean bl = false;
            this._defaultValue = it;
            t = t2;
        }
        return t;
    }

    public final void validate() {
        this.group.validate();
        Flag.Companion.verifyDefaultValue(this.getDefaultValue(), this.valueConverter);
        Companion.verifyFlagIdFormat(this.id);
        Companion.verifyDisplayTextFormat(this.displayName);
        Companion.verifyDisplayTextFormat(this.description);
    }

    public final T get() {
        T t;
        String string = this.group.getFlags().getValue(this);
        if (string == null) {
            return this.getDefaultValue();
        }
        String strValue = string;
        try {
            t = this.valueConverter.deserialize(strValue);
        }
        catch (Exception exception) {
            t = this.getDefaultValue();
        }
        return t;
    }

    public final void override(T overrideValue) {
        this.group.getFlags().getUserOverrides().put(this, this.valueConverter.serialize(overrideValue));
    }

    public final void clearOverride() {
        this.group.getFlags().getUserOverrides().remove(this);
    }

    public final boolean isUserOverridden() {
        return this.group.getFlags().getUserOverrides().get(this) != null;
    }

    @JvmStatic
    public static final void verifyFlagIdFormat(@NotNull String id2) {
        Companion.verifyFlagIdFormat(id2);
    }

    @JvmStatic
    public static final void verifyDisplayTextFormat(@NotNull String name2) {
        Companion.verifyDisplayTextFormat(name2);
    }

    public /* synthetic */ Flag(FlagGroup group2, String name2, String displayName, String description2, FlagDefault flagDefault, ValueConverter valueConverter, DefaultConstructorMarker $constructor_marker) {
        this(group2, name2, displayName, description2, flagDefault, valueConverter);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007H\u0007J)\u0010\n\u001a\u00020\u0005\"\u0004\b\u0001\u0010\u000b2\u0006\u0010\f\u001a\u0002H\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000eH\u0002\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/android/flags/Flag$Companion;", "", "<init>", "()V", "verifyFlagIdFormat", "", "id", "", "verifyDisplayTextFormat", "name", "verifyDefaultValue", "T", "defaultValue", "converter", "Lcom/android/flags/Flag$ValueConverter;", "(Ljava/lang/Object;Lcom/android/flags/Flag$ValueConverter;)V", "android.sdktools.flags"})
    @SourceDebugExtension(value={"SMAP\nFlag.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Flag.kt\ncom/android/flags/Flag$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,318:1\n1#2:319\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void verifyFlagIdFormat(@NotNull String id2) {
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            CharSequence charSequence = id2;
            if (!new Regex("[a-z][a-z0-9]*(\\.[a-z0-9]+)*").matches(charSequence)) {
                boolean bl = false;
                String string = "Invalid id: " + id2;
                throw new IllegalArgumentException(string.toString());
            }
        }

        @JvmStatic
        public final void verifyDisplayTextFormat(@NotNull String name2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            if (!(((CharSequence)name2).length() > 0 && name2.charAt(0) != ' ' && name2.charAt(name2.length() - 1) != ' ')) {
                boolean bl = false;
                String string = "Invalid name: " + name2;
                throw new IllegalArgumentException(string.toString());
            }
        }

        private final <T> void verifyDefaultValue(T defaultValue, ValueConverter<T> converter) {
            T t;
            String string;
            try {
                string = converter.serialize(defaultValue);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Default value cannot be serialized", e);
            }
            String serialized = string;
            try {
                t = converter.deserialize(serialized);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Default value cannot be deserialized.");
            }
            T deserialized = t;
            if (!Intrinsics.areEqual(deserialized, defaultValue)) {
                boolean bl = false;
                String string2 = "Deserialized value does not match default value.";
                throw new IllegalArgumentException(string2.toString());
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\bd\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u0007\u001a\u00028\u00012\u0006\u0010\b\u001a\u00020\u0004H&\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n\u00c0\u0006\u0003"}, d2={"Lcom/android/flags/Flag$ValueConverter;", "T", "", "serialize", "", "value", "(Ljava/lang/Object;)Ljava/lang/String;", "deserialize", "strValue", "(Ljava/lang/String;)Ljava/lang/Object;", "android.sdktools.flags"})
    protected static interface ValueConverter<T> {
        @NotNull
        public String serialize(T var1);

        public T deserialize(@NotNull String var1);
    }
}

