/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.model;

import com.android.build.attribution.ui.BuildAttributionUIUtilKt;
import com.android.build.attribution.ui.data.CriticalPathEntryUiData;
import com.android.build.attribution.ui.data.CriticalPathPluginUiData;
import com.android.build.attribution.ui.data.CriticalPathTaskCategoryUiData;
import com.android.build.attribution.ui.data.TaskUiData;
import com.android.build.attribution.ui.model.TasksPageId;
import com.android.build.attribution.ui.model.TasksTreePresentableNodeDescriptor;
import com.android.build.attribution.ui.model.TimeDistributionBuilder;
import com.android.build.attribution.ui.panels.CriticalPathChartLegend;
import com.android.build.attribution.ui.view.BuildAnalyzerTreeNodePresentation;
import com.android.buildanalyzer.common.TaskCategoryIssue;
import com.google.wireless.android.sdk.stats.BuildAttributionUiEvent;
import java.awt.Color;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0015\u0010\u0013\u001a\u00060\u0014R\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\u00a8\u0006+"}, d2={"Lcom/android/build/attribution/ui/model/EntryDetailsNodeDescriptor;", "Lcom/android/build/attribution/ui/model/TasksTreePresentableNodeDescriptor;", "entryData", "Lcom/android/build/attribution/ui/data/CriticalPathEntryUiData;", "filteredTaskNodes", "", "Lcom/android/build/attribution/ui/data/TaskUiData;", "timeDistributionBuilder", "Lcom/android/build/attribution/ui/model/TimeDistributionBuilder;", "<init>", "(Lcom/android/build/attribution/ui/data/CriticalPathEntryUiData;Ljava/util/List;Lcom/android/build/attribution/ui/model/TimeDistributionBuilder;)V", "getEntryData", "()Lcom/android/build/attribution/ui/data/CriticalPathEntryUiData;", "getFilteredTaskNodes", "()Ljava/util/List;", "filteredWarningCount", "", "getFilteredWarningCount", "()I", "filteredEntryTime", "Lcom/android/build/attribution/ui/model/TimeDistributionBuilder$TimeEntry;", "getFilteredEntryTime", "()Lcom/android/build/attribution/ui/model/TimeDistributionBuilder$TimeEntry;", "pageId", "Lcom/android/build/attribution/ui/model/TasksPageId;", "getPageId", "()Lcom/android/build/attribution/ui/model/TasksPageId;", "analyticsPageType", "Lcom/google/wireless/android/sdk/stats/BuildAttributionUiEvent$Page$PageType;", "getAnalyticsPageType", "()Lcom/google/wireless/android/sdk/stats/BuildAttributionUiEvent$Page$PageType;", "presentation", "Lcom/android/build/attribution/ui/view/BuildAnalyzerTreeNodePresentation;", "getPresentation", "()Lcom/android/build/attribution/ui/view/BuildAnalyzerTreeNodePresentation;", "relativeWeight", "", "getRelativeWeight", "()D", "chartItemColor", "Ljava/awt/Color;", "getChartItemColor", "()Ljava/awt/Color;", "intellij.android.build-attribution"})
@SourceDebugExtension(value={"SMAP\nTasksDataPageModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TasksDataPageModel.kt\ncom/android/build/attribution/ui/model/EntryDetailsNodeDescriptor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,436:1\n1788#2,4:437\n1#3:441\n*S KotlinDebug\n*F\n+ 1 TasksDataPageModel.kt\ncom/android/build/attribution/ui/model/EntryDetailsNodeDescriptor\n*L\n374#1:437,4\n*E\n"})
public final class EntryDetailsNodeDescriptor
extends TasksTreePresentableNodeDescriptor {
    @NotNull
    private final CriticalPathEntryUiData entryData;
    @NotNull
    private final List<TaskUiData> filteredTaskNodes;
    private final int filteredWarningCount;
    @NotNull
    private final TimeDistributionBuilder.TimeEntry filteredEntryTime;
    @NotNull
    private final TasksPageId pageId;
    @NotNull
    private final BuildAttributionUiEvent.Page.PageType analyticsPageType;

    /*
     * WARNING - void declaration
     */
    public EntryDetailsNodeDescriptor(@NotNull CriticalPathEntryUiData entryData, @NotNull List<? extends TaskUiData> filteredTaskNodes, @NotNull TimeDistributionBuilder timeDistributionBuilder) {
        TasksPageId tasksPageId;
        long l;
        int n;
        TaskUiData it;
        int n2;
        void $this$count$iv;
        Intrinsics.checkNotNullParameter((Object)entryData, (String)"entryData");
        Intrinsics.checkNotNullParameter(filteredTaskNodes, (String)"filteredTaskNodes");
        Intrinsics.checkNotNullParameter((Object)timeDistributionBuilder, (String)"timeDistributionBuilder");
        super(null);
        this.entryData = entryData;
        this.filteredTaskNodes = filteredTaskNodes;
        Object object = this.filteredTaskNodes;
        EntryDetailsNodeDescriptor entryDetailsNodeDescriptor = this;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n2 = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                it = (TaskUiData)element$iv;
                boolean bl = false;
                if (!it.getHasWarning() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n2 = count$iv;
        }
        entryDetailsNodeDescriptor.filteredWarningCount = n = n2;
        object = this.filteredTaskNodes;
        TimeDistributionBuilder timeDistributionBuilder2 = timeDistributionBuilder;
        entryDetailsNodeDescriptor = this;
        long l2 = 0L;
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            Object t = iterator2.next();
            it = (TaskUiData)t;
            l = l2;
            boolean bl = false;
            long l3 = it.getExecutionTime().getTimeMs();
            l2 = l + l3;
        }
        l = l2;
        entryDetailsNodeDescriptor.filteredEntryTime = timeDistributionBuilder2.registerTimeEntry(l);
        object = this.entryData;
        if (object instanceof CriticalPathPluginUiData) {
            tasksPageId = TasksPageId.Companion.plugin((CriticalPathPluginUiData)this.entryData);
        } else if (object instanceof CriticalPathTaskCategoryUiData) {
            tasksPageId = TasksPageId.Companion.taskCategory(((CriticalPathTaskCategoryUiData)this.entryData).getTaskCategory());
        } else {
            throw new IllegalArgumentException("Unknown type " + this.entryData.getClass() + " of " + this.entryData.getName());
        }
        this.pageId = tasksPageId;
        this.analyticsPageType = this.entryData instanceof CriticalPathPluginUiData ? BuildAttributionUiEvent.Page.PageType.PLUGIN_PAGE : BuildAttributionUiEvent.Page.PageType.TASK_CATEGORY_PAGE;
    }

    @NotNull
    public final CriticalPathEntryUiData getEntryData() {
        return this.entryData;
    }

    @NotNull
    public final List<TaskUiData> getFilteredTaskNodes() {
        return this.filteredTaskNodes;
    }

    public final int getFilteredWarningCount() {
        return this.filteredWarningCount;
    }

    @NotNull
    public final TimeDistributionBuilder.TimeEntry getFilteredEntryTime() {
        return this.filteredEntryTime;
    }

    @Override
    @NotNull
    public TasksPageId getPageId() {
        return this.pageId;
    }

    @Override
    @NotNull
    public BuildAttributionUiEvent.Page.PageType getAnalyticsPageType() {
        return this.analyticsPageType;
    }

    @Override
    @NotNull
    public BuildAnalyzerTreeNodePresentation getPresentation() {
        return new BuildAnalyzerTreeNodePresentation(this.entryData.getName(), this.entryData instanceof CriticalPathTaskCategoryUiData ? BuildAttributionUIUtilKt.warningsCountString(this.filteredWarningCount + ((CriticalPathTaskCategoryUiData)this.entryData).getTaskCategoryIssues(TaskCategoryIssue.Severity.WARNING, false).size()) : BuildAttributionUIUtilKt.warningsCountString(this.filteredWarningCount), this.filteredEntryTime.toRightAlignedNodeDurationText(), null, 8, null);
    }

    @Override
    public double getRelativeWeight() {
        return this.filteredEntryTime.toTimeWithPercentage().getPercentage();
    }

    @Override
    @NotNull
    public Color getChartItemColor() {
        Color color = CriticalPathChartLegend.pluginColorPalette.getColor((String)this.entryData.getName()).baseColor;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"baseColor");
        return color;
    }
}

