/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.data.builder;

import com.android.build.attribution.analyzers.BuildEventsAnalysisResult;
import com.android.build.attribution.data.PluginData;
import com.android.build.attribution.data.TaskData;
import com.android.build.attribution.ui.data.PluginSourceType;
import com.android.build.attribution.ui.data.TaskCategoryIssueUiData;
import com.android.build.attribution.ui.data.TaskIssueUiData;
import com.android.build.attribution.ui.data.TaskUiData;
import com.android.build.attribution.ui.data.TimeWithPercentage;
import com.android.build.attribution.ui.data.builder.TaskCategoryIssueUiDataContainer;
import com.android.build.attribution.ui.data.builder.TaskIssueUiDataContainer;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.buildanalyzer.common.TaskCategoryIssue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/build/attribution/ui/data/builder/TaskUiDataContainer;", "", "buildAnalysisResult", "Lcom/android/build/attribution/analyzers/BuildEventsAnalysisResult;", "issuesContainer", "Lcom/android/build/attribution/ui/data/builder/TaskIssueUiDataContainer;", "taskCategoryIssuesContainer", "Lcom/android/build/attribution/ui/data/builder/TaskCategoryIssueUiDataContainer;", "criticalPathDuration", "", "<init>", "(Lcom/android/build/attribution/analyzers/BuildEventsAnalysisResult;Lcom/android/build/attribution/ui/data/builder/TaskIssueUiDataContainer;Lcom/android/build/attribution/ui/data/builder/TaskCategoryIssueUiDataContainer;J)V", "getIssuesContainer", "()Lcom/android/build/attribution/ui/data/builder/TaskIssueUiDataContainer;", "getTaskCategoryIssuesContainer", "()Lcom/android/build/attribution/ui/data/builder/TaskCategoryIssueUiDataContainer;", "tasksCache", "", "Lcom/android/build/attribution/data/TaskData;", "Lcom/android/build/attribution/ui/data/TaskUiData;", "tasksDeterminingBuildDuration", "", "configurationCacheUsed", "", "getByTaskData", "task", "intellij.android.build-attribution"})
public final class TaskUiDataContainer {
    @NotNull
    private final TaskIssueUiDataContainer issuesContainer;
    @NotNull
    private final TaskCategoryIssueUiDataContainer taskCategoryIssuesContainer;
    private final long criticalPathDuration;
    @NotNull
    private final Map<TaskData, TaskUiData> tasksCache;
    @NotNull
    private final Set<TaskData> tasksDeterminingBuildDuration;
    private final boolean configurationCacheUsed;

    public TaskUiDataContainer(@NotNull BuildEventsAnalysisResult buildAnalysisResult, @NotNull TaskIssueUiDataContainer issuesContainer, @NotNull TaskCategoryIssueUiDataContainer taskCategoryIssuesContainer, long criticalPathDuration) {
        Intrinsics.checkNotNullParameter((Object)buildAnalysisResult, (String)"buildAnalysisResult");
        Intrinsics.checkNotNullParameter((Object)issuesContainer, (String)"issuesContainer");
        Intrinsics.checkNotNullParameter((Object)taskCategoryIssuesContainer, (String)"taskCategoryIssuesContainer");
        this.issuesContainer = issuesContainer;
        this.taskCategoryIssuesContainer = taskCategoryIssuesContainer;
        this.criticalPathDuration = criticalPathDuration;
        this.tasksCache = new HashMap();
        this.tasksDeterminingBuildDuration = CollectionsKt.toHashSet((Iterable)buildAnalysisResult.getTasksDeterminingBuildDuration());
        this.configurationCacheUsed = buildAnalysisResult.buildUsesConfigurationCache();
    }

    @NotNull
    public final TaskIssueUiDataContainer getIssuesContainer() {
        return this.issuesContainer;
    }

    @NotNull
    public final TaskCategoryIssueUiDataContainer getTaskCategoryIssuesContainer() {
        return this.taskCategoryIssuesContainer;
    }

    @NotNull
    public final TaskUiData getByTaskData(@NotNull TaskData task2) {
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        TaskUiData taskUiData = this.tasksCache.computeIfAbsent(task2, arg_0 -> TaskUiDataContainer.getByTaskData$lambda$1(arg_0 -> TaskUiDataContainer.getByTaskData$lambda$0(task2, this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)taskUiData, (String)"computeIfAbsent(...)");
        return taskUiData;
    }

    private static final TaskUiData getByTaskData$lambda$0(TaskData $task, TaskUiDataContainer this$0, TaskData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new TaskUiData($task, this$0){
            private final String pluginName;
            private final PluginSourceType sourceType;
            private final boolean pluginUnknownBecauseOfCC;
            private final String module;
            private final String name;
            private final String taskPath;
            private final String taskType;
            private final TimeWithPercentage executionTime;
            private final boolean executedIncrementally;
            private final String executionMode;
            private final boolean onLogicalCriticalPath;
            private final boolean onExtendedCriticalPath;
            private final List<String> reasonsToRun;
            private final TaskCategory primaryTaskCategory;
            private final List<TaskCategory> secondaryTaskCategories;
            private final List<TaskCategoryIssueUiData> relatedTaskCategoryIssues;
            final /* synthetic */ TaskData $task;
            final /* synthetic */ TaskUiDataContainer this$0;
            {
                this.$task = $task;
                this.this$0 = $receiver;
                this.pluginName = $task.getOriginPlugin().displayNameInProject($task.getProjectPath());
                this.sourceType = $task.getOriginPlugin().isAndroidPlugin() ? PluginSourceType.ANDROID_PLUGIN : ($task.getOriginPlugin().isKotlinPlugin() ? PluginSourceType.ANDROID_PLUGIN : ($task.getOriginPlugin().isGradlePlugin() ? PluginSourceType.ANDROID_PLUGIN : ($task.getOriginPlugin().isJavaPlugin() ? PluginSourceType.ANDROID_PLUGIN : ($task.getOriginPlugin().getPluginType() == PluginData.PluginType.BUILDSRC_PLUGIN || $task.getOriginPlugin().getPluginType() == PluginData.PluginType.SCRIPT ? PluginSourceType.BUILD_SCRIPT : PluginSourceType.THIRD_PARTY))));
                this.pluginUnknownBecauseOfCC = $task.getOriginPlugin().getPluginType() == PluginData.PluginType.UNKNOWN && TaskUiDataContainer.access$getConfigurationCacheUsed$p($receiver);
                this.module = $task.getProjectPath();
                this.name = $task.getTaskName();
                this.taskPath = $task.getTaskPath();
                this.taskType = $task.getTaskType();
                this.executionTime = new TimeWithPercentage($task.getExecutionTime(), TaskUiDataContainer.access$getCriticalPathDuration$p($receiver));
                this.executedIncrementally = $task.getExecutionMode() == TaskData.TaskExecutionMode.INCREMENTAL;
                this.executionMode = $task.getExecutionMode().name();
                this.onLogicalCriticalPath = $task.isOnTheCriticalPath();
                this.onExtendedCriticalPath = TaskUiDataContainer.access$getTasksDeterminingBuildDuration$p($receiver).contains($task);
                this.reasonsToRun = $task.getExecutionReasons();
                this.primaryTaskCategory = $task.getPrimaryTaskCategory();
                this.secondaryTaskCategories = $task.getSecondaryTaskCategories();
                this.relatedTaskCategoryIssues = $receiver.getTaskCategoryIssuesContainer().issuesForCategory($task.getPrimaryTaskCategory(), TaskCategoryIssue.Severity.WARNING);
            }

            public String getPluginName() {
                return this.pluginName;
            }

            public PluginSourceType getSourceType() {
                return this.sourceType;
            }

            public boolean getPluginUnknownBecauseOfCC() {
                return this.pluginUnknownBecauseOfCC;
            }

            public String getModule() {
                return this.module;
            }

            public String getName() {
                return this.name;
            }

            public String getTaskPath() {
                return this.taskPath;
            }

            public String getTaskType() {
                return this.taskType;
            }

            public TimeWithPercentage getExecutionTime() {
                return this.executionTime;
            }

            public boolean getExecutedIncrementally() {
                return this.executedIncrementally;
            }

            public String getExecutionMode() {
                return this.executionMode;
            }

            public boolean getOnLogicalCriticalPath() {
                return this.onLogicalCriticalPath;
            }

            public boolean getOnExtendedCriticalPath() {
                return this.onExtendedCriticalPath;
            }

            public List<String> getReasonsToRun() {
                return this.reasonsToRun;
            }

            public List<TaskIssueUiData> getIssues() {
                return this.this$0.getIssuesContainer().issuesForTask(this.$task);
            }

            public TaskCategory getPrimaryTaskCategory() {
                return this.primaryTaskCategory;
            }

            public List<TaskCategory> getSecondaryTaskCategories() {
                return this.secondaryTaskCategories;
            }

            public List<TaskCategoryIssueUiData> getRelatedTaskCategoryIssues() {
                return this.relatedTaskCategoryIssues;
            }

            public boolean getHasWarning() {
                return TaskUiData.super.getHasWarning();
            }

            public boolean getHasInfo() {
                return TaskUiData.super.getHasInfo();
            }
        };
    }

    private static final TaskUiData getByTaskData$lambda$1(Function1 $tmp0, Object p0) {
        return (TaskUiData)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ boolean access$getConfigurationCacheUsed$p(TaskUiDataContainer $this) {
        return $this.configurationCacheUsed;
    }

    public static final /* synthetic */ long access$getCriticalPathDuration$p(TaskUiDataContainer $this) {
        return $this.criticalPathDuration;
    }

    public static final /* synthetic */ Set access$getTasksDeterminingBuildDuration$p(TaskUiDataContainer $this) {
        return $this.tasksDeterminingBuildDuration;
    }
}

