/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.analyzers;

import com.android.build.attribution.analyzers.AnalyzerNotRun;
import com.android.build.attribution.analyzers.BaseAnalyzer;
import com.android.build.attribution.analyzers.BuildEventsAnalyzersProxy;
import com.android.build.attribution.analyzers.CheckJetifierResultData;
import com.android.build.attribution.analyzers.JetifierCanBeRemoved;
import com.android.build.attribution.analyzers.JetifierNotUsed;
import com.android.build.attribution.analyzers.JetifierRequiredForLibraries;
import com.android.build.attribution.analyzers.JetifierUsageAnalyzerKt;
import com.android.build.attribution.analyzers.JetifierUsageAnalyzerResult;
import com.android.build.attribution.analyzers.JetifierUsedCheckRequired;
import com.android.build.attribution.analyzers.PostBuildProcessAnalyzer;
import com.android.build.attribution.data.StudioProvidedInfo;
import com.android.buildanalyzer.common.CheckJetifierResult;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0011\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0002H\u0014J\b\u0010\u0019\u001a\u00020\u0013H\u0016R\u0012\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u0012\u0010\u000b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lcom/android/build/attribution/analyzers/JetifierUsageAnalyzer;", "Lcom/android/build/attribution/analyzers/BaseAnalyzer;", "Lcom/android/build/attribution/analyzers/JetifierUsageAnalyzerResult;", "Lcom/android/build/attribution/analyzers/PostBuildProcessAnalyzer;", "cachedCheckJetifierResultData", "Lcom/android/build/attribution/analyzers/CheckJetifierResultData;", "<init>", "(Lcom/android/build/attribution/analyzers/CheckJetifierResultData;)V", "enableJetifierFlagState", "", "Ljava/lang/Boolean;", "useAndroidXFlagState", "shouldAnalyzerRun", "isCheckJetifierBuild", "checkJetifierResultData", "getCheckJetifierResultData", "()Lcom/android/build/attribution/analyzers/CheckJetifierResultData;", "setCheckJetifierResultData", "runPostBuildAnalysis", "", "analyzersResult", "Lcom/android/build/attribution/analyzers/BuildEventsAnalyzersProxy;", "studioProvidedInfo", "Lcom/android/build/attribution/data/StudioProvidedInfo;", "calculateResult", "cleanupTempState", "intellij.android.build-attribution"})
public final class JetifierUsageAnalyzer
extends BaseAnalyzer<JetifierUsageAnalyzerResult>
implements PostBuildProcessAnalyzer {
    @Nullable
    private Boolean enableJetifierFlagState;
    @Nullable
    private Boolean useAndroidXFlagState;
    private boolean shouldAnalyzerRun;
    private boolean isCheckJetifierBuild;
    @Nullable
    private CheckJetifierResultData checkJetifierResultData;

    public JetifierUsageAnalyzer(@Nullable CheckJetifierResultData cachedCheckJetifierResultData) {
        this.checkJetifierResultData = cachedCheckJetifierResultData;
    }

    @Nullable
    public final CheckJetifierResultData getCheckJetifierResultData() {
        return this.checkJetifierResultData;
    }

    public final void setCheckJetifierResultData(@Nullable CheckJetifierResultData checkJetifierResultData) {
        this.checkJetifierResultData = checkJetifierResultData;
    }

    @Override
    public void runPostBuildAnalysis(@NotNull BuildEventsAnalyzersProxy analyzersResult, @NotNull StudioProvidedInfo studioProvidedInfo) {
        Intrinsics.checkNotNullParameter((Object)analyzersResult, (String)"analyzersResult");
        Intrinsics.checkNotNullParameter((Object)studioProvidedInfo, (String)"studioProvidedInfo");
        this.shouldAnalyzerRun = JetifierUsageAnalyzerKt.access$shouldAnalyzerRun(studioProvidedInfo.getAgpVersion());
        if (!this.shouldAnalyzerRun) {
            return;
        }
        this.enableJetifierFlagState = studioProvidedInfo.getEnableJetifierPropertyState();
        this.useAndroidXFlagState = studioProvidedInfo.getUseAndroidXPropertyState();
        File it = JetifierUsageAnalyzerKt.checkJetifierResultFile(studioProvidedInfo.getBuildRequestHolder().getBuildRequest().getData());
        boolean bl = false;
        if (it.exists()) {
            CheckJetifierResult checkJetifierResult = CheckJetifierResult.Companion.load(it);
            long l = System.currentTimeMillis();
            this.checkJetifierResultData = new CheckJetifierResultData(l, checkJetifierResult);
            this.isCheckJetifierBuild = true;
        }
    }

    @Override
    @NotNull
    protected JetifierUsageAnalyzerResult calculateResult() {
        if (!this.shouldAnalyzerRun) {
            CheckJetifierResultData checkJetifierResultData = this.checkJetifierResultData;
            return new JetifierUsageAnalyzerResult(AnalyzerNotRun.INSTANCE, checkJetifierResultData != null ? checkJetifierResultData.getLastCheckJetifierBuildTimestamp() : null, false);
        }
        if (Intrinsics.areEqual((Object)this.enableJetifierFlagState, (Object)true) && Intrinsics.areEqual((Object)this.useAndroidXFlagState, (Object)true)) {
            JetifierUsageAnalyzerResult jetifierUsageAnalyzerResult;
            CheckJetifierResultData checkJetifierResultData = this.checkJetifierResultData;
            if (checkJetifierResultData != null && (checkJetifierResultData = checkJetifierResultData.getCheckJetifierResult()) != null) {
                CheckJetifierResultData it = checkJetifierResultData;
                boolean bl = false;
                if (it.isEmpty()) {
                    CheckJetifierResultData checkJetifierResultData2 = this.checkJetifierResultData;
                    jetifierUsageAnalyzerResult = new JetifierUsageAnalyzerResult(JetifierCanBeRemoved.INSTANCE, checkJetifierResultData2 != null ? checkJetifierResultData2.getLastCheckJetifierBuildTimestamp() : null, this.isCheckJetifierBuild);
                } else {
                    CheckJetifierResultData checkJetifierResultData3 = this.checkJetifierResultData;
                    jetifierUsageAnalyzerResult = new JetifierUsageAnalyzerResult(new JetifierRequiredForLibraries((CheckJetifierResult)it), checkJetifierResultData3 != null ? checkJetifierResultData3.getLastCheckJetifierBuildTimestamp() : null, this.isCheckJetifierBuild);
                }
            } else {
                CheckJetifierResultData checkJetifierResultData4 = this.checkJetifierResultData;
                jetifierUsageAnalyzerResult = new JetifierUsageAnalyzerResult(JetifierUsedCheckRequired.INSTANCE, checkJetifierResultData4 != null ? checkJetifierResultData4.getLastCheckJetifierBuildTimestamp() : null, false);
            }
            return jetifierUsageAnalyzerResult;
        }
        CheckJetifierResultData checkJetifierResultData = this.checkJetifierResultData;
        return new JetifierUsageAnalyzerResult(JetifierNotUsed.INSTANCE, checkJetifierResultData != null ? checkJetifierResultData.getLastCheckJetifierBuildTimestamp() : null, false);
    }

    @Override
    public void cleanupTempState() {
        this.enableJetifierFlagState = null;
        this.useAndroidXFlagState = null;
        this.shouldAnalyzerRun = false;
        this.isCheckJetifierBuild = false;
    }
}

