/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.analyzers;

import com.android.build.attribution.analyzers.AnalyzerResult;
import com.android.build.attribution.analyzers.BaseAnalyzer;
import com.android.build.attribution.analyzers.BuildAttributionReportAnalyzer;
import com.android.build.attribution.analyzers.BuildEventsAnalyzer;
import com.android.build.attribution.analyzers.BuildEventsAnalyzersProxy;
import com.android.build.attribution.analyzers.DownloadsAnalyzerKt;
import com.android.build.attribution.analyzers.PostBuildProcessAnalyzer;
import com.android.build.attribution.data.StudioProvidedInfo;
import com.android.build.output.DownloadInfoDataModel;
import com.android.buildanalyzer.common.AndroidGradlePluginAttributionData;
import com.android.ide.common.repository.AgpVersion;
import com.google.wireless.android.sdk.stats.BuildDownloadsAnalysisData;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.tooling.events.FailureResult;
import org.gradle.tooling.events.ProgressEvent;
import org.gradle.tooling.events.download.FileDownloadFinishEvent;
import org.gradle.tooling.events.download.FileDownloadResult;
import org.gradle.tooling.events.download.FileDownloadStartEvent;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u0000 *2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u00042\u00020\u0005:\r!\"#$%&'()*+,-B\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0014H\u0016J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u0002H\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/android/build/attribution/analyzers/DownloadsAnalyzer;", "Lcom/android/build/attribution/analyzers/BaseAnalyzer;", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$Result;", "Lcom/android/build/attribution/analyzers/BuildEventsAnalyzer;", "Lcom/android/build/attribution/analyzers/BuildAttributionReportAnalyzer;", "Lcom/android/build/attribution/analyzers/PostBuildProcessAnalyzer;", "<init>", "()V", "statsAccumulator", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$DownloadStatsAccumulator;", "eventsProcessor", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$DownloadEventsProcessor;", "getEventsProcessor", "()Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$DownloadEventsProcessor;", "gradleCanProvideDownloadEvents", "", "Ljava/lang/Boolean;", "currentAgpVersionFromBuild", "Lcom/android/ide/common/repository/AgpVersion;", "receiveEvent", "", "event", "Lorg/gradle/tooling/events/ProgressEvent;", "cleanupTempState", "receiveBuildAttributionReport", "androidGradlePluginAttributionData", "Lcom/android/buildanalyzer/common/AndroidGradlePluginAttributionData;", "runPostBuildAnalysis", "analyzersResult", "Lcom/android/build/attribution/analyzers/BuildEventsAnalyzersProxy;", "studioProvidedInfo", "Lcom/android/build/attribution/data/StudioProvidedInfo;", "calculateResult", "DownloadStatsAccumulator", "DownloadEventsProcessor", "Result", "ActiveResult", "AnalyzerIsDisabled", "GradleDoesNotProvideEvents", "DownloadStatus", "DownloadResult", "RepositoryResult", "Companion", "Repository", "OtherRepository", "KnownRepository", "intellij.android.build-attribution"})
@SourceDebugExtension(value={"SMAP\nDownloadsAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DownloadsAnalyzer.kt\ncom/android/build/attribution/analyzers/DownloadsAnalyzer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,225:1\n1#2:226\n*E\n"})
public final class DownloadsAnalyzer
extends BaseAnalyzer<Result>
implements BuildEventsAnalyzer,
BuildAttributionReportAnalyzer,
PostBuildProcessAnalyzer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private DownloadStatsAccumulator statsAccumulator = new DownloadStatsAccumulator();
    @NotNull
    private final DownloadEventsProcessor eventsProcessor = new DownloadEventsProcessor(this.statsAccumulator, null);
    @Nullable
    private Boolean gradleCanProvideDownloadEvents;
    @Nullable
    private AgpVersion currentAgpVersionFromBuild;

    @NotNull
    public final DownloadEventsProcessor getEventsProcessor() {
        return this.eventsProcessor;
    }

    @Override
    public void receiveEvent(@NotNull ProgressEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.eventsProcessor.receiveEvent(event);
    }

    @Override
    public void cleanupTempState() {
        this.statsAccumulator = new DownloadStatsAccumulator();
        this.eventsProcessor.setStatsAccumulator(this.statsAccumulator);
        this.gradleCanProvideDownloadEvents = null;
        this.currentAgpVersionFromBuild = null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void receiveBuildAttributionReport(@NotNull AndroidGradlePluginAttributionData androidGradlePluginAttributionData) {
        AgpVersion agpVersion;
        Intrinsics.checkNotNullParameter((Object)androidGradlePluginAttributionData, (String)"androidGradlePluginAttributionData");
        DownloadsAnalyzer downloadsAnalyzer = this;
        Object object = androidGradlePluginAttributionData.getBuildInfo();
        if (object != null && (object = object.getAgpVersion()) != null) {
            void it;
            Object object2 = object;
            DownloadsAnalyzer downloadsAnalyzer2 = downloadsAnalyzer;
            boolean bl = false;
            agpVersion = AgpVersion.Companion.tryParse((String)it);
            downloadsAnalyzer = downloadsAnalyzer2;
        } else {
            agpVersion = null;
        }
        downloadsAnalyzer.currentAgpVersionFromBuild = agpVersion;
    }

    @Override
    public void runPostBuildAnalysis(@NotNull BuildEventsAnalyzersProxy analyzersResult, @NotNull StudioProvidedInfo studioProvidedInfo) {
        boolean bl;
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)analyzersResult, (String)"analyzersResult");
        Intrinsics.checkNotNullParameter((Object)studioProvidedInfo, (String)"studioProvidedInfo");
        AgpVersion agpVersion = this.currentAgpVersionFromBuild;
        if (agpVersion != null) {
            AgpVersion it = agpVersion;
            boolean bl3 = false;
            bl2 = it.compareTo(DownloadsAnalyzerKt.access$getMinAgpVersionGuaranteesGradle_7_3$p()) >= 0;
        } else {
            bl2 = false;
        }
        boolean doesCurrentAgpRequireGradleThatProvidesEvents = bl2;
        GradleVersion gradleVersion2 = studioProvidedInfo.getGradleVersion();
        if (gradleVersion2 != null) {
            GradleVersion it = gradleVersion2;
            boolean bl4 = false;
            bl = it.compareTo(DownloadsAnalyzerKt.getMinGradleVersionProvidingDownloadEvents()) >= 0;
        } else {
            bl = false;
        }
        boolean canGradleVersionFromSettingsProvideEvents = bl;
        this.gradleCanProvideDownloadEvents = doesCurrentAgpRequireGradleThatProvidesEvents || canGradleVersionFromSettingsProvideEvents;
    }

    @Override
    @NotNull
    protected Result calculateResult() {
        if (!Intrinsics.areEqual((Object)this.gradleCanProvideDownloadEvents, (Object)true)) {
            return GradleDoesNotProvideEvents.INSTANCE;
        }
        List<RepositoryResult> resultList = this.statsAccumulator.getRepositoryResults();
        Object[] objectArray = new Object[]{resultList};
        DownloadsAnalyzerKt.access$getLOG$p().debug("Downloads stats for this build: ", objectArray);
        return new ActiveResult(resultList);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\n\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$ActiveResult;", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$Result;", "repositoryResults", "", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$RepositoryResult;", "<init>", "(Ljava/util/List;)V", "getRepositoryResults", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.android.build-attribution"})
    public static final class ActiveResult
    extends Result {
        @NotNull
        private final List<RepositoryResult> repositoryResults;

        public ActiveResult(@NotNull List<RepositoryResult> repositoryResults) {
            Intrinsics.checkNotNullParameter(repositoryResults, (String)"repositoryResults");
            super(null);
            this.repositoryResults = repositoryResults;
        }

        @NotNull
        public final List<RepositoryResult> getRepositoryResults() {
            return this.repositoryResults;
        }

        @NotNull
        public final List<RepositoryResult> component1() {
            return this.repositoryResults;
        }

        @NotNull
        public final ActiveResult copy(@NotNull List<RepositoryResult> repositoryResults) {
            Intrinsics.checkNotNullParameter(repositoryResults, (String)"repositoryResults");
            return new ActiveResult(repositoryResults);
        }

        public static /* synthetic */ ActiveResult copy$default(ActiveResult activeResult, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = activeResult.repositoryResults;
            }
            return activeResult.copy(list);
        }

        @NotNull
        public String toString() {
            return "ActiveResult(repositoryResults=" + this.repositoryResults + ")";
        }

        public int hashCode() {
            return ((Object)this.repositoryResults).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ActiveResult)) {
                return false;
            }
            ActiveResult activeResult = (ActiveResult)other;
            return Intrinsics.areEqual(this.repositoryResults, activeResult.repositoryResults);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$AnalyzerIsDisabled;", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$Result;", "<init>", "()V", "intellij.android.build-attribution"})
    public static final class AnalyzerIsDisabled
    extends Result {
        @NotNull
        public static final AnalyzerIsDisabled INSTANCE = new AnalyzerIsDisabled();

        private AnalyzerIsDisabled() {
            super(null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$Companion;", "", "<init>", "()V", "detectRepository", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$Repository;", "uri", "Ljava/net/URI;", "intellij.android.build-attribution"})
    @SourceDebugExtension(value={"SMAP\nDownloadsAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DownloadsAnalyzer.kt\ncom/android/build/attribution/analyzers/DownloadsAnalyzer$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,225:1\n1#2:226\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Repository detectRepository(@NotNull URI uri) {
            Repository repository2;
            Object v0;
            block4: {
                Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
                Iterable iterable = (Iterable)KnownRepository.getEntries();
                for (Object t : iterable) {
                    KnownRepository it = (KnownRepository)t;
                    boolean bl = false;
                    if (!it.matches(uri)) continue;
                    v0 = t;
                    break block4;
                }
                v0 = null;
            }
            KnownRepository knownRepository = v0;
            if (knownRepository != null) {
                repository2 = knownRepository;
            } else {
                String string = uri.getAuthority();
                if (string == null) {
                    string = "";
                }
                repository2 = new OtherRepository(string);
            }
            return repository2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$DownloadEventsProcessor;", "", "statsAccumulator", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$DownloadStatsAccumulator;", "downloadsInfoDataModel", "Lcom/android/build/output/DownloadInfoDataModel;", "<init>", "(Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$DownloadStatsAccumulator;Lcom/android/build/output/DownloadInfoDataModel;)V", "getStatsAccumulator", "()Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$DownloadStatsAccumulator;", "setStatsAccumulator", "(Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$DownloadStatsAccumulator;)V", "getDownloadsInfoDataModel", "()Lcom/android/build/output/DownloadInfoDataModel;", "setDownloadsInfoDataModel", "(Lcom/android/build/output/DownloadInfoDataModel;)V", "receiveEvent", "", "event", "Lorg/gradle/tooling/events/ProgressEvent;", "intellij.android.build-attribution"})
    @SourceDebugExtension(value={"SMAP\nDownloadsAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DownloadsAnalyzer.kt\ncom/android/build/attribution/analyzers/DownloadsAnalyzer$DownloadEventsProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,225:1\n1#2:226\n*E\n"})
    public static final class DownloadEventsProcessor {
        @Nullable
        private DownloadStatsAccumulator statsAccumulator;
        @Nullable
        private DownloadInfoDataModel downloadsInfoDataModel;

        public DownloadEventsProcessor(@Nullable DownloadStatsAccumulator statsAccumulator, @Nullable DownloadInfoDataModel downloadsInfoDataModel) {
            this.statsAccumulator = statsAccumulator;
            this.downloadsInfoDataModel = downloadsInfoDataModel;
        }

        @Nullable
        public final DownloadStatsAccumulator getStatsAccumulator() {
            return this.statsAccumulator;
        }

        public final void setStatsAccumulator(@Nullable DownloadStatsAccumulator downloadStatsAccumulator) {
            this.statsAccumulator = downloadStatsAccumulator;
        }

        @Nullable
        public final DownloadInfoDataModel getDownloadsInfoDataModel() {
            return this.downloadsInfoDataModel;
        }

        public final void setDownloadsInfoDataModel(@Nullable DownloadInfoDataModel downloadInfoDataModel) {
            this.downloadsInfoDataModel = downloadInfoDataModel;
        }

        public final void receiveEvent(@NotNull ProgressEvent event) {
            block6: {
                String string;
                FailureResult it;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event instanceof FileDownloadStartEvent) {
                    String string2 = ((FileDownloadStartEvent)event).getDescriptor().getUri().toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                    String url = string2;
                    URI uRI = ((FileDownloadStartEvent)event).getDescriptor().getUri();
                    Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"getUri(...)");
                    Repository repository2 = Companion.detectRepository(uRI);
                    long startTime = ((FileDownloadStartEvent)event).getEventTime();
                    DownloadInfoDataModel downloadInfoDataModel = this.downloadsInfoDataModel;
                    if (downloadInfoDataModel != null) {
                        downloadInfoDataModel.downloadStarted(startTime, url, repository2);
                    }
                }
                if (!(event instanceof FileDownloadFinishEvent)) break block6;
                long startTime = ((FileDownloadFinishEvent)event).getResult().getStartTime();
                URI uRI = ((FileDownloadFinishEvent)event).getDescriptor().getUri();
                Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"getUri(...)");
                Repository repository3 = Companion.detectRepository(uRI);
                DownloadStatus status2 = ((FileDownloadFinishEvent)event).getResult() instanceof FailureResult ? DownloadStatus.FAILURE : (((FileDownloadFinishEvent)event).getResult().getBytesDownloaded() == 0L ? DownloadStatus.MISSED : DownloadStatus.SUCCESS);
                FileDownloadResult fileDownloadResult = ((FileDownloadFinishEvent)event).getResult();
                FailureResult failureResult = fileDownloadResult instanceof FailureResult ? (FailureResult)fileDownloadResult : null;
                if (failureResult != null) {
                    it = failureResult;
                    boolean bl = false;
                    List list = it.getFailures();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFailures(...)");
                    string = DownloadsAnalyzerKt.buildFailureMessage(list);
                } else {
                    string = null;
                }
                String failureMessage = string;
                String string3 = ((FileDownloadFinishEvent)event).getDescriptor().getUri().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
                it = ((FileDownloadFinishEvent)event).getResult();
                DownloadStatus downloadStatus = status2;
                String string4 = string3;
                Repository repository4 = repository3;
                long l = startTime;
                boolean bl = false;
                long l2 = it.getEndTime() - it.getStartTime();
                String string5 = failureMessage;
                long l3 = ((FileDownloadFinishEvent)event).getResult().getBytesDownloaded();
                long l4 = l2;
                DownloadStatus downloadStatus2 = downloadStatus;
                String string6 = string4;
                Repository repository5 = repository4;
                long l5 = l;
                DownloadResult downloadResult = new DownloadResult(l5, repository5, string6, downloadStatus2, l4, l3, string5);
                DownloadStatsAccumulator downloadStatsAccumulator = this.statsAccumulator;
                if (downloadStatsAccumulator != null) {
                    downloadStatsAccumulator.recordNewDownloadResult(downloadResult);
                }
                DownloadInfoDataModel downloadInfoDataModel = this.downloadsInfoDataModel;
                if (downloadInfoDataModel != null) {
                    downloadInfoDataModel.downloadFinished(downloadResult);
                }
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\u0007H\u00c6\u0003JQ\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\u00032\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010%\u001a\u00020&H\u00d6\u0001J\t\u0010'\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0010R\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0010R\u0013\u0010\f\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0014\u00a8\u0006("}, d2={"Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$DownloadResult;", "", "timestamp", "", "repository", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$Repository;", "url", "", "status", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$DownloadStatus;", "duration", "bytes", "failureMessage", "<init>", "(JLcom/android/build/attribution/analyzers/DownloadsAnalyzer$Repository;Ljava/lang/String;Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$DownloadStatus;JJLjava/lang/String;)V", "getTimestamp", "()J", "getRepository", "()Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$Repository;", "getUrl", "()Ljava/lang/String;", "getStatus", "()Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$DownloadStatus;", "getDuration", "getBytes", "getFailureMessage", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.android.build-attribution"})
    public static final class DownloadResult {
        private final long timestamp;
        @NotNull
        private final Repository repository;
        @NotNull
        private final String url;
        @NotNull
        private final DownloadStatus status;
        private final long duration;
        private final long bytes;
        @Nullable
        private final String failureMessage;

        public DownloadResult(long timestamp, @NotNull Repository repository2, @NotNull String url, @NotNull DownloadStatus status2, long duration, long bytes2, @Nullable String failureMessage) {
            Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)((Object)status2), (String)"status");
            this.timestamp = timestamp;
            this.repository = repository2;
            this.url = url;
            this.status = status2;
            this.duration = duration;
            this.bytes = bytes2;
            this.failureMessage = failureMessage;
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        @NotNull
        public final Repository getRepository() {
            return this.repository;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @NotNull
        public final DownloadStatus getStatus() {
            return this.status;
        }

        public final long getDuration() {
            return this.duration;
        }

        public final long getBytes() {
            return this.bytes;
        }

        @Nullable
        public final String getFailureMessage() {
            return this.failureMessage;
        }

        public final long component1() {
            return this.timestamp;
        }

        @NotNull
        public final Repository component2() {
            return this.repository;
        }

        @NotNull
        public final String component3() {
            return this.url;
        }

        @NotNull
        public final DownloadStatus component4() {
            return this.status;
        }

        public final long component5() {
            return this.duration;
        }

        public final long component6() {
            return this.bytes;
        }

        @Nullable
        public final String component7() {
            return this.failureMessage;
        }

        @NotNull
        public final DownloadResult copy(long timestamp, @NotNull Repository repository2, @NotNull String url, @NotNull DownloadStatus status2, long duration, long bytes2, @Nullable String failureMessage) {
            Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)((Object)status2), (String)"status");
            return new DownloadResult(timestamp, repository2, url, status2, duration, bytes2, failureMessage);
        }

        public static /* synthetic */ DownloadResult copy$default(DownloadResult downloadResult, long l, Repository repository2, String string, DownloadStatus downloadStatus, long l2, long l3, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                l = downloadResult.timestamp;
            }
            if ((n & 2) != 0) {
                repository2 = downloadResult.repository;
            }
            if ((n & 4) != 0) {
                string = downloadResult.url;
            }
            if ((n & 8) != 0) {
                downloadStatus = downloadResult.status;
            }
            if ((n & 0x10) != 0) {
                l2 = downloadResult.duration;
            }
            if ((n & 0x20) != 0) {
                l3 = downloadResult.bytes;
            }
            if ((n & 0x40) != 0) {
                string2 = downloadResult.failureMessage;
            }
            return downloadResult.copy(l, repository2, string, downloadStatus, l2, l3, string2);
        }

        @NotNull
        public String toString() {
            return "DownloadResult(timestamp=" + this.timestamp + ", repository=" + this.repository + ", url=" + this.url + ", status=" + this.status + ", duration=" + this.duration + ", bytes=" + this.bytes + ", failureMessage=" + this.failureMessage + ")";
        }

        public int hashCode() {
            int result2 = Long.hashCode(this.timestamp);
            result2 = result2 * 31 + this.repository.hashCode();
            result2 = result2 * 31 + this.url.hashCode();
            result2 = result2 * 31 + this.status.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.duration);
            result2 = result2 * 31 + Long.hashCode(this.bytes);
            result2 = result2 * 31 + (this.failureMessage == null ? 0 : this.failureMessage.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DownloadResult)) {
                return false;
            }
            DownloadResult downloadResult = (DownloadResult)other;
            if (this.timestamp != downloadResult.timestamp) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.repository, (Object)downloadResult.repository)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.url, (Object)downloadResult.url)) {
                return false;
            }
            if (this.status != downloadResult.status) {
                return false;
            }
            if (this.duration != downloadResult.duration) {
                return false;
            }
            if (this.bytes != downloadResult.bytes) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.failureMessage, (Object)downloadResult.failureMessage);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$DownloadStatsAccumulator;", "", "<init>", "()V", "processedEvents", "", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$DownloadResult;", "repositoryResults", "", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$RepositoryResult;", "getRepositoryResults", "()Ljava/util/List;", "recordNewDownloadResult", "", "downloadResult", "intellij.android.build-attribution"})
    @SourceDebugExtension(value={"SMAP\nDownloadsAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DownloadsAnalyzer.kt\ncom/android/build/attribution/analyzers/DownloadsAnalyzer$DownloadStatsAccumulator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,225:1\n1491#2:226\n1516#2,3:227\n1519#2,3:237\n382#3,7:230\n126#4:240\n153#4,3:241\n*S KotlinDebug\n*F\n+ 1 DownloadsAnalyzer.kt\ncom/android/build/attribution/analyzers/DownloadsAnalyzer$DownloadStatsAccumulator\n*L\n90#1:226\n90#1:227,3\n90#1:237,3\n90#1:230,7\n90#1:240\n90#1:241,3\n*E\n"})
    public static final class DownloadStatsAccumulator {
        @NotNull
        private final List<DownloadResult> processedEvents = new ArrayList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final List<RepositoryResult> getRepositoryResults() {
            List list;
            List<DownloadResult> list2 = this.processedEvents;
            synchronized (list2) {
                void $this$mapTo$iv$iv;
                Map $this$groupByTo$iv$iv;
                boolean bl = false;
                Iterable $this$groupBy$iv = this.processedEvents;
                boolean $i$f$groupBy = false;
                Iterable iterable = $this$groupBy$iv;
                Object destination$iv$iv = new LinkedHashMap();
                boolean $i$f$groupByTo = false;
                Iterator<Object> iterator2 = $this$groupByTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Object object;
                    Object element$iv$iv = iterator2.next();
                    DownloadResult it = (DownloadResult)element$iv$iv;
                    boolean bl2 = false;
                    Repository key$iv$iv = it.getRepository();
                    Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl3 = false;
                        List answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object = answer$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object;
                    list$iv$iv.add(element$iv$iv);
                }
                Map $this$map$iv = destination$iv$iv;
                boolean $i$f$map = false;
                $this$groupByTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList($this$map$iv.size());
                boolean $i$f$mapTo = false;
                iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry item$iv$iv;
                    Map.Entry entry = item$iv$iv = (Map.Entry)iterator2.next();
                    Object object = destination$iv$iv;
                    boolean bl4 = false;
                    Repository repo = (Repository)entry.getKey();
                    List events = (List)entry.getValue();
                    object.add(new RepositoryResult(repo, events));
                }
                list = (List)destination$iv$iv;
            }
            return list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void recordNewDownloadResult(@NotNull DownloadResult downloadResult) {
            Intrinsics.checkNotNullParameter((Object)downloadResult, (String)"downloadResult");
            List<DownloadResult> list = this.processedEvents;
            synchronized (list) {
                boolean bl = false;
                boolean bl2 = this.processedEvents.add(downloadResult);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$DownloadStatus;", "", "<init>", "(Ljava/lang/String;I)V", "SUCCESS", "MISSED", "FAILURE", "intellij.android.build-attribution"})
    public static final class DownloadStatus
    extends Enum<DownloadStatus> {
        public static final /* enum */ DownloadStatus SUCCESS = new DownloadStatus();
        public static final /* enum */ DownloadStatus MISSED = new DownloadStatus();
        public static final /* enum */ DownloadStatus FAILURE = new DownloadStatus();
        private static final /* synthetic */ DownloadStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static DownloadStatus[] values() {
            return (DownloadStatus[])$VALUES.clone();
        }

        public static DownloadStatus valueOf(String value2) {
            return Enum.valueOf(DownloadStatus.class, value2);
        }

        @NotNull
        public static EnumEntries<DownloadStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = downloadStatusArray = new DownloadStatus[]{DownloadStatus.SUCCESS, DownloadStatus.MISSED, DownloadStatus.FAILURE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$GradleDoesNotProvideEvents;", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$Result;", "<init>", "()V", "intellij.android.build-attribution"})
    public static final class GradleDoesNotProvideEvents
    extends Result {
        @NotNull
        public static final GradleDoesNotProvideEvents INSTANCE = new GradleDoesNotProvideEvents();

        private GradleDoesNotProvideEvents() {
            super(null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0081\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B!\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011\u00a8\u0006\u0015"}, d2={"Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$KnownRepository;", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$Repository;", "", "presentableName", "", "analyticsType", "Lcom/google/wireless/android/sdk/stats/BuildDownloadsAnalysisData$RepositoryStats$RepositoryType;", "uri", "Ljava/net/URI;", "<init>", "(Ljava/lang/String;ILjava/lang/String;Lcom/google/wireless/android/sdk/stats/BuildDownloadsAnalysisData$RepositoryStats$RepositoryType;Ljava/net/URI;)V", "getPresentableName", "()Ljava/lang/String;", "getAnalyticsType", "()Lcom/google/wireless/android/sdk/stats/BuildDownloadsAnalysisData$RepositoryStats$RepositoryType;", "GOOGLE", "MAVEN_CENTRAL", "JCENTER", "matches", "", "resourceURI", "intellij.android.build-attribution"})
    public static final class KnownRepository
    extends Enum<KnownRepository>
    implements Repository {
        @NotNull
        private final String presentableName;
        @NotNull
        private final BuildDownloadsAnalysisData.RepositoryStats.RepositoryType analyticsType;
        @NotNull
        private final URI uri;
        public static final /* enum */ KnownRepository GOOGLE;
        public static final /* enum */ KnownRepository MAVEN_CENTRAL;
        public static final /* enum */ KnownRepository JCENTER;
        private static final /* synthetic */ KnownRepository[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private KnownRepository(String presentableName, BuildDownloadsAnalysisData.RepositoryStats.RepositoryType analyticsType, URI uri) {
            this.presentableName = presentableName;
            this.analyticsType = analyticsType;
            this.uri = uri;
        }

        @NotNull
        public final String getPresentableName() {
            return this.presentableName;
        }

        @Override
        @NotNull
        public BuildDownloadsAnalysisData.RepositoryStats.RepositoryType getAnalyticsType() {
            return this.analyticsType;
        }

        public final boolean matches(@NotNull URI resourceURI) {
            Intrinsics.checkNotNullParameter((Object)resourceURI, (String)"resourceURI");
            return Intrinsics.areEqual((Object)this.uri.getScheme(), (Object)resourceURI.getScheme()) && Intrinsics.areEqual((Object)this.uri.getAuthority(), (Object)resourceURI.getAuthority());
        }

        public static KnownRepository[] values() {
            return (KnownRepository[])$VALUES.clone();
        }

        public static KnownRepository valueOf(String value2) {
            return Enum.valueOf(KnownRepository.class, value2);
        }

        @NotNull
        public static EnumEntries<KnownRepository> getEntries() {
            return $ENTRIES;
        }

        static {
            URI uRI = URI.create("https://dl.google.com/dl/android/maven2/");
            Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(...)");
            GOOGLE = new KnownRepository("Google", BuildDownloadsAnalysisData.RepositoryStats.RepositoryType.GOOGLE, uRI);
            URI uRI2 = URI.create("https://repo.maven.apache.org/maven2/");
            Intrinsics.checkNotNullExpressionValue((Object)uRI2, (String)"create(...)");
            MAVEN_CENTRAL = new KnownRepository("Maven Central", BuildDownloadsAnalysisData.RepositoryStats.RepositoryType.MAVEN_CENTRAL, uRI2);
            URI uRI3 = URI.create("https://jcenter.bintray.com/");
            Intrinsics.checkNotNullExpressionValue((Object)uRI3, (String)"create(...)");
            JCENTER = new KnownRepository("JCenter", BuildDownloadsAnalysisData.RepositoryStats.RepositoryType.JCENTER, uRI3);
            $VALUES = knownRepositoryArray = new KnownRepository[]{KnownRepository.GOOGLE, KnownRepository.MAVEN_CENTRAL, KnownRepository.JCENTER};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$OtherRepository;", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$Repository;", "host", "", "<init>", "(Ljava/lang/String;)V", "getHost", "()Ljava/lang/String;", "analyticsType", "Lcom/google/wireless/android/sdk/stats/BuildDownloadsAnalysisData$RepositoryStats$RepositoryType;", "getAnalyticsType", "()Lcom/google/wireless/android/sdk/stats/BuildDownloadsAnalysisData$RepositoryStats$RepositoryType;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.android.build-attribution"})
    public static final class OtherRepository
    implements Repository {
        @NotNull
        private final String host;
        @NotNull
        private final BuildDownloadsAnalysisData.RepositoryStats.RepositoryType analyticsType;

        public OtherRepository(@NotNull String host) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            this.host = host;
            this.analyticsType = BuildDownloadsAnalysisData.RepositoryStats.RepositoryType.OTHER_REPOSITORY;
        }

        @NotNull
        public final String getHost() {
            return this.host;
        }

        @Override
        @NotNull
        public BuildDownloadsAnalysisData.RepositoryStats.RepositoryType getAnalyticsType() {
            return this.analyticsType;
        }

        @NotNull
        public final String component1() {
            return this.host;
        }

        @NotNull
        public final OtherRepository copy(@NotNull String host) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            return new OtherRepository(host);
        }

        public static /* synthetic */ OtherRepository copy$default(OtherRepository otherRepository, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = otherRepository.host;
            }
            return otherRepository.copy(string);
        }

        @NotNull
        public String toString() {
            return "OtherRepository(host=" + this.host + ")";
        }

        public int hashCode() {
            return this.host.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OtherRepository)) {
                return false;
            }
            OtherRepository otherRepository = (OtherRepository)other;
            return Intrinsics.areEqual((Object)this.host, (Object)otherRepository.host);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b\u00c0\u0006\u0003"}, d2={"Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$Repository;", "", "analyticsType", "Lcom/google/wireless/android/sdk/stats/BuildDownloadsAnalysisData$RepositoryStats$RepositoryType;", "getAnalyticsType", "()Lcom/google/wireless/android/sdk/stats/BuildDownloadsAnalysisData$RepositoryStats$RepositoryType;", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$KnownRepository;", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$OtherRepository;", "intellij.android.build-attribution"})
    public static sealed interface Repository
    permits KnownRepository, OtherRepository {
        @NotNull
        public BuildDownloadsAnalysisData.RepositoryStats.RepositoryType getAnalyticsType();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010'\u001a\u00020\u000eH\u00d6\u0001J\t\u0010(\u001a\u00020)H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0011\u0010\u0017\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0010R\u0011\u0010\u0019\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0014R\u0011\u0010\u001b\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0010R\u0011\u0010\u001d\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0014R\u0011\u0010\u001f\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0014\u00a8\u0006*"}, d2={"Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$RepositoryResult;", "", "repository", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$Repository;", "downloads", "", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$DownloadResult;", "<init>", "(Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$Repository;Ljava/util/List;)V", "getRepository", "()Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$Repository;", "getDownloads", "()Ljava/util/List;", "successRequestsCount", "", "getSuccessRequestsCount", "()I", "successRequestsTimeMs", "", "getSuccessRequestsTimeMs", "()J", "successRequestsBytesDownloaded", "getSuccessRequestsBytesDownloaded", "missedRequestsCount", "getMissedRequestsCount", "missedRequestsTimeMs", "getMissedRequestsTimeMs", "failedRequestsCount", "getFailedRequestsCount", "failedRequestsTimeMs", "getFailedRequestsTimeMs", "failedRequestsBytesDownloaded", "getFailedRequestsBytesDownloaded", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.android.build-attribution"})
    @SourceDebugExtension(value={"SMAP\nDownloadsAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DownloadsAnalyzer.kt\ncom/android/build/attribution/analyzers/DownloadsAnalyzer$RepositoryResult\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,225:1\n1491#2:226\n1516#2,3:227\n1519#2,3:237\n382#3,7:230\n1#4:240\n*S KotlinDebug\n*F\n+ 1 DownloadsAnalyzer.kt\ncom/android/build/attribution/analyzers/DownloadsAnalyzer$RepositoryResult\n*L\n173#1:226\n173#1:227,3\n173#1:237,3\n173#1:230,7\n*E\n"})
    public static final class RepositoryResult {
        @NotNull
        private final Repository repository;
        @NotNull
        private final List<DownloadResult> downloads;
        private final int successRequestsCount;
        private final long successRequestsTimeMs;
        private final long successRequestsBytesDownloaded;
        private final int missedRequestsCount;
        private final long missedRequestsTimeMs;
        private final int failedRequestsCount;
        private final long failedRequestsTimeMs;
        private final long failedRequestsBytesDownloaded;

        /*
         * WARNING - void declaration
         */
        public RepositoryResult(@NotNull Repository repository2, @NotNull List<DownloadResult> downloads2) {
            long l;
            long l2;
            void $this$groupByTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
            Intrinsics.checkNotNullParameter(downloads2, (String)"downloads");
            this.repository = repository2;
            this.downloads = downloads2;
            Iterable $this$groupBy$iv = this.downloads;
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                DownloadResult it = (DownloadResult)element$iv$iv;
                boolean bl = false;
                DownloadStatus key$iv$iv = it.getStatus();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get((Object)key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Map groupedByStatus = destination$iv$iv;
            List successDownloads = groupedByStatus.getOrDefault((Object)DownloadStatus.SUCCESS, CollectionsKt.emptyList());
            List failedDownloads = groupedByStatus.getOrDefault((Object)DownloadStatus.FAILURE, CollectionsKt.emptyList());
            List missedDownloads = groupedByStatus.getOrDefault((Object)DownloadStatus.MISSED, CollectionsKt.emptyList());
            this.successRequestsCount = successDownloads.size();
            Iterable iterable2 = successDownloads;
            RepositoryResult repositoryResult = this;
            long l3 = 0L;
            for (Object t : iterable2) {
                void it;
                DownloadResult bl = (DownloadResult)t;
                l2 = l3;
                boolean bl3 = false;
                l = it.getDuration();
                l3 = l2 + l;
            }
            repositoryResult.successRequestsTimeMs = l2 = l3;
            iterable2 = successDownloads;
            repositoryResult = this;
            l3 = 0L;
            for (Object t : iterable2) {
                DownloadResult it = (DownloadResult)t;
                l2 = l3;
                boolean bl = false;
                l = it.getBytes();
                l3 = l2 + l;
            }
            repositoryResult.successRequestsBytesDownloaded = l2 = l3;
            this.missedRequestsCount = missedDownloads.size();
            iterable2 = missedDownloads;
            repositoryResult = this;
            l3 = 0L;
            for (Object t : iterable2) {
                DownloadResult it = (DownloadResult)t;
                l2 = l3;
                boolean bl = false;
                l = it.getDuration();
                l3 = l2 + l;
            }
            repositoryResult.missedRequestsTimeMs = l2 = l3;
            this.failedRequestsCount = failedDownloads.size();
            iterable2 = failedDownloads;
            repositoryResult = this;
            l3 = 0L;
            for (Object t : iterable2) {
                DownloadResult it = (DownloadResult)t;
                l2 = l3;
                boolean bl = false;
                l = it.getDuration();
                l3 = l2 + l;
            }
            repositoryResult.failedRequestsTimeMs = l2 = l3;
            iterable2 = failedDownloads;
            repositoryResult = this;
            l3 = 0L;
            for (Object t : iterable2) {
                DownloadResult it = (DownloadResult)t;
                l2 = l3;
                boolean bl = false;
                l = it.getBytes();
                l3 = l2 + l;
            }
            repositoryResult.failedRequestsBytesDownloaded = l2 = l3;
        }

        @NotNull
        public final Repository getRepository() {
            return this.repository;
        }

        @NotNull
        public final List<DownloadResult> getDownloads() {
            return this.downloads;
        }

        public final int getSuccessRequestsCount() {
            return this.successRequestsCount;
        }

        public final long getSuccessRequestsTimeMs() {
            return this.successRequestsTimeMs;
        }

        public final long getSuccessRequestsBytesDownloaded() {
            return this.successRequestsBytesDownloaded;
        }

        public final int getMissedRequestsCount() {
            return this.missedRequestsCount;
        }

        public final long getMissedRequestsTimeMs() {
            return this.missedRequestsTimeMs;
        }

        public final int getFailedRequestsCount() {
            return this.failedRequestsCount;
        }

        public final long getFailedRequestsTimeMs() {
            return this.failedRequestsTimeMs;
        }

        public final long getFailedRequestsBytesDownloaded() {
            return this.failedRequestsBytesDownloaded;
        }

        @NotNull
        public final Repository component1() {
            return this.repository;
        }

        @NotNull
        public final List<DownloadResult> component2() {
            return this.downloads;
        }

        @NotNull
        public final RepositoryResult copy(@NotNull Repository repository2, @NotNull List<DownloadResult> downloads2) {
            Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
            Intrinsics.checkNotNullParameter(downloads2, (String)"downloads");
            return new RepositoryResult(repository2, downloads2);
        }

        public static /* synthetic */ RepositoryResult copy$default(RepositoryResult repositoryResult, Repository repository2, List list, int n, Object object) {
            if ((n & 1) != 0) {
                repository2 = repositoryResult.repository;
            }
            if ((n & 2) != 0) {
                list = repositoryResult.downloads;
            }
            return repositoryResult.copy(repository2, list);
        }

        @NotNull
        public String toString() {
            return "RepositoryResult(repository=" + this.repository + ", downloads=" + this.downloads + ")";
        }

        public int hashCode() {
            int result2 = this.repository.hashCode();
            result2 = result2 * 31 + ((Object)this.downloads).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RepositoryResult)) {
                return false;
            }
            RepositoryResult repositoryResult = (RepositoryResult)other;
            if (!Intrinsics.areEqual((Object)this.repository, (Object)repositoryResult.repository)) {
                return false;
            }
            return Intrinsics.areEqual(this.downloads, repositoryResult.downloads);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0003\u0004\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$Result;", "Lcom/android/build/attribution/analyzers/AnalyzerResult;", "<init>", "()V", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$ActiveResult;", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$AnalyzerIsDisabled;", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$GradleDoesNotProvideEvents;", "intellij.android.build-attribution"})
    public static abstract sealed class Result
    implements AnalyzerResult
    permits ActiveResult, AnalyzerIsDisabled, GradleDoesNotProvideEvents {
        private Result() {
        }

        public /* synthetic */ Result(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

