/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.analytics;

import com.android.build.attribution.analytics.BuildAttributionAnalyticsManagerKt;
import com.android.build.attribution.analyzers.AGPUpdateRequired;
import com.android.build.attribution.analyzers.AnalyzerNotRun;
import com.android.build.attribution.analyzers.BuildEventsAnalysisResult;
import com.android.build.attribution.analyzers.ConfigurationCacheCompatibilityTestFlow;
import com.android.build.attribution.analyzers.ConfigurationCachingCompatibilityProjectResult;
import com.android.build.attribution.analyzers.ConfigurationCachingTurnedOff;
import com.android.build.attribution.analyzers.ConfigurationCachingTurnedOn;
import com.android.build.attribution.analyzers.DownloadsAnalyzer;
import com.android.build.attribution.analyzers.IncompatiblePluginWarning;
import com.android.build.attribution.analyzers.IncompatiblePluginsDetected;
import com.android.build.attribution.analyzers.JetifierCanBeRemoved;
import com.android.build.attribution.analyzers.JetifierNotUsed;
import com.android.build.attribution.analyzers.JetifierRequiredForLibraries;
import com.android.build.attribution.analyzers.JetifierUsageAnalyzerResult;
import com.android.build.attribution.analyzers.JetifierUsageProjectStatus;
import com.android.build.attribution.analyzers.JetifierUsedCheckRequired;
import com.android.build.attribution.analyzers.NoDataFromSavedResult;
import com.android.build.attribution.analyzers.NoIncompatiblePlugins;
import com.android.build.attribution.analyzers.TaskCategoryWarningsAnalyzer;
import com.android.build.attribution.data.AlwaysRunTaskData;
import com.android.build.attribution.data.AnnotationProcessorData;
import com.android.build.attribution.data.BuildInvocationType;
import com.android.build.attribution.data.PluginBuildData;
import com.android.build.attribution.data.PluginConfigurationData;
import com.android.build.attribution.data.PluginData;
import com.android.build.attribution.data.ProjectConfigurationData;
import com.android.build.attribution.data.TaskData;
import com.android.build.attribution.data.TasksSharingOutputData;
import com.android.buildanalyzer.common.TaskCategoryIssue;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.analytics.UsageTrackerUtils;
import com.google.common.base.Stopwatch;
import com.google.wireless.android.sdk.stats.AlwaysRunTasksAnalyzerData;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.AnnotationProcessorsAnalyzerData;
import com.google.wireless.android.sdk.stats.BuildAttribuitionTaskIdentifier;
import com.google.wireless.android.sdk.stats.BuildAttributionAnalyzersData;
import com.google.wireless.android.sdk.stats.BuildAttributionPerformanceStats;
import com.google.wireless.android.sdk.stats.BuildAttributionPluginIdentifier;
import com.google.wireless.android.sdk.stats.BuildAttributionStats;
import com.google.wireless.android.sdk.stats.BuildDownloadsAnalysisData;
import com.google.wireless.android.sdk.stats.ConfigurationCacheCompatibilityData;
import com.google.wireless.android.sdk.stats.CriticalPathAnalyzerData;
import com.google.wireless.android.sdk.stats.JetifierUsageData;
import com.google.wireless.android.sdk.stats.ProjectConfigurationAnalyzerData;
import com.google.wireless.android.sdk.stats.TaskCategoryIssuesData;
import com.google.wireless.android.sdk.stats.TasksConfigurationIssuesAnalyzerData;
import com.intellij.openapi.project.Project;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J+\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0014\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018J\b\u0010\u0019\u001a\u00020\u000eH\u0016J\u001e\u0010\u001a\u001a\n \f*\u0004\u0018\u00010\u001b0\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002J\u001e\u0010\u001f\u001a\n \f*\u0004\u0018\u00010 0 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001dH\u0002J>\u0010#\u001a\n \f*\u0004\u0018\u00010$0$2\u0006\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u00122\u0006\u0010(\u001a\u00020\u00122\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u001dH\u0002J&\u0010+\u001a\n \f*\u0004\u0018\u00010,0,2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u001d2\u0006\u0010/\u001a\u00020.H\u0002J\u001e\u00100\u001a\n \f*\u0004\u0018\u000101012\f\u00102\u001a\b\u0012\u0004\u0012\u0002030\u001dH\u0002J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0002J\u0010\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0002J\u0010\u0010<\u001a\u00020\u00032\u0006\u0010=\u001a\u00020>H\u0002J\u0018\u0010?\u001a\n \f*\u0004\u0018\u00010@0@2\u0006\u0010=\u001a\u00020>H\u0002J\u0018\u0010A\u001a\n \f*\u0004\u0018\u00010B0B2\u0006\u0010C\u001a\u00020*H\u0002J\u0010\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020GH\u0002J\u0018\u0010H\u001a\n \f*\u0004\u0018\u00010I0I2\u0006\u0010J\u001a\u00020\u001eH\u0002J\u0018\u0010K\u001a\n \f*\u0004\u0018\u00010L0L2\u0006\u0010M\u001a\u00020\"H\u0002J\u0018\u0010N\u001a\n \f*\u0004\u0018\u00010O0O2\u0006\u0010P\u001a\u00020QH\u0002J\u0010\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020UH\u0002J\u0018\u0010V\u001a\n \f*\u0004\u0018\u00010W0W2\u0006\u0010X\u001a\u00020YH\u0002J\u0018\u0010Z\u001a\n \f*\u0004\u0018\u00010[0[2\u0006\u0010-\u001a\u00020.H\u0002J\u0018\u0010\\\u001a\n \f*\u0004\u0018\u00010]0]2\u0006\u00102\u001a\u000203H\u0002J\u0018\u0010^\u001a\n \f*\u0004\u0018\u00010_0_2\u0006\u0010`\u001a\u00020aH\u0002J\u0018\u0010b\u001a\n \f*\u0004\u0018\u00010c0c2\u0006\u0010d\u001a\u00020eH\u0002J\u0010\u0010f\u001a\u00020g2\u0006\u0010h\u001a\u00020iH\u0002J\u0012\u0010j\u001a\u0004\u0018\u00010k2\u0006\u0010l\u001a\u00020mH\u0002J\u0010\u0010n\u001a\u00020o2\u0006\u0010p\u001a\u00020qH\u0002J\u000e\u0010r\u001a\u00020\u000e2\u0006\u0010s\u001a\u00020tJ\u000e\u0010u\u001a\u00020\u000e2\u0006\u0010s\u001a\u00020tJ\u000e\u0010v\u001a\u00020\u000e2\u0006\u0010s\u001a\u00020tJ\u000e\u0010w\u001a\u00020\u000e2\u0006\u0010s\u001a\u00020tR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006x"}, d2={"Lcom/android/build/attribution/analytics/BuildAttributionAnalyticsManager;", "Ljava/io/Closeable;", "buildSessionId", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;)V", "eventBuilder", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$Builder;", "attributionStatsBuilder", "Lcom/google/wireless/android/sdk/stats/BuildAttributionStats$Builder;", "kotlin.jvm.PlatformType", "runLoggingPerformanceStats", "", "toolingApiLatencyMs", "", "numberOfGeneratedPartialResults", "", "postBuildAnalysis", "Lkotlin/Function0;", "(JLjava/lang/Integer;Lkotlin/jvm/functions/Function0;)V", "logAnalyzersData", "analysisResult", "Lcom/android/build/attribution/analyzers/BuildEventsAnalysisResult;", "close", "transformAlwaysRunTasksAnalyzerData", "Lcom/google/wireless/android/sdk/stats/AlwaysRunTasksAnalyzerData;", "alwaysRunTasks", "", "Lcom/android/build/attribution/data/AlwaysRunTaskData;", "transformAnnotationProcessorsAnalyzerData", "Lcom/google/wireless/android/sdk/stats/AnnotationProcessorsAnalyzerData;", "nonIncrementalAnnotationProcessors", "Lcom/android/build/attribution/data/AnnotationProcessorData;", "transformCriticalPathAnalyzerData", "Lcom/google/wireless/android/sdk/stats/CriticalPathAnalyzerData;", "criticalPathDurationMs", "tasksDeterminingBuildDurationMs", "numberOfTasksOnCriticalPath", "numberOfTasksDeterminingBuildDuration", "pluginsCriticalPath", "Lcom/android/build/attribution/data/PluginBuildData;", "transformProjectConfigurationAnalyzerData", "Lcom/google/wireless/android/sdk/stats/ProjectConfigurationAnalyzerData;", "projectConfigurationData", "Lcom/android/build/attribution/data/ProjectConfigurationData;", "totalConfigurationData", "transformTasksConfigurationIssuesAnalyzerData", "Lcom/google/wireless/android/sdk/stats/TasksConfigurationIssuesAnalyzerData;", "tasksSharingOutputData", "Lcom/android/build/attribution/data/TasksSharingOutputData;", "transformPluginType", "Lcom/google/wireless/android/sdk/stats/BuildAttributionPluginIdentifier$PluginType;", "pluginType", "Lcom/android/build/attribution/data/PluginData$PluginType;", "transformPluginData", "Lcom/google/wireless/android/sdk/stats/BuildAttributionPluginIdentifier;", "pluginData", "Lcom/android/build/attribution/data/PluginData;", "getTaskClassName", "taskData", "Lcom/android/build/attribution/data/TaskData;", "transformTaskData", "Lcom/google/wireless/android/sdk/stats/BuildAttribuitionTaskIdentifier;", "transformPluginBuildData", "Lcom/google/wireless/android/sdk/stats/CriticalPathAnalyzerData$PluginBuildData;", "pluginBuildData", "transformAlwaysRunTaskReason", "Lcom/google/wireless/android/sdk/stats/AlwaysRunTasksAnalyzerData$AlwaysRunTask$AlwaysRunReason;", "reason", "Lcom/android/build/attribution/data/AlwaysRunTaskData$Reason;", "transformAlwaysRunTaskData", "Lcom/google/wireless/android/sdk/stats/AlwaysRunTasksAnalyzerData$AlwaysRunTask;", "alwaysRunTaskData", "transformAnnotationProcessorData", "Lcom/google/wireless/android/sdk/stats/AnnotationProcessorsAnalyzerData$NonIncrementalAnnotationProcessor;", "annotationProcessorData", "transformPluginConfigurationData", "Lcom/google/wireless/android/sdk/stats/ProjectConfigurationAnalyzerData$PluginConfigurationData;", "pluginConfigurationData", "Lcom/android/build/attribution/data/PluginConfigurationData;", "transformConfigurationStepType", "Lcom/google/wireless/android/sdk/stats/ProjectConfigurationAnalyzerData$ConfigurationStep$StepType;", "stepType", "Lcom/android/build/attribution/data/ProjectConfigurationData$ConfigurationStep$Type;", "transformConfigurationStepData", "Lcom/google/wireless/android/sdk/stats/ProjectConfigurationAnalyzerData$ConfigurationStep;", "configurationStep", "Lcom/android/build/attribution/data/ProjectConfigurationData$ConfigurationStep;", "transformProjectConfigurationData", "Lcom/google/wireless/android/sdk/stats/ProjectConfigurationAnalyzerData$ProjectConfigurationData;", "transformTasksSharingOutputData", "Lcom/google/wireless/android/sdk/stats/TasksConfigurationIssuesAnalyzerData$TasksSharingOutputData;", "transformConfigurationCacheCompatibilityData", "Lcom/google/wireless/android/sdk/stats/ConfigurationCacheCompatibilityData;", "configurationCachingCompatibilityState", "Lcom/android/build/attribution/analyzers/ConfigurationCachingCompatibilityProjectResult;", "transformJetifierUsageData", "Lcom/google/wireless/android/sdk/stats/JetifierUsageData;", "jetifierUsageResult", "Lcom/android/build/attribution/analyzers/JetifierUsageAnalyzerResult;", "transformDownloadsAnalyzerData", "Lcom/google/wireless/android/sdk/stats/BuildDownloadsAnalysisData;", "downloadsAnalyzerResult", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$ActiveResult;", "transformTaskCategoryIssue", "Lcom/google/wireless/android/sdk/stats/TaskCategoryIssuesData$TaskCategoryIssue;", "issue", "Lcom/android/buildanalyzer/common/TaskCategoryIssue;", "transformTaskCategoryIssuesData", "Lcom/google/wireless/android/sdk/stats/TaskCategoryIssuesData;", "taskCategoryIssuesResult", "Lcom/android/build/attribution/analyzers/TaskCategoryWarningsAnalyzer$IssuesResult;", "logBuildSuccess", "buildInvocationType", "Lcom/android/build/attribution/data/BuildInvocationType;", "logBuildFailure", "logAnalysisFailure", "logAnalysisCancellation", "intellij.android.build-attribution"})
@SourceDebugExtension(value={"SMAP\nBuildAttributionAnalyticsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildAttributionAnalyticsManager.kt\ncom/android/build/attribution/analytics/BuildAttributionAnalyticsManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,353:1\n1#2:354\n1#2:405\n1563#3:355\n1634#3,3:356\n1563#3:359\n1634#3,3:360\n1563#3:363\n1634#3,3:364\n1563#3:367\n1634#3,3:368\n1563#3:371\n1634#3,3:372\n1563#3:375\n1634#3,3:376\n1563#3:379\n1634#3,3:380\n1563#3:383\n1634#3,3:384\n1563#3:387\n1634#3,3:388\n1563#3:391\n1634#3,3:392\n1617#3,9:395\n1869#3:404\n1870#3:406\n1626#3:407\n*S KotlinDebug\n*F\n+ 1 BuildAttributionAnalyticsManager.kt\ncom/android/build/attribution/analytics/BuildAttributionAnalyticsManager\n*L\n310#1:405\n132#1:355\n132#1:356,3\n137#1:359\n137#1:360,3\n151#1:363\n151#1:364,3\n159#1:367\n159#1:368,3\n165#1:371\n165#1:372,3\n249#1:375\n249#1:376,3\n250#1:379\n250#1:380,3\n255#1:383\n255#1:384,3\n270#1:387\n270#1:388,3\n271#1:391\n271#1:392,3\n310#1:395,9\n310#1:404\n310#1:406\n310#1:407\n*E\n"})
public final class BuildAttributionAnalyticsManager
implements Closeable {
    @NotNull
    private final AndroidStudioEvent.Builder eventBuilder;
    private final BuildAttributionStats.Builder attributionStatsBuilder;

    public BuildAttributionAnalyticsManager(@NotNull String buildSessionId, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)buildSessionId, (String)"buildSessionId");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        AndroidStudioEvent.Builder builder = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.BUILD_ATTRIBUTION_STATS);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setKind(...)");
        this.eventBuilder = UsageTrackerUtils.withProjectId(builder, project);
        this.attributionStatsBuilder = BuildAttributionStats.newBuilder().setBuildAttributionReportSessionId(buildSessionId);
    }

    public final void runLoggingPerformanceStats(long toolingApiLatencyMs, @Nullable Integer numberOfGeneratedPartialResults, @NotNull Function0<Unit> postBuildAnalysis) {
        Intrinsics.checkNotNullParameter(postBuildAnalysis, (String)"postBuildAnalysis");
        Stopwatch watch = Stopwatch.createStarted();
        postBuildAnalysis.invoke();
        BuildAttributionPerformanceStats.Builder performanceStats = BuildAttributionPerformanceStats.newBuilder().setPostBuildAnalysisDurationMs(watch.stop().elapsed(TimeUnit.MILLISECONDS)).setToolingApiBuildFinishedEventLatencyMs(toolingApiLatencyMs);
        Integer n = numberOfGeneratedPartialResults;
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            performanceStats.setNumberOfGeneratedPartialResults(it);
        }
        this.attributionStatsBuilder.setBuildAttributionPerformanceStats(performanceStats);
    }

    /*
     * WARNING - void declaration
     */
    public final void logAnalyzersData(@NotNull BuildEventsAnalysisResult analysisResult) {
        long l;
        TaskData it;
        long l2;
        Intrinsics.checkNotNullParameter((Object)analysisResult, (String)"analysisResult");
        BuildAttributionAnalyzersData.Builder analyzersDataBuilder = BuildAttributionAnalyzersData.newBuilder();
        analyzersDataBuilder.setTotalBuildTimeMs(analysisResult.getTotalBuildTimeMs());
        analyzersDataBuilder.setAlwaysRunTasksAnalyzerData(this.transformAlwaysRunTasksAnalyzerData(analysisResult.getAlwaysRunTasks()));
        analyzersDataBuilder.setAnnotationProcessorsAnalyzerData(this.transformAnnotationProcessorsAnalyzerData(analysisResult.getNonIncrementalAnnotationProcessorsData()));
        Iterable iterable = analysisResult.getCriticalPathTasks();
        BuildAttributionAnalyticsManager buildAttributionAnalyticsManager = this;
        BuildAttributionAnalyzersData.Builder builder = analyzersDataBuilder;
        long l3 = 0L;
        for (Object t : iterable) {
            TaskData taskData = (TaskData)t;
            l2 = l3;
            boolean bl = false;
            l = it.getExecutionTime();
            l3 = l2 + l;
        }
        l2 = l3;
        iterable = analysisResult.getTasksDeterminingBuildDuration();
        l3 = 0L;
        for (Object t : iterable) {
            void p0;
            it = (TaskData)t;
            l = l3;
            boolean bl = false;
            long l4 = p0.getExecutionTime();
            l3 = l + l4;
        }
        l = l3;
        builder.setCriticalPathAnalyzerData(buildAttributionAnalyticsManager.transformCriticalPathAnalyzerData(l2, l, analysisResult.getCriticalPathTasks().size(), analysisResult.getTasksDeterminingBuildDuration().size(), analysisResult.getPluginsDeterminingBuildDuration()));
        analyzersDataBuilder.setProjectConfigurationAnalyzerData(this.transformProjectConfigurationAnalyzerData(analysisResult.getProjectsConfigurationData(), analysisResult.getTotalConfigurationData()));
        analyzersDataBuilder.setTasksConfigurationIssuesAnalyzerData(this.transformTasksConfigurationIssuesAnalyzerData(analysisResult.getTasksSharingOutput()));
        analyzersDataBuilder.setConfigurationCacheCompatibilityData(this.transformConfigurationCacheCompatibilityData(analysisResult.getConfigurationCachingCompatibility()));
        analyzersDataBuilder.setJetifierUsageData(this.transformJetifierUsageData(analysisResult.getJetifierUsageResult()));
        DownloadsAnalyzer.Result it2 = analysisResult.getDownloadsAnalyzerResult();
        boolean bl = false;
        if (it2 instanceof DownloadsAnalyzer.ActiveResult) {
            analyzersDataBuilder.setDownloadsAnalysisData(this.transformDownloadsAnalyzerData((DownloadsAnalyzer.ActiveResult)it2));
        }
        if (analysisResult.getTaskCategoryWarningsAnalyzerResult() instanceof TaskCategoryWarningsAnalyzer.IssuesResult) {
            TaskCategoryWarningsAnalyzer.Result result2 = analysisResult.getTaskCategoryWarningsAnalyzerResult();
            Intrinsics.checkNotNull((Object)result2, (String)"null cannot be cast to non-null type com.android.build.attribution.analyzers.TaskCategoryWarningsAnalyzer.IssuesResult");
            analyzersDataBuilder.setTaskCategoryIssuesData(this.transformTaskCategoryIssuesData((TaskCategoryWarningsAnalyzer.IssuesResult)result2));
        }
        this.attributionStatsBuilder.setBuildAttributionAnalyzersData(analyzersDataBuilder);
    }

    @Override
    public void close() {
        AndroidStudioEvent.Builder builder = this.eventBuilder.setBuildAttributionStats(this.attributionStatsBuilder);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setBuildAttributionStats(...)");
        UsageTracker.log((AndroidStudioEvent.Builder)builder);
    }

    /*
     * WARNING - void declaration
     */
    private final AlwaysRunTasksAnalyzerData transformAlwaysRunTasksAnalyzerData(List<AlwaysRunTaskData> alwaysRunTasks) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = alwaysRunTasks;
        AlwaysRunTasksAnalyzerData.Builder builder = AlwaysRunTasksAnalyzerData.newBuilder();
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            AlwaysRunTaskData alwaysRunTaskData = (AlwaysRunTaskData)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(this.transformAlwaysRunTaskData((AlwaysRunTaskData)p0));
        }
        return builder.addAllAlwaysRunTasks((Iterable)((List)destination$iv$iv)).build();
    }

    /*
     * WARNING - void declaration
     */
    private final AnnotationProcessorsAnalyzerData transformAnnotationProcessorsAnalyzerData(List<AnnotationProcessorData> nonIncrementalAnnotationProcessors) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = nonIncrementalAnnotationProcessors;
        AnnotationProcessorsAnalyzerData.Builder builder = AnnotationProcessorsAnalyzerData.newBuilder();
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            AnnotationProcessorData annotationProcessorData = (AnnotationProcessorData)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(this.transformAnnotationProcessorData((AnnotationProcessorData)p0));
        }
        return builder.addAllNonIncrementalAnnotationProcessors((Iterable)((List)destination$iv$iv)).build();
    }

    /*
     * WARNING - void declaration
     */
    private final CriticalPathAnalyzerData transformCriticalPathAnalyzerData(long criticalPathDurationMs, long tasksDeterminingBuildDurationMs, int numberOfTasksOnCriticalPath, int numberOfTasksDeterminingBuildDuration, List<PluginBuildData> pluginsCriticalPath) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = pluginsCriticalPath;
        CriticalPathAnalyzerData.Builder builder = CriticalPathAnalyzerData.newBuilder().setCriticalPathDurationMs(criticalPathDurationMs).setTasksDeterminingBuildDurationMs(tasksDeterminingBuildDurationMs).setNumberOfTasksOnCriticalPath(numberOfTasksOnCriticalPath).setNumberOfTasksDeterminingBuildDuration(numberOfTasksDeterminingBuildDuration);
        boolean $i$f$map = false;
        void var10_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            PluginBuildData pluginBuildData = (PluginBuildData)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(this.transformPluginBuildData((PluginBuildData)p0));
        }
        return builder.addAllPluginsCriticalPath((Iterable)((List)destination$iv$iv)).build();
    }

    /*
     * WARNING - void declaration
     */
    private final ProjectConfigurationAnalyzerData transformProjectConfigurationAnalyzerData(List<ProjectConfigurationData> projectConfigurationData, ProjectConfigurationData totalConfigurationData) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = projectConfigurationData;
        ProjectConfigurationAnalyzerData.Builder builder = ProjectConfigurationAnalyzerData.newBuilder();
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ProjectConfigurationData projectConfigurationData2 = (ProjectConfigurationData)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(this.transformProjectConfigurationData((ProjectConfigurationData)p0));
        }
        return builder.addAllProjectConfigurationData((Iterable)((List)destination$iv$iv)).setOverallConfigurationData(this.transformProjectConfigurationData(totalConfigurationData)).build();
    }

    /*
     * WARNING - void declaration
     */
    private final TasksConfigurationIssuesAnalyzerData transformTasksConfigurationIssuesAnalyzerData(List<TasksSharingOutputData> tasksSharingOutputData) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = tasksSharingOutputData;
        TasksConfigurationIssuesAnalyzerData.Builder builder = TasksConfigurationIssuesAnalyzerData.newBuilder();
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            TasksSharingOutputData tasksSharingOutputData2 = (TasksSharingOutputData)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(this.transformTasksSharingOutputData((TasksSharingOutputData)p0));
        }
        return builder.addAllTasksSharingOutputData((Iterable)((List)destination$iv$iv)).build();
    }

    private final BuildAttributionPluginIdentifier.PluginType transformPluginType(PluginData.PluginType pluginType) {
        return switch (WhenMappings.$EnumSwitchMapping$0[pluginType.ordinal()]) {
            case 1 -> BuildAttributionPluginIdentifier.PluginType.UNKNOWN_TYPE;
            case 2 -> BuildAttributionPluginIdentifier.PluginType.BUILD_SCRIPT;
            case 3 -> BuildAttributionPluginIdentifier.PluginType.BUILD_SRC;
            case 4 -> BuildAttributionPluginIdentifier.PluginType.OTHER_PLUGIN;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final BuildAttributionPluginIdentifier transformPluginData(PluginData pluginData) {
        BuildAttributionPluginIdentifier.PluginType pluginType = this.transformPluginType(pluginData.getPluginType());
        BuildAttributionPluginIdentifier.Builder builder = BuildAttributionPluginIdentifier.newBuilder().setType(pluginType);
        if (pluginType == BuildAttributionPluginIdentifier.PluginType.OTHER_PLUGIN) {
            builder.setPluginDisplayName(pluginData.getDisplayName());
            builder.setPluginClassName(pluginData.getIdName());
        }
        BuildAttributionPluginIdentifier buildAttributionPluginIdentifier = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)buildAttributionPluginIdentifier, (String)"build(...)");
        return buildAttributionPluginIdentifier;
    }

    private final String getTaskClassName(TaskData taskData) {
        char[] cArray = new char[]{'.'};
        return (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)taskData.getTaskType(), (char[])cArray, (boolean)false, (int)0, (int)6, null));
    }

    private final BuildAttribuitionTaskIdentifier transformTaskData(TaskData taskData) {
        return BuildAttribuitionTaskIdentifier.newBuilder().setTaskClassName(this.getTaskClassName(taskData)).setOriginPlugin(this.transformPluginData(taskData.getOriginPlugin())).build();
    }

    private final CriticalPathAnalyzerData.PluginBuildData transformPluginBuildData(PluginBuildData pluginBuildData) {
        return CriticalPathAnalyzerData.PluginBuildData.newBuilder().setBuildDurationMs(pluginBuildData.getBuildDuration()).setPluginIdentifier(this.transformPluginData(pluginBuildData.getPlugin())).build();
    }

    private final AlwaysRunTasksAnalyzerData.AlwaysRunTask.AlwaysRunReason transformAlwaysRunTaskReason(AlwaysRunTaskData.Reason reason) {
        return switch (WhenMappings.$EnumSwitchMapping$1[reason.ordinal()]) {
            case 1 -> AlwaysRunTasksAnalyzerData.AlwaysRunTask.AlwaysRunReason.NO_OUTPUTS_WITH_ACTIONS;
            case 2 -> AlwaysRunTasksAnalyzerData.AlwaysRunTask.AlwaysRunReason.UP_TO_DATE_WHEN_FALSE;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final AlwaysRunTasksAnalyzerData.AlwaysRunTask transformAlwaysRunTaskData(AlwaysRunTaskData alwaysRunTaskData) {
        return AlwaysRunTasksAnalyzerData.AlwaysRunTask.newBuilder().setReason(this.transformAlwaysRunTaskReason(alwaysRunTaskData.getRerunReason())).setTaskIdentifier(this.transformTaskData(alwaysRunTaskData.getTaskData())).build();
    }

    private final AnnotationProcessorsAnalyzerData.NonIncrementalAnnotationProcessor transformAnnotationProcessorData(AnnotationProcessorData annotationProcessorData) {
        return AnnotationProcessorsAnalyzerData.NonIncrementalAnnotationProcessor.newBuilder().setCompilationDurationMs(annotationProcessorData.getCompilationDuration().toMillis()).setAnnotationProcessorClassName(annotationProcessorData.getClassName()).build();
    }

    private final ProjectConfigurationAnalyzerData.PluginConfigurationData transformPluginConfigurationData(PluginConfigurationData pluginConfigurationData) {
        return ProjectConfigurationAnalyzerData.PluginConfigurationData.newBuilder().setPluginConfigurationTimeMs(pluginConfigurationData.getConfigurationTimeMs()).setPluginIdentifier(this.transformPluginData(pluginConfigurationData.getPlugin())).build();
    }

    private final ProjectConfigurationAnalyzerData.ConfigurationStep.StepType transformConfigurationStepType(ProjectConfigurationData.ConfigurationStep.Type stepType) {
        return switch (WhenMappings.$EnumSwitchMapping$2[stepType.ordinal()]) {
            case 1 -> ProjectConfigurationAnalyzerData.ConfigurationStep.StepType.NOTIFYING_BUILD_LISTENERS;
            case 2 -> ProjectConfigurationAnalyzerData.ConfigurationStep.StepType.RESOLVING_DEPENDENCIES;
            case 3 -> ProjectConfigurationAnalyzerData.ConfigurationStep.StepType.COMPILING_BUILD_SCRIPTS;
            case 4 -> ProjectConfigurationAnalyzerData.ConfigurationStep.StepType.EXECUTING_BUILD_SCRIPT_BLOCKS;
            case 5 -> ProjectConfigurationAnalyzerData.ConfigurationStep.StepType.OTHER;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final ProjectConfigurationAnalyzerData.ConfigurationStep transformConfigurationStepData(ProjectConfigurationData.ConfigurationStep configurationStep) {
        return ProjectConfigurationAnalyzerData.ConfigurationStep.newBuilder().setType(this.transformConfigurationStepType(configurationStep.getType())).setConfigurationTimeMs(configurationStep.getConfigurationTimeMs()).build();
    }

    private final ProjectConfigurationAnalyzerData.ProjectConfigurationData transformProjectConfigurationData(ProjectConfigurationData projectConfigurationData) {
        ProjectConfigurationData.ConfigurationStep p0;
        Collection collection2;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable iterable = projectConfigurationData.getPluginsConfigurationData();
        ProjectConfigurationAnalyzerData.ProjectConfigurationData.Builder builder = ProjectConfigurationAnalyzerData.ProjectConfigurationData.newBuilder().setConfigurationTimeMs(projectConfigurationData.getTotalConfigurationTimeMs());
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            PluginConfigurationData pluginConfigurationData = (PluginConfigurationData)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(this.transformPluginConfigurationData((PluginConfigurationData)((Object)p0)));
        }
        $this$map$iv = projectConfigurationData.getConfigurationSteps();
        builder = builder.addAllPluginsConfigurationData((Iterable)((List)destination$iv$iv));
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            p0 = (ProjectConfigurationData.ConfigurationStep)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(this.transformConfigurationStepData(p0));
        }
        return builder.addAllConfigurationSteps((Iterable)((List)destination$iv$iv)).build();
    }

    /*
     * WARNING - void declaration
     */
    private final TasksConfigurationIssuesAnalyzerData.TasksSharingOutputData transformTasksSharingOutputData(TasksSharingOutputData tasksSharingOutputData) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = tasksSharingOutputData.getTaskList();
        TasksConfigurationIssuesAnalyzerData.TasksSharingOutputData.Builder builder = TasksConfigurationIssuesAnalyzerData.TasksSharingOutputData.newBuilder();
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            TaskData taskData = (TaskData)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(this.transformTaskData((TaskData)p0));
        }
        return builder.addAllTasksSharingOutput((Iterable)((List)destination$iv$iv)).build();
    }

    private final ConfigurationCacheCompatibilityData transformConfigurationCacheCompatibilityData(ConfigurationCachingCompatibilityProjectResult configurationCachingCompatibilityState) {
        ConfigurationCacheCompatibilityData.CompatibilityState compatibilityState;
        ConfigurationCacheCompatibilityData.Builder builder;
        ConfigurationCacheCompatibilityData.Builder $this$transformConfigurationCacheCompatibilityData_u24lambda_u2413 = builder = ConfigurationCacheCompatibilityData.newBuilder();
        boolean bl = false;
        Object object = configurationCachingCompatibilityState;
        if (object instanceof AGPUpdateRequired) {
            compatibilityState = ConfigurationCacheCompatibilityData.CompatibilityState.AGP_NOT_COMPATIBLE;
        } else if (object instanceof NoIncompatiblePlugins) {
            compatibilityState = ConfigurationCacheCompatibilityData.CompatibilityState.INCOMPATIBLE_PLUGINS_NOT_DETECTED;
        } else if (object instanceof IncompatiblePluginsDetected) {
            compatibilityState = ConfigurationCacheCompatibilityData.CompatibilityState.INCOMPATIBLE_PLUGINS_DETECTED;
        } else if (Intrinsics.areEqual((Object)object, (Object)ConfigurationCachingTurnedOn.INSTANCE)) {
            compatibilityState = ConfigurationCacheCompatibilityData.CompatibilityState.CONFIGURATION_CACHE_TURNED_ON;
        } else if (object instanceof ConfigurationCacheCompatibilityTestFlow) {
            compatibilityState = ConfigurationCacheCompatibilityData.CompatibilityState.CONFIGURATION_CACHE_TRIAL_FLOW_BUILD;
        } else if (Intrinsics.areEqual((Object)object, (Object)ConfigurationCachingTurnedOff.INSTANCE)) {
            compatibilityState = ConfigurationCacheCompatibilityData.CompatibilityState.CONFIGURATION_CACHE_TURNED_OFF;
        } else if (Intrinsics.areEqual((Object)object, (Object)NoDataFromSavedResult.INSTANCE)) {
            compatibilityState = ConfigurationCacheCompatibilityData.CompatibilityState.UNKNOWN_STATE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        $this$transformConfigurationCacheCompatibilityData_u24lambda_u2413.setCompatibilityState(compatibilityState);
        if (configurationCachingCompatibilityState instanceof IncompatiblePluginsDetected) {
            IncompatiblePluginWarning it;
            Collection collection2;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            object = ((IncompatiblePluginsDetected)configurationCachingCompatibilityState).getIncompatiblePluginWarnings();
            ConfigurationCacheCompatibilityData.Builder builder2 = $this$transformConfigurationCacheCompatibilityData_u24lambda_u2413;
            boolean $i$f$map = false;
            void var8_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                IncompatiblePluginWarning incompatiblePluginWarning = (IncompatiblePluginWarning)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl2 = false;
                collection2.add(this.transformPluginData(it.getPlugin()));
            }
            builder2.addAllIncompatiblePlugins((Iterable)((List)destination$iv$iv));
            $this$map$iv = ((IncompatiblePluginsDetected)configurationCachingCompatibilityState).getUpgradePluginWarnings();
            builder2 = $this$transformConfigurationCacheCompatibilityData_u24lambda_u2413;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (IncompatiblePluginWarning)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl3 = false;
                collection2.add(this.transformPluginData(it.getPlugin()));
            }
            builder2.addAllIncompatiblePlugins((Iterable)((List)destination$iv$iv));
        }
        return builder.build();
    }

    private final JetifierUsageData transformJetifierUsageData(JetifierUsageAnalyzerResult jetifierUsageResult) {
        JetifierUsageData.JetifierUsageState jetifierUsageState;
        JetifierUsageData.Builder builder;
        JetifierUsageData.Builder $this$transformJetifierUsageData_u24lambda_u2415 = builder = JetifierUsageData.newBuilder();
        boolean bl = false;
        $this$transformJetifierUsageData_u24lambda_u2415.setCheckJetifierTaskBuild(jetifierUsageResult.getCheckJetifierBuild());
        JetifierUsageProjectStatus jetifierUsageProjectStatus = jetifierUsageResult.getProjectStatus();
        if (Intrinsics.areEqual((Object)jetifierUsageProjectStatus, (Object)AnalyzerNotRun.INSTANCE)) {
            jetifierUsageState = null;
        } else if (Intrinsics.areEqual((Object)jetifierUsageProjectStatus, (Object)JetifierCanBeRemoved.INSTANCE)) {
            jetifierUsageState = JetifierUsageData.JetifierUsageState.JETIFIER_CAN_BE_REMOVED;
        } else if (Intrinsics.areEqual((Object)jetifierUsageProjectStatus, (Object)JetifierNotUsed.INSTANCE)) {
            jetifierUsageState = JetifierUsageData.JetifierUsageState.JETIFIER_NOT_USED;
        } else if (Intrinsics.areEqual((Object)jetifierUsageProjectStatus, (Object)JetifierUsedCheckRequired.INSTANCE)) {
            jetifierUsageState = JetifierUsageData.JetifierUsageState.JETIFIER_USED_CHECK_REQUIRED;
        } else if (jetifierUsageProjectStatus instanceof JetifierRequiredForLibraries) {
            jetifierUsageState = JetifierUsageData.JetifierUsageState.JETIFIER_REQUIRED_FOR_LIBRARIES;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        JetifierUsageData.JetifierUsageState jetifierUsageState2 = jetifierUsageState;
        if (jetifierUsageState2 != null) {
            JetifierUsageData.JetifierUsageState it = jetifierUsageState2;
            boolean bl2 = false;
            $this$transformJetifierUsageData_u24lambda_u2415.setJetifierUsageState(it);
        }
        if (jetifierUsageResult.getProjectStatus() instanceof JetifierRequiredForLibraries) {
            $this$transformJetifierUsageData_u24lambda_u2415.setNumberOfLibrariesRequireJetifier(((JetifierRequiredForLibraries)jetifierUsageResult.getProjectStatus()).getCheckJetifierResult().getDependenciesDependingOnSupportLibs().size());
        }
        return builder.build();
    }

    private final BuildDownloadsAnalysisData transformDownloadsAnalyzerData(DownloadsAnalyzer.ActiveResult downloadsAnalyzerResult) {
        return BuildAttributionAnalyticsManagerKt.transformDownloadsAnalyzerData(downloadsAnalyzerResult.getRepositoryResults());
    }

    private final TaskCategoryIssuesData.TaskCategoryIssue transformTaskCategoryIssue(TaskCategoryIssue issue2) {
        return switch (WhenMappings.$EnumSwitchMapping$3[issue2.ordinal()]) {
            case 1 -> TaskCategoryIssuesData.TaskCategoryIssue.NON_FINAL_RES_IDS_DISABLED;
            case 2 -> TaskCategoryIssuesData.TaskCategoryIssue.NON_TRANSITIVE_R_CLASS_DISABLED;
            case 3 -> TaskCategoryIssuesData.TaskCategoryIssue.RESOURCE_VALIDATION_ENABLED;
            case 4 -> TaskCategoryIssuesData.TaskCategoryIssue.MINIFICATION_ENABLED_IN_DEBUG_BUILD;
            case 5 -> null;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - void declaration
     */
    private final TaskCategoryIssuesData transformTaskCategoryIssuesData(TaskCategoryWarningsAnalyzer.IssuesResult taskCategoryIssuesResult) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        TaskCategoryIssuesData.Builder builder;
        TaskCategoryIssuesData.Builder $this$transformTaskCategoryIssuesData_u24lambda_u2417 = builder = TaskCategoryIssuesData.newBuilder();
        boolean bl = false;
        Iterable iterable = taskCategoryIssuesResult.getTaskCategoryIssues();
        TaskCategoryIssuesData.Builder builder2 = $this$transformTaskCategoryIssuesData_u24lambda_u2417;
        boolean $i$f$mapNotNull = false;
        void var8_8 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            TaskCategoryIssuesData.TaskCategoryIssue it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl2 = false;
            TaskCategoryIssue p0 = (TaskCategoryIssue)element$iv$iv;
            boolean bl3 = false;
            if (this.transformTaskCategoryIssue(p0) == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        builder2.addAllReportedIssues((Iterable)((List)destination$iv$iv));
        TaskCategoryIssuesData taskCategoryIssuesData = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)taskCategoryIssuesData, (String)"build(...)");
        return taskCategoryIssuesData;
    }

    public final void logBuildSuccess(@NotNull BuildInvocationType buildInvocationType) {
        Intrinsics.checkNotNullParameter((Object)((Object)buildInvocationType), (String)"buildInvocationType");
        this.attributionStatsBuilder.setBuildType(buildInvocationType.getMetricsType());
        this.attributionStatsBuilder.setBuildAnalysisStatus(BuildAttributionStats.BuildAnalysisStatus.SUCCESS);
    }

    public final void logBuildFailure(@NotNull BuildInvocationType buildInvocationType) {
        Intrinsics.checkNotNullParameter((Object)((Object)buildInvocationType), (String)"buildInvocationType");
        this.attributionStatsBuilder.setBuildType(buildInvocationType.getMetricsType());
        this.attributionStatsBuilder.setBuildAnalysisStatus(BuildAttributionStats.BuildAnalysisStatus.BUILD_FAILURE);
    }

    public final void logAnalysisFailure(@NotNull BuildInvocationType buildInvocationType) {
        Intrinsics.checkNotNullParameter((Object)((Object)buildInvocationType), (String)"buildInvocationType");
        this.attributionStatsBuilder.setBuildType(buildInvocationType.getMetricsType());
        this.attributionStatsBuilder.setBuildAnalysisStatus(BuildAttributionStats.BuildAnalysisStatus.ANALYSIS_FAILURE);
    }

    public final void logAnalysisCancellation(@NotNull BuildInvocationType buildInvocationType) {
        Intrinsics.checkNotNullParameter((Object)((Object)buildInvocationType), (String)"buildInvocationType");
        this.attributionStatsBuilder.setBuildType(buildInvocationType.getMetricsType());
        this.attributionStatsBuilder.setBuildAnalysisStatus(BuildAttributionStats.BuildAnalysisStatus.ANALYSIS_CANCELED);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;

        static {
            int[] nArray = new int[PluginData.PluginType.values().length];
            try {
                nArray[PluginData.PluginType.UNKNOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PluginData.PluginType.SCRIPT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PluginData.PluginType.BUILDSRC_PLUGIN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PluginData.PluginType.BINARY_PLUGIN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[AlwaysRunTaskData.Reason.values().length];
            try {
                nArray[AlwaysRunTaskData.Reason.NO_OUTPUTS_WITH_ACTIONS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AlwaysRunTaskData.Reason.UP_TO_DATE_WHEN_FALSE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[ProjectConfigurationData.ConfigurationStep.Type.values().length];
            try {
                nArray[ProjectConfigurationData.ConfigurationStep.Type.NOTIFYING_BUILD_LISTENERS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectConfigurationData.ConfigurationStep.Type.RESOLVING_DEPENDENCIES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectConfigurationData.ConfigurationStep.Type.COMPILING_BUILD_SCRIPTS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectConfigurationData.ConfigurationStep.Type.EXECUTING_BUILD_SCRIPT_BLOCKS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProjectConfigurationData.ConfigurationStep.Type.OTHER.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[TaskCategoryIssue.values().length];
            try {
                nArray[TaskCategoryIssue.NON_FINAL_RES_IDS_DISABLED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TaskCategoryIssue.NON_TRANSITIVE_R_CLASS_DISABLED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TaskCategoryIssue.RESOURCE_VALIDATION_ENABLED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TaskCategoryIssue.MINIFICATION_ENABLED_IN_DEBUG_BUILD.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TaskCategoryIssue.JAVA_NON_INCREMENTAL_ANNOTATION_PROCESSOR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$3 = nArray;
        }
    }
}

