/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.rml.ast;

import com.intellij.rml.dfa.impl.domains.Domain;
import com.intellij.rml.dfa.impl.relations.IRelation;
import com.intellij.rml.dfa.impl.relations.IRelationsManager;
import com.intellij.rml.dfa.impl.rml.DomainsPool;
import com.intellij.rml.dfa.impl.rml.ast.Context;
import com.intellij.rml.dfa.impl.rml.ast.RelExpr;
import com.intellij.rml.dfa.impl.rml.ast.RelExprTransformer;
import com.intellij.rml.dfa.impl.rml.ast.RelExprVisitor;
import com.intellij.rml.dfa.impl.rml.profiler.ProfilePoint;
import com.intellij.rml.dfa.impl.rml.profiler.RmlProfileManager;
import com.intellij.rml.dfa.impl.rml.profiler.RmlProfileManagerKt;
import com.intellij.rml.dfa.impl.scripts.RuntimeVariablesManager;
import com.intellij.rml.dfa.impl.symtable.SymbolTable;
import com.intellij.rml.dfa.impl.ui.UIInstancesProvider;
import com.intellij.rml.dfa.impl.utils.ArrayHelper;
import com.intellij.rml.dfa.utils.Cancellation;

public class RelExprVarEquivalence
extends RelExpr {
    private final String domain;
    private final RelExpr relExpr;

    public RelExprVarEquivalence(String domain, RelExpr relExpr, Context context) {
        super(context, relExpr);
        this.domain = domain;
        this.relExpr = relExpr;
    }

    public String getDomain() {
        return this.domain;
    }

    public RelExpr getRelExpr() {
        return this.relExpr;
    }

    @Override
    public void accept(RelExprVisitor visitor2) {
        if (visitor2.visitEquivalenceStart(this)) {
            this.relExpr.accept(visitor2);
        }
        visitor2.visitEquivalenceEnd(this);
    }

    @Override
    public RelExpr transform(RelExprTransformer transformer) {
        return transformer.transformEquivalence(this);
    }

    @Override
    public Domain[] getDomains(RuntimeVariablesManager variablesManager, DomainsPool domainsPool) {
        return ArrayHelper.uniteArrays(new Domain[]{variablesManager.getDomain(this.domain)}, this.relExpr.getDomains(variablesManager, domainsPool), Domain.class);
    }

    @Override
    public IRelation interpret(IRelationsManager relationsManager, RuntimeVariablesManager variablesManager, Cancellation cancellation, DomainsPool domainsPool, UIInstancesProvider uiInstancesProvider, SymbolTable symbolTable, RmlProfileManager profileManager2) {
        ProfilePoint start = RmlProfileManagerKt.getProfilePoint(profileManager2, relationsManager);
        IRelation cached = variablesManager.getRelation(this.getResultCacheRelName(), cancellation);
        if (this.canBeCached && cached != null) {
            return cached.getClone();
        }
        Domain dom = variablesManager.getDomain(this.domain);
        IRelation exprResult = this.relExpr.interpret(relationsManager, variablesManager, cancellation, domainsPool, uiInstancesProvider, symbolTable, profileManager2);
        IRelation exprNotResult = exprResult.complement(cancellation);
        IRelation result = exprResult.unsafeIntersect(relationsManager.makeSingleTuple(dom, 1), cancellation).unsafeUnite(exprNotResult.unsafeIntersect(relationsManager.makeSingleTuple(dom, 0), cancellation), cancellation);
        exprResult.kill();
        exprNotResult.kill();
        variablesManager.storeRelation(this.getResultCacheRelName(), result.getClone());
        if (profileManager2 != null) {
            profileManager2.addDuration(this, start, RmlProfileManagerKt.getProfilePoint(profileManager2, relationsManager));
        }
        return result;
    }

    @Override
    public String toLongString() {
        return "RelExprEquivalence{domain='" + this.domain + "', relExpr='" + this.relExpr.toLongString() + "'}";
    }

    @Override
    public String toShortString() {
        return "(" + this.domain + " = " + this.relExpr.toShortString() + ")";
    }
}

