/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.repositories;

import com.intellij.rml.dfa.impl.domains.DomainTypeManager;
import com.intellij.rml.dfa.impl.relations.IImmutableRelation;
import com.intellij.rml.dfa.impl.relations.plain.PlainRelation;
import com.intellij.rml.dfa.impl.relations.plain.PlainRelationsManager;
import com.intellij.rml.dfa.impl.repositories.RelationsRepository;
import java.io.DataInput;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0016J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0004H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u0004H\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\tX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/rml/dfa/impl/repositories/ImmutableRelationsRepository;", "Lcom/intellij/rml/dfa/impl/repositories/RelationsRepository;", "nameToRelationMap", "", "", "Lcom/intellij/rml/dfa/impl/relations/IImmutableRelation;", "<init>", "(Ljava/util/Map;)V", "availableRelations", "", "getAvailableRelations", "()[Ljava/lang/String;", "[Ljava/lang/String;", "containsRelation", "", "name", "getRelation", "getRelationOrNull", "Companion", "intellij.rml.dfa.impl"})
@SourceDebugExtension(value={"SMAP\nRelationsRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RelationsRepository.kt\ncom/intellij/rml/dfa/impl/repositories/ImmutableRelationsRepository\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,48:1\n37#2:49\n36#2,3:50\n*S KotlinDebug\n*F\n+ 1 RelationsRepository.kt\ncom/intellij/rml/dfa/impl/repositories/ImmutableRelationsRepository\n*L\n29#1:49\n29#1:50,3\n*E\n"})
public final class ImmutableRelationsRepository
implements RelationsRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, IImmutableRelation> nameToRelationMap;
    @NotNull
    private final String[] availableRelations;

    public ImmutableRelationsRepository(@NotNull Map<String, ? extends IImmutableRelation> nameToRelationMap) {
        Intrinsics.checkNotNullParameter(nameToRelationMap, (String)"nameToRelationMap");
        this.nameToRelationMap = nameToRelationMap;
        Collection $this$toTypedArray$iv = this.nameToRelationMap.keySet();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        this.availableRelations = thisCollection$iv.toArray(new String[0]);
    }

    @Override
    @NotNull
    public String[] getAvailableRelations() {
        return this.availableRelations;
    }

    @Override
    public boolean containsRelation(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.nameToRelationMap.containsKey(name);
    }

    @Override
    @NotNull
    public IImmutableRelation getRelation(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        IImmutableRelation iImmutableRelation = this.nameToRelationMap.get(name);
        Intrinsics.checkNotNull((Object)iImmutableRelation);
        return iImmutableRelation;
    }

    @Override
    @Nullable
    public IImmutableRelation getRelationOrNull(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.nameToRelationMap.get(name);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/rml/dfa/impl/repositories/ImmutableRelationsRepository$Companion;", "", "<init>", "()V", "load", "Lcom/intellij/rml/dfa/impl/repositories/RelationsRepository;", "typeManager", "Lcom/intellij/rml/dfa/impl/domains/DomainTypeManager;", "relationsManager", "Lcom/intellij/rml/dfa/impl/relations/plain/PlainRelationsManager;", "stream", "Ljava/io/DataInput;", "intellij.rml.dfa.impl"})
    @SourceDebugExtension(value={"SMAP\nRelationsRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RelationsRepository.kt\ncom/intellij/rml/dfa/impl/repositories/ImmutableRelationsRepository$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,48:1\n1193#2,2:49\n1267#2,4:51\n*S KotlinDebug\n*F\n+ 1 RelationsRepository.kt\ncom/intellij/rml/dfa/impl/repositories/ImmutableRelationsRepository$Companion\n*L\n40#1:49,2\n40#1:51,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final RelationsRepository load(@NotNull DomainTypeManager typeManager, @NotNull PlainRelationsManager relationsManager, @NotNull DataInput stream) {
            void $this$associateTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)typeManager, (String)"typeManager");
            Intrinsics.checkNotNullParameter((Object)relationsManager, (String)"relationsManager");
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            int relationsCnt = stream.readInt();
            Iterable $this$associate$iv = (Iterable)RangesKt.until((int)0, (int)relationsCnt);
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            Iterator iterator = $this$associateTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                int element$iv$iv = ((IntIterator)iterator).nextInt();
                Map map2 = destination$iv$iv;
                int it = element$iv$iv;
                boolean bl = false;
                String relationName = stream.readUTF();
                IImmutableRelation relation = PlainRelation.Companion.load(typeManager, relationsManager, stream);
                Pair pair = TuplesKt.to((Object)relationName, (Object)relation);
                map2.put(pair.getFirst(), pair.getSecond());
            }
            Map map3 = destination$iv$iv;
            return new ImmutableRelationsRepository(map3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

