/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.relations.plain;

import com.intellij.rml.dfa.DfaInternalException;
import com.intellij.rml.dfa.attributes.IntAttribute;
import com.intellij.rml.dfa.impl.bdd.BddManager;
import com.intellij.rml.dfa.impl.bdd.BddNode;
import com.intellij.rml.dfa.impl.domains.Domain;
import com.intellij.rml.dfa.impl.domains.DomainType;
import com.intellij.rml.dfa.impl.relations.IRelation;
import com.intellij.rml.dfa.impl.relations.IRelationsManager;
import com.intellij.rml.dfa.impl.relations.plain.PlainRelation;
import com.intellij.rml.dfa.impl.symtable.SymbolTable;
import com.intellij.rml.dfa.impl.ui.Messages;
import com.intellij.rml.dfa.impl.utils.SortedArrayHelper;
import com.intellij.rml.dfa.utils.Cancellation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u0003H\u0016J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J(\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001b\u0010\u001a\u001a\u00020\u00102\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001cH\u0016\u00a2\u0006\u0002\u0010\u001dJ\u001b\u0010\u001a\u001a\u00020\u00102\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001cH\u0016\u00a2\u0006\u0002\u0010 J#\u0010\u001a\u001a\u00020\u00102\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001c2\u0006\u0010!\u001a\u00020\"H\u0016\u00a2\u0006\u0002\u0010#J\u0018\u0010$\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020\fH\u0016J#\u0010$\u001a\u00020\u00102\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001c2\u0006\u0010&\u001a\u00020'H\u0016\u00a2\u0006\u0002\u0010(J\u0018\u0010$\u001a\u00020\u00102\u0006\u0010)\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\fH\u0016J \u0010*\u001a\u00020\u00102\u0006\u0010+\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010-\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010/\u001a\u00020\u00102\u0006\u00100\u001a\u00020\u000e2\u0006\u00101\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001e\u00102\u001a\b\u0012\u0004\u0012\u00020\f032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u001fH\u0002J(\u00104\u001a\u00020\u00102\u0006\u00100\u001a\u00020\u000e2\u0006\u00101\u001a\u00020\u000e2\u0006\u00105\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J(\u00106\u001a\u00020\u00102\u0006\u00100\u001a\u00020\u000e2\u0006\u00101\u001a\u00020\u000e2\u0006\u00105\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J)\u00107\u001a\u00020\u00102\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001c2\f\u00108\u001a\b\u0012\u0004\u0012\u00020'09H\u0002\u00a2\u0006\u0002\u0010:J\u001e\u00107\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\f\u00108\u001a\b\u0012\u0004\u0012\u00020\f09H\u0002J(\u00104\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020\f2\u0006\u00105\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J(\u00106\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020\f2\u0006\u00105\u001a\u00020\"2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001b\u0010;\u001a\u00020<2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001cH\u0002\u00a2\u0006\u0002\u0010=J%\u0010;\u001a\u00020<2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001c2\b\b\u0002\u0010>\u001a\u00020\"H\u0002\u00a2\u0006\u0002\u0010?J%\u0010;\u001a\u00020<2\u0006\u0010@\u001a\u00020A2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001cH\u0002\u00a2\u0006\u0004\bB\u0010CJ\b\u0010D\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006E"}, d2={"Lcom/intellij/rml/dfa/impl/relations/plain/PlainRelationsManager;", "Lcom/intellij/rml/dfa/impl/relations/IRelationsManager;", "bddManager", "Lcom/intellij/rml/dfa/impl/bdd/BddManager;", "symbolTable", "Lcom/intellij/rml/dfa/impl/symtable/SymbolTable;", "<init>", "(Lcom/intellij/rml/dfa/impl/bdd/BddManager;Lcom/intellij/rml/dfa/impl/symtable/SymbolTable;)V", "getSymbolTable$intellij_rml_dfa_impl", "()Lcom/intellij/rml/dfa/impl/symtable/SymbolTable;", "getBDDManager", "getBitLength", "", "domain", "Lcom/intellij/rml/dfa/impl/domains/Domain;", "makeRepositoryRelation", "Lcom/intellij/rml/dfa/impl/relations/IRelation;", "relation", "relname", "", "makeSubIncrementalRelation", "base", "add", "sub", "cancellation", "Lcom/intellij/rml/dfa/utils/Cancellation;", "makeEmptyRelation", "domains", "", "([Lcom/intellij/rml/dfa/impl/domains/Domain;)Lcom/intellij/rml/dfa/impl/relations/IRelation;", "types", "Lcom/intellij/rml/dfa/impl/domains/DomainType;", "([Lcom/intellij/rml/dfa/impl/domains/DomainType;)Lcom/intellij/rml/dfa/impl/relations/IRelation;", "isFull", "", "([Lcom/intellij/rml/dfa/impl/domains/Domain;Z)Lcom/intellij/rml/dfa/impl/relations/IRelation;", "makeSingleTuple", "value", "values", "", "([Lcom/intellij/rml/dfa/impl/domains/Domain;[I)Lcom/intellij/rml/dfa/impl/relations/IRelation;", "type", "makeBinaryExpansion", "maskDomain", "bitDomain", "makeRegExprSet", "regexpr", "makeEqual", "domain1", "domain2", "getIntAttributeSubset", "", "makeLess", "equ", "makeGreater", "makeRelation", "tuples", "", "([Lcom/intellij/rml/dfa/impl/domains/Domain;Ljava/util/Collection;)Lcom/intellij/rml/dfa/impl/relations/IRelation;", "createRelation", "Lcom/intellij/rml/dfa/impl/relations/plain/PlainRelation;", "([Lcom/intellij/rml/dfa/impl/domains/DomainType;)Lcom/intellij/rml/dfa/impl/relations/plain/PlainRelation;", "full", "([Lcom/intellij/rml/dfa/impl/domains/Domain;Z)Lcom/intellij/rml/dfa/impl/relations/plain/PlainRelation;", "root", "Lcom/intellij/rml/dfa/impl/bdd/BddNode;", "createRelation-44iABIQ", "(I[Lcom/intellij/rml/dfa/impl/domains/Domain;)Lcom/intellij/rml/dfa/impl/relations/plain/PlainRelation;", "toString", "intellij.rml.dfa.impl"})
@SourceDebugExtension(value={"SMAP\nPlainRelationsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlainRelationsManager.kt\ncom/intellij/rml/dfa/impl/relations/plain/PlainRelationsManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,187:1\n1#2:188\n774#3:189\n865#3,2:190\n1563#3:192\n1634#3,3:193\n*S KotlinDebug\n*F\n+ 1 PlainRelationsManager.kt\ncom/intellij/rml/dfa/impl/relations/plain/PlainRelationsManager\n*L\n129#1:189\n129#1:190,2\n168#1:192\n168#1:193,3\n*E\n"})
public final class PlainRelationsManager
implements IRelationsManager {
    @NotNull
    private final BddManager bddManager;
    @NotNull
    private final SymbolTable symbolTable;

    public PlainRelationsManager(@NotNull BddManager bddManager, @NotNull SymbolTable symbolTable) {
        Intrinsics.checkNotNullParameter((Object)bddManager, (String)"bddManager");
        Intrinsics.checkNotNullParameter((Object)symbolTable, (String)"symbolTable");
        this.bddManager = bddManager;
        this.symbolTable = symbolTable;
    }

    @NotNull
    public final SymbolTable getSymbolTable$intellij_rml_dfa_impl() {
        return this.symbolTable;
    }

    @Override
    @NotNull
    public BddManager getBDDManager() {
        return this.bddManager;
    }

    public final int getBitLength(@NotNull Domain domain) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        DomainType domainType = domain.getType();
        Intrinsics.checkNotNullExpressionValue((Object)domainType, (String)"getType(...)");
        return this.symbolTable.getAttributesInfo(domainType).getBitLength();
    }

    @Override
    @NotNull
    public IRelation makeRepositoryRelation(@NotNull IRelation relation, @NotNull String relname) {
        Intrinsics.checkNotNullParameter((Object)relation, (String)"relation");
        Intrinsics.checkNotNullParameter((Object)relname, (String)"relname");
        return relation;
    }

    @Override
    @NotNull
    public IRelation makeSubIncrementalRelation(@NotNull IRelation base, @NotNull IRelation add, @NotNull IRelation sub, @NotNull Cancellation cancellation) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Intrinsics.checkNotNullParameter((Object)add, (String)"add");
        Intrinsics.checkNotNullParameter((Object)sub, (String)"sub");
        Intrinsics.checkNotNullParameter((Object)cancellation, (String)"cancellation");
        IRelation iRelation = base.subtract(sub, cancellation).unsafeUnite(add, cancellation);
        Intrinsics.checkNotNullExpressionValue((Object)iRelation, (String)"unsafeUnite(...)");
        return iRelation;
    }

    @Override
    @NotNull
    public IRelation makeEmptyRelation(@NotNull Domain[] domains) {
        Intrinsics.checkNotNullParameter((Object)domains, (String)"domains");
        return PlainRelationsManager.createRelation$default(this, domains, false, 2, null);
    }

    @Override
    @NotNull
    public IRelation makeEmptyRelation(@NotNull DomainType[] types) {
        Intrinsics.checkNotNullParameter((Object)types, (String)"types");
        return this.createRelation(types);
    }

    @Override
    @NotNull
    public IRelation makeEmptyRelation(@NotNull Domain[] domains, boolean isFull) {
        Intrinsics.checkNotNullParameter((Object)domains, (String)"domains");
        return this.createRelation(domains, isFull);
    }

    @Override
    @NotNull
    public IRelation makeSingleTuple(@NotNull Domain domain, int value) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Domain[] domainArray = new Domain[]{domain};
        return this.createRelation-44iABIQ(BddNode.Companion.makeSingleTuple-eQ8CBRE(this.bddManager, domain.getFirstVar(), this.getBitLength(domain), value), domainArray);
    }

    @Override
    @NotNull
    public IRelation makeSingleTuple(@NotNull Domain[] domains, @NotNull int[] values) {
        Intrinsics.checkNotNullParameter((Object)domains, (String)"domains");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        int[] perm = SortedArrayHelper.getAscendingPermutation(domains);
        int[] firstVars = new int[domains.length];
        int[] lengths = new int[domains.length];
        SortedArrayHelper.applyPerm(values, perm);
        int n = domains.length;
        for (int i = 0; i < n; ++i) {
            firstVars[i] = domains[perm[i]].getFirstVar();
            lengths[i] = this.getBitLength(domains[perm[i]]);
        }
        return this.createRelation-44iABIQ(BddNode.Companion.makeSingleTuple-eQ8CBRE(this.bddManager, firstVars, lengths, values), domains);
    }

    @Override
    @NotNull
    public IRelation makeSingleTuple(@NotNull DomainType type, int value) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Domain domain = type.getDomain(0);
        int n = domain.getFirstVar();
        Intrinsics.checkNotNull((Object)domain);
        Domain[] domainArray = new Domain[]{domain};
        return this.createRelation-44iABIQ(BddNode.Companion.makeSingleTuple-eQ8CBRE(this.bddManager, n, this.getBitLength(domain), value), domainArray);
    }

    @Override
    @NotNull
    public IRelation makeBinaryExpansion(@NotNull Domain maskDomain, @NotNull Domain bitDomain, @NotNull Cancellation cancellation) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)maskDomain, (String)"maskDomain");
        Intrinsics.checkNotNullParameter((Object)bitDomain, (String)"bitDomain");
        Intrinsics.checkNotNullParameter((Object)cancellation, (String)"cancellation");
        int node = BddNode.Companion.getZero-CmkRj6U();
        boolean bl2 = bl = bitDomain.getFirstVar() < maskDomain.getFirstVar();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-PlainRelationsManager$makeBinaryExpansion$22 = false;
            String $i$a$-assert-PlainRelationsManager$makeBinaryExpansion$22 = "Bits domain must be before the mask domain";
            throw new AssertionError((Object)$i$a$-assert-PlainRelationsManager$makeBinaryExpansion$22);
        }
        DomainType domainType = maskDomain.getType();
        Intrinsics.checkNotNullExpressionValue((Object)domainType, (String)"getType(...)");
        int size2 = this.symbolTable.getAttributesInfo(domainType).getBitLength();
        for (int i = 0; i < size2; ++i) {
            int bitNode = BddNode.Companion.makeSingleTuple-eQ8CBRE(this.bddManager, bitDomain.getFirstVar(), this.getBitLength(bitDomain), i);
            int maskNode = BddNode.Companion.makeSingleTuple-eQ8CBRE(this.bddManager, maskDomain.getFirstVar() + i, 1, 1);
            int tuple = BddNode.intersect-EV6QKKk(bitNode, this.bddManager, maskNode, cancellation);
            node = BddNode.unite-EV6QKKk(node, this.bddManager, tuple, cancellation);
        }
        Domain[] domainArray = new Domain[]{maskDomain, bitDomain};
        return this.createRelation-44iABIQ(node, domainArray);
    }

    @Override
    @NotNull
    public IRelation makeRegExprSet(@NotNull Domain domain, @NotNull String regexpr, @NotNull Cancellation cancellation) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)regexpr, (String)"regexpr");
        Intrinsics.checkNotNullParameter((Object)cancellation, (String)"cancellation");
        SymbolTable symTable = this.symbolTable;
        DomainType type = domain.getType();
        Pattern pattern = Pattern.compile(regexpr);
        int node = BddNode.Companion.getZero-CmkRj6U();
        Intrinsics.checkNotNull((Object)type);
        int numOfAttrs = this.symbolTable.getAttributesInfo(type).getNumOfAttributes();
        for (int i = 0; i < numOfAttrs; ++i) {
            Matcher matcher = pattern.matcher(symTable.getAttribute(type, i).getKey());
            if (!matcher.matches()) continue;
            int tuple = BddNode.Companion.makeSingleTuple-eQ8CBRE(this.bddManager, domain.getFirstVar(), this.getBitLength(domain), i);
            node = BddNode.unite-EV6QKKk(node, this.bddManager, tuple, cancellation);
        }
        Domain[] domainArray = new Domain[]{domain};
        return this.createRelation-44iABIQ(node, domainArray);
    }

    @Override
    @NotNull
    public IRelation makeEqual(@NotNull Domain domain1, @NotNull Domain domain2, @NotNull Cancellation cancellation) {
        int unlimitedFlag;
        Intrinsics.checkNotNullParameter((Object)domain1, (String)"domain1");
        Intrinsics.checkNotNullParameter((Object)domain2, (String)"domain2");
        Intrinsics.checkNotNullParameter((Object)cancellation, (String)"cancellation");
        if (!Intrinsics.areEqual((Object)domain1.getType(), (Object)domain2.getType())) {
            String string = this.bddManager.toString();
            String string2 = Messages.getString(PlainRelationsManager.class.getName() + "-0");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
            throw new DfaInternalException(string, string2);
        }
        int node = BddNode.Companion.getZero-CmkRj6U();
        DomainType type = domain1.getType();
        Intrinsics.checkNotNull((Object)type);
        int numOfAttrs = this.symbolTable.getAttributesInfo(type).getNumOfAttributes();
        int domainLength = this.getBitLength(domain1);
        Object[] objectArray = new Integer[]{domain1.getFirstVar(), domain2.getFirstVar()};
        int[] starts = CollectionsKt.toIntArray((Collection)CollectionsKt.sorted((Iterable)CollectionsKt.listOf((Object[])objectArray)));
        int[] nArray = new int[]{domainLength, domainLength};
        int[] lengths = nArray;
        int[] nArray2 = new int[]{-1, -1};
        int[] values = nArray2;
        int i = 0;
        while (i < numOfAttrs) {
            values[0] = i;
            values[1] = i++;
            node = BddNode.addTuple-eQ8CBRE(node, this.bddManager, starts, lengths, values);
        }
        values[0] = unlimitedFlag = (1 << domainLength) - 1;
        values[1] = unlimitedFlag;
        node = BddNode.addTuple-eQ8CBRE(node, this.bddManager, starts, lengths, values);
        Domain[] domainArray = new Domain[]{domain1, domain2};
        return this.createRelation-44iABIQ(node, domainArray);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Integer> getIntAttributeSubset(SymbolTable symbolTable, DomainType type) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = (Iterable)RangesKt.until((int)0, (int)symbolTable.getAttributesInfo(type).getNumOfAttributes());
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            int it = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            if (!(symbolTable.getAttribute(type, it) instanceof IntAttribute)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public IRelation makeLess(@NotNull Domain domain1, @NotNull Domain domain2, boolean equ, @NotNull Cancellation cancellation) {
        Intrinsics.checkNotNullParameter((Object)domain1, (String)"domain1");
        Intrinsics.checkNotNullParameter((Object)domain2, (String)"domain2");
        Intrinsics.checkNotNullParameter((Object)cancellation, (String)"cancellation");
        if (!Intrinsics.areEqual((Object)domain1.getType(), (Object)domain2.getType())) {
            String string = this.bddManager.toString();
            String string2 = Messages.getString(PlainRelationsManager.class.getName() + "-0");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
            throw new DfaInternalException(string, string2);
        }
        int node = BddNode.Companion.getZero-CmkRj6U();
        DomainType type = domain1.getType();
        Intrinsics.checkNotNull((Object)type);
        List<Integer> intSubset = this.getIntAttributeSubset(this.symbolTable, type);
        Iterator<Integer> iterator = intSubset.iterator();
        while (iterator.hasNext()) {
            int i = ((Number)iterator.next()).intValue();
            int pair = BddNode.Companion.makeLess-cO8FTMI(this.bddManager, domain1.getFirstVar(), this.getBitLength(domain1), i, equ);
            int tuple = BddNode.Companion.makeSingleTuple-eQ8CBRE(this.bddManager, domain2.getFirstVar(), this.getBitLength(domain2), i);
            pair = BddNode.intersect-EV6QKKk(pair, this.bddManager, tuple, cancellation);
            node = BddNode.unite-EV6QKKk(node, this.bddManager, pair, cancellation);
        }
        Domain[] domainArray = new Domain[]{domain1, domain2};
        PlainRelation less = this.createRelation-44iABIQ(node, domainArray);
        IRelation iRelation = less.unsafeIntersect(this.makeRelation(domain1, (Collection<Integer>)intSubset), cancellation).unsafeIntersect(this.makeRelation(domain2, (Collection<Integer>)intSubset), cancellation);
        Intrinsics.checkNotNullExpressionValue((Object)iRelation, (String)"unsafeIntersect(...)");
        return iRelation;
    }

    @Override
    @NotNull
    public IRelation makeGreater(@NotNull Domain domain1, @NotNull Domain domain2, boolean equ, @NotNull Cancellation cancellation) {
        Intrinsics.checkNotNullParameter((Object)domain1, (String)"domain1");
        Intrinsics.checkNotNullParameter((Object)domain2, (String)"domain2");
        Intrinsics.checkNotNullParameter((Object)cancellation, (String)"cancellation");
        IRelation greater = this.makeLess(domain1, domain2, !equ, cancellation).complement(cancellation);
        DomainType domainType = domain1.getType();
        Intrinsics.checkNotNullExpressionValue((Object)domainType, (String)"getType(...)");
        List<Integer> intSubset = this.getIntAttributeSubset(this.symbolTable, domainType);
        IRelation iRelation = greater.unsafeIntersect(this.makeRelation(domain1, (Collection<Integer>)intSubset), cancellation).unsafeIntersect(this.makeRelation(domain2, (Collection<Integer>)intSubset), cancellation);
        Intrinsics.checkNotNullExpressionValue((Object)iRelation, (String)"unsafeIntersect(...)");
        return iRelation;
    }

    private final IRelation makeRelation(Domain[] domains, Collection<int[]> tuples) {
        IRelation result = PlainRelationsManager.createRelation$default(this, domains, false, 2, null);
        for (int[] tuple : tuples) {
            Intrinsics.checkNotNullExpressionValue((Object)result.addTuple(tuple), (String)"addTuple(...)");
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final IRelation makeRelation(Domain domain, Collection<Integer> tuples) {
        Collection<int[]> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object = new Domain[]{domain};
        Domain[] domainArray = object;
        object = tuples;
        Domain[] domainArray2 = domainArray;
        PlainRelationsManager plainRelationsManager = this;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            int n = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            boolean bl = false;
            int[] nArray = new int[]{it};
            collection.add(nArray);
        }
        collection = (List)destination$iv$iv;
        return plainRelationsManager.makeRelation(domainArray2, collection);
    }

    @Override
    @NotNull
    public IRelation makeLess(@NotNull Domain domain, int value, boolean equ, @NotNull Cancellation cancellation) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)cancellation, (String)"cancellation");
        Domain[] domainArray = new Domain[]{domain};
        return this.createRelation-44iABIQ(BddNode.Companion.makeLess-cO8FTMI(this.bddManager, domain.getFirstVar(), this.getBitLength(domain), value, equ), domainArray);
    }

    @Override
    @NotNull
    public IRelation makeGreater(@NotNull Domain domain, int value, boolean equ, @NotNull Cancellation cancellation) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)cancellation, (String)"cancellation");
        Domain[] domainArray = new Domain[]{domain};
        return this.createRelation-44iABIQ(BddNode.complement-tT6QPSE(BddNode.Companion.makeLess-cO8FTMI(this.bddManager, domain.getFirstVar(), this.getBitLength(domain), value, !equ), this.bddManager, cancellation), domainArray);
    }

    private final PlainRelation createRelation(DomainType[] types) {
        return new PlainRelation(this, types);
    }

    private final PlainRelation createRelation(Domain[] domains, boolean full) {
        return new PlainRelation(this, domains, full);
    }

    static /* synthetic */ PlainRelation createRelation$default(PlainRelationsManager plainRelationsManager, Domain[] domainArray, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return plainRelationsManager.createRelation(domainArray, bl);
    }

    private final PlainRelation createRelation-44iABIQ(int root, Domain[] domains) {
        return new PlainRelation(this, root, domains, null);
    }

    @NotNull
    public String toString() {
        return this.symbolTable.toString();
    }
}

