/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.results;

import com.google.gct.testing.CloudTestingUtils;
import com.google.gct.testing.results.GoogleCloudTestEventsProcessor;
import com.google.gct.testing.results.GoogleCloudTestingProcessOutputConsumer;
import com.google.gct.testing.results.events.GoogleCloudTestFailedEvent;
import com.google.gct.testing.results.events.GoogleCloudTestFinishedEvent;
import com.google.gct.testing.results.events.GoogleCloudTestIgnoredEvent;
import com.google.gct.testing.results.events.GoogleCloudTestOutputEvent;
import com.google.gct.testing.results.events.GoogleCloudTestStartedEvent;
import com.google.gct.testing.results.events.SetActiveCloudMatrixEvent;
import com.google.gct.testing.results.events.SetTestRunIdEvent;
import com.google.gct.testing.results.events.TestConfigurationFinishedEvent;
import com.google.gct.testing.results.events.TestConfigurationProgressEvent;
import com.google.gct.testing.results.events.TestConfigurationScheduledEvent;
import com.google.gct.testing.results.events.TestConfigurationStartedEvent;
import com.google.gct.testing.results.events.TestConfigurationStoppedEvent;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.sm.runner.GeneralToSMTRunnerEventsConvertor;
import com.intellij.execution.testframework.sm.runner.OutputEventSplitter;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteStartedEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import java.text.ParseException;
import java.util.Map;
import jetbrains.buildServer.messages.serviceMessages.BaseTestMessage;
import jetbrains.buildServer.messages.serviceMessages.BuildNumber;
import jetbrains.buildServer.messages.serviceMessages.BuildStatisticValue;
import jetbrains.buildServer.messages.serviceMessages.BuildStatus;
import jetbrains.buildServer.messages.serviceMessages.DefaultServiceMessageVisitor;
import jetbrains.buildServer.messages.serviceMessages.Message;
import jetbrains.buildServer.messages.serviceMessages.ProgressFinish;
import jetbrains.buildServer.messages.serviceMessages.ProgressMessage;
import jetbrains.buildServer.messages.serviceMessages.ProgressStart;
import jetbrains.buildServer.messages.serviceMessages.PublishArtifacts;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessage;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessageVisitor;
import jetbrains.buildServer.messages.serviceMessages.TestFailed;
import jetbrains.buildServer.messages.serviceMessages.TestFinished;
import jetbrains.buildServer.messages.serviceMessages.TestIgnored;
import jetbrains.buildServer.messages.serviceMessages.TestStarted;
import jetbrains.buildServer.messages.serviceMessages.TestStdErr;
import jetbrains.buildServer.messages.serviceMessages.TestStdOut;
import jetbrains.buildServer.messages.serviceMessages.TestSuiteFinished;
import jetbrains.buildServer.messages.serviceMessages.TestSuiteStarted;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OutputToGoogleCloudTestEventsConverter
implements GoogleCloudTestingProcessOutputConsumer {
    private static final Logger LOG = Logger.getInstance((String)OutputToGoogleCloudTestEventsConverter.class.getName());
    private GoogleCloudTestEventsProcessor myProcessor;
    private final MyServiceMessageVisitor myServiceMessageVisitor;
    private final String myTestFrameworkName;
    private final OutputEventSplitter mySplitter;
    private boolean myPendingLineBreakFlag;

    public OutputToGoogleCloudTestEventsConverter(@NotNull String testFrameworkName) {
        this.myTestFrameworkName = testFrameworkName;
        this.myServiceMessageVisitor = new MyServiceMessageVisitor();
        this.mySplitter = new OutputEventSplitter(true, true){

            public void onTextAvailable(@NotNull String text, @NotNull Key<?> outputType) {
                OutputToGoogleCloudTestEventsConverter.this.processConsistentText(text, outputType);
            }
        };
    }

    @Override
    public void setProcessor(@Nullable GoogleCloudTestEventsProcessor processor) {
        this.myProcessor = processor;
    }

    public void dispose() {
        this.setProcessor(null);
    }

    @Override
    public void process(String text, Key outputType) {
        this.mySplitter.process(text, outputType);
    }

    @Override
    public void flushBufferBeforeTerminating() {
        this.mySplitter.flush();
        if (this.myPendingLineBreakFlag) {
            this.fireOnUncapturedLineBreak();
        }
    }

    private void fireOnUncapturedLineBreak() {
        this.fireOnUncapturedOutput("\n", ProcessOutputTypes.STDOUT);
    }

    private void processConsistentText(String text, Key outputType) {
        try {
            if (!this.processServiceMessages(text, outputType, (ServiceMessageVisitor)this.myServiceMessageVisitor)) {
                if (this.myPendingLineBreakFlag) {
                    this.fireOnUncapturedLineBreak();
                    this.myPendingLineBreakFlag = false;
                }
                String outputToProcess = text;
                if (text.endsWith("\n")) {
                    this.myPendingLineBreakFlag = true;
                    outputToProcess = outputToProcess.substring(0, outputToProcess.length() - 1);
                }
                this.fireOnUncapturedOutput(outputToProcess, outputType);
            } else {
                this.myPendingLineBreakFlag = false;
            }
        }
        catch (ParseException e) {
            LOG.error(GeneralToSMTRunnerEventsConvertor.getTFrameworkPrefix((String)this.myTestFrameworkName) + "Error parsing text: [" + text + "]", (Throwable)e);
        }
    }

    protected boolean processServiceMessages(String text, Key outputType, ServiceMessageVisitor visitor) throws ParseException {
        ServiceMessage message = ServiceMessage.parse((String)text.trim());
        if (message != null) {
            message.visit(visitor);
        }
        return message != null;
    }

    private void fireOnTestStarted(@NotNull GoogleCloudTestStartedEvent testStartedEvent) {
        GoogleCloudTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onTestStarted(testStartedEvent);
        }
    }

    private void fireOnTestFailure(@NotNull GoogleCloudTestFailedEvent testFailedEvent) {
        this.assertNotNull(testFailedEvent.getLocalizedFailureMessage());
        GoogleCloudTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onTestFailure(testFailedEvent);
        }
    }

    private void fireOnTestIgnored(@NotNull GoogleCloudTestIgnoredEvent testIgnoredEvent) {
        GoogleCloudTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onTestIgnored(testIgnoredEvent);
        }
    }

    private void fireOnTestFinished(@NotNull GoogleCloudTestFinishedEvent testFinishedEvent) {
        GoogleCloudTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onTestFinished(testFinishedEvent);
        }
    }

    private void fireOnCustomProgressTestsCategory(String categoryName, int testsCount) {
        this.assertNotNull(categoryName);
        GoogleCloudTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            boolean disableCustomMode = StringUtil.isEmpty((String)categoryName);
            processor.onCustomProgressTestsCategory(disableCustomMode ? null : categoryName, disableCustomMode ? 0 : testsCount);
        }
    }

    private void fireOnCustomProgressTestStarted() {
        GoogleCloudTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onCustomProgressTestStarted();
        }
    }

    private void fireOnCustomProgressTestFailed() {
        GoogleCloudTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onCustomProgressTestFailed();
        }
    }

    private void fireOnTestFrameworkAttached() {
        GoogleCloudTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onTestsReporterAttached();
        }
    }

    private void fireOnTestOutput(@NotNull GoogleCloudTestOutputEvent testOutputEvent) {
        GoogleCloudTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onTestOutput(testOutputEvent);
        }
    }

    private void fireOnUncapturedOutput(String text, Key outputType) {
        this.assertNotNull(text);
        if (StringUtil.isEmpty((String)text)) {
            return;
        }
        GoogleCloudTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onUncapturedOutput(text, outputType);
        }
    }

    private void fireOnTestsCountInSuite(int count) {
        GoogleCloudTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onTestsCountInSuite(count);
        }
    }

    private void fireOnSuiteStarted(@NotNull TestSuiteStartedEvent suiteStartedEvent) {
        GoogleCloudTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onSuiteStarted(suiteStartedEvent);
        }
    }

    private void fireOnSetTestRunId(@NotNull SetTestRunIdEvent setTestRunIdEvent) {
        GoogleCloudTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onSetTestRunId(setTestRunIdEvent);
        }
    }

    private void fireOnSetActiveCloudMatrix(@NotNull SetActiveCloudMatrixEvent setActiveCloudMatrixEvent) {
        GoogleCloudTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onSetActiveCloudMatrix(setActiveCloudMatrixEvent);
        }
    }

    private void fireOnConfigurationStopped(@NotNull TestConfigurationStoppedEvent configurationStoppedEvent) {
        GoogleCloudTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onConfigurationStopped(configurationStoppedEvent);
        }
    }

    private void fireOnConfigurationStarted(@NotNull TestConfigurationStartedEvent configurationStartedEvent) {
        GoogleCloudTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onConfigurationStarted(configurationStartedEvent);
        }
    }

    private void fireOnConfigurationProgress(@NotNull TestConfigurationProgressEvent configurationProgressEvent) {
        GoogleCloudTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onConfigurationProgress(configurationProgressEvent);
        }
    }

    private void fireOnConfigurationScheduled(@NotNull TestConfigurationScheduledEvent configurationScheduledEvent) {
        GoogleCloudTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onConfigurationScheduled(configurationScheduledEvent);
        }
    }

    private void fireOnConfigurationFinished(@NotNull TestConfigurationFinishedEvent configurationFinishedEvent) {
        GoogleCloudTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onConfigurationFinished(configurationFinishedEvent);
        }
    }

    private void fireOnSuiteFinished(@NotNull TestSuiteFinishedEvent suiteFinishedEvent) {
        GoogleCloudTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onSuiteFinished(suiteFinishedEvent);
        }
    }

    protected void fireOnErrorMsg(String localizedMessage, @Nullable String stackTrace, boolean isCritical) {
        this.assertNotNull(localizedMessage);
        GoogleCloudTestEventsProcessor processor = this.myProcessor;
        if (processor != null) {
            processor.onError(localizedMessage, stackTrace, isCritical);
        }
    }

    private void assertNotNull(String s) {
        if (s == null) {
            LOG.error(GeneralToSMTRunnerEventsConvertor.getTFrameworkPrefix((String)this.myTestFrameworkName) + " @NotNull value is expected.");
        }
    }

    private class MyServiceMessageVisitor
    extends DefaultServiceMessageVisitor {
        @NonNls
        public static final String KEY_TESTS_COUNT = "testCount";
        @NonNls
        private static final String ATTR_KEY_TEST_ERROR = "error";
        @NonNls
        private static final String ATTR_KEY_TEST_COUNT = "count";
        @NonNls
        private static final String ATTR_KEY_TEST_DURATION = "duration";
        @NonNls
        private static final String ATTR_KEY_LOCATION_URL = "locationHint";
        @NonNls
        private static final String ATTR_KEY_LOCATION_URL_OLD = "location";
        @NonNls
        private static final String ATTR_KEY_STACKTRACE_DETAILS = "details";
        @NonNls
        private static final String ATTR_KEY_DIAGNOSTIC = "diagnosticInfo";
        @NonNls
        private static final String MESSAGE = "message";
        @NonNls
        private static final String TEST_REPORTER_ATTACHED = "enteredTheMatrix";
        @NonNls
        private static final String ATTR_KEY_STATUS = "status";
        @NonNls
        private static final String ATTR_VALUE_STATUS_ERROR = "ERROR";
        @NonNls
        private static final String ATTR_VALUE_STATUS_WARNING = "WARNING";
        @NonNls
        private static final String ATTR_KEY_TEXT = "text";
        @NonNls
        private static final String ATTR_KEY_ERROR_DETAILS = "errorDetails";
        @NonNls
        public static final String CUSTOM_STATUS = "customProgressStatus";
        @NonNls
        private static final String ATTR_KEY_TEST_TYPE = "type";
        @NonNls
        private static final String ATTR_KEY_TESTS_CATEGORY = "testsCategory";
        @NonNls
        private static final String ATTR_VAL_TEST_STARTED = "testStarted";
        @NonNls
        private static final String ATTR_VAL_TEST_FAILED = "testFailed";

        private MyServiceMessageVisitor() {
        }

        public void visitTestSuiteStarted(@NotNull TestSuiteStarted suiteStarted) {
            String locationUrl = this.fetchTestLocation(suiteStarted);
            TestSuiteStartedEvent suiteStartedEvent = new TestSuiteStartedEvent(suiteStarted, locationUrl);
            OutputToGoogleCloudTestEventsConverter.this.fireOnSuiteStarted(suiteStartedEvent);
        }

        @Nullable
        private String fetchTestLocation(TestSuiteStarted suiteStarted) {
            Map attrs = suiteStarted.getAttributes();
            String location = (String)attrs.get(ATTR_KEY_LOCATION_URL);
            if (location == null) {
                String oldLocation = (String)attrs.get(ATTR_KEY_LOCATION_URL_OLD);
                if (oldLocation != null) {
                    LOG.error(GeneralToSMTRunnerEventsConvertor.getTFrameworkPrefix((String)OutputToGoogleCloudTestEventsConverter.this.myTestFrameworkName) + "Test Runner API was changed for TeamCity 5.0 compatibility. Please use 'locationHint' attribute instead of 'location'.");
                    return oldLocation;
                }
                return null;
            }
            return location;
        }

        public void visitTestSuiteFinished(@NotNull TestSuiteFinished suiteFinished) {
            TestSuiteFinishedEvent finishedEvent = new TestSuiteFinishedEvent(suiteFinished);
            OutputToGoogleCloudTestEventsConverter.this.fireOnSuiteFinished(finishedEvent);
        }

        public void visitTestStarted(@NotNull TestStarted testStarted) {
            String locationUrl = (String)testStarted.getAttributes().get(ATTR_KEY_LOCATION_URL);
            GoogleCloudTestStartedEvent testStartedEvent = new GoogleCloudTestStartedEvent(testStarted, locationUrl);
            OutputToGoogleCloudTestEventsConverter.this.fireOnTestStarted(testStartedEvent);
        }

        public void visitTestFinished(@NotNull TestFinished testFinished) {
            String durationStr = (String)testFinished.getAttributes().get(ATTR_KEY_TEST_DURATION);
            long duration = 0L;
            if (!StringUtil.isEmptyOrSpaces((String)durationStr)) {
                duration = this.convertToLong(durationStr, (ServiceMessage)testFinished);
            }
            GoogleCloudTestFinishedEvent testFinishedEvent = new GoogleCloudTestFinishedEvent(testFinished, duration);
            OutputToGoogleCloudTestEventsConverter.this.fireOnTestFinished(testFinishedEvent);
        }

        public void visitTestIgnored(@NotNull TestIgnored testIgnored) {
            String stacktrace = (String)testIgnored.getAttributes().get(ATTR_KEY_STACKTRACE_DETAILS);
            OutputToGoogleCloudTestEventsConverter.this.fireOnTestIgnored(new GoogleCloudTestIgnoredEvent(testIgnored, stacktrace));
        }

        public void visitTestStdOut(@NotNull TestStdOut testStdOut) {
            OutputToGoogleCloudTestEventsConverter.this.fireOnTestOutput(new GoogleCloudTestOutputEvent((BaseTestMessage)testStdOut, testStdOut.getStdOut(), ProcessOutputTypes.STDOUT, (String)testStdOut.getAttributes().get("configuration"), (String)testStdOut.getAttributes().get("className")));
        }

        public void visitTestStdErr(@NotNull TestStdErr testStdErr) {
            OutputToGoogleCloudTestEventsConverter.this.fireOnTestOutput(new GoogleCloudTestOutputEvent((BaseTestMessage)testStdErr, testStdErr.getStdErr(), ProcessOutputTypes.STDERR, (String)testStdErr.getAttributes().get("configuration"), (String)testStdErr.getAttributes().get("className")));
        }

        public void visitTestFailed(@NotNull TestFailed testFailed) {
            boolean testError = testFailed.getAttributes().get(ATTR_KEY_TEST_ERROR) != null;
            GoogleCloudTestFailedEvent testFailedEvent = new GoogleCloudTestFailedEvent(testFailed, testError);
            OutputToGoogleCloudTestEventsConverter.this.fireOnTestFailure(testFailedEvent);
        }

        public void visitPublishArtifacts(@NotNull PublishArtifacts publishArtifacts) {
        }

        public void visitProgressMessage(@NotNull ProgressMessage progressMessage) {
        }

        public void visitProgressStart(@NotNull ProgressStart progressStart) {
        }

        public void visitProgressFinish(@NotNull ProgressFinish progressFinish) {
        }

        public void visitBuildStatus(@NotNull BuildStatus buildStatus) {
        }

        public void visitBuildNumber(@NotNull BuildNumber buildNumber) {
        }

        public void visitBuildStatisticValue(@NotNull BuildStatisticValue buildStatsValue) {
        }

        public void visitMessageWithStatus(@NotNull Message msg) {
            Map msgAttrs = msg.getAttributes();
            String text = (String)msgAttrs.get(ATTR_KEY_TEXT);
            if (!StringUtil.isEmpty((String)text)) {
                String status = (String)msgAttrs.get(ATTR_KEY_STATUS);
                if (status.equals(ATTR_VALUE_STATUS_ERROR)) {
                    String stackTrace = (String)msgAttrs.get(ATTR_KEY_ERROR_DETAILS);
                    OutputToGoogleCloudTestEventsConverter.this.fireOnErrorMsg(text, stackTrace, true);
                } else if (status.equals(ATTR_VALUE_STATUS_WARNING)) {
                    String stackTrace = (String)msgAttrs.get(ATTR_KEY_ERROR_DETAILS);
                    OutputToGoogleCloudTestEventsConverter.this.fireOnErrorMsg(text, stackTrace, false);
                } else {
                    OutputToGoogleCloudTestEventsConverter.this.fireOnUncapturedOutput(text, ProcessOutputTypes.STDOUT);
                }
            }
        }

        public void visitServiceMessage(@NotNull ServiceMessage msg) {
            String name = msg.getMessageName();
            if (KEY_TESTS_COUNT.equals(name)) {
                this.processTestCountInSuite(msg);
            } else if (CUSTOM_STATUS.equals(name)) {
                this.processCustomStatus(msg);
            } else if (MESSAGE.equals(name)) {
                Map msgAttrs = msg.getAttributes();
                String text = (String)msgAttrs.get(ATTR_KEY_TEXT);
                if (!StringUtil.isEmpty((String)text)) {
                    OutputToGoogleCloudTestEventsConverter.this.fireOnUncapturedOutput(text, ProcessOutputTypes.STDOUT);
                }
            } else if (TEST_REPORTER_ATTACHED.equals(name)) {
                OutputToGoogleCloudTestEventsConverter.this.fireOnTestFrameworkAttached();
            } else {
                this.handleCustomMessages(msg);
            }
        }

        private void handleCustomMessages(@NotNull ServiceMessage message) {
            String messageName = message.getMessageName();
            if (messageName.equals("setTestRunId")) {
                SetTestRunIdEvent setTestRunIdEvent = new SetTestRunIdEvent((String)message.getAttributes().get("testRunId"));
                OutputToGoogleCloudTestEventsConverter.this.fireOnSetTestRunId(setTestRunIdEvent);
            } else if (messageName.equals("setActiveCloudMatrix")) {
                OutputToGoogleCloudTestEventsConverter.this.fireOnSetActiveCloudMatrix(new SetActiveCloudMatrixEvent());
            } else {
                String configurationName = (String)message.getAttributes().get("name");
                if (messageName.equals("testConfigurationStopped")) {
                    CloudTestingUtils.ConfigurationStopReason stopReason = CloudTestingUtils.ConfigurationStopReason.valueOf((String)message.getAttributes().get("stopReason"));
                    long testDuration = Long.valueOf((String)message.getAttributes().get("testDuration"));
                    TestConfigurationStoppedEvent configurationStoppedEvent = new TestConfigurationStoppedEvent(configurationName, stopReason, testDuration);
                    OutputToGoogleCloudTestEventsConverter.this.fireOnConfigurationStopped(configurationStoppedEvent);
                } else if (messageName.equals("testConfigurationProgress")) {
                    TestConfigurationProgressEvent configurationProgressEvent = new TestConfigurationProgressEvent(configurationName, (String)message.getAttributes().get(ATTR_KEY_TEXT));
                    OutputToGoogleCloudTestEventsConverter.this.fireOnConfigurationProgress(configurationProgressEvent);
                } else if (messageName.equals("testConfigurationScheduled")) {
                    TestConfigurationScheduledEvent configurationScheduledEvent = new TestConfigurationScheduledEvent(configurationName);
                    OutputToGoogleCloudTestEventsConverter.this.fireOnConfigurationScheduled(configurationScheduledEvent);
                } else if (messageName.equals("testConfigurationStarted")) {
                    TestConfigurationStartedEvent configurationStartedEvent = new TestConfigurationStartedEvent(configurationName);
                    OutputToGoogleCloudTestEventsConverter.this.fireOnConfigurationStarted(configurationStartedEvent);
                } else if (messageName.equals("testConfigurationFinished")) {
                    TestConfigurationFinishedEvent configurationFinishedEvent = new TestConfigurationFinishedEvent(configurationName);
                    OutputToGoogleCloudTestEventsConverter.this.fireOnConfigurationFinished(configurationFinishedEvent);
                } else {
                    GeneralToSMTRunnerEventsConvertor.logProblem((Logger)LOG, (String)("Unexpected service message:" + messageName), (String)OutputToGoogleCloudTestEventsConverter.this.myTestFrameworkName);
                }
            }
        }

        private void processTestCountInSuite(ServiceMessage msg) {
            String countStr = (String)msg.getAttributes().get(ATTR_KEY_TEST_COUNT);
            OutputToGoogleCloudTestEventsConverter.this.fireOnTestsCountInSuite(this.convertToInt(countStr, msg));
        }

        private int convertToInt(String countStr, ServiceMessage msg) {
            int count = 0;
            try {
                count = Integer.parseInt(countStr);
            }
            catch (NumberFormatException ex) {
                String diagnosticInfo = (String)msg.getAttributes().get(ATTR_KEY_DIAGNOSTIC);
                LOG.error(GeneralToSMTRunnerEventsConvertor.getTFrameworkPrefix((String)OutputToGoogleCloudTestEventsConverter.this.myTestFrameworkName) + "Parse integer error." + (String)(diagnosticInfo == null ? "" : " " + diagnosticInfo), (Throwable)ex);
            }
            return count;
        }

        private long convertToLong(String countStr, @NotNull ServiceMessage msg) {
            long count = 0L;
            try {
                count = Long.parseLong(countStr);
            }
            catch (NumberFormatException ex) {
                String diagnosticInfo = (String)msg.getAttributes().get(ATTR_KEY_DIAGNOSTIC);
                LOG.error(GeneralToSMTRunnerEventsConvertor.getTFrameworkPrefix((String)OutputToGoogleCloudTestEventsConverter.this.myTestFrameworkName) + "Parse long error." + (String)(diagnosticInfo == null ? "" : " " + diagnosticInfo), (Throwable)ex);
            }
            return count;
        }

        private void processCustomStatus(ServiceMessage msg) {
            Map attrs = msg.getAttributes();
            String msgType = (String)attrs.get(ATTR_KEY_TEST_TYPE);
            if (msgType != null) {
                if (msgType.equals(ATTR_VAL_TEST_STARTED)) {
                    OutputToGoogleCloudTestEventsConverter.this.fireOnCustomProgressTestStarted();
                } else if (msgType.equals(ATTR_VAL_TEST_FAILED)) {
                    OutputToGoogleCloudTestEventsConverter.this.fireOnCustomProgressTestFailed();
                }
                return;
            }
            String testsCategory = (String)attrs.get(ATTR_KEY_TESTS_CATEGORY);
            if (testsCategory != null) {
                String countStr = (String)msg.getAttributes().get(ATTR_KEY_TEST_COUNT);
                OutputToGoogleCloudTestEventsConverter.this.fireOnCustomProgressTestsCategory(testsCategory, this.convertToInt(countStr, msg));
                return;
            }
        }
    }
}

