/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.results;

import com.google.gct.testing.CloudTestingUtils;
import com.google.gct.testing.results.GoogleCloudTestEventsListener;
import com.google.gct.testing.results.GoogleCloudTestProxy;
import com.google.gct.testing.results.GoogleCloudTestResultsViewer;
import com.google.gct.testing.results.GoogleCloudTestRunnerToolbarPanel;
import com.google.gct.testing.results.GoogleCloudTestTreeBuilder;
import com.google.gct.testing.results.GoogleCloudTestTreeStructure;
import com.google.gct.testing.results.GoogleCloudTestTreeView;
import com.google.gct.testing.results.GoogleCloudTestingPropagateSelectionHandler;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Filter;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.TestTreeView;
import com.intellij.execution.testframework.TestsUIUtil;
import com.intellij.execution.testframework.ToolbarPanel;
import com.intellij.execution.testframework.sm.runner.ui.TestsPresentationUtil;
import com.intellij.execution.testframework.ui.TestResultsPanel;
import com.intellij.history.LocalHistory;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.IndexComparator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.util.ColorProgressBar;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoogleCloudTestingResultsForm
extends TestResultsPanel
implements TestFrameworkRunningModel,
GoogleCloudTestResultsViewer,
GoogleCloudTestEventsListener {
    @NonNls
    private static final String DEFAULT_SM_RUNNER_SPLITTER_PROPERTY = "SMTestRunner.Splitter.Proportion";
    public static final Color DARK_YELLOW = JBColor.YELLOW.darker();
    private GoogleCloudTestTreeView myTreeView;
    private final GoogleCloudTestProxy.GoogleCloudRootTestProxy myTestsRootNode;
    private GoogleCloudTestTreeBuilder myTreeBuilder;
    private final TestConsoleProperties myConsoleProperties;
    private final List<GoogleCloudTestResultsViewer.EventsListener> myEventListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private GoogleCloudTestingPropagateSelectionHandler myShowStatisticForProxyHandler;
    private final Project myProject;
    private int myTotalTestCount = 0;
    private int myStartedTestCount = 0;
    private int myFinishedTestCount = 0;
    private int myFailedTestCount = 0;
    private int myIgnoredTestCount = 0;
    private long myStartTime;
    private long myEndTime;
    private String myCurrentCustomProgressCategory;
    private final Set<String> myMentionedCategories = new LinkedHashSet<String>();
    private boolean myTestsRunning = true;
    private static final Color RED = new JBColor(new Color(250, 220, 220), new Color(104, 67, 67));
    private static final Color GREEN = new JBColor(new Color(220, 250, 220), new Color(44, 66, 60));

    public GoogleCloudTestingResultsForm(RunProfile runProfile, @NotNull JComponent console, AnAction[] consoleActions, TestConsoleProperties consoleProperties, String splitterPropertyName) {
        super(console, consoleActions, consoleProperties, splitterPropertyName != null ? splitterPropertyName : DEFAULT_SM_RUNNER_SPLITTER_PROPERTY, 0.5f);
        this.myConsoleProperties = consoleProperties;
        this.myProject = ((RunConfiguration)runProfile).getProject();
        this.myTestsRootNode = new GoogleCloudTestProxy.GoogleCloudRootTestProxy();
    }

    public void initUI() {
        super.initUI();
        KeyStroke shiftEnterKey = KeyStroke.getKeyStroke(10, 1);
        InputMap inputMap = this.myTreeView.getInputMap(1);
        inputMap.put(shiftEnterKey, "show-statistics-for-test-proxy");
        this.myTreeView.getActionMap().put(inputMap.get(shiftEnterKey), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ignored) {
                GoogleCloudTestingResultsForm.this.showStatisticsForSelectedProxy();
            }
        });
    }

    protected ToolbarPanel createToolbarPanel() {
        return new GoogleCloudTestRunnerToolbarPanel(this.myConsoleProperties, this, (JComponent)((Object)this));
    }

    protected JComponent createTestTreeView() {
        this.myTreeView = new GoogleCloudTestTreeView();
        this.myTreeView.setLargeModel(true);
        this.myTreeView.attachToModel(this);
        this.myTreeView.setTestResultsViewer(this);
        GoogleCloudTestTreeStructure structure = new GoogleCloudTestTreeStructure(this.myProject, (Object)this.myTestsRootNode);
        this.myTreeBuilder = new GoogleCloudTestTreeBuilder((JTree)((Object)this.myTreeView), structure);
        StructureTreeModel structureTreeModel = new StructureTreeModel((AbstractTreeStructure)structure, (Comparator)IndexComparator.getInstance(), (Disposable)this.myProject);
        AsyncTreeModel asyncTreeModel = new AsyncTreeModel((TreeModel)structureTreeModel, true, (Disposable)this.myProject);
        this.myTreeView.setModel((TreeModel)asyncTreeModel);
        this.myTreeBuilder.setModel(structureTreeModel);
        this.myTreeBuilder.setTestsComparator(this);
        Disposer.register((Disposable)this, (Disposable)this.myTreeBuilder);
        Disposer.register((Disposable)this, (Disposable)asyncTreeModel);
        return this.myTreeView;
    }

    public void addTestsTreeSelectionListener(TreeSelectionListener listener) {
        this.myTreeView.getSelectionModel().addTreeSelectionListener(listener);
    }

    @Override
    public void onTestingStarted(@NotNull GoogleCloudTestProxy.GoogleCloudRootTestProxy testsRoot, boolean printTestingStartedTime) {
        this.myTreeBuilder.updateFromRoot();
        this.myStatusLine.setStatusColor(ColorProgressBar.GREEN);
        this.selectAndNotify(this.myTestsRootNode);
        this.myStartTime = System.currentTimeMillis();
        if (printTestingStartedTime) {
            this.myTestsRootNode.addSystemOutput("Testing started at " + DateFormatUtil.formatTime((long)this.myStartTime) + " ...\n");
        }
        this.updateStatusLabel(false);
        this.fireOnTestingStarted();
    }

    @Override
    public void onTestingFinished(@NotNull GoogleCloudTestProxy.GoogleCloudRootTestProxy testsRoot) {
        this.myEndTime = System.currentTimeMillis();
        if (this.myTotalTestCount == 0) {
            this.myTotalTestCount = this.myStartedTestCount;
            this.myStatusLine.setFraction(1.0);
        }
        this.updateStatusLabel(true);
        this.updateIconProgress();
        this.myTreeBuilder.updateFromRoot();
        GoogleCloudTestingResultsForm.addLabel(this);
        this.selectAndNotify(this.myTestsRootNode, () -> {
            this.myTestsRunning = false;
        });
        this.fireOnTestingFinished();
    }

    private static void addLabel(TestFrameworkRunningModel model) {
        String name;
        int color;
        AbstractTestProxy root = model.getRoot();
        if (root.isInterrupted()) {
            return;
        }
        TestConsoleProperties consoleProperties = model.getProperties();
        String configName = consoleProperties.getConfiguration().getName();
        if (root.isPassed() || root.isIgnored()) {
            color = GREEN.getRGB();
            name = "Tests Passed " + configName;
        } else {
            color = RED.getRGB();
            name = "Tests Failed " + configName;
        }
        Project project = consoleProperties.getProject();
        if (project.isDisposed()) {
            return;
        }
        LocalHistory.getInstance().putSystemLabel(project, name, color);
    }

    @Override
    public void onTestsCountInSuite(int count) {
        this.updateCountersAndProgressOnTestCount(count, false);
    }

    @Override
    public void onTestStarted(@NotNull GoogleCloudTestProxy testProxy) {
        this.updateOnTestStarted(false);
        this._addTestOrSuite(testProxy);
        this.fireOnTestNodeAdded(testProxy);
    }

    @Override
    public void onTestFailed(@NotNull GoogleCloudTestProxy test) {
        this.updateOnTestFailed(false);
        this.updateIconProgress();
    }

    @Override
    public void onTestIgnored(@NotNull GoogleCloudTestProxy test) {
        this.updateOnTestIgnored();
    }

    @Override
    public void onSuiteStarted(@NotNull GoogleCloudTestProxy newSuite) {
        this._addTestOrSuite(newSuite);
    }

    @Override
    public void onCustomProgressTestsCategory(@Nullable String categoryName, int testCount) {
        this.myCurrentCustomProgressCategory = categoryName;
        this.updateCountersAndProgressOnTestCount(testCount, true);
    }

    @Override
    public void onCustomProgressTestStarted() {
        this.updateOnTestStarted(true);
    }

    @Override
    public void onCustomProgressTestFailed() {
        this.updateOnTestFailed(true);
    }

    @Override
    public void onTestFinished(@NotNull GoogleCloudTestProxy test) {
        this.updateOnTestFinished(false);
        this.updateIconProgress();
    }

    @Override
    public void onSuiteFinished(@NotNull GoogleCloudTestProxy suite) {
    }

    @Override
    public GoogleCloudTestProxy.GoogleCloudRootTestProxy getTestsRootNode() {
        return this.myTestsRootNode;
    }

    public TestConsoleProperties getProperties() {
        return this.myConsoleProperties;
    }

    public void setFilter(Filter filter) {
        GoogleCloudTestTreeStructure treeStructure = this.myTreeBuilder.getGoogleCloudTestTreeStructure();
        treeStructure.setFilter(filter);
        this.myTreeBuilder.updateFromRoot();
    }

    public boolean isRunning() {
        return this.myTestsRunning;
    }

    public TestTreeView getTreeView() {
        return this.myTreeView;
    }

    public GoogleCloudTestTreeBuilder getTreeBuilder() {
        return this.myTreeBuilder;
    }

    public boolean hasTestSuites() {
        return !this.getRoot().getChildren().isEmpty();
    }

    @NotNull
    public AbstractTestProxy getRoot() {
        return this.myTestsRootNode;
    }

    @Override
    public void selectAndNotify(AbstractTestProxy testProxy) {
        this.selectAndNotify(testProxy, null);
    }

    private void selectAndNotify(@Nullable AbstractTestProxy testProxy, @Nullable Runnable onDone) {
        this.selectWithoutNotify(testProxy, onDone);
        this.showStatisticsForSelectedProxy(testProxy, false);
    }

    @Override
    public void addEventsListener(GoogleCloudTestResultsViewer.EventsListener listener) {
        this.myEventListeners.add(listener);
        this.addTestsTreeSelectionListener(e -> {
            @Nullable GoogleCloudTestProxy selectedProxy = (GoogleCloudTestProxy)this.getTreeView().getSelectedTest();
            listener.onSelected(selectedProxy, this, this);
        });
    }

    public void dispose() {
        super.dispose();
        this.myShowStatisticForProxyHandler = null;
        this.myEventListeners.clear();
    }

    @Override
    public void showStatisticsForSelectedProxy() {
        TestConsoleProperties.SHOW_STATISTICS.set((AbstractProperty.AbstractPropertyContainer)this.myProperties, (Object)true);
        AbstractTestProxy selectedProxy = this.myTreeView.getSelectedTest();
        this.showStatisticsForSelectedProxy(selectedProxy, true);
    }

    private void showStatisticsForSelectedProxy(AbstractTestProxy selectedProxy, boolean requestFocus) {
        if (selectedProxy instanceof GoogleCloudTestProxy && this.myShowStatisticForProxyHandler != null) {
            this.myShowStatisticForProxyHandler.handlePropagateSelectionRequest((GoogleCloudTestProxy)selectedProxy, this, requestFocus);
        }
    }

    private void _addTestOrSuite(@NotNull GoogleCloudTestProxy newTestOrSuite) {
        GoogleCloudTestProxy parentSuite = newTestOrSuite.getParent();
        assert (parentSuite != null);
        this.myTreeBuilder.updateTestsSubtree(parentSuite);
        this.myTreeBuilder.repaintWithParents(newTestOrSuite);
    }

    private void fireOnTestNodeAdded(GoogleCloudTestProxy test) {
        for (GoogleCloudTestResultsViewer.EventsListener eventListener : this.myEventListeners) {
            eventListener.onTestNodeAdded(this, test);
        }
    }

    private void fireOnTestingFinished() {
        for (GoogleCloudTestResultsViewer.EventsListener eventListener : this.myEventListeners) {
            eventListener.onTestingFinished(this);
        }
    }

    private void fireOnTestingStarted() {
        for (GoogleCloudTestResultsViewer.EventsListener eventListener : this.myEventListeners) {
            eventListener.onTestingStarted(this);
        }
    }

    private void selectWithoutNotify(AbstractTestProxy testProxy, @Nullable Runnable onDone) {
        if (testProxy == null) {
            return;
        }
        CloudTestingUtils.runInEventDispatchThread(() -> {
            if (this.myTreeBuilder.isDisposed()) {
                return;
            }
            this.myTreeBuilder.select(testProxy, onDone);
        }, ModalityState.NON_MODAL);
    }

    private void updateStatusLabel(boolean testingFinished) {
        boolean launchedAndFinished;
        if (this.myFailedTestCount > 0) {
            this.myStatusLine.setStatusColor(ColorProgressBar.RED);
        } else if (this.myIgnoredTestCount > 0) {
            this.myStatusLine.setStatusColor(DARK_YELLOW);
        }
        if (testingFinished && this.myTotalTestCount == 0) {
            this.myStatusLine.setStatusColor((Color)(this.myTestsRootNode.wasLaunched() || !this.myTestsRootNode.isTestsReporterAttached() ? JBColor.LIGHT_GRAY : ColorProgressBar.RED));
        }
        boolean bl = launchedAndFinished = this.myTestsRootNode.wasLaunched() && !this.myTestsRootNode.isInProgress();
        if (!TestsPresentationUtil.hasNonDefaultCategories(this.myMentionedCategories)) {
            if (this.myTestsRootNode.getDuration() == null || this.myEndTime == 0L) {
                this.myStatusLine.setText("");
            } else {
                this.myStatusLine.setText("Total time \u2013 " + StringUtil.formatDuration((long)this.myTestsRootNode.getDuration()));
            }
        } else {
            this.myStatusLine.setText(TestsPresentationUtil.getProgressStatus_Text((long)this.myStartTime, (long)this.myEndTime, (int)this.myTotalTestCount, (int)this.myFinishedTestCount, (int)this.myFailedTestCount, this.myMentionedCategories, (boolean)launchedAndFinished));
        }
    }

    private void updateIconProgress() {
        int doneTestCount;
        int totalTestCount;
        if (this.myTotalTestCount == 0) {
            totalTestCount = 2;
            doneTestCount = 1;
        } else {
            totalTestCount = this.myTotalTestCount;
            doneTestCount = this.myFinishedTestCount + this.myFailedTestCount + this.myIgnoredTestCount;
        }
        TestsUIUtil.showIconProgress((Project)this.myProject, (int)doneTestCount, (int)totalTestCount, (int)this.myFailedTestCount, (boolean)true);
    }

    private void updateCountersAndProgressOnTestCount(int count, boolean isCustomMessage) {
        if (!this.isModeConsistent(isCustomMessage)) {
            return;
        }
        this.myTotalTestCount += count;
        this.updateStatusLabel(false);
    }

    private void updateOnTestStarted(boolean isCustomMessage) {
        if (!this.isModeConsistent(isCustomMessage)) {
            return;
        }
        this.myMentionedCategories.add(this.myCurrentCustomProgressCategory != null ? this.myCurrentCustomProgressCategory : "Tests");
        ++this.myStartedTestCount;
        if (this.myStartedTestCount > this.myTotalTestCount && this.myTotalTestCount != 0) {
            this.myTotalTestCount = this.myStartedTestCount;
        }
        this.updateStatusLabel(false);
    }

    private void updateProgressOnTestDone() {
        int doneTestCount = this.myFinishedTestCount + this.myFailedTestCount + this.myIgnoredTestCount;
        if (this.myTotalTestCount != 0) {
            this.myStatusLine.setFraction((double)doneTestCount / (double)this.myTotalTestCount);
        } else {
            this.myStatusLine.setFraction(doneTestCount > 0 ? 0.5 : 0.0);
        }
    }

    private void updateOnTestFailed(boolean isCustomMessage) {
        if (!this.isModeConsistent(isCustomMessage)) {
            return;
        }
        ++this.myFailedTestCount;
        this.updateProgressOnTestDone();
        this.updateStatusLabel(false);
    }

    private void updateOnTestFinished(boolean isCustomMessage) {
        if (!this.isModeConsistent(isCustomMessage)) {
            return;
        }
        ++this.myFinishedTestCount;
        this.updateProgressOnTestDone();
    }

    private void updateOnTestIgnored() {
        ++this.myIgnoredTestCount;
        this.updateProgressOnTestDone();
        this.updateStatusLabel(false);
    }

    private boolean isModeConsistent(boolean isCustomMessage) {
        return isCustomMessage != (this.myCurrentCustomProgressCategory == null);
    }
}

