/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.visuallint.analyzers;

import android.graphics.RectF;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.TextView;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.configurations.Configuration;
import com.android.tools.rendering.RenderResult;
import com.android.tools.visuallint.VisualLintAnalyzer;
import com.android.tools.visuallint.VisualLintErrorType;
import com.android.utils.HtmlBuilder;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/visuallint/analyzers/LongTextAnalyzer;", "Lcom/android/tools/visuallint/VisualLintAnalyzer;", "<init>", "()V", "type", "Lcom/android/tools/visuallint/VisualLintErrorType;", "getType", "()Lcom/android/tools/visuallint/VisualLintErrorType;", "findIssues", "", "Lcom/android/tools/visuallint/VisualLintAnalyzer$VisualLintIssueContent;", "renderResult", "Lcom/android/tools/rendering/RenderResult;", "configuration", "Lcom/android/tools/configurations/Configuration;", "hasLongText", "", "view", "Lcom/android/ide/common/rendering/api/ViewInfo;", "createIssueContent", "intellij.android.visual-lint"})
@SourceDebugExtension(value={"SMAP\nLongTextAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LongTextAnalyzer.kt\ncom/android/tools/visuallint/analyzers/LongTextAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n1869#2,2:110\n*S KotlinDebug\n*F\n+ 1 LongTextAnalyzer.kt\ncom/android/tools/visuallint/analyzers/LongTextAnalyzer\n*L\n45#1:110,2\n*E\n"})
public final class LongTextAnalyzer
extends VisualLintAnalyzer {
    @NotNull
    public static final LongTextAnalyzer INSTANCE = new LongTextAnalyzer();

    private LongTextAnalyzer() {
    }

    @Override
    @NotNull
    public VisualLintErrorType getType() {
        return VisualLintErrorType.LONG_TEXT;
    }

    @Override
    @NotNull
    public List<VisualLintAnalyzer.VisualLintIssueContent> findIssues(@NotNull RenderResult renderResult, @NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)renderResult, (String)"renderResult");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        List issues = new ArrayList();
        ImmutableList immutableList = renderResult.getRootViews();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"getRootViews(...)");
        ArrayDeque viewsToAnalyze = new ArrayDeque((Collection)immutableList);
        while (!((Collection)viewsToAnalyze).isEmpty()) {
            ViewInfo view = (ViewInfo)viewsToAnalyze.removeLast();
            List list = view.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ViewInfo it = (ViewInfo)element$iv;
                boolean bl = false;
                viewsToAnalyze.addLast((Object)it);
            }
            Intrinsics.checkNotNull((Object)view);
            if (!this.hasLongText(view)) continue;
            issues.add(this.createIssueContent(view));
        }
        return issues;
    }

    private final boolean hasLongText(ViewInfo view) {
        Object object;
        Object object2 = view.getViewObject();
        TextView textView = object2 instanceof TextView ? (TextView)object2 : null;
        if (textView != null && (textView = textView.getLayout()) != null) {
            TextView it = textView;
            boolean bl = false;
            int n = it.getLineCount();
            for (int i = 0; i < n; ++i) {
                int numChars = it.getLineVisibleEnd(i) - it.getEllipsisCount(i) - it.getLineStart(i) + 1;
                if (numChars <= 120) continue;
                return true;
            }
        }
        object2 = (object = view.getAccessibilityObject()) instanceof AccessibilityNodeInfo ? (AccessibilityNodeInfo)object : null;
        RectF[] data = object2 != null && (object = object2.getExtras()) != null ? (RectF[])object.getParcelableArray("android.view.accessibility.extra.DATA_TEXT_CHARACTER_LOCATION_KEY", RectF.class) : null;
        if (!((object2 = data) == null || ((Object)object2).length == 0)) {
            RectF rectF = data[0];
            if (rectF == null) {
                return false;
            }
            float lineBottom = rectF.bottom;
            int charCount = 1;
            for (int index = 1; index < data.length; ++index) {
                RectF currentCharPosition = data[index];
                if (currentCharPosition == null) continue;
                float currentBottom = currentCharPosition.bottom;
                if (currentBottom == lineBottom) {
                    if (++charCount <= 120) continue;
                    return true;
                }
                lineBottom = currentBottom;
                charCount = 1;
            }
        }
        return false;
    }

    private final VisualLintAnalyzer.VisualLintIssueContent createIssueContent(ViewInfo view) {
        String summary = VisualLintAnalyzer.Companion.nameWithId(view) + " has lines containing more than 120 characters";
        String simpleName = VisualLintAnalyzer.Companion.simpleName(view);
        String url = "https://m3.material.io/foundations/layout/applying-layout/window-size-classes#a9594611-a6d4-4dce-abcb-15e7dd431f8a";
        Function1 provider = arg_0 -> LongTextAnalyzer.createIssueContent$lambda$2(simpleName, url, arg_0);
        return new VisualLintAnalyzer.VisualLintIssueContent(view, summary, null, provider, 4, null);
    }

    private static final HtmlBuilder createIssueContent$lambda$2(String $simpleName, String $url, int count) {
        return new HtmlBuilder().add($simpleName + " has lines containing more than 120 characters in " + VisualLintAnalyzer.Companion.previewConfigurations(count) + ".").newline().add("Material Design recommends reducing the width of TextView or switching to a ").addLink("multi-column layout", $url).add(" for breakpoints >= 600dp.");
    }
}

