/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.visuallint;

import android.view.accessibility.AccessibilityNodeInfo;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.resources.Density;
import com.android.resources.ResourceUrl;
import com.android.tools.configurations.Configuration;
import com.android.tools.idea.validator.ValidatorData;
import com.android.tools.rendering.RenderContext;
import com.android.tools.rendering.RenderResult;
import com.android.tools.rendering.parsers.TagSnapshot;
import com.android.tools.visuallint.VisualLintErrorType;
import com.android.utils.HtmlBuilder;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u00112\u00020\u0001:\u0002\u0010\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH&R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/visuallint/VisualLintAnalyzer;", "", "<init>", "()V", "type", "Lcom/android/tools/visuallint/VisualLintErrorType;", "getType", "()Lcom/android/tools/visuallint/VisualLintErrorType;", "analyze", "", "Lcom/android/tools/visuallint/VisualLintAnalyzer$VisualLintIssueContent;", "renderResult", "Lcom/android/tools/rendering/RenderResult;", "findIssues", "configuration", "Lcom/android/tools/configurations/Configuration;", "VisualLintIssueContent", "Companion", "intellij.android.visual-lint"})
public abstract class VisualLintAnalyzer {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public abstract VisualLintErrorType getType();

    @NotNull
    public final List<VisualLintIssueContent> analyze(@NotNull RenderResult renderResult) {
        Intrinsics.checkNotNullParameter((Object)renderResult, (String)"renderResult");
        RenderContext renderContext = renderResult.getRenderContext();
        if (renderContext == null || (renderContext = renderContext.getConfiguration()) == null) {
            return CollectionsKt.emptyList();
        }
        RenderContext configuration = renderContext;
        return this.findIssues(renderResult, (Configuration)configuration);
    }

    @NotNull
    public abstract List<VisualLintIssueContent> findIssues(@NotNull RenderResult var1, @NotNull Configuration var2);

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\nJ\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\n2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010J\u0016\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0007\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/visuallint/VisualLintAnalyzer$Companion;", "", "<init>", "()V", "previewConfigurations", "", "count", "", "simpleName", "view", "Lcom/android/ide/common/rendering/api/ViewInfo;", "nameWithId", "viewInfo", "checkIsClass", "", "clazz", "Ljava/lang/Class;", "pxToDp", "config", "Lcom/android/tools/configurations/Configuration;", "androidPx", "intellij.android.visual-lint"})
    @SourceDebugExtension(value={"SMAP\nVisualLintAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VisualLintAnalyzer.kt\ncom/android/tools/visuallint/VisualLintAnalyzer$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n1#2:91\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String previewConfigurations(int count) {
            return count == 1 ? "a preview configuration" : count + " preview configurations";
        }

        @NotNull
        public final String simpleName(@NotNull ViewInfo view) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            if (view.getCookie() instanceof TagSnapshot) {
                Object object = view.getCookie();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.android.tools.rendering.parsers.TagSnapshot");
                String string = ((TagSnapshot)object).tagName;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tagName");
                return StringsKt.substringAfterLast$default((String)string, (char)'.', null, (int)2, null);
            }
            if (view.getAccessibilityObject() instanceof AccessibilityNodeInfo && Intrinsics.areEqual((Object)view.getClassName(), (Object)"android.view.View")) {
                return "Composable";
            }
            String string = view.getClassName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClassName(...)");
            return StringsKt.substringAfterLast$default((String)string, (char)'.', null, (int)2, null);
        }

        @NotNull
        public final String nameWithId(@NotNull ViewInfo viewInfo) {
            Object object;
            block6: {
                String name;
                block5: {
                    String id;
                    String string;
                    Object it;
                    Intrinsics.checkNotNullParameter((Object)viewInfo, (String)"viewInfo");
                    Object object2 = viewInfo.getCookie();
                    TagSnapshot tagSnapshot = object2 instanceof TagSnapshot ? (TagSnapshot)object2 : null;
                    name = this.simpleName(viewInfo);
                    Object object3 = tagSnapshot;
                    if (object3 != null && (object3 = object3.getAttribute("id", "http://schemas.android.com/apk/res/android")) != null) {
                        it = object3;
                        boolean bl = false;
                        ResourceUrl resourceUrl = ResourceUrl.parse((String)it);
                        string = resourceUrl != null ? resourceUrl.name : null;
                    } else {
                        string = null;
                    }
                    if ((object = (id = string)) == null) break block5;
                    it = object;
                    boolean bl = false;
                    String string2 = id + " <" + name + ">";
                    object = string2;
                    if (string2 != null) break block6;
                }
                object = name;
            }
            return object;
        }

        public final boolean checkIsClass(@NotNull ViewInfo viewInfo, @NotNull Class<?> clazz) {
            Intrinsics.checkNotNullParameter((Object)viewInfo, (String)"viewInfo");
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            return clazz.isInstance(viewInfo.getViewObject()) || Intrinsics.areEqual((Object)clazz.getCanonicalName(), (Object)viewInfo.getClassName());
        }

        public final int pxToDp(@NotNull Configuration config, int androidPx) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            int dpiValue = config.getDensity().getDpiValue();
            return androidPx * Density.DEFAULT_DENSITY / dpiValue;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B9\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0004\b\f\u0010\rJ\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u0015\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u00c6\u0003JA\u0010\u001a\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\nH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0005H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006 "}, d2={"Lcom/android/tools/visuallint/VisualLintAnalyzer$VisualLintIssueContent;", "", "view", "Lcom/android/ide/common/rendering/api/ViewInfo;", "message", "", "atfIssue", "Lcom/android/tools/idea/validator/ValidatorData$Issue;", "descriptionProvider", "Lkotlin/Function1;", "", "Lcom/android/utils/HtmlBuilder;", "<init>", "(Lcom/android/ide/common/rendering/api/ViewInfo;Ljava/lang/String;Lcom/android/tools/idea/validator/ValidatorData$Issue;Lkotlin/jvm/functions/Function1;)V", "getView", "()Lcom/android/ide/common/rendering/api/ViewInfo;", "getMessage", "()Ljava/lang/String;", "getAtfIssue", "()Lcom/android/tools/idea/validator/ValidatorData$Issue;", "getDescriptionProvider", "()Lkotlin/jvm/functions/Function1;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "intellij.android.visual-lint"})
    public static final class VisualLintIssueContent {
        @Nullable
        private final ViewInfo view;
        @NotNull
        private final String message;
        @Nullable
        private final ValidatorData.Issue atfIssue;
        @NotNull
        private final Function1<Integer, HtmlBuilder> descriptionProvider;

        public VisualLintIssueContent(@Nullable ViewInfo view, @NotNull String message, @Nullable ValidatorData.Issue atfIssue, @NotNull Function1<? super Integer, ? extends HtmlBuilder> descriptionProvider) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter(descriptionProvider, (String)"descriptionProvider");
            this.view = view;
            this.message = message;
            this.atfIssue = atfIssue;
            this.descriptionProvider = descriptionProvider;
        }

        public /* synthetic */ VisualLintIssueContent(ViewInfo viewInfo, String string, ValidatorData.Issue issue, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                issue = null;
            }
            this(viewInfo, string, issue, (Function1<? super Integer, ? extends HtmlBuilder>)function1);
        }

        @Nullable
        public final ViewInfo getView() {
            return this.view;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        @Nullable
        public final ValidatorData.Issue getAtfIssue() {
            return this.atfIssue;
        }

        @NotNull
        public final Function1<Integer, HtmlBuilder> getDescriptionProvider() {
            return this.descriptionProvider;
        }

        @Nullable
        public final ViewInfo component1() {
            return this.view;
        }

        @NotNull
        public final String component2() {
            return this.message;
        }

        @Nullable
        public final ValidatorData.Issue component3() {
            return this.atfIssue;
        }

        @NotNull
        public final Function1<Integer, HtmlBuilder> component4() {
            return this.descriptionProvider;
        }

        @NotNull
        public final VisualLintIssueContent copy(@Nullable ViewInfo view, @NotNull String message, @Nullable ValidatorData.Issue atfIssue, @NotNull Function1<? super Integer, ? extends HtmlBuilder> descriptionProvider) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter(descriptionProvider, (String)"descriptionProvider");
            return new VisualLintIssueContent(view, message, atfIssue, descriptionProvider);
        }

        public static /* synthetic */ VisualLintIssueContent copy$default(VisualLintIssueContent visualLintIssueContent, ViewInfo viewInfo, String string, ValidatorData.Issue issue, Function1 function1, int n, Object object) {
            if ((n & 1) != 0) {
                viewInfo = visualLintIssueContent.view;
            }
            if ((n & 2) != 0) {
                string = visualLintIssueContent.message;
            }
            if ((n & 4) != 0) {
                issue = visualLintIssueContent.atfIssue;
            }
            if ((n & 8) != 0) {
                function1 = visualLintIssueContent.descriptionProvider;
            }
            return visualLintIssueContent.copy(viewInfo, string, issue, function1);
        }

        @NotNull
        public String toString() {
            return "VisualLintIssueContent(view=" + this.view + ", message=" + this.message + ", atfIssue=" + this.atfIssue + ", descriptionProvider=" + this.descriptionProvider + ")";
        }

        public int hashCode() {
            int result = this.view == null ? 0 : this.view.hashCode();
            result = result * 31 + this.message.hashCode();
            result = result * 31 + (this.atfIssue == null ? 0 : this.atfIssue.hashCode());
            result = result * 31 + this.descriptionProvider.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VisualLintIssueContent)) {
                return false;
            }
            VisualLintIssueContent visualLintIssueContent = (VisualLintIssueContent)other;
            if (!Intrinsics.areEqual((Object)this.view, (Object)visualLintIssueContent.view)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.message, (Object)visualLintIssueContent.message)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.atfIssue, (Object)visualLintIssueContent.atfIssue)) {
                return false;
            }
            return Intrinsics.areEqual(this.descriptionProvider, visualLintIssueContent.descriptionProvider);
        }
    }
}

