/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wear.preview.animation.analytics;

import com.android.tools.idea.preview.animation.AnimationTracker;
import com.android.tools.idea.wear.preview.animation.analytics.AnimationToolingEvent;
import com.android.tools.idea.wear.preview.animation.analytics.AnimationToolingUsageTracker;
import com.google.wireless.android.sdk.stats.WearTileAnimationToolingEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\u0007H\u0016J\b\u0010\u000b\u001a\u00020\u0007H\u0016J\b\u0010\f\u001a\u00020\u0007H\u0016J\b\u0010\r\u001a\u00020\u0007H\u0016J\b\u0010\u000e\u001a\u00020\u0007H\u0016J\b\u0010\u000f\u001a\u00020\u0007H\u0016J\b\u0010\u0010\u001a\u00020\u0007H\u0016J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0007H\u0016J\b\u0010\u0015\u001a\u00020\u0007H\u0016J\b\u0010\u0016\u001a\u00020\u0007H\u0016J\b\u0010\u0017\u001a\u00020\u0007H\u0016J\b\u0010\u0018\u001a\u00020\u0007H\u0016J\b\u0010\u0019\u001a\u00020\u0007H\u0016J\b\u0010\u001a\u001a\u00020\u0007H\u0016J\b\u0010\u001b\u001a\u00020\u0007H\u0016J\b\u0010\u001c\u001a\u00020\u0007H\u0016J\b\u0010\u001d\u001a\u00020\u0007H\u0016J\b\u0010\u001e\u001a\u00020\u0007H\u0016J\b\u0010\u001f\u001a\u00020\u0007H\u0016J\b\u0010 \u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/tools/idea/wear/preview/animation/analytics/WearTileAnimationTracker;", "Lcom/android/tools/idea/preview/animation/AnimationTracker;", "eventLogger", "Lcom/android/tools/idea/wear/preview/animation/analytics/AnimationToolingUsageTracker;", "<init>", "(Lcom/android/tools/idea/wear/preview/animation/analytics/AnimationToolingUsageTracker;)V", "logEvent", "", "type", "Lcom/google/wireless/android/sdk/stats/WearTileAnimationToolingEvent$WearTileAnimationToolingEventType;", "openAnimationInspector", "closeAnimationInspector", "animationInspectorAvailable", "triggerPlayAction", "triggerPauseAction", "enableLoopAction", "disableLoopAction", "changeAnimationSpeed", "speedMultiplier", "", "triggerJumpToStartAction", "triggerJumpToEndAction", "changeStartState", "changeEndState", "triggerSwapStatesAction", "clickAnimationInspectorTimeline", "expandAnimationCard", "collapseAnimationCard", "openAnimationInTab", "closeAnimationTab", "lockAnimation", "unlockAnimation", "openPicker", "intellij.android.wear-designer"})
public final class WearTileAnimationTracker
implements AnimationTracker {
    @NotNull
    private final AnimationToolingUsageTracker eventLogger;

    public WearTileAnimationTracker(@NotNull AnimationToolingUsageTracker eventLogger) {
        Intrinsics.checkNotNullParameter((Object)eventLogger, (String)"eventLogger");
        this.eventLogger = eventLogger;
    }

    private final void logEvent(WearTileAnimationToolingEvent.WearTileAnimationToolingEventType type) {
        this.eventLogger.logEvent(new AnimationToolingEvent(type));
    }

    @Override
    public void openAnimationInspector() {
        this.logEvent(WearTileAnimationToolingEvent.WearTileAnimationToolingEventType.OPEN_ANIMATION_INSPECTOR);
    }

    @Override
    public void closeAnimationInspector() {
        this.logEvent(WearTileAnimationToolingEvent.WearTileAnimationToolingEventType.CLOSE_ANIMATION_INSPECTOR);
    }

    @Override
    public void animationInspectorAvailable() {
        this.logEvent(WearTileAnimationToolingEvent.WearTileAnimationToolingEventType.ANIMATION_INSPECTOR_AVAILABLE);
    }

    @Override
    public void triggerPlayAction() {
        this.logEvent(WearTileAnimationToolingEvent.WearTileAnimationToolingEventType.TRIGGER_PLAY_ACTION);
    }

    @Override
    public void triggerPauseAction() {
        this.logEvent(WearTileAnimationToolingEvent.WearTileAnimationToolingEventType.TRIGGER_PAUSE_ACTION);
    }

    @Override
    public void enableLoopAction() {
        this.logEvent(WearTileAnimationToolingEvent.WearTileAnimationToolingEventType.ENABLE_LOOP_ACTION);
    }

    @Override
    public void disableLoopAction() {
        this.logEvent(WearTileAnimationToolingEvent.WearTileAnimationToolingEventType.DISABLE_LOOP_ACTION);
    }

    @Override
    public void changeAnimationSpeed(float speedMultiplier) {
        AnimationToolingEvent event = new AnimationToolingEvent(WearTileAnimationToolingEvent.WearTileAnimationToolingEventType.CHANGE_ANIMATION_SPEED).withAnimationMultiplier(speedMultiplier);
        this.eventLogger.logEvent(event);
    }

    @Override
    public void triggerJumpToStartAction() {
        this.logEvent(WearTileAnimationToolingEvent.WearTileAnimationToolingEventType.TRIGGER_JUMP_TO_START_ACTION);
    }

    @Override
    public void triggerJumpToEndAction() {
        this.logEvent(WearTileAnimationToolingEvent.WearTileAnimationToolingEventType.TRIGGER_JUMP_TO_END_ACTION);
    }

    @Override
    public void changeStartState() {
        this.logEvent(WearTileAnimationToolingEvent.WearTileAnimationToolingEventType.CHANGE_START_STATE);
    }

    @Override
    public void changeEndState() {
        this.logEvent(WearTileAnimationToolingEvent.WearTileAnimationToolingEventType.CHANGE_END_STATE);
    }

    @Override
    public void triggerSwapStatesAction() {
        this.logEvent(WearTileAnimationToolingEvent.WearTileAnimationToolingEventType.TRIGGER_SWAP_STATES_ACTION);
    }

    @Override
    public void clickAnimationInspectorTimeline() {
        this.logEvent(WearTileAnimationToolingEvent.WearTileAnimationToolingEventType.CLICK_ANIMATION_INSPECTOR_TIMELINE);
    }

    @Override
    public void expandAnimationCard() {
        this.logEvent(WearTileAnimationToolingEvent.WearTileAnimationToolingEventType.EXPAND_ANIMATION_CARD);
    }

    @Override
    public void collapseAnimationCard() {
        this.logEvent(WearTileAnimationToolingEvent.WearTileAnimationToolingEventType.COLLAPSE_ANIMATION_CARD);
    }

    @Override
    public void openAnimationInTab() {
        this.logEvent(WearTileAnimationToolingEvent.WearTileAnimationToolingEventType.OPEN_ANIMATION_IN_TAB);
    }

    @Override
    public void closeAnimationTab() {
        this.logEvent(WearTileAnimationToolingEvent.WearTileAnimationToolingEventType.CLOSE_ANIMATION_TAB);
    }

    @Override
    public void lockAnimation() {
        this.logEvent(WearTileAnimationToolingEvent.WearTileAnimationToolingEventType.LOCK_ANIMATION);
    }

    @Override
    public void unlockAnimation() {
        this.logEvent(WearTileAnimationToolingEvent.WearTileAnimationToolingEventType.UNLOCK_ANIMATION);
    }

    @Override
    public void openPicker() {
        this.logEvent(WearTileAnimationToolingEvent.WearTileAnimationToolingEventType.OPEN_PICKER);
    }
}

