/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.visual.colorblindmode;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.uibuilder.visual.colorblindmode.ColorBlindMode;
import com.android.tools.idea.uibuilder.visual.colorblindmode.ColorLut;
import com.android.tools.idea.uibuilder.visual.colorblindmode.ColorUtilKt;
import com.android.tools.idea.uibuilder.visual.colorblindmode.MathUtilKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/uibuilder/visual/colorblindmode/ColorConverter;", "Lcom/intellij/openapi/Disposable;", "mode", "Lcom/android/tools/idea/uibuilder/visual/colorblindmode/ColorBlindMode;", "<init>", "(Lcom/android/tools/idea/uibuilder/visual/colorblindmode/ColorBlindMode;)V", "getMode", "()Lcom/android/tools/idea/uibuilder/visual/colorblindmode/ColorBlindMode;", "cbmCLut", "Lcom/android/tools/idea/uibuilder/visual/colorblindmode/ColorLut;", "convert", "", "startImage", "Ljava/awt/image/BufferedImage;", "postImage", "alphaCorrect", "", "color", "dispose", "", "Companion", "intellij.android.designer"})
@StabilityInferred(parameters=0)
public final class ColorConverter
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ColorBlindMode mode;
    @Nullable
    private ColorLut cbmCLut;
    public static final int $stable = 8;
    @Nullable
    private static double[] removeGammaCLut;

    public ColorConverter(@NotNull ColorBlindMode mode) {
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        this.mode = mode;
    }

    @NotNull
    public final ColorBlindMode getMode() {
        return this.mode;
    }

    public final boolean convert(@NotNull BufferedImage startImage, @NotNull BufferedImage postImage) {
        Intrinsics.checkNotNullParameter((Object)startImage, (String)"startImage");
        Intrinsics.checkNotNullParameter((Object)postImage, (String)"postImage");
        if (this.cbmCLut == null || removeGammaCLut == null) {
            removeGammaCLut = ColorUtilKt.buildGammaCLut(ColorConverter::convert$lambda$0);
            Intrinsics.checkNotNull((Object)removeGammaCLut);
            this.cbmCLut = ColorUtilKt.buildColorLut(16, this.mode, removeGammaCLut);
        }
        if (startImage.getType() != 3 || postImage.getType() != 3) {
            Logger.getInstance(ColorConverter.class).warn("Error:: BufferedImage not supported for color blind mode.");
            return false;
        }
        DataBuffer dataBuffer = startImage.getRaster().getDataBuffer();
        Intrinsics.checkNotNull((Object)dataBuffer, (String)"null cannot be cast to non-null type java.awt.image.DataBufferInt");
        int[] inData = ((DataBufferInt)dataBuffer).getData();
        DataBuffer dataBuffer2 = postImage.getRaster().getDataBuffer();
        Intrinsics.checkNotNull((Object)dataBuffer2, (String)"null cannot be cast to non-null type java.awt.image.DataBufferInt");
        int[] outData = ((DataBufferInt)dataBuffer2).getData();
        int n = inData.length;
        for (int i = 0; i < n; ++i) {
            ColorLut colorLut = this.cbmCLut;
            Intrinsics.checkNotNull((Object)colorLut);
            outData[i] = 0xFF000000 | colorLut.interpolate(this.alphaCorrect(inData[i]));
        }
        return true;
    }

    private final int alphaCorrect(int color) {
        int whiteBg = 255 - MathUtilKt.a(color);
        return MathUtilKt.combine(MathUtilKt.r(color) + whiteBg, MathUtilKt.g(color) + whiteBg, MathUtilKt.b(color) + whiteBg);
    }

    public void dispose() {
        removeGammaCLut = null;
        this.cbmCLut = null;
    }

    private static final Double convert$lambda$0(Double it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Math.pow(it / 255.0, 2.2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0013\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/uibuilder/visual/colorblindmode/ColorConverter$Companion;", "", "<init>", "()V", "removeGammaCLut", "", "intellij.android.designer"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

