/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scout;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintComponentUtilities;
import com.android.tools.idea.uibuilder.scout.Direction;
import com.android.tools.idea.uibuilder.scout.Scout;
import java.util.List;

public class ScoutConnectArrange {
    static int gap(NlComponent fromComponent, Direction fromDir, NlComponent toComponent, Direction toDir) {
        int fromY = 0;
        int fromX = 0;
        int marginDir = 1;
        switch (fromDir) {
            case TOP: {
                fromY = ConstraintComponentUtilities.getDpY(fromComponent);
                marginDir = -1;
                break;
            }
            case BOTTOM: {
                fromY = ConstraintComponentUtilities.getDpY(fromComponent);
                fromY += ConstraintComponentUtilities.getDpHeight(fromComponent);
                break;
            }
            case LEFT: {
                marginDir = -1;
                fromX = ConstraintComponentUtilities.getDpX(fromComponent);
                break;
            }
            case RIGHT: {
                fromX = ConstraintComponentUtilities.getDpX(fromComponent);
                fromX += ConstraintComponentUtilities.getDpWidth(fromComponent);
                break;
            }
            case BASELINE: {
                return 0;
            }
        }
        if (toComponent == null) {
            switch (toDir) {
                case TOP: {
                    return fromY -= ConstraintComponentUtilities.getDpY(fromComponent.getParent());
                }
                case BOTTOM: {
                    fromY -= ConstraintComponentUtilities.getDpY(fromComponent.getParent());
                    return -(fromY -= ConstraintComponentUtilities.getDpHeight(fromComponent.getParent()));
                }
                case LEFT: {
                    return fromX -= ConstraintComponentUtilities.getDpX(fromComponent.getParent());
                }
                case RIGHT: {
                    fromX -= ConstraintComponentUtilities.getDpX(fromComponent.getParent());
                    return -(fromX -= ConstraintComponentUtilities.getDpWidth(fromComponent.getParent()));
                }
                case BASELINE: {
                    return 0;
                }
            }
        }
        switch (toDir) {
            case TOP: {
                fromY = ConstraintComponentUtilities.getDpY(toComponent) - fromY;
                return fromY * marginDir;
            }
            case BOTTOM: {
                int toY = ConstraintComponentUtilities.getDpY(toComponent);
                toY += ConstraintComponentUtilities.getDpHeight(toComponent);
                return (toY -= fromY) * marginDir;
            }
            case LEFT: {
                fromX = ConstraintComponentUtilities.getDpX(toComponent) - fromX;
                return fromX * marginDir;
            }
            case RIGHT: {
                int toX = ConstraintComponentUtilities.getDpX(toComponent);
                toX += ConstraintComponentUtilities.getDpWidth(toComponent);
                return (toX -= fromX) * marginDir;
            }
            case BASELINE: {
                return 0;
            }
        }
        return 0;
    }

    public static void connect(List<NlComponent> widgets, Scout.Connect action2, boolean reverse, boolean useMargin) {
        NlComponent componentTo;
        int margin = 0;
        NlComponent componentFrom = widgets.get(0);
        NlComponent nlComponent = componentTo = widgets.size() > 1 ? widgets.get(1) : null;
        if (reverse) {
            NlComponent swap = componentTo;
            componentTo = componentFrom;
            componentFrom = swap;
        }
        switch (action2) {
            case ConnectTopToTop: {
                margin = ScoutConnectArrange.gap(componentFrom, Direction.TOP, componentTo, Direction.TOP);
                ConstraintComponentUtilities.scoutConnect(componentFrom, Direction.TOP, componentTo, Direction.TOP, margin);
                break;
            }
            case ConnectTopToBottom: {
                margin = ScoutConnectArrange.gap(componentFrom, Direction.TOP, componentTo, Direction.BOTTOM);
                ConstraintComponentUtilities.scoutConnect(componentFrom, Direction.TOP, componentTo, Direction.BOTTOM, margin);
                break;
            }
            case ConnectBottomToTop: {
                margin = ScoutConnectArrange.gap(componentFrom, Direction.BOTTOM, componentTo, Direction.TOP);
                ConstraintComponentUtilities.scoutConnect(componentFrom, Direction.BOTTOM, componentTo, Direction.TOP, margin);
                break;
            }
            case ConnectBottomToBottom: {
                margin = ScoutConnectArrange.gap(componentFrom, Direction.BOTTOM, componentTo, Direction.BOTTOM);
                ConstraintComponentUtilities.scoutConnect(componentFrom, Direction.BOTTOM, componentTo, Direction.BOTTOM, margin);
                break;
            }
            case ConnectStartToStart: {
                margin = ScoutConnectArrange.gap(componentFrom, Direction.LEFT, componentTo, Direction.LEFT);
                ConstraintComponentUtilities.scoutConnect(componentFrom, Direction.LEFT, componentTo, Direction.LEFT, margin);
                break;
            }
            case ConnectStartToEnd: {
                margin = ScoutConnectArrange.gap(componentFrom, Direction.LEFT, componentTo, Direction.RIGHT);
                ConstraintComponentUtilities.scoutConnect(componentFrom, Direction.LEFT, componentTo, Direction.RIGHT, margin);
                break;
            }
            case ConnectEndToStart: {
                margin = ScoutConnectArrange.gap(componentFrom, Direction.RIGHT, componentTo, Direction.LEFT);
                ConstraintComponentUtilities.scoutConnect(componentFrom, Direction.RIGHT, componentTo, Direction.LEFT, margin);
                break;
            }
            case ConnectEndToEnd: {
                margin = ScoutConnectArrange.gap(componentFrom, Direction.RIGHT, componentTo, Direction.RIGHT);
                ConstraintComponentUtilities.scoutConnect(componentFrom, Direction.RIGHT, componentTo, Direction.RIGHT, margin);
                break;
            }
            case ConnectBaseLineToBaseLine: {
                ConstraintComponentUtilities.scoutConnect(componentFrom, Direction.BASELINE, componentTo, Direction.BASELINE, margin);
                break;
            }
            case ConnectToParentTop: {
                margin = ScoutConnectArrange.gap(componentFrom, Direction.TOP, null, Direction.TOP);
                ConstraintComponentUtilities.scoutConnect(componentFrom, Direction.TOP, componentFrom.getParent(), Direction.TOP, margin);
                break;
            }
            case ConnectToParentBottom: {
                margin = ScoutConnectArrange.gap(componentFrom, Direction.BOTTOM, null, Direction.BOTTOM);
                ConstraintComponentUtilities.scoutConnect(componentFrom, Direction.BOTTOM, componentFrom.getParent(), Direction.BOTTOM, margin);
                break;
            }
            case ConnectToParentStart: {
                margin = ScoutConnectArrange.gap(componentFrom, Direction.LEFT, null, Direction.LEFT);
                ConstraintComponentUtilities.scoutConnect(componentFrom, Direction.LEFT, componentFrom.getParent(), Direction.LEFT, margin);
                break;
            }
            case ConnectToParentEnd: {
                margin = ScoutConnectArrange.gap(componentFrom, Direction.RIGHT, null, Direction.RIGHT);
                ConstraintComponentUtilities.scoutConnect(componentFrom, Direction.RIGHT, componentFrom.getParent(), Direction.RIGHT, margin);
            }
        }
    }

    public static boolean connectCheck(List<NlComponent> widgets, Scout.Connect test, boolean reverse) {
        NlComponent componentTo;
        if (widgets.size() == 0) {
            return false;
        }
        NlComponent componentFrom = widgets.get(0);
        NlComponent nlComponent = componentTo = widgets.size() > 1 ? widgets.get(1) : null;
        if (componentFrom == componentTo) {
            return false;
        }
        if (reverse) {
            NlComponent swap = componentTo;
            componentTo = componentFrom;
            componentFrom = swap;
        }
        switch (test) {
            case ConnectTopToTop: {
                return !ConstraintComponentUtilities.wouldCreateLoop(componentFrom, Direction.TOP, componentTo);
            }
            case ConnectTopToBottom: {
                return !ConstraintComponentUtilities.wouldCreateLoop(componentFrom, Direction.TOP, componentTo);
            }
            case ConnectBottomToTop: {
                return !ConstraintComponentUtilities.wouldCreateLoop(componentFrom, Direction.BOTTOM, componentTo);
            }
            case ConnectBottomToBottom: {
                return !ConstraintComponentUtilities.wouldCreateLoop(componentFrom, Direction.BOTTOM, componentTo);
            }
            case ConnectStartToStart: {
                return !ConstraintComponentUtilities.wouldCreateLoop(componentFrom, Direction.LEFT, componentTo);
            }
            case ConnectStartToEnd: {
                return !ConstraintComponentUtilities.wouldCreateLoop(componentFrom, Direction.LEFT, componentTo);
            }
            case ConnectEndToStart: {
                return !ConstraintComponentUtilities.wouldCreateLoop(componentFrom, Direction.RIGHT, componentTo);
            }
            case ConnectEndToEnd: {
                return !ConstraintComponentUtilities.wouldCreateLoop(componentFrom, Direction.RIGHT, componentTo);
            }
            case ConnectBaseLineToBaseLine: {
                return !ConstraintComponentUtilities.wouldCreateLoop(componentFrom, Direction.BASELINE, componentTo);
            }
            case ConnectToParentTop: 
            case ConnectToParentBottom: 
            case ConnectToParentStart: 
            case ConnectToParentEnd: {
                return widgets.size() == 1;
            }
        }
        return false;
    }
}

