/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scout;

public enum Direction {
    TOP(0),
    BOTTOM(1),
    LEFT(2),
    RIGHT(3),
    BASELINE(4);

    private final int mDirection;
    static final int ORIENTATION_VERTICAL = 0;
    static final int ORIENTATION_HORIZONTAL = 1;
    private static Direction[] sAllDirections;
    private static Direction[] sVertical;
    private static Direction[] sHorizontal;

    private Direction(int n2) {
        this.mDirection = n2;
    }

    static Direction[] getAllDirections() {
        return sAllDirections;
    }

    static String toString(int directionInteger) {
        return Direction.get(directionInteger).toString();
    }

    public String toString() {
        switch (this.ordinal()) {
            case 0: {
                return "N";
            }
            case 1: {
                return "S";
            }
            case 3: {
                return "E";
            }
            case 2: {
                return "W";
            }
            case 4: {
                return "B";
            }
        }
        return "?";
    }

    int getDirection() {
        return this.mDirection;
    }

    Direction getOpposite() {
        switch (this.ordinal()) {
            case 0: {
                return BOTTOM;
            }
            case 1: {
                return TOP;
            }
            case 3: {
                return LEFT;
            }
            case 2: {
                return RIGHT;
            }
            case 4: {
                return BASELINE;
            }
        }
        return BASELINE;
    }

    static Direction get(int directionInteger) {
        return sAllDirections[directionInteger];
    }

    boolean reverse() {
        return this == TOP || this == LEFT;
    }

    static Direction[] getDirections(int orientation) {
        if (orientation == 0) {
            return sVertical;
        }
        return sHorizontal;
    }

    public int connectTypes() {
        switch (this.ordinal()) {
            case 0: 
            case 1: {
                return 2;
            }
            case 2: 
            case 3: {
                return 2;
            }
            case 4: {
                return 1;
            }
        }
        return 1;
    }

    public String getMarginString() {
        switch (this.ordinal()) {
            case 0: {
                return "layout_marginTop";
            }
            case 1: {
                return "layout_marginBottom";
            }
            case 3: {
                return "layout_marginRight";
            }
            case 2: {
                return "layout_marginLeft";
            }
        }
        return "?";
    }

    static {
        sAllDirections = Direction.values();
        sVertical = new Direction[]{TOP, BOTTOM, BASELINE};
        sHorizontal = new Direction[]{LEFT, RIGHT};
    }
}

