/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.scene.target;

import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.scene.draw.DrawHorizontalNotch;
import com.android.tools.idea.uibuilder.scene.draw.DrawVerticalNotch;
import com.google.common.collect.ImmutableList;
import java.awt.Point;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Notch {
    protected static final int DEFAULT_GAP = 8;
    static final int TYPE_HORIZONTAL = 1;
    static final int TYPE_VERTICAL = 2;
    static final int TYPE_CIRCLE = 4;
    @NotNull
    protected SceneComponent myOwner;
    protected int myType;
    protected int myGap = 8;
    @Nullable
    Action myAction;
    @Nullable
    Target myTarget;

    protected Notch(@NotNull SceneComponent owner, int type, @Nullable Action action2) {
        this.myOwner = owner;
        this.myType = type;
        this.myAction = action2;
    }

    public void setGap(int gap) {
        this.myGap = gap;
    }

    public void setAction(@Nullable Action action2) {
        this.myAction = action2;
    }

    public void applyAction(@NotNull NlAttributesHolder attributes) {
        if (this.myAction != null) {
            this.myAction.apply(attributes);
        }
    }

    abstract boolean isSnappable(int var1, int var2, @NotNull Point var3);

    public final int getType() {
        return this.myType;
    }

    public final void setTarget(@Nullable Target target) {
        this.myTarget = target;
    }

    @Nullable
    public final Target getTarget() {
        return this.myTarget;
    }

    public abstract void render(@NotNull DisplayList var1, @NotNull SceneContext var2, @NotNull SceneComponent var3);

    public static interface Action {
        public void apply(@NotNull NlAttributesHolder var1);
    }

    public static class SmallVertical
    extends Vertical {
        public SmallVertical(@NotNull SceneComponent owner, int valueY, int displayValueY) {
            super(owner, valueY, displayValueY, null);
            this.myGap = 6;
        }

        @Override
        public void render(@NotNull DisplayList list, @NotNull SceneContext context, @NotNull SceneComponent component) {
            int gap = 16;
            int x1 = Math.min(this.myOwner.getDrawX(), component.getDrawX()) - gap;
            int x2 = Math.max(this.myOwner.getDrawX() + this.myOwner.getDrawWidth(), component.getDrawX() + component.getDrawWidth()) + gap;
            DrawHorizontalNotch.add(list, context, x1, this.myDisplayValueY, x2);
        }
    }

    public static class SmallHorizontal
    extends Horizontal {
        public SmallHorizontal(@NotNull SceneComponent owner, int valueX, int displayValueX) {
            super(owner, valueX, displayValueX, null);
            this.myGap = 6;
        }

        @Override
        public void render(@NotNull DisplayList list, @NotNull SceneContext context, @NotNull SceneComponent component) {
            int gap = 16;
            int y1 = Math.min(this.myOwner.getDrawY(), component.getDrawY()) - gap;
            int y2 = Math.max(this.myOwner.getDrawY() + this.myOwner.getDrawHeight(), component.getDrawY() + component.getDrawHeight()) + gap;
            DrawVerticalNotch.add(list, context, this.myDisplayValueX, y1, y2);
        }
    }

    public static class Circle
    extends Notch {
        private int myValueX;
        private int myValueY;

        public Circle(@NotNull SceneComponent owner, int valueX, int valueY) {
            this(owner, valueX, valueY, null);
        }

        public Circle(@NotNull SceneComponent owner, int valueX, int valueY, @Nullable Action action2) {
            super(owner, 4, action2);
            this.myValueX = valueX;
            this.myValueY = valueY;
        }

        @Override
        public boolean isSnappable(int valueX, int valueY, @NotNull Point retPoint) {
            int dx = valueX - this.myValueX;
            int dy = valueY - this.myValueY;
            if (dx * dx + dy * dy <= this.myGap * this.myGap) {
                retPoint.x = this.myValueX;
                retPoint.y = this.myValueY;
                return true;
            }
            return false;
        }

        @Override
        public void render(@NotNull DisplayList list, @NotNull SceneContext context, @NotNull SceneComponent component) {
        }
    }

    public static class Vertical
    extends Notch {
        protected int myValueY;
        protected int myDisplayValueY;

        public Vertical(@NotNull SceneComponent owner, int valueY, int displayValueY) {
            this(owner, valueY, displayValueY, null);
        }

        public Vertical(@NotNull SceneComponent owner, int valueY, int displayValueY, @Nullable Action action2) {
            super(owner, 2, action2);
            this.myValueY = valueY;
            this.myDisplayValueY = displayValueY;
        }

        @Override
        public boolean isSnappable(int valueX, int valueY, @NotNull Point retPoint) {
            if (Math.abs(valueY - this.myValueY) <= this.myGap) {
                retPoint.x = valueX;
                retPoint.y = this.myValueY;
                return true;
            }
            return false;
        }

        @Override
        public void render(@NotNull DisplayList list, @NotNull SceneContext context, @NotNull SceneComponent component) {
            SceneComponent parent = component.getParent();
            if (parent != null) {
                DrawHorizontalNotch.add(list, context, parent.getDrawX(), this.myDisplayValueY, parent.getDrawX() + parent.getDrawWidth());
            }
        }
    }

    public static class Horizontal
    extends Notch {
        protected int myValueX;
        protected int myDisplayValueX;

        public Horizontal(@NotNull SceneComponent owner, int valueX, int displayValueX) {
            this(owner, valueX, displayValueX, null);
        }

        public Horizontal(@NotNull SceneComponent owner, int valueX, int displayValueX, @Nullable Action action2) {
            super(owner, 1, action2);
            this.myValueX = valueX;
            this.myDisplayValueX = displayValueX;
        }

        @Override
        public boolean isSnappable(int valueX, int valueY, @NotNull Point retPoint) {
            if (Math.abs(valueX - this.myValueX) <= this.myGap) {
                retPoint.x = this.myValueX;
                retPoint.y = valueY;
                return true;
            }
            return false;
        }

        @Override
        public void render(@NotNull DisplayList list, @NotNull SceneContext context, @NotNull SceneComponent component) {
            SceneComponent parent = component.getParent();
            if (parent != null) {
                DrawVerticalNotch.add(list, context, this.myDisplayValueX, parent.getDrawY(), parent.getDrawY() + parent.getDrawHeight());
            }
        }
    }

    public static interface Provider {
        public void fill(@NotNull SceneComponent var1, @NotNull SceneComponent var2, @NotNull ImmutableList.Builder<Notch> var3);
    }
}

