/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VirtualWidget
extends JComponent {
    double myRotate = 0.0;
    double myRotateX = 0.0;
    double myRotateY = 0.0;
    private static double ourFillFactor = 0.666;
    private static double ourThick = 0.1;
    private static double ourHalfWidth = 1.0;
    private static double ourHalfHeight = 0.8;
    double ourTextPercent = 0.6666666;
    String myString = "View";
    private double[][] myTextPath;
    private double[][] myTransformedTextPath;
    GeneralPath mGeneralPath = new GeneralPath();
    Matrix myMatrix = new Matrix();
    double[][] myCubeVertex = new double[][]{{-ourHalfWidth, -ourHalfHeight, -ourThick}, {ourHalfWidth, -ourHalfHeight, -ourThick}, {ourHalfWidth, ourHalfHeight, -ourThick}, {-ourHalfWidth, ourHalfHeight, -ourThick}, {-ourHalfWidth, -ourHalfHeight, ourThick}, {ourHalfWidth, -ourHalfHeight, ourThick}, {ourHalfWidth, ourHalfHeight, ourThick}, {-ourHalfWidth, ourHalfHeight, ourThick}};
    double[][] myTransformedVertex = new double[][]{{-ourHalfWidth, -ourHalfHeight, -ourThick}, {ourHalfWidth, -ourHalfHeight, -ourThick}, {ourHalfWidth, ourHalfHeight, -ourThick}, {-ourHalfWidth, ourHalfHeight, -ourThick}, {-ourHalfWidth, -ourHalfHeight, ourThick}, {ourHalfWidth, -ourHalfHeight, ourThick}, {ourHalfWidth, ourHalfHeight, ourThick}, {-ourHalfWidth, ourHalfHeight, ourThick}};
    int[][] myCubeEdges = new int[][]{{0, 1}, {1, 2}, {2, 3}, {3, 0}, {4, 5}, {5, 6}, {6, 7}, {7, 4}, {0, 4}, {1, 5}, {2, 6}, {3, 7}};

    VirtualWidget() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                VirtualWidget.this.setText(VirtualWidget.this.myString);
            }
        });
    }

    public void setText(String text) {
        this.myString = text;
        this.myTextPath = this.getPoints((Graphics2D)this.getGraphics(), text);
        this.myTransformedTextPath = new double[this.myTextPath.length][];
        for (int i = 0; i < this.myTextPath.length; ++i) {
            double[] point = this.myTextPath[i];
            this.myTransformedTextPath[i] = new double[point.length];
        }
        this.update();
    }

    double[][] getPoints(Graphics2D g, String str) {
        double[] point = new double[6];
        Font font = g.getFont();
        if (font == null) {
            return new double[0][0];
        }
        FontRenderContext frc = g.getFontRenderContext();
        Rectangle2D bounds2 = g.getFontMetrics().getStringBounds(str, g);
        double offx = -bounds2.getWidth() / 2.0;
        double offy = g.getFontMetrics().getDescent();
        double scale = this.ourTextPercent / (bounds2.getWidth() / 2.0);
        if (frc == null) {
            return new double[0][0];
        }
        GlyphVector gv = font.createGlyphVector(frc, str);
        ArrayList<double[]> points = new ArrayList<double[]>();
        double last_move_x = 0.0;
        double last_move_y = 0.0;
        int length = gv.getNumGlyphs();
        for (int i = 0; i < length; ++i) {
            Shape outline = gv.getGlyphOutline(i);
            PathIterator iter = outline.getPathIterator(null, 1.0E-4);
            while (!iter.isDone()) {
                int type = iter.currentSegment(point);
                if (type == 1) {
                    points.add(new double[]{(point[0] + offx) * scale, (point[1] + offy) * scale, -ourThick});
                } else if (type == 0) {
                    points.add(new double[0]);
                    points.add(new double[]{(point[0] + offx) * scale, (point[1] + offy) * scale, -ourThick});
                    last_move_x = (point[0] + offx) * scale;
                    last_move_y = (point[1] + offy) * scale;
                } else if (type == 4) {
                    points.add(new double[0]);
                    points.add(new double[]{(point[0] + offx) * scale, (point[1] + offy) * scale, -ourThick});
                    points.add(new double[]{last_move_x, last_move_y, -ourThick});
                }
                iter.next();
            }
        }
        return (double[][])points.toArray((T[])new double[0][]);
    }

    private void update() {
        this.myMatrix.setRots(this.myRotateX, this.myRotateY, this.myRotate);
        this.myMatrix.transform(this.myCubeVertex, this.myTransformedVertex);
        if (this.myTextPath != null) {
            this.myMatrix.transform(this.myTextPath, this.myTransformedTextPath);
        }
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int w = this.getWidth();
        int h = this.getHeight();
        double ss = (double)(2 * Math.min(w, h)) * ourFillFactor;
        Color c = g.getColor();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, w, h);
        g.setColor(c);
        AffineTransform af = new AffineTransform();
        Graphics2D g2d = (Graphics2D)g.create();
        AffineTransform tx = new AffineTransform();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        for (int i = 0; i < this.myCubeEdges.length; ++i) {
            int[] index = this.myCubeEdges[i];
            double[] p1 = this.myTransformedVertex[index[0]];
            double[] p2 = this.myTransformedVertex[index[1]];
            double s1 = ss / (4.0 + p1[2]);
            int p1x = w / 2 + (int)(p1[0] * s1);
            int p1y = h / 2 + (int)(p1[1] * s1);
            double s2 = ss / (4.0 + p2[2]);
            int p2x = w / 2 + (int)(p2[0] * s2);
            int p2y = h / 2 + (int)(p2[1] * s2);
            g2d.drawLine(p1x, p1y, p2x, p2y);
        }
        this.mGeneralPath.reset();
        boolean moveto = true;
        if (this.myTransformedTextPath != null) {
            for (int i = 0; i < this.myTransformedTextPath.length; ++i) {
                double[] p = this.myTransformedTextPath[i];
                if (p.length != 3) {
                    moveto = true;
                    continue;
                }
                double s2 = ss / (4.0 + p[2]);
                double p2x = (double)((float)w / 2.0f) + p[0] * s2;
                double p2y = (double)((float)h / 2.0f) + p[1] * s2;
                if (moveto) {
                    this.mGeneralPath.moveTo(p2x, p2y);
                } else {
                    this.mGeneralPath.lineTo(p2x, p2y);
                }
                moveto = false;
            }
            g2d.draw(this.mGeneralPath);
        }
    }

    public void setRotate(double value) {
        this.myRotate = Math.toRadians(value);
        this.update();
    }

    public void setRotateX(double value) {
        this.myRotateX = -Math.toRadians(value);
        this.update();
    }

    public void setRotateY(double value) {
        this.myRotateY = -Math.toRadians(value);
        this.update();
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("test Trackball");
        f.setDefaultCloseOperation(3);
        JPanel base = new JPanel(new BorderLayout());
        JPanel control = new JPanel();
        control.setLayout(new BoxLayout(control, 3));
        base.add((Component)control, "South");
        final VirtualWidget virtualWidget = new VirtualWidget();
        base.add(virtualWidget);
        final JSlider rot = new JSlider(-360, 360, 0);
        final JSlider rotX = new JSlider(-360, 360, 0);
        final JSlider rotY = new JSlider(-360, 360, 0);
        final JLabel rotLabel = new JLabel("0");
        final JLabel rotYLabel = new JLabel("0");
        final JLabel rotXLabel = new JLabel("0");
        rotLabel.setPreferredSize(new Dimension(40, 20));
        rotYLabel.setPreferredSize(new Dimension(40, 20));
        rotXLabel.setPreferredSize(new Dimension(40, 20));
        control.add(new JLabel("Rotation"));
        JPanel controlRotationX = new JPanel();
        controlRotationX.setLayout(new BoxLayout(controlRotationX, 2));
        controlRotationX.add(new JLabel("   X"));
        controlRotationX.add(rotX);
        controlRotationX.add(rotXLabel);
        control.add(controlRotationX);
        JPanel controlRotationY = new JPanel();
        controlRotationY.setLayout(new BoxLayout(controlRotationY, 2));
        controlRotationY.add(new JLabel("   Y"));
        controlRotationY.add(rotY);
        controlRotationY.add(rotYLabel);
        control.add(controlRotationY);
        JPanel controlRotationZ = new JPanel();
        controlRotationZ.setLayout(new BoxLayout(controlRotationZ, 2));
        controlRotationZ.add(new JLabel("   Z"));
        controlRotationZ.add(rot);
        controlRotationZ.add(rotLabel);
        control.add(controlRotationZ);
        virtualWidget.setBackground(Color.BLACK);
        virtualWidget.setForeground(Color.GREEN);
        rot.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                rotLabel.setText("" + rot.getValue());
                virtualWidget.setRotate(rot.getValue());
            }
        });
        rotX.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                rotXLabel.setText("" + rotX.getValue());
                virtualWidget.setRotateX(rotX.getValue());
            }
        });
        rotY.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                rotYLabel.setText("" + rotY.getValue());
                virtualWidget.setRotateY(rotY.getValue());
            }
        });
        f.setContentPane(base);
        f.setBounds(100, 100, 280, 400);
        f.setVisible(true);
    }

    static class Matrix {
        double[] m = new double[16];
        double[] scratch = new double[16];

        Matrix() {
        }

        void unit() {
            for (int i = 0; i < this.m.length; ++i) {
                this.m[i] = i % 4 == i / 4 ? 1.0 : 0.0;
            }
        }

        void mult(double[] m2) {
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    this.scratch[i + 4 * j] = 0.0;
                    for (int k = 0; k < 4; ++k) {
                        int n = i + 4 * j;
                        this.scratch[n] = this.scratch[n] + this.m[i + 4 * k] * m2[k + 4 * j];
                    }
                }
            }
            double[] swap = this.m;
            this.m = this.scratch;
            this.scratch = swap;
        }

        void addRotZ(double angle) {
            double s = Math.sin(angle);
            double c = Math.cos(angle);
            double[] yaw = new double[]{c, -s, 0.0, 0.0, s, c, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0};
            this.mult(yaw);
        }

        void addRotY(double angle) {
            double s = Math.sin(angle);
            double c = Math.cos(angle);
            double[] pitch = new double[]{c, 0.0, s, 0.0, 0.0, 1.0, 0.0, 0.0, -s, 0.0, c, 0.0, 0.0, 0.0, 0.0, 1.0};
            this.mult(pitch);
        }

        void addRotX(double angle) {
            double s = Math.sin(angle);
            double c = Math.cos(angle);
            double[] roll = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, c, -s, 0.0, 0.0, s, c, 0.0, 0.0, 0.0, 0.0, 1.0};
            this.mult(roll);
        }

        void setRots(double x, double y, double z) {
            this.unit();
            this.addRotZ(z);
            this.addRotY(y);
            this.addRotX(x);
        }

        void transform(double[][] src, double[][] dest) {
            for (int k = 0; k < src.length; ++k) {
                if (src[k].length != 3) continue;
                for (int i = 0; i < 3; ++i) {
                    int col = i * 4;
                    double sum = 0.0;
                    for (int j = 0; j < 3; ++j) {
                        sum += this.m[col + j] * src[k][j];
                    }
                    dest[k][i] = sum + this.m[col + 3];
                }
            }
        }
    }
}

