/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.model;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlComponentMixin;
import com.android.tools.idea.uibuilder.model.PreferenceUtils;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/uibuilder/model/NlComponentHelper;", "", "<init>", "()V", "TAGS_THAT_DONT_NEED_DEFAULT_IDS", "", "", "getTAGS_THAT_DONT_NEED_DEFAULT_IDS", "()Ljava/util/Collection;", "TAGS_THAT_DONT_NEED_LAYOUT_ATTRIBUTES", "viewClassToTag", "fqcn", "viewNeedsPackage", "", "hasNlComponentInfo", "component", "Lcom/android/tools/idea/common/model/NlComponent;", "needsLayoutAttributes", "intellij.android.designer"})
@StabilityInferred(parameters=0)
public final class NlComponentHelper {
    @NotNull
    public static final NlComponentHelper INSTANCE = new NlComponentHelper();
    @NotNull
    private static final Collection<String> TAGS_THAT_DONT_NEED_DEFAULT_IDS;
    @NotNull
    private static final Collection<String> TAGS_THAT_DONT_NEED_LAYOUT_ATTRIBUTES;
    public static final int $stable;

    private NlComponentHelper() {
    }

    @NotNull
    public final Collection<String> getTAGS_THAT_DONT_NEED_DEFAULT_IDS() {
        return TAGS_THAT_DONT_NEED_DEFAULT_IDS;
    }

    @NotNull
    public final String viewClassToTag(@NotNull String fqcn) {
        Intrinsics.checkNotNullParameter((Object)fqcn, (String)"fqcn");
        if (!this.viewNeedsPackage(fqcn)) {
            String string = fqcn.substring(StringsKt.lastIndexOf$default((CharSequence)fqcn, (char)'.', (int)0, (boolean)false, (int)6, null) + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return string;
        }
        return fqcn;
    }

    private final boolean viewNeedsPackage(String fqcn) {
        return !StringsKt.startsWith$default((String)fqcn, (String)"android.widget.", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)fqcn, (String)"android.view.", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)fqcn, (String)"android.webkit.", (boolean)false, (int)2, null);
    }

    public final boolean hasNlComponentInfo(@NotNull NlComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        return component.getMixin() instanceof NlComponentMixin;
    }

    public final boolean needsLayoutAttributes(@NotNull NlComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        return !TAGS_THAT_DONT_NEED_LAYOUT_ATTRIBUTES.contains(component.getTagName());
    }

    static {
        ImmutableSet immutableSet = new ImmutableSet.Builder().add((Object)"requestFocus").add((Object)"Space").add((Object)"item").add((Object)"include").add((Object)"merge").addAll((Iterable)PreferenceUtils.VALUES).build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"build(...)");
        TAGS_THAT_DONT_NEED_DEFAULT_IDS = (Collection)immutableSet;
        ImmutableSet immutableSet2 = new ImmutableSet.Builder().add((Object)"item").add((Object)"include").add((Object)"merge").addAll((Iterable)PreferenceUtils.VALUES).build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet2, (String)"build(...)");
        TAGS_THAT_DONT_NEED_LAYOUT_ATTRIBUTES = (Collection)immutableSet2;
        $stable = 8;
    }
}

