/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.relative.draw;

import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintUtilities;
import com.android.tools.idea.uibuilder.handlers.relative.draw.Connection;
import com.android.tools.idea.uibuilder.handlers.relative.draw.DrawHorizontalArrowCommand;
import com.android.tools.idea.uibuilder.handlers.relative.draw.DrawVerticalDashedLineCommand;
import com.android.tools.idea.uibuilder.handlers.relative.draw.EdgeSide;
import com.android.tools.idea.uibuilder.handlers.relative.draw.RelativeLayoutDecoratorKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/uibuilder/handlers/relative/draw/HorizontalWidgetConnectoin;", "Lcom/android/tools/idea/uibuilder/handlers/relative/draw/Connection;", "component", "Lcom/android/tools/idea/common/scene/SceneComponent;", "componentSide", "Lcom/android/tools/idea/uibuilder/handlers/relative/draw/EdgeSide;", "source", "sourceSide", "<init>", "(Lcom/android/tools/idea/common/scene/SceneComponent;Lcom/android/tools/idea/uibuilder/handlers/relative/draw/EdgeSide;Lcom/android/tools/idea/common/scene/SceneComponent;Lcom/android/tools/idea/uibuilder/handlers/relative/draw/EdgeSide;)V", "getComponent", "()Lcom/android/tools/idea/common/scene/SceneComponent;", "getComponentSide", "()Lcom/android/tools/idea/uibuilder/handlers/relative/draw/EdgeSide;", "getSource", "getSourceSide", "addDrawCommand", "", "list", "Lcom/android/tools/idea/common/scene/draw/DisplayList;", "time", "", "sceneContext", "Lcom/android/tools/idea/common/scene/SceneContext;", "intellij.android.designer"})
final class HorizontalWidgetConnectoin
implements Connection {
    @NotNull
    private final SceneComponent component;
    @NotNull
    private final EdgeSide componentSide;
    @NotNull
    private final SceneComponent source;
    @NotNull
    private final EdgeSide sourceSide;

    public HorizontalWidgetConnectoin(@NotNull SceneComponent component, @NotNull EdgeSide componentSide, @NotNull SceneComponent source, @NotNull EdgeSide sourceSide) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)((Object)componentSide), (String)"componentSide");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)((Object)sourceSide), (String)"sourceSide");
        this.component = component;
        this.componentSide = componentSide;
        this.source = source;
        this.sourceSide = sourceSide;
    }

    @NotNull
    public final SceneComponent getComponent() {
        return this.component;
    }

    @NotNull
    public final EdgeSide getComponentSide() {
        return this.componentSide;
    }

    @NotNull
    public final SceneComponent getSource() {
        return this.source;
    }

    @NotNull
    public final EdgeSide getSourceSide() {
        return this.sourceSide;
    }

    @Override
    public void addDrawCommand(@NotNull DisplayList list, long time, @NotNull SceneContext sceneContext) {
        String margin;
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)sceneContext, (String)"sceneContext");
        int arrowX1 = this.componentSide == EdgeSide.LEFT ? RelativeLayoutDecoratorKt.access$getLeft(this.component, time) : RelativeLayoutDecoratorKt.access$getRight(this.component, time);
        int arrowX2 = this.sourceSide == EdgeSide.LEFT ? RelativeLayoutDecoratorKt.access$getLeft(this.source, time) : RelativeLayoutDecoratorKt.access$getRight(this.source, time);
        int arrowY = RelativeLayoutDecoratorKt.access$getDrawCenterY(this.component, time);
        String string = margin = this.componentSide == EdgeSide.LEFT ? RelativeLayoutDecoratorKt.access$retrieveLeftMarginAttribute(this.component) : RelativeLayoutDecoratorKt.access$retrieveRightMarginAttribute(this.component);
        boolean isReference = string != null ? StringsKt.startsWith$default((String)string, (String)"@", (boolean)false, (int)2, null) : false;
        int marginDp = ConstraintUtilities.getDpValue(this.component.getAuthoritativeNlComponent(), margin);
        String displayedMarginText = marginDp != 0 ? String.valueOf(marginDp) : "";
        list.add(new DrawHorizontalArrowCommand(sceneContext, arrowX1, arrowX2, arrowY, isReference, displayedMarginText));
        if (!Intrinsics.areEqual((Object)this.source, (Object)this.component.getParent())) {
            int lineY1 = Math.min(RelativeLayoutDecoratorKt.access$getTop(this.source, time), RelativeLayoutDecoratorKt.access$getTop(this.component, time));
            int lineY2 = Math.max(RelativeLayoutDecoratorKt.access$getBottom(this.source, time), RelativeLayoutDecoratorKt.access$getBottom(this.component, time));
            list.add(new DrawVerticalDashedLineCommand(sceneContext, arrowX2, lineY1, lineY2));
        }
    }
}

