/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.preference;

import com.android.ide.common.rendering.api.ViewInfo;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ViewInfoUtils {
    private ViewInfoUtils() {
    }

    @Nullable
    static ViewInfo findViewWithName(@NotNull Collection<ViewInfo> rootViews, @NotNull String name) {
        return rootViews.stream().map(rootView -> ViewInfoUtils.findViewWithName(rootView, name)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Nullable
    private static ViewInfo findViewWithName(@NotNull ViewInfo parent, @NotNull String name) {
        if (parent.getClassName().equals(name)) {
            return parent;
        }
        Optional<ViewInfo> view = parent.getChildren().stream().map(child -> ViewInfoUtils.findViewWithName(child, name)).filter(Objects::nonNull).findFirst();
        return view.orElse(null);
    }
}

