/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.model;

import com.android.tools.idea.uibuilder.handlers.constraint.model.ConstraintAnchor;
import com.android.tools.idea.uibuilder.handlers.constraint.model.ConstraintAnchorConstants;
import java.util.ArrayList;

public class ConstraintWidget {
    public int mHorizontalResolution = -1;
    public int mVerticalResolution = -1;
    int mMatchConstraintDefaultWidth = 0;
    int mMatchConstraintDefaultHeight = 0;
    int mMatchConstraintMinWidth = 0;
    int mMatchConstraintMaxWidth = 0;
    float mMatchConstraintPercentWidth = 1.0f;
    int mMatchConstraintMinHeight = 0;
    int mMatchConstraintMaxHeight = 0;
    float mMatchConstraintPercentHeight = 1.0f;
    int mResolvedDimensionRatioSide = -1;
    float mResolvedDimensionRatio = 1.0f;
    private final int[] mMaxDimension = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE};
    ConstraintAnchor mLeft = new ConstraintAnchor(this, ConstraintAnchorConstants.Type.LEFT);
    ConstraintAnchor mTop = new ConstraintAnchor(this, ConstraintAnchorConstants.Type.TOP);
    ConstraintAnchor mRight = new ConstraintAnchor(this, ConstraintAnchorConstants.Type.RIGHT);
    ConstraintAnchor mBottom = new ConstraintAnchor(this, ConstraintAnchorConstants.Type.BOTTOM);
    ConstraintAnchor mBaseline = new ConstraintAnchor(this, ConstraintAnchorConstants.Type.BASELINE);
    ConstraintAnchor mCenterX = new ConstraintAnchor(this, ConstraintAnchorConstants.Type.CENTER_X);
    ConstraintAnchor mCenterY = new ConstraintAnchor(this, ConstraintAnchorConstants.Type.CENTER_Y);
    ConstraintAnchor mCenter = new ConstraintAnchor(this, ConstraintAnchorConstants.Type.CENTER);
    protected ConstraintAnchor[] mListAnchors = new ConstraintAnchor[]{this.mLeft, this.mRight, this.mTop, this.mBottom, this.mBaseline, this.mCenter};
    protected ArrayList<ConstraintAnchor> mAnchors = new ArrayList();
    static final int DIMENSION_HORIZONTAL = 0;
    static final int DIMENSION_VERTICAL = 1;
    protected DimensionBehaviour[] mListDimensionBehaviors = new DimensionBehaviour[]{DimensionBehaviour.FIXED, DimensionBehaviour.FIXED};
    ConstraintWidget mParent = null;
    int mWidth = 0;
    int mHeight = 0;
    protected float mDimensionRatio = 0.0f;
    protected int mDimensionRatioSide = -1;
    protected int mX = 0;
    protected int mY = 0;
    private int mDrawX = 0;
    private int mDrawY = 0;
    private int mDrawWidth = 0;
    private int mDrawHeight = 0;
    protected int mOffsetX = 0;
    protected int mOffsetY = 0;
    int mBaselineDistance = 0;
    protected int mMinWidth;
    protected int mMinHeight;
    private int mWrapWidth;
    private int mWrapHeight;
    float mHorizontalBiasPercent = 0.5f;
    float mVerticalBiasPercent = 0.5f;
    private int mVisibility = 0;
    private String mDebugName = null;
    private String mType = null;
    boolean mHorizontalWrapVisited;
    boolean mVerticalWrapVisited;
    int mHorizontalChainStyle = 0;
    int mVerticalChainStyle = 0;
    boolean mHorizontalChainFixedPosition;
    boolean mVerticalChainFixedPosition;
    float[] mWeight = new float[]{0.0f, 0.0f};

    public int getMaxHeight() {
        return this.mMaxDimension[1];
    }

    public int getMaxWidth() {
        return this.mMaxDimension[0];
    }

    public void setMaxWidth(int maxWidth) {
        this.mMaxDimension[0] = maxWidth;
    }

    public void setMaxHeight(int maxWidth) {
        this.mMaxDimension[1] = maxWidth;
    }

    public void reset() {
        this.mLeft.reset();
        this.mTop.reset();
        this.mRight.reset();
        this.mBottom.reset();
        this.mBaseline.reset();
        this.mCenterX.reset();
        this.mCenterY.reset();
        this.mCenter.reset();
        this.mParent = null;
        this.mWidth = 0;
        this.mHeight = 0;
        this.mDimensionRatio = 0.0f;
        this.mDimensionRatioSide = -1;
        this.mX = 0;
        this.mY = 0;
        this.mDrawX = 0;
        this.mDrawY = 0;
        this.mDrawWidth = 0;
        this.mDrawHeight = 0;
        this.mOffsetX = 0;
        this.mOffsetY = 0;
        this.mBaselineDistance = 0;
        this.mMinWidth = 0;
        this.mMinHeight = 0;
        this.mWrapWidth = 0;
        this.mWrapHeight = 0;
        this.mHorizontalBiasPercent = 0.5f;
        this.mVerticalBiasPercent = 0.5f;
        this.mListDimensionBehaviors[0] = DimensionBehaviour.FIXED;
        this.mListDimensionBehaviors[1] = DimensionBehaviour.FIXED;
        this.mVisibility = 0;
        this.mDebugName = null;
        this.mType = null;
        this.mHorizontalWrapVisited = false;
        this.mVerticalWrapVisited = false;
        this.mHorizontalChainStyle = 0;
        this.mVerticalChainStyle = 0;
        this.mHorizontalChainFixedPosition = false;
        this.mVerticalChainFixedPosition = false;
        this.mWeight[0] = 0.0f;
        this.mWeight[1] = 0.0f;
        this.mHorizontalResolution = -1;
        this.mVerticalResolution = -1;
        this.mMaxDimension[0] = Integer.MAX_VALUE;
        this.mMaxDimension[1] = Integer.MAX_VALUE;
        this.mMatchConstraintDefaultWidth = 0;
        this.mMatchConstraintDefaultHeight = 0;
        this.mMatchConstraintPercentWidth = 1.0f;
        this.mMatchConstraintPercentHeight = 1.0f;
        this.mMatchConstraintMaxWidth = Integer.MAX_VALUE;
        this.mMatchConstraintMaxHeight = Integer.MAX_VALUE;
        this.mMatchConstraintMinWidth = 0;
        this.mMatchConstraintMinHeight = 0;
        this.mResolvedDimensionRatioSide = -1;
        this.mResolvedDimensionRatio = 1.0f;
    }

    public ConstraintWidget() {
        this.addAnchors();
    }

    private void addAnchors() {
        this.mAnchors.add(this.mLeft);
        this.mAnchors.add(this.mTop);
        this.mAnchors.add(this.mRight);
        this.mAnchors.add(this.mBottom);
        this.mAnchors.add(this.mCenterX);
        this.mAnchors.add(this.mCenterY);
        this.mAnchors.add(this.mCenter);
        this.mAnchors.add(this.mBaseline);
    }

    public boolean isRoot() {
        return this.mParent == null;
    }

    public ConstraintWidget getParent() {
        return this.mParent;
    }

    public void setParent(ConstraintWidget widget) {
        this.mParent = widget;
    }

    public String getType() {
        return this.mType;
    }

    public void setType(String type) {
        this.mType = type;
    }

    public void setVisibility(int visibility) {
        this.mVisibility = visibility;
    }

    public int getVisibility() {
        return this.mVisibility;
    }

    public String getDebugName() {
        return this.mDebugName;
    }

    public void setDebugName(String name) {
        this.mDebugName = name;
    }

    public String toString() {
        return (String)(this.mType != null ? "type: " + this.mType + " " : "") + (String)(this.mDebugName != null ? "id: " + this.mDebugName + " " : "") + "(" + this.mX + ", " + this.mY + ") - (" + this.mWidth + " x " + this.mHeight + ") wrap: (" + this.mWrapWidth + " x " + this.mWrapHeight + ")";
    }

    public int getX() {
        return this.mX;
    }

    public int getY() {
        return this.mY;
    }

    public int getWidth() {
        if (this.mVisibility == 8) {
            return 0;
        }
        return this.mWidth;
    }

    public int getHeight() {
        if (this.mVisibility == 8) {
            return 0;
        }
        return this.mHeight;
    }

    public int getDrawX() {
        return this.mDrawX + this.mOffsetX;
    }

    public int getDrawY() {
        return this.mDrawY + this.mOffsetY;
    }

    public int getDrawWidth() {
        return this.mDrawWidth;
    }

    public int getDrawHeight() {
        return this.mDrawHeight;
    }

    protected int getRootX() {
        return this.mX + this.mOffsetX;
    }

    protected int getRootY() {
        return this.mY + this.mOffsetY;
    }

    public int getMinWidth() {
        return this.mMinWidth;
    }

    public int getMinHeight() {
        return this.mMinHeight;
    }

    public int getLeft() {
        return this.getX();
    }

    public int getTop() {
        return this.getY();
    }

    public int getRight() {
        return this.getX() + this.mWidth;
    }

    public int getBottom() {
        return this.getY() + this.mHeight;
    }

    public boolean hasBaseline() {
        return this.mBaselineDistance > 0;
    }

    public ArrayList<ConstraintAnchor> getAnchors() {
        return this.mAnchors;
    }

    public void setX(int x) {
        this.mX = x;
    }

    public void setY(int y) {
        this.mY = y;
    }

    public void setOffset(int x, int y) {
        this.mOffsetX = x;
        this.mOffsetY = y;
    }

    public void updateDrawPosition() {
        int left = this.mX;
        int top = this.mY;
        int right = this.mX + this.mWidth;
        int bottom = this.mY + this.mHeight;
        this.mDrawX = left;
        this.mDrawY = top;
        this.mDrawWidth = right - left;
        this.mDrawHeight = bottom - top;
    }

    public void setDrawX(int x) {
        this.mX = this.mDrawX = x - this.mOffsetX;
    }

    public void setDrawY(int y) {
        this.mY = this.mDrawY = y - this.mOffsetY;
    }

    public void setDrawWidth(int drawWidth) {
        this.mDrawWidth = drawWidth;
    }

    public void setDrawHeight(int drawHeight) {
        this.mDrawHeight = drawHeight;
    }

    public void setWidth(int w) {
        this.mWidth = w;
        if (this.mWidth < this.mMinWidth) {
            this.mWidth = this.mMinWidth;
        }
    }

    public void setHeight(int h) {
        this.mHeight = h;
        if (this.mHeight < this.mMinHeight) {
            this.mHeight = this.mMinHeight;
        }
    }

    public void setMinWidth(int w) {
        this.mMinWidth = Math.max(w, 0);
    }

    public void setMinHeight(int h) {
        this.mMinHeight = Math.max(h, 0);
    }

    public void connectedTo(ConstraintWidget source) {
    }

    public void connect(ConstraintAnchor from, ConstraintAnchor to, int margin, ConstraintAnchorConstants.Strength strength, int creator) {
        if (from.getOwner() == this) {
            this.connect(from.getType(), to.getOwner(), to.getType(), margin, strength, creator);
        }
    }

    public void connect(ConstraintAnchorConstants.Type constraintFrom, ConstraintWidget target, ConstraintAnchorConstants.Type constraintTo, int margin) {
        this.connect(constraintFrom, target, constraintTo, margin, ConstraintAnchorConstants.Strength.STRONG);
    }

    public void connect(ConstraintAnchorConstants.Type constraintFrom, ConstraintWidget target, ConstraintAnchorConstants.Type constraintTo) {
        this.connect(constraintFrom, target, constraintTo, 0, ConstraintAnchorConstants.Strength.STRONG);
    }

    public void connect(ConstraintAnchorConstants.Type constraintFrom, ConstraintWidget target, ConstraintAnchorConstants.Type constraintTo, int margin, ConstraintAnchorConstants.Strength strength) {
        this.connect(constraintFrom, target, constraintTo, margin, strength, 0);
    }

    public void connect(ConstraintAnchorConstants.Type constraintFrom, ConstraintWidget target, ConstraintAnchorConstants.Type constraintTo, int margin, ConstraintAnchorConstants.Strength strength, int creator) {
        if (constraintFrom == ConstraintAnchorConstants.Type.CENTER) {
            if (constraintTo == ConstraintAnchorConstants.Type.CENTER) {
                ConstraintAnchor left = this.getAnchor(ConstraintAnchorConstants.Type.LEFT);
                ConstraintAnchor right = this.getAnchor(ConstraintAnchorConstants.Type.RIGHT);
                ConstraintAnchor top = this.getAnchor(ConstraintAnchorConstants.Type.TOP);
                ConstraintAnchor bottom = this.getAnchor(ConstraintAnchorConstants.Type.BOTTOM);
                boolean centerX = false;
                boolean centerY = false;
                if (!(left != null && left.isConnected() || right != null && right.isConnected())) {
                    this.connect(ConstraintAnchorConstants.Type.LEFT, target, ConstraintAnchorConstants.Type.LEFT, 0, strength, creator);
                    this.connect(ConstraintAnchorConstants.Type.RIGHT, target, ConstraintAnchorConstants.Type.RIGHT, 0, strength, creator);
                    centerX = true;
                }
                if (!(top != null && top.isConnected() || bottom != null && bottom.isConnected())) {
                    this.connect(ConstraintAnchorConstants.Type.TOP, target, ConstraintAnchorConstants.Type.TOP, 0, strength, creator);
                    this.connect(ConstraintAnchorConstants.Type.BOTTOM, target, ConstraintAnchorConstants.Type.BOTTOM, 0, strength, creator);
                    centerY = true;
                }
                if (centerX && centerY) {
                    ConstraintAnchor center = this.getAnchor(ConstraintAnchorConstants.Type.CENTER);
                    center.connect(target.getAnchor(ConstraintAnchorConstants.Type.CENTER), 0, creator);
                } else if (centerX) {
                    ConstraintAnchor center = this.getAnchor(ConstraintAnchorConstants.Type.CENTER_X);
                    center.connect(target.getAnchor(ConstraintAnchorConstants.Type.CENTER_X), 0, creator);
                } else if (centerY) {
                    ConstraintAnchor center = this.getAnchor(ConstraintAnchorConstants.Type.CENTER_Y);
                    center.connect(target.getAnchor(ConstraintAnchorConstants.Type.CENTER_Y), 0, creator);
                }
            } else if (constraintTo == ConstraintAnchorConstants.Type.LEFT || constraintTo == ConstraintAnchorConstants.Type.RIGHT) {
                this.connect(ConstraintAnchorConstants.Type.LEFT, target, constraintTo, 0, strength, creator);
                this.connect(ConstraintAnchorConstants.Type.RIGHT, target, constraintTo, 0, strength, creator);
                ConstraintAnchor center = this.getAnchor(ConstraintAnchorConstants.Type.CENTER);
                center.connect(target.getAnchor(constraintTo), 0, creator);
            } else if (constraintTo == ConstraintAnchorConstants.Type.TOP || constraintTo == ConstraintAnchorConstants.Type.BOTTOM) {
                this.connect(ConstraintAnchorConstants.Type.TOP, target, constraintTo, 0, strength, creator);
                this.connect(ConstraintAnchorConstants.Type.BOTTOM, target, constraintTo, 0, strength, creator);
                ConstraintAnchor center = this.getAnchor(ConstraintAnchorConstants.Type.CENTER);
                center.connect(target.getAnchor(constraintTo), 0, creator);
            }
        } else if (constraintFrom == ConstraintAnchorConstants.Type.CENTER_X && (constraintTo == ConstraintAnchorConstants.Type.LEFT || constraintTo == ConstraintAnchorConstants.Type.RIGHT)) {
            ConstraintAnchor left = this.getAnchor(ConstraintAnchorConstants.Type.LEFT);
            ConstraintAnchor targetAnchor = target.getAnchor(constraintTo);
            ConstraintAnchor right = this.getAnchor(ConstraintAnchorConstants.Type.RIGHT);
            left.connect(targetAnchor, 0, creator);
            right.connect(targetAnchor, 0, creator);
            ConstraintAnchor centerX = this.getAnchor(ConstraintAnchorConstants.Type.CENTER_X);
            centerX.connect(targetAnchor, 0, creator);
        } else if (constraintFrom == ConstraintAnchorConstants.Type.CENTER_Y && (constraintTo == ConstraintAnchorConstants.Type.TOP || constraintTo == ConstraintAnchorConstants.Type.BOTTOM)) {
            ConstraintAnchor targetAnchor = target.getAnchor(constraintTo);
            ConstraintAnchor top = this.getAnchor(ConstraintAnchorConstants.Type.TOP);
            top.connect(targetAnchor, 0, creator);
            ConstraintAnchor bottom = this.getAnchor(ConstraintAnchorConstants.Type.BOTTOM);
            bottom.connect(targetAnchor, 0, creator);
            ConstraintAnchor centerY = this.getAnchor(ConstraintAnchorConstants.Type.CENTER_Y);
            centerY.connect(targetAnchor, 0, creator);
        } else if (constraintFrom == ConstraintAnchorConstants.Type.CENTER_X && constraintTo == ConstraintAnchorConstants.Type.CENTER_X) {
            ConstraintAnchor left = this.getAnchor(ConstraintAnchorConstants.Type.LEFT);
            ConstraintAnchor leftTarget = target.getAnchor(ConstraintAnchorConstants.Type.LEFT);
            left.connect(leftTarget, 0, creator);
            ConstraintAnchor right = this.getAnchor(ConstraintAnchorConstants.Type.RIGHT);
            ConstraintAnchor rightTarget = target.getAnchor(ConstraintAnchorConstants.Type.RIGHT);
            right.connect(rightTarget, 0, creator);
            ConstraintAnchor centerX = this.getAnchor(ConstraintAnchorConstants.Type.CENTER_X);
            centerX.connect(target.getAnchor(constraintTo), 0, creator);
        } else if (constraintFrom == ConstraintAnchorConstants.Type.CENTER_Y && constraintTo == ConstraintAnchorConstants.Type.CENTER_Y) {
            ConstraintAnchor top = this.getAnchor(ConstraintAnchorConstants.Type.TOP);
            ConstraintAnchor topTarget = target.getAnchor(ConstraintAnchorConstants.Type.TOP);
            top.connect(topTarget, 0, creator);
            ConstraintAnchor bottom = this.getAnchor(ConstraintAnchorConstants.Type.BOTTOM);
            ConstraintAnchor bottomTarget = target.getAnchor(ConstraintAnchorConstants.Type.BOTTOM);
            bottom.connect(bottomTarget, 0, creator);
            ConstraintAnchor centerY = this.getAnchor(ConstraintAnchorConstants.Type.CENTER_Y);
            centerY.connect(target.getAnchor(constraintTo), 0, creator);
        } else {
            ConstraintAnchor toAnchor;
            ConstraintAnchor fromAnchor = this.getAnchor(constraintFrom);
            if (fromAnchor.isValidConnection(toAnchor = target.getAnchor(constraintTo))) {
                if (constraintFrom == ConstraintAnchorConstants.Type.BASELINE) {
                    ConstraintAnchor top = this.getAnchor(ConstraintAnchorConstants.Type.TOP);
                    ConstraintAnchor bottom = this.getAnchor(ConstraintAnchorConstants.Type.BOTTOM);
                    if (top != null) {
                        top.reset();
                    }
                    if (bottom != null) {
                        bottom.reset();
                    }
                    margin = 0;
                } else if (constraintFrom == ConstraintAnchorConstants.Type.TOP || constraintFrom == ConstraintAnchorConstants.Type.BOTTOM) {
                    ConstraintAnchor center;
                    ConstraintAnchor baseline = this.getAnchor(ConstraintAnchorConstants.Type.BASELINE);
                    if (baseline != null) {
                        baseline.reset();
                    }
                    if ((center = this.getAnchor(ConstraintAnchorConstants.Type.CENTER)).getTarget() != toAnchor) {
                        center.reset();
                    }
                    ConstraintAnchor opposite = this.getAnchor(constraintFrom).getOpposite();
                    ConstraintAnchor centerY = this.getAnchor(ConstraintAnchorConstants.Type.CENTER_Y);
                    if (centerY.isConnected()) {
                        if (opposite != null) {
                            opposite.reset();
                        }
                        centerY.reset();
                    }
                } else if (constraintFrom == ConstraintAnchorConstants.Type.LEFT || constraintFrom == ConstraintAnchorConstants.Type.RIGHT) {
                    ConstraintAnchor center = this.getAnchor(ConstraintAnchorConstants.Type.CENTER);
                    if (center.getTarget() != toAnchor) {
                        center.reset();
                    }
                    ConstraintAnchor opposite = this.getAnchor(constraintFrom).getOpposite();
                    ConstraintAnchor centerX = this.getAnchor(ConstraintAnchorConstants.Type.CENTER_X);
                    if (centerX.isConnected()) {
                        if (opposite != null) {
                            opposite.reset();
                        }
                        centerX.reset();
                    }
                }
                fromAnchor.connect(toAnchor, margin, strength, creator);
                toAnchor.getOwner().connectedTo(fromAnchor.getOwner());
            }
        }
    }

    public ConstraintAnchor getAnchor(ConstraintAnchorConstants.Type anchorType) {
        switch (anchorType) {
            case LEFT: {
                return this.mLeft;
            }
            case TOP: {
                return this.mTop;
            }
            case RIGHT: {
                return this.mRight;
            }
            case BOTTOM: {
                return this.mBottom;
            }
            case BASELINE: {
                return this.mBaseline;
            }
            case CENTER_X: {
                return this.mCenterX;
            }
            case CENTER_Y: {
                return this.mCenterY;
            }
            case CENTER: {
                return this.mCenter;
            }
            case NONE: {
                return null;
            }
        }
        throw new AssertionError((Object)anchorType.name());
    }

    public static enum DimensionBehaviour {
        FIXED,
        WRAP_CONTENT,
        MATCH_CONSTRAINT,
        MATCH_PARENT;

    }
}

