/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.draw.ColorSet;
import com.android.tools.idea.common.scene.target.AnchorTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.ComponentModification;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintUtilities;
import com.android.tools.idea.uibuilder.handlers.constraint.MarginWidget;
import com.android.tools.idea.uibuilder.handlers.constraint.WidgetConstraintModel;
import com.android.tools.idea.uibuilder.handlers.constraint.model.ConstraintAnchorConstants;
import com.android.tools.idea.uibuilder.scout.Scout;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class SingleWidgetView
extends JPanel {
    private static final int RATIO_UNLOCK = 0;
    private static final int RATIO_LOCK = 1;
    private static final int RATIO_LOCK_HEIGHT = 2;
    private static final int RATIO_LOCK_WIDTH = 3;
    public static final String TOP_MARGIN_WIDGET = "topMarginWidget";
    public static final String LEFT_MARGIN_WIDGET = "leftMarginWidget";
    public static final String BOTTOM_MARGIN_WIDGET = "bottomMarginWidget";
    public static final String RIGHT_MARGIN_WIDGET = "rightMarginWidget";
    private static final int ASPECT_BUTTON_BOX_SIZE_RATIO = 6;
    private static final int MIDDLE_SPACE = 6;
    private static final int CONSTRAINT_LENGTH = 9;
    private static final int CONSTRAINT_WIDTH = 4;
    private static final int CONSTRAINT_COMPONENT_WIDTH = 200;
    private static final int CONSTRAINT_COMPONENT_HEIGHT = 30;
    private static final int CIRCLE_CONTROL_RADIUS = 5;
    private static final int KILL_BUTTON_SIZE = 5;
    private static final int CONSTRAINT_PATTERN_SIZE = 2;
    private static final int DROP_DOWN_WIDTH = 66;
    private static final int DROP_DOWN_HEIGHT = 25;
    private static final int DROPDOWN_OFFSET = 12;
    public static final int BOX_SIZE = 60;
    public static final int MATCH_CONSTRAINT = 1;
    public static final int WRAP_CONTENT = 2;
    public static final int FIXED = 0;
    public static final int UNCONNECTED = -1;
    private final ColorSet mColorSet;
    private boolean mCacheBaseline;
    private int mCacheWidth;
    private int mCacheHeight;
    private String mRatioString;
    private float mDimensionRatio;
    private int mDimensionRatioSide;
    private int mRatioHeight;
    private int mRatioWidth;
    private int mRatioLock;
    private int mWidth;
    private int mHeight;
    private final WidgetRender mWidgetRender = new WidgetRender();
    private final ArrayList<Graphic> mGraphicList = new ArrayList();
    private MarginWidget mTopMargin;
    private MarginWidget mLeftMargin;
    private MarginWidget mRightMargin;
    private MarginWidget mBottomMargin;
    private HConstraintDisplay mHbar1;
    private HConstraintDisplay mHbar2;
    private VConstraintDisplay mVbar1;
    private VConstraintDisplay mVbar2;
    private ConnectButton mTopConnect;
    private ConnectButton mLeftConnect;
    private ConnectButton mRightConnect;
    private ConnectButton mBottomConnect;
    private KillButton mTopKill;
    private KillButton mLeftKill;
    private KillButton mRightKill;
    private KillButton mBottomKill;
    private KillButton mBaselineKill;
    private AspectButton mAspectButton;
    private JLabel mAspectLabel;
    private JTextField mAspectText;
    private WidgetConstraintModel myWidgetModel;
    private boolean myInitialized;
    private final String[] statusString = new String[]{"Fixed", "Match Constraints", "Wrap Content"};
    private static final int CONNECT_BUTTON_RADIUS = 7;
    public static final int BAR_OUTSIDE_MARGINS = 9;
    private static final int[][] ratios = new int[][]{{1, 1}, {4, 3}, {3, 2}, {5, 3}, {16, 9}, {2, 1}, {21, 9}, {5, 2}, {3, 1}, {4, 1}};

    public SingleWidgetView(@NotNull ColorSet colorSet, @NotNull WidgetConstraintModel widgetModel) {
        super(null);
        this.mColorSet = colorSet;
        this.myWidgetModel = widgetModel;
        this.mTopMargin = new MarginWidget(TOP_MARGIN_WIDGET, "Top Margin");
        this.mLeftMargin = new MarginWidget(LEFT_MARGIN_WIDGET, "Left Margin");
        this.mRightMargin = new MarginWidget(RIGHT_MARGIN_WIDGET, "Right Margin");
        this.mBottomMargin = new MarginWidget(BOTTOM_MARGIN_WIDGET, "Bottom Margin");
        this.mHbar1 = new HConstraintDisplay(this.mColorSet, true);
        this.mHbar2 = new HConstraintDisplay(this.mColorSet, false);
        this.mVbar1 = new VConstraintDisplay(this.mColorSet, true);
        this.mVbar2 = new VConstraintDisplay(this.mColorSet, false);
        this.mTopKill = new KillButton(this.mColorSet);
        this.mLeftKill = new KillButton(this.mColorSet);
        this.mRightKill = new KillButton(this.mColorSet);
        this.mBottomKill = new KillButton(this.mColorSet);
        this.mBaselineKill = new KillButton(this.mColorSet);
        this.mTopConnect = new ConnectButton();
        this.mLeftConnect = new ConnectButton();
        this.mRightConnect = new ConnectButton();
        this.mBottomConnect = new ConnectButton();
        this.mAspectButton = new AspectButton(this.mColorSet);
        this.mAspectText = new JTextField();
        this.mAspectLabel = new JLabel("ratio");
        this.mTopKill.setToolTipText(AnchorTarget.createAnchorToolTips(AnchorTarget.Type.TOP, false, false, false));
        this.mLeftKill.setToolTipText(AnchorTarget.createAnchorToolTips(AnchorTarget.Type.LEFT, false, false, false));
        this.mRightKill.setName("deleteRightConstraintButton");
        this.mRightKill.setToolTipText(AnchorTarget.createAnchorToolTips(AnchorTarget.Type.RIGHT, false, false, false));
        this.mBottomKill.setToolTipText(AnchorTarget.createAnchorToolTips(AnchorTarget.Type.BOTTOM, false, false, false));
        this.mBaselineKill.setToolTipText(AnchorTarget.createAnchorToolTips(AnchorTarget.Type.BASELINE, false, false, false));
        this.mTopConnect.setToolTipText(AnchorTarget.createAnchorToolTips(AnchorTarget.Type.TOP, true, false, false));
        this.mLeftConnect.setToolTipText(AnchorTarget.createAnchorToolTips(AnchorTarget.Type.LEFT, true, false, false));
        this.mRightConnect.setToolTipText(AnchorTarget.createAnchorToolTips(AnchorTarget.Type.RIGHT, true, false, false));
        this.mBottomConnect.setToolTipText(AnchorTarget.createAnchorToolTips(AnchorTarget.Type.BOTTOM, true, false, false));
        this.mAspectButton.setToolTipText("Toggle Aspect Ratio Constraint");
        this.mHbar1.setSister(this.mHbar2);
        this.mHbar2.setSister(this.mHbar1);
        this.mVbar1.setSister(this.mVbar2);
        this.mVbar2.setSister(this.mVbar1);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                SingleWidgetView.this.resize();
            }
        });
        this.add(this.mTopMargin);
        this.add(this.mLeftMargin);
        this.add(this.mRightMargin);
        this.add(this.mBottomMargin);
        this.mTopMargin.addActionListener(e -> this.myWidgetModel.setMargin(2, this.mTopMargin.getMargin(this.myWidgetModel.getComponent())));
        this.mLeftMargin.addActionListener(e -> this.myWidgetModel.setMargin(0, this.mLeftMargin.getMargin(this.myWidgetModel.getComponent())));
        this.mRightMargin.addActionListener(e -> this.myWidgetModel.setMargin(1, this.mRightMargin.getMargin(this.myWidgetModel.getComponent())));
        this.mBottomMargin.addActionListener(e -> this.myWidgetModel.setMargin(3, this.mBottomMargin.getMargin(this.myWidgetModel.getComponent())));
        this.add(this.mTopKill);
        this.add(this.mLeftKill);
        this.add(this.mRightKill);
        this.add(this.mBottomKill);
        this.add(this.mTopConnect);
        this.add(this.mLeftConnect);
        this.add(this.mRightConnect);
        this.add(this.mBottomConnect);
        this.add(this.mBaselineKill);
        this.add(this.mAspectButton);
        this.add(this.mAspectText);
        this.add(this.mAspectLabel);
        this.add(this.mHbar1);
        this.add(this.mHbar2);
        this.add(this.mVbar1);
        this.add(this.mVbar2);
        this.mTopKill.addActionListener(e -> this.topKill());
        this.mLeftKill.addActionListener(e -> this.leftKill());
        this.mRightKill.addActionListener(e -> this.rightKill());
        this.mBottomKill.addActionListener(e -> this.bottomKill());
        this.mBaselineKill.addActionListener(e -> this.baselineKill());
        this.mTopConnect.addActionListener(e -> this.connectConstraint(2));
        this.mLeftConnect.addActionListener(e -> this.connectConstraint(0));
        this.mRightConnect.addActionListener(e -> this.connectConstraint(1));
        this.mBottomConnect.addActionListener(e -> this.connectConstraint(3));
        this.mAspectButton.addActionListener(e -> this.toggleAspect());
        this.mAspectText.addActionListener(e -> this.setAspectString());
        this.mAspectText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                SingleWidgetView.this.setAspectString();
            }
        });
        this.mHbar1.addPropertyChangeListener("state", e -> this.setHorizontalState(this.mHbar1));
        this.mHbar2.addPropertyChangeListener("state", e -> this.setHorizontalState(this.mHbar2));
        this.mVbar1.addPropertyChangeListener("state", e -> this.setVerticalState(this.mVbar1));
        this.mVbar2.addPropertyChangeListener("state", e -> this.setVerticalState(this.mVbar2));
        ConstraintUtilities.registerAttributeHelp(this.mTopMargin, () -> this.myWidgetModel.getMarginAttribute(2));
        ConstraintUtilities.registerAttributeHelp(this.mBottomMargin, () -> this.myWidgetModel.getMarginAttribute(3));
        ConstraintUtilities.registerAttributeHelp(this.mLeftMargin, () -> this.myWidgetModel.getMarginAttribute(0));
        ConstraintUtilities.registerAttributeHelp(this.mRightMargin, () -> this.myWidgetModel.getMarginAttribute(1));
        this.mGraphicList.add(this.mWidgetRender);
        this.myInitialized = true;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.myInitialized) {
            this.resize();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new JBDimension(216, 134);
    }

    private void setAspectString() {
        String sideRatioString = "";
        if (this.mRatioString != null && this.mRatioString.contains(",")) {
            sideRatioString = this.mRatioString.substring(0, this.mRatioString.indexOf(44) + 1);
        }
        this.mRatioString = sideRatioString + this.mAspectText.getText();
        this.myWidgetModel.setAspect(this.mRatioString);
    }

    private static String getRatioPart(String str) {
        if (str == null) {
            return "1:1";
        }
        int index = str.indexOf(44);
        if (index == -1) {
            return str;
        }
        return str.substring(index + 1);
    }

    private void toggleAspect() {
        int[] order = new int[4];
        int count = 0;
        order[count++] = 0;
        if (this.mCacheHeight == 1 && this.mCacheWidth == 1) {
            order[count++] = 1;
        }
        if (this.mCacheHeight == 1) {
            order[count++] = 2;
        }
        if (this.mCacheWidth == 1) {
            order[count++] = 3;
        }
        int lock = 0;
        for (int i = 0; i < count; ++i) {
            if (this.mRatioLock != order[i]) continue;
            lock = order[(i + 1) % count];
            break;
        }
        this.mRatioLock = lock;
        switch (this.mRatioLock) {
            case 3: {
                this.mRatioString = "w," + SingleWidgetView.getRatioPart(this.mRatioString);
                break;
            }
            case 1: {
                this.mRatioString = SingleWidgetView.getRatioPart(this.mRatioString);
                break;
            }
            case 2: {
                this.mRatioString = "h," + SingleWidgetView.getRatioPart(this.mRatioString);
                break;
            }
            case 0: {
                this.mRatioString = null;
            }
        }
        this.myWidgetModel.setAspect(this.mRatioString);
    }

    private void setHorizontalState(HConstraintDisplay state) {
        if (state == this.mHbar1) {
            this.mHbar2.setState(state.getState());
        } else {
            this.mHbar1.setState(state.getState());
        }
        this.updateTriangle();
        this.mHbar1.setToolTipText(this.statusString[state.getState()]);
        this.mHbar2.setToolTipText(this.statusString[state.getState()]);
        this.myWidgetModel.setHorizontalConstraint(state.getState());
    }

    private void setVerticalState(VConstraintDisplay state) {
        if (state == this.mVbar1) {
            this.mVbar2.setState(state.getState());
        } else {
            this.mVbar1.setState(state.getState());
        }
        this.updateTriangle();
        this.mVbar1.setToolTipText(this.statusString[state.getState()]);
        this.mVbar2.setToolTipText(this.statusString[state.getState()]);
        this.myWidgetModel.setVerticalConstraint(state.getState());
    }

    private void updateTriangle() {
        boolean show2 = this.mVbar1.getState() == 1 || this.mHbar1.getState() == 1;
        this.mWidgetRender.mAspectLock.setShowTriangle(show2);
    }

    private void topKill() {
        this.myWidgetModel.killConstraint(ConstraintAnchorConstants.Type.TOP);
    }

    private void leftKill() {
        this.myWidgetModel.killConstraint(ConstraintAnchorConstants.Type.LEFT);
    }

    private void rightKill() {
        this.myWidgetModel.killConstraint(ConstraintAnchorConstants.Type.RIGHT);
    }

    private void bottomKill() {
        this.myWidgetModel.killConstraint(ConstraintAnchorConstants.Type.BOTTOM);
    }

    private void baselineKill() {
        this.myWidgetModel.killBaselineConstraint();
        this.mCacheBaseline = false;
    }

    private void connectConstraint(int connectionType) {
        NlComponent component = this.myWidgetModel.getComponent();
        if (component != null) {
            Scout.Arrange arrange;
            boolean rtl = ConstraintUtilities.isInRTL(component);
            switch (connectionType) {
                case 0: {
                    arrange = rtl ? Scout.Arrange.ConnectEnd : Scout.Arrange.ConnectStart;
                    break;
                }
                case 1: {
                    arrange = rtl ? Scout.Arrange.ConnectStart : Scout.Arrange.ConnectEnd;
                    break;
                }
                case 2: {
                    arrange = Scout.Arrange.ConnectTop;
                    break;
                }
                case 3: {
                    arrange = Scout.Arrange.ConnectBottom;
                    break;
                }
                default: {
                    return;
                }
            }
            component.clearTransaction();
            Scout.arrangeWidgets(arrange, Collections.singletonList(component), false);
            ComponentModification modification = new ComponentModification(component, "Connect Constraint");
            component.startAttributeTransaction().applyToModification(modification);
            modification.commit();
        }
    }

    static int baselinePos(int height) {
        return 9 * height / 10;
    }

    private void resize() {
        this.mWidth = this.getWidth();
        this.mHeight = this.getHeight();
        int mBoxSize = JBUI.scale((int)60);
        int boxLeft = (this.mWidth - mBoxSize) / 2;
        int boxTop = (this.mHeight - mBoxSize) / 2;
        int boxRight = boxLeft + mBoxSize;
        this.mWidgetRender.build(boxLeft, boxTop, mBoxSize);
        int dropDownWidth = JBUI.scale((int)66);
        int dropDownHeight = JBUI.scale((int)25);
        int dropDownOffset = JBUI.scale((int)12);
        this.mTopMargin.setBounds(this.mWidth / 2 - dropDownWidth / 2, boxTop - dropDownOffset - dropDownHeight, dropDownWidth, dropDownHeight);
        this.mLeftMargin.setBounds(boxLeft - dropDownOffset - dropDownWidth, (this.mHeight - dropDownHeight) / 2, dropDownWidth, dropDownHeight);
        this.mRightMargin.setBounds(boxRight + dropDownOffset, (this.mHeight - dropDownHeight) / 2, dropDownWidth, dropDownHeight);
        this.mBottomMargin.setBounds(this.mWidth / 2 - dropDownWidth / 2, boxTop + mBoxSize + dropDownOffset, dropDownWidth, dropDownHeight);
        int rad = JBUI.scale((int)5);
        int size = rad * 2;
        int boxCenter = (int)((double)((float)mBoxSize / 2.0f) + 0.5);
        int centerX = boxLeft + boxCenter;
        int centerY = boxTop + boxCenter;
        this.mTopKill.setBounds(centerX - rad, boxTop - rad, size, size);
        this.mLeftKill.setBounds(boxLeft - rad, centerY - rad, size, size);
        this.mRightKill.setBounds(boxRight - rad, centerY - rad, size, size);
        this.mBottomKill.setBounds(centerX - rad, boxTop + mBoxSize - rad, size, size);
        this.mBaselineKill.setBounds(centerX - rad, boxTop + SingleWidgetView.baselinePos(mBoxSize) - rad, size, size);
        this.mTopConnect.setLocation(centerX - Math.round((float)this.mTopConnect.getPreferredSize().width / 2.0f), boxTop - this.mTopConnect.getPreferredSize().height - dropDownOffset);
        this.mLeftConnect.setLocation(boxLeft - this.mLeftConnect.getPreferredSize().width - dropDownOffset, centerY - Math.round((float)this.mLeftConnect.getPreferredSize().height / 2.0f));
        this.mRightConnect.setLocation(boxRight + dropDownOffset, centerY - Math.round((float)this.mRightConnect.getPreferredSize().height / 2.0f));
        this.mBottomConnect.setLocation(centerX - Math.round((float)this.mTopConnect.getPreferredSize().width / 2.0f), boxTop + mBoxSize + dropDownOffset);
        this.mAspectButton.setBounds(boxLeft, boxTop, mBoxSize / 6, mBoxSize / 6);
        this.mAspectText.setBounds(this.mRightMargin.getX(), this.mBottomConnect.getY(), dropDownWidth, dropDownHeight);
        Dimension labelSize = this.mAspectLabel.getPreferredSize();
        this.mAspectLabel.setBounds(boxRight + dropDownOffset, this.mAspectText.getY() - labelSize.height, labelSize.width, labelSize.height);
        int barMargin = JBUI.scale((int)9);
        int barLong = mBoxSize / 2 - barMargin - JBUI.scale((int)6);
        int scaledConstraintLength = JBUI.scale((int)9);
        centerY = boxTop + (mBoxSize - scaledConstraintLength) / 2;
        centerX = boxLeft + (mBoxSize - scaledConstraintLength) / 2;
        this.mHbar1.setBounds(boxLeft + barMargin, centerY, barLong, scaledConstraintLength);
        this.mHbar2.setBounds(boxRight - barLong - barMargin, centerY, barLong, scaledConstraintLength);
        this.mVbar1.setBounds(centerX, boxTop + barMargin, scaledConstraintLength, barLong);
        if (this.mCacheBaseline) {
            int top = boxTop + mBoxSize / 2 + scaledConstraintLength;
            int height = boxTop + SingleWidgetView.baselinePos(mBoxSize) - top - 2;
            this.mVbar2.setBounds(centerX, top, scaledConstraintLength + 1, height);
        } else {
            this.mVbar2.setBounds(centerX, boxTop + mBoxSize - barMargin - barLong, scaledConstraintLength, barLong);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.mWidth != this.getWidth() || this.mHeight != this.getHeight()) {
            this.resize();
        }
        Graphics2D g2d = (Graphics2D)g;
        for (Graphic graphic : this.mGraphicList) {
            graphic.paint(g2d, this.mColorSet);
        }
    }

    public void configureUi(int bottom, int top, int left, int right, boolean baseline, int width, int height, String ratioString) {
        int[] split;
        this.mRatioString = ratioString;
        this.parseDimensionRatio(ratioString);
        String aspectText = "";
        if (ratioString != null) {
            if (ratioString.contains(",")) {
                aspectText = ratioString.substring(ratioString.indexOf(44) + 1);
                this.mRatioLock = Character.toLowerCase(ratioString.charAt(0)) == 'w' ? 3 : 2;
            } else {
                aspectText = ratioString;
                this.mRatioLock = 1;
            }
        } else {
            this.mRatioLock = 0;
        }
        if (this.mRatioHeight == -1 && this.mDimensionRatio > 0.0f && (split = SingleWidgetView.splitRatio(this.mDimensionRatio)) != null) {
            this.mRatioWidth = split[1];
            this.mRatioHeight = split[0];
        }
        this.mAspectText.setText(aspectText);
        this.configureUi(bottom, top, left, right, baseline, width, height);
    }

    private void configureUi(int bottom, int top, int left, int right, boolean baseline, int width, int height) {
        this.mCacheBaseline = baseline;
        this.mCacheWidth = width;
        this.mCacheHeight = height;
        this.mTopMargin.setVisible(top != -1);
        this.mLeftMargin.setVisible(left != -1);
        this.mRightMargin.setVisible(right != -1);
        this.mBottomMargin.setVisible(bottom != -1);
        this.mTopMargin.setMargin(top);
        this.mLeftMargin.setMargin(left);
        this.mRightMargin.setMargin(right);
        this.mBottomMargin.setMargin(bottom);
        this.mWidgetRender.setConstraints(left, top, right, bottom);
        this.mWidgetRender.mBaseline = baseline;
        this.mTopKill.setVisible(top != -1);
        this.mLeftKill.setVisible(left != -1);
        this.mRightKill.setVisible(right != -1);
        this.mBottomKill.setVisible(bottom != -1);
        this.mTopConnect.setVisible(top == -1);
        this.mLeftConnect.setVisible(left == -1);
        this.mRightConnect.setVisible(right == -1);
        this.mBottomConnect.setVisible(bottom == -1);
        this.mBaselineKill.setVisible(baseline);
        this.mAspectButton.setVisible(true);
        this.mAspectText.setVisible(this.mRatioString != null);
        this.mAspectLabel.setVisible(this.mRatioString != null);
        this.mHbar1.setState(width);
        this.mHbar2.setState(width);
        this.mVbar1.setState(height);
        this.mVbar2.setState(height);
        this.mHbar1.setVisible(this.mDimensionRatioSide != 0);
        this.mHbar2.setVisible(this.mDimensionRatioSide != 0);
        this.mVbar1.setVisible(this.mDimensionRatioSide != 1);
        this.mVbar2.setVisible(this.mDimensionRatioSide != 1);
        this.mVbar1.setToolTipText(this.statusString[height]);
        this.mVbar2.setToolTipText(this.statusString[height]);
        this.mHbar1.setToolTipText(this.statusString[width]);
        this.mHbar2.setToolTipText(this.statusString[width]);
        this.resize();
        this.repaint();
    }

    private void parseDimensionRatio(String ratio) {
        this.mRatioHeight = -1;
        this.mRatioWidth = -1;
        if (ratio == null || ratio.isEmpty()) {
            this.mDimensionRatio = 0.0f;
            this.mDimensionRatioSide = -1;
            return;
        }
        int dimensionRatioSide = -1;
        float dimensionRatio = 0.0f;
        int len = ratio.length();
        int commaIndex = ratio.indexOf(44);
        if (commaIndex > 0 && commaIndex < len - 1) {
            String dimension = ratio.substring(0, commaIndex);
            if (dimension.equalsIgnoreCase("W")) {
                dimensionRatioSide = 0;
            } else if (dimension.equalsIgnoreCase("H")) {
                dimensionRatioSide = 1;
            }
            ++commaIndex;
        } else {
            commaIndex = 0;
        }
        int colonIndex = ratio.indexOf(58);
        if (colonIndex >= 0 && colonIndex < len - 1) {
            String nominator = ratio.substring(commaIndex, colonIndex);
            String denominator = ratio.substring(colonIndex + 1);
            if (!nominator.isEmpty() && !denominator.isEmpty()) {
                try {
                    float nominatorValue = Float.parseFloat(nominator);
                    float denominatorValue = Float.parseFloat(denominator);
                    dimensionRatio = Math.abs(nominatorValue / denominatorValue);
                    this.mRatioHeight = (int)nominatorValue;
                    this.mRatioWidth = (int)denominatorValue;
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else {
            String r = ratio.substring(commaIndex);
            if (!r.isEmpty()) {
                try {
                    dimensionRatio = Float.parseFloat(r);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (dimensionRatio > 0.0f) {
            this.mDimensionRatio = dimensionRatio;
            this.mDimensionRatioSide = dimensionRatioSide;
        }
    }

    private static int[] splitRatio(float ratio) {
        if (ratio >= 1.0f) {
            for (int[] r : ratios) {
                if (!((float)r[0] / (float)r[1] >= ratio)) continue;
                return r;
            }
        } else {
            for (int[] r : ratios) {
                if (!((float)r[1] / (float)r[0] <= ratio)) continue;
                return r;
            }
        }
        return null;
    }

    private static void drawCircle(Graphics2D g, int x, int y) {
        int radius = JBUI.scale((int)5);
        int diameter = radius * 2;
        g.fillRoundRect(x - radius, y - radius, diameter, diameter, diameter, diameter);
    }

    static {
        Arrays.sort(ratios, (a, b) -> Float.compare((float)a[0] / (float)a[1], (float)b[0] / (float)b[1]));
    }

    private class WidgetRender
    implements Graphic {
        private int mMarginLeft;
        private int mMarginTop;
        private int mMarginRight;
        private int mMarginBottom;
        private boolean mBaseline;
        private Box mWidgetCenter;
        private Line mTopArrow;
        private Line mLeftArrow;
        private Line mRightArrow;
        private Line mBottomArrow;
        private LineArrow mBaselineArrow;
        private AspectLock mAspectLock;

        private WidgetRender() {
        }

        void setConstraints(int left, int top, int right, int bottom) {
            this.mMarginTop = top;
            this.mMarginLeft = left;
            this.mMarginRight = right;
            this.mMarginBottom = bottom;
        }

        public void build(int boxLeft, int boxTop, int boxSize) {
            this.mWidgetCenter = new BaseLineBox(boxLeft, boxTop, boxSize, boxSize, this.mBaseline);
            this.mAspectLock = new AspectLock(boxLeft, boxTop, boxSize, boxSize, SingleWidgetView.this.mRatioLock, SingleWidgetView.this.mRatioWidth, SingleWidgetView.this.mRatioHeight);
            int baseArrowX = boxLeft + boxSize / 2;
            this.mBaselineArrow = new LineArrow(baseArrowX, boxTop + SingleWidgetView.baselinePos(boxSize), baseArrowX, boxTop + boxSize / 2, this.mBaseline);
            int centerY = (int)((double)boxTop + (double)boxSize / 2.0 + 0.5);
            int centerX = (int)((double)boxLeft + (double)boxSize / 2.0 + 0.5);
            int dropDownOffset = JBUI.scale((int)12);
            this.mTopArrow = new Line(centerX, boxTop, centerX, boxTop - dropDownOffset, this.mMarginTop >= 0);
            this.mLeftArrow = new Line(boxLeft, centerY, boxLeft - dropDownOffset, centerY, this.mMarginLeft >= 0);
            this.mRightArrow = new Line(boxLeft + boxSize, centerY, boxLeft + boxSize + dropDownOffset, centerY, this.mMarginRight >= 0);
            this.mBottomArrow = new Line(centerX, boxTop + boxSize, centerX, boxTop + boxSize + dropDownOffset, this.mMarginBottom >= 0);
            SingleWidgetView.this.updateTriangle();
        }

        @Override
        public void paint(Graphics2D g, ColorSet colorSet) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setColor(SingleWidgetView.this.mColorSet.getInspectorBackgroundColor());
            g.fillRect(0, 0, JBUI.scale((int)60), JBUI.scale((int)60));
            g.setColor(SingleWidgetView.this.mColorSet.getInspectorStrokeColor());
            this.mWidgetCenter.paint(g, colorSet);
            this.mAspectLock.paint(g, colorSet);
            this.mTopArrow.paint(g, colorSet);
            this.mLeftArrow.paint(g, colorSet);
            this.mRightArrow.paint(g, colorSet);
            this.mBottomArrow.paint(g, colorSet);
            this.mBaselineArrow.paint(g, colorSet);
        }
    }

    static class HConstraintDisplay
    extends TriStateControl {
        final boolean mDirection;

        HConstraintDisplay(ColorSet colorSet, boolean direction) {
            super(colorSet);
            this.mDirection = direction;
        }

        @Override
        void drawState(Graphics g, int width, int height) {
            int start = 0;
            int pos = height / 2;
            switch (this.mState) {
                case 0: {
                    HConstraintDisplay.drawFixedHorizontalConstraint(g, start, pos, width);
                    break;
                }
                case 1: {
                    HConstraintDisplay.drawSpringHorizontalConstraint(g, start, pos, width);
                    break;
                }
                case 2: {
                    HConstraintDisplay.drawWrapHorizontalConstraint(g, start, pos, width, this.mDirection);
                }
            }
        }

        private static void drawSpringHorizontalConstraint(Graphics g, int left, int top, int right) {
            int width = JBUI.scale((int)4);
            int spacing = JBUI.scale((int)2);
            int length = right - left;
            int ni = length / (2 * spacing) - 1;
            int margin = (length - ni * 2 * spacing) / 2;
            g.drawLine(left, top - width, left, top + width);
            g.drawLine(left, top, left + margin, top);
            for (int i = left + margin; i <= right - margin - 2 * spacing; i += 2 * spacing) {
                g.drawLine(i, top, i + spacing, top - spacing);
                g.drawLine(i + spacing, top - spacing, i + spacing, top + spacing);
                g.drawLine(i + spacing, top + spacing, i + 2 * spacing, top);
            }
            g.drawLine(right - margin, top, right, top);
            g.drawLine(right, top - width, right, top + width);
        }

        private static void drawWrapHorizontalConstraint(Graphics g, int left, int y, int right, boolean directionLeftToRight) {
            int width = JBUI.scale((int)4);
            int spacing = width + JBUI.scale((int)2);
            Graphics2D g2 = (Graphics2D)g;
            if (directionLeftToRight) {
                for (int x = left; x <= right - width; x += spacing) {
                    g2.drawLine(x, y - width, x + width, y);
                    g2.drawLine(x + width, y, x, y + width);
                }
            } else {
                for (int x = right; x >= left + width; x -= spacing) {
                    g2.drawLine(x, y - width, x - width, y);
                    g2.drawLine(x - width, y, x, y + width);
                }
            }
        }

        private static void drawFixedHorizontalConstraint(Graphics g, int left, int y, int right) {
            int scaledConstraintWidth = JBUI.scale((int)4);
            g.drawLine(left, y - scaledConstraintWidth, left, y + scaledConstraintWidth);
            g.drawLine(left, y, right, y);
            g.drawLine(right, y - scaledConstraintWidth, right, y + scaledConstraintWidth);
        }
    }

    private static class VConstraintDisplay
    extends TriStateControl {
        final boolean mDirection;

        VConstraintDisplay(ColorSet colorSet, boolean direction) {
            super(colorSet);
            this.mDirection = direction;
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.setPreferredSize((Dimension)new JBDimension(30, 200));
        }

        @Override
        void drawState(Graphics g, int width, int height) {
            int start = 0;
            int pos = width / 2;
            switch (this.mState) {
                case 0: {
                    VConstraintDisplay.drawFixedVerticalConstraint(g, start, pos, height);
                    break;
                }
                case 1: {
                    VConstraintDisplay.drawSpringVerticalConstraint(g, start, pos, height);
                    break;
                }
                case 2: {
                    VConstraintDisplay.drawWrapVerticalConstraint(g, start, pos, height, this.mDirection);
                }
            }
        }

        private static void drawSpringVerticalConstraint(Graphics g, int top, int x, int bottom) {
            int width = JBUI.scale((int)4);
            int spacing = JBUI.scale((int)2);
            int h = bottom - top;
            int ni = h / (2 * spacing) - 1;
            int margin = (h - ni * 2 * spacing) / 2;
            g.drawLine(x - width, top, x + width, top);
            g.drawLine(x, top, x, top + margin);
            for (int i = top + margin; i <= bottom - margin - 2 * spacing; i += 2 * spacing) {
                g.drawLine(x, i, x + spacing, i + spacing);
                g.drawLine(x + spacing, i + spacing, x - spacing, i + spacing);
                g.drawLine(x - spacing, i + spacing, x, i + 2 * spacing);
            }
            g.drawLine(x, bottom - margin, x, bottom);
            g.drawLine(x - width, bottom, x + width, bottom);
        }

        private static void drawFixedVerticalConstraint(Graphics g, int top, int x, int bottom) {
            int width = JBUI.scale((int)4);
            g.drawLine(x - width, top, x + width, top);
            g.drawLine(x, top, x, bottom);
            g.drawLine(x - width, bottom, x + width, bottom);
        }

        private static void drawWrapVerticalConstraint(Graphics g, int top, int x, int bottom, boolean topToBottom) {
            int width = JBUI.scale((int)4);
            int spacing = width + JBUI.scale((int)2);
            if (topToBottom) {
                for (int y = top; y <= bottom - width; y += spacing) {
                    g.drawLine(x - width, y, x, y + width);
                    g.drawLine(x + width, y, x, y + width);
                }
            } else {
                for (int y = bottom; y >= top + width; y -= spacing) {
                    g.drawLine(x - width, y, x, y - width);
                    g.drawLine(x + width, y, x, y - width);
                }
            }
        }
    }

    public static class KillButton
    extends JComponent {
        boolean mMouseIn;
        final ColorSet mColorSet;
        private ActionListener mListener;
        private static final int CROSS_BAR_SIZE = 9;
        final Icon icon = new Icon(){
            private final BasicStroke myStroke = new BasicStroke(1.0f);

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                g.setColor((Color)JBColor.BLUE);
                if (mMouseIn) {
                    this.drawCircle((Graphics2D)g, x + JBUI.scale((int)5), y + JBUI.scale((int)5));
                }
            }

            private void drawCircle(Graphics2D g, int x, int y) {
                g.setColor(mColorSet.getInspectorConstraintColor());
                int radius = JBUI.scale((int)5);
                int size = radius * 2;
                g.drawRoundRect(x - radius, y - radius, size, size, size, size);
                g.fillRoundRect(x - radius, y - radius, size, size, size, size);
                g.setColor(mColorSet.getInspectorBackgroundColor());
                g.setStroke(this.myStroke);
                int crossBarSize = JBUI.scale((int)9);
                g.drawLine(x - crossBarSize, y - crossBarSize, x + crossBarSize, y + crossBarSize);
                g.drawLine(x - crossBarSize, y + crossBarSize, x + crossBarSize, y - crossBarSize);
            }

            @Override
            public int getIconWidth() {
                return JBUI.scale((int)12);
            }

            @Override
            public int getIconHeight() {
                return JBUI.scale((int)10);
            }
        };

        @Override
        public void paint(Graphics g) {
            if (this.mMouseIn) {
                this.icon.paintIcon(this, g, 0, 0);
            }
        }

        public KillButton(ColorSet colorSet) {
            this.mColorSet = colorSet;
            this.setOpaque(false);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent evt) {
                    mMouseIn = true;
                    this.repaint();
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    mListener.actionPerformed(null);
                }

                @Override
                public void mouseExited(MouseEvent evt) {
                    mMouseIn = false;
                    this.repaint();
                }
            });
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.setPreferredSize((Dimension)JBUI.size((int)10));
        }

        public void addActionListener(ActionListener listener2) {
            this.mListener = listener2;
        }
    }

    static class ConnectButton
    extends JLabel {
        private static final Icon ICON = StudioIcons.LayoutEditor.Properties.ADD_CONNECTION;
        private ActionListener mListener;

        public void addActionListener(ActionListener listener2) {
            this.mListener = listener2;
        }

        private ConnectButton() {
            this.setOpaque(false);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent evt) {
                    this.repaint();
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    mListener.actionPerformed(null);
                }

                @Override
                public void mouseExited(MouseEvent evt) {
                    this.repaint();
                }
            });
        }

        @Override
        public void updateUI() {
            super.updateUI();
            Dimension size = new Dimension(ICON.getIconWidth(), ICON.getIconHeight());
            this.setPreferredSize(size);
            this.setSize(size);
        }

        @Override
        public void paint(Graphics g) {
            ICON.paintIcon(this, g, 0, 0);
        }
    }

    static class AspectButton
    extends JComponent {
        private boolean mMouseIn;
        private final ColorSet mColorSet;
        private final Color mColor;
        private final int[] mXPoints = new int[3];
        private final int[] mYPoints = new int[3];
        private ActionListener mListener;
        final Icon icon = new Icon(){

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                g.setColor((Color)JBColor.BLUE);
                mXPoints[0] = 1;
                mYPoints[0] = 1;
                mXPoints[1] = this.getIconWidth();
                mYPoints[1] = 1;
                mXPoints[2] = 1;
                mYPoints[2] = this.getIconHeight();
                if (mMouseIn) {
                    g.setColor(mColor);
                    g.fillPolygon(mXPoints, mYPoints, 3);
                }
            }

            @Override
            public int getIconWidth() {
                return this.getWidth();
            }

            @Override
            public int getIconHeight() {
                return this.getHeight();
            }
        };

        @Override
        public void paint(Graphics g) {
            if (this.mMouseIn) {
                this.icon.paintIcon(this, g, 0, 0);
            }
        }

        private AspectButton(ColorSet colorSet) {
            this.mColorSet = colorSet;
            this.mColor = new Color(this.mColorSet.getInspectorFillColor().getRGB() & 0x88FFFFFF, true);
            this.setOpaque(false);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent evt) {
                    mMouseIn = true;
                    this.repaint();
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    mListener.actionPerformed(null);
                }

                @Override
                public void mouseExited(MouseEvent evt) {
                    mMouseIn = false;
                    this.repaint();
                }
            });
        }

        @Override
        public void updateUI() {
            super.updateUI();
            JBDimension size = new JBDimension(10, 10);
            this.setPreferredSize((Dimension)size);
            this.setSize((Dimension)size);
        }

        public void addActionListener(ActionListener listener2) {
            this.mListener = listener2;
        }
    }

    static class TriStateControl
    extends JComponent {
        private static final String STATE = "state";
        private boolean mMouseIn;
        int mState;
        private final Color mBackground;
        private final Color mLineColor;
        private final Color mMouseOverColor;
        private TriStateControl mSisterControl;

        TriStateControl(ColorSet colorSet) {
            this.mBackground = colorSet.getInspectorFillColor();
            this.mLineColor = colorSet.getInspectorStrokeColor();
            this.mMouseOverColor = colorSet.getInspectorConstraintColor();
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int oldValue = mState;
                    mState = (mState + 1) % 3;
                    this.firePropertyChange(TriStateControl.STATE, oldValue, mState);
                    this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    mMouseIn = false;
                    if (mSisterControl != null) {
                        mSisterControl.mMouseIn = false;
                        mSisterControl.repaint();
                    }
                    this.repaint();
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    mMouseIn = true;
                    if (mSisterControl != null) {
                        mSisterControl.mMouseIn = true;
                        mSisterControl.repaint();
                    }
                    this.repaint();
                }
            });
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.setPreferredSize((Dimension)new JBDimension(200, 30));
        }

        public void setSister(TriStateControl sister) {
            this.mSisterControl = sister;
        }

        public int getState() {
            return this.mState;
        }

        public void setState(int state) {
            this.mState = state;
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics g) {
            int width = this.getWidth() - 1;
            int height = this.getHeight() - 1;
            g.setColor(this.mBackground);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(this.mMouseIn ? this.mMouseOverColor : this.mLineColor);
            this.drawState(g, width, height);
        }

        void drawState(Graphics g, int width, int height) {
        }
    }

    static class AspectLock
    implements Graphic {
        final int mX;
        final int mY;
        final int mWidth;
        final int mHeight;
        final int mLock;
        private final int mRatioHeight;
        private final int mRatioWidth;
        final int[] mXPoints = new int[3];
        final int[] mYPoints = new int[3];
        final BasicStroke mStroke = new BasicStroke(2.0f);
        private boolean mShowTriangle;

        AspectLock(int x, int y, int w, int h, int lock, int ratioWidth, int ratioHeight) {
            this.mX = x;
            this.mY = y;
            this.mHeight = h;
            this.mWidth = w;
            this.mLock = lock;
            this.mXPoints[0] = this.mX;
            this.mYPoints[0] = this.mY;
            this.mXPoints[1] = this.mX + this.mWidth / 6;
            this.mYPoints[1] = this.mY;
            this.mXPoints[2] = this.mX;
            this.mYPoints[2] = this.mY + this.mHeight / 6;
            this.mRatioHeight = ratioHeight;
            this.mRatioWidth = ratioWidth;
        }

        public void setShowTriangle(boolean show2) {
            this.mShowTriangle = show2;
        }

        @Override
        public void paint(Graphics2D g, ColorSet colorSet) {
            Rectangle2D bounds2;
            String str;
            if (this.mShowTriangle) {
                g.setColor(colorSet.getInspectorHighlightsStrokeColor());
                g.drawPolygon(this.mXPoints, this.mYPoints, 3);
            }
            if (this.mLock == 0) {
                return;
            }
            g.setColor(colorSet.getInspectorStrokeColor());
            g.fillPolygon(this.mXPoints, this.mYPoints, 3);
            FontMetrics fm = g.getFontMetrics();
            if (this.mRatioHeight != -1) {
                str = Integer.toString(this.mRatioHeight);
                bounds2 = fm.getStringBounds(str, g);
                g.drawString(str, this.mX + this.mWidth / 12 - (int)(bounds2.getWidth() / 2.0), this.mY - fm.getDescent());
            }
            if (this.mRatioWidth != -1) {
                str = Integer.toString(this.mRatioWidth);
                bounds2 = fm.getStringBounds(str, g);
                g.drawString(str, this.mX - (int)bounds2.getWidth() - 2, this.mY + fm.getAscent());
            }
            Stroke prevStroke = g.getStroke();
            g.setStroke(this.mStroke);
            if (this.mLock == 3) {
                g.drawLine(this.mX, this.mY + 1, this.mX, this.mY + this.mHeight - 1);
                g.drawLine(this.mX + this.mWidth, this.mY + 1, this.mX + this.mWidth, this.mY + this.mHeight - 1);
                g.drawLine(this.mX + 1, this.mY + this.mHeight / 2, this.mX + this.mWidth - 1, this.mY + this.mHeight / 2);
            } else if (this.mLock == 2) {
                g.drawLine(this.mX + 1, this.mY, this.mX + this.mWidth - 1, this.mY);
                g.drawLine(this.mX + 1, this.mY + this.mHeight, this.mX + this.mWidth - 1, this.mY + this.mHeight);
                g.drawLine(this.mX + this.mWidth / 2, this.mY + 1, this.mX + this.mWidth / 2, this.mY + this.mHeight - 1);
            }
            g.setStroke(prevStroke);
        }
    }

    static interface Graphic {
        public void paint(Graphics2D var1, ColorSet var2);
    }

    private static class LineArrow
    implements Graphic {
        final int mX1;
        final int mY1;
        final int mX2;
        final int mY2;
        final boolean mDisplay;
        final int[] mXArrow = new int[3];
        final int[] mYArrow = new int[3];

        LineArrow(int x1, int y1, int x2, int y2, boolean display) {
            this.mX1 = x1;
            this.mY1 = y1;
            this.mX2 = x2;
            this.mY2 = y2;
            this.mDisplay = display;
            this.mXArrow[0] = x2;
            this.mYArrow[0] = y2;
            this.mXArrow[1] = x2 - 3;
            this.mYArrow[1] = y2 - 5;
            this.mXArrow[2] = x2 + 3;
            this.mYArrow[2] = y2 - 5;
        }

        @Override
        public void paint(Graphics2D g, ColorSet colorSet) {
            if (this.mDisplay) {
                int lineTipSpacing = JBUI.scale((int)2);
                g.drawLine(this.mX1, this.mY1, this.mX2, this.mY2 - lineTipSpacing);
                g.fillPolygon(this.mXArrow, this.mYArrow, 3);
                SingleWidgetView.drawCircle(g, this.mX1, this.mY1);
            }
        }
    }

    static class Line
    implements Graphic {
        private final int mX1;
        private final int mY1;
        private final int mX2;
        private final int mY2;
        private final boolean mDisplay;

        Line(int x1, int y1, int x2, int y2, boolean display) {
            this.mX1 = x1;
            this.mY1 = y1;
            this.mX2 = x2;
            this.mY2 = y2;
            this.mDisplay = display;
        }

        @Override
        public void paint(Graphics2D g, ColorSet colorSet) {
            Stroke stroke = g.getStroke();
            if (this.mDisplay) {
                SingleWidgetView.drawCircle(g, this.mX1, this.mY1);
                g.setStroke(new BasicStroke(JBUI.scale((float)2.0f)));
            } else {
                BasicStroke dash = new BasicStroke(JBUI.scale((float)2.0f), 0, 0, JBUI.scale((float)2.0f), new float[]{JBUI.scale((float)2.0f), JBUI.scale((float)2.0f)}, 0.0f);
                g.setStroke(dash);
            }
            Object antialiazing = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.drawLine(this.mX1, this.mY1, this.mX2, this.mY2);
            g.setStroke(stroke);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antialiazing);
        }
    }

    static class BaseLineBox
    extends Box {
        final boolean mBaseline;

        BaseLineBox(int x, int y, int w, int h, boolean baseline) {
            super(x, y, w, h);
            this.mBaseline = baseline;
        }

        @Override
        public void paint(Graphics2D g, ColorSet colorSet) {
            Stroke defaultStroke = g.getStroke();
            g.setColor(colorSet.getInspectorFillColor());
            g.fillRect(this.mX, this.mY, this.mWidth + 1, this.mHeight + 1);
            g.setColor(colorSet.getInspectorStrokeColor());
            if (this.mBaseline) {
                g.drawLine(this.mX, this.mY, this.mX, this.mY + this.mWidth);
                g.drawLine(this.mX + this.mWidth, this.mY, this.mX + this.mWidth, this.mY + this.mHeight);
                int y = this.mY + SingleWidgetView.baselinePos(this.mHeight);
                g.setStroke(defaultStroke);
                g.drawLine(this.mX, y, this.mX + this.mWidth, y);
            } else {
                g.drawRect(this.mX, this.mY, this.mWidth, this.mHeight);
            }
        }
    }

    static class Box
    implements Graphic {
        final int mX;
        final int mY;
        final int mWidth;
        final int mHeight;

        Box(int x, int y, int w, int h) {
            this.mX = x;
            this.mY = y;
            this.mHeight = h;
            this.mWidth = w;
        }

        @Override
        public void paint(Graphics2D g, ColorSet colorSet) {
            g.setColor(colorSet.getInspectorFillColor());
            g.fillRect(this.mX, this.mY, this.mWidth + 1, this.mHeight + 1);
            g.setColor(colorSet.getInspectorStrokeColor());
            g.drawRect(this.mX, this.mY, this.mWidth, this.mHeight);
        }
    }
}

