/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.AndroidXConstants;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.Placeholder;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.TemporarySceneComponent;
import com.android.tools.idea.uibuilder.api.XmlType;
import com.android.tools.idea.uibuilder.handlers.HorizontalScrollViewHandler;
import com.android.tools.idea.uibuilder.handlers.TabLayoutPlaceholder;
import com.android.tools.idea.uibuilder.handlers.common.ViewGroupPlaceholder;
import com.android.xml.XmlBuilder;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TabLayoutHandler
extends HorizontalScrollViewHandler {
    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        return ImmutableList.of((Object)"style", (Object)"tabIndicatorColor", (Object)"tabIndicatorHeight", (Object)"tabContentStart", (Object)"tabBackground", (Object)"tabIndicator", (Object)"tabIndicatorGravity", (Object)"tabIndicatorAnimationDuration", (Object)"tabIndicatorFullWidth", (Object)"tabMode", (Object)"tabGravity", (Object)"tabInlineLabel", (Object[])new String[]{"tabMinWidth", "tabMaxWidth", "tabTextAppearance", "tabTextColor", "tabSelectedTextColor", "tabPadding", "tabPaddingStart", "tabPaddingEnd", "tabPaddingTop", "tabPaddingBottom", "tabIconTint", "tabIconTintMode", "tabRippleColor", "tabUnboundedRipple", "theme", "background"});
    }

    @Override
    @NotNull
    @Language(value="XML")
    public String getXml(@NotNull String tagName, @NotNull XmlType xmlType) {
        String tabItem = tagName.startsWith("com.google.android.material.") ? AndroidXConstants.TAB_ITEM.newName() : AndroidXConstants.TAB_ITEM.oldName();
        return new XmlBuilder().startTag(tagName).withSize("match_parent", "wrap_content").startTag(tabItem).wrapContent().androidAttribute("text", "Monday").endTag(tabItem).startTag(tabItem).wrapContent().androidAttribute("text", "Tuesday").endTag(tabItem).startTag(tabItem).wrapContent().androidAttribute("text", "Wednesday").endTag(tabItem).endTag(tagName).toString();
    }

    @Override
    public boolean onCreate(@Nullable NlComponent parent, @NotNull NlComponent node, @NotNull InsertType insertType) {
        return true;
    }

    @Override
    public boolean acceptsChild(@NotNull NlComponent layout, @NotNull NlComponent newChild) {
        return TabLayoutHandler.isTabItem(newChild);
    }

    private static boolean isTabItem(@NotNull NlComponent child) {
        return AndroidXConstants.TAB_ITEM.isEquals(child.getTagName());
    }

    @Override
    public void onChildInserted(@NotNull NlComponent layout, @NotNull NlComponent newChild, @NotNull InsertType insertType) {
        if (newChild.getAndroidAttribute("text") == null) {
            newChild.setAndroidAttribute("text", "Tab" + (layout.getChildren().size() + 1));
        }
    }

    @Override
    public boolean shouldAddCommonDragTarget(@NotNull SceneComponent component) {
        return true;
    }

    @Override
    public List<Placeholder> getPlaceholders(@NotNull SceneComponent component, @NotNull List<SceneComponent> draggedComponents) {
        if (!draggedComponents.stream().allMatch(it -> TabLayoutHandler.isTabItem(it.getNlComponent()))) {
            return Collections.emptyList();
        }
        ArrayList<Placeholder> retList = new ArrayList<Placeholder>();
        List children = component.getChildren().stream().filter(it -> !(it instanceof TemporarySceneComponent)).collect(Collectors.toList());
        if (children.size() == 0) {
            retList.add(new ViewGroupPlaceholder(component));
        } else {
            for (SceneComponent child : children) {
                retList.add(new TabLayoutPlaceholder(component, child));
            }
            retList.add(new TabLayoutPlaceholder(component, null));
        }
        return retList;
    }
}

