/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.adaptiveicon;

import com.android.resources.Density;
import com.android.sdklib.devices.Device;
import com.android.tools.adtui.actions.DropDownAction;
import com.android.tools.configurations.Configuration;
import com.android.tools.idea.actions.DesignerDataKeys;
import com.google.common.collect.Iterables;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class DensityMenuAction
extends DropDownAction {
    private static final Density[] DENSITIES = new Density[]{Density.MEDIUM, Density.HIGH, Density.XHIGH, Density.XXHIGH, Density.XXXHIGH};

    public DensityMenuAction() {
        super("Device Screen Density", "Device Screen Density", null);
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        e.getPresentation().putClientProperty(ActionUtil.SHOW_TEXT_IN_TOOLBAR, (Object)true);
        Collection configurations = (Collection)e.getData(DesignerDataKeys.CONFIGURATIONS);
        if (configurations == null || configurations.isEmpty()) {
            return;
        }
        Configuration configuration = (Configuration)Iterables.getFirst((Iterable)configurations, null);
        Density currentDensity = this.getCurrentDensity(configuration);
        e.getPresentation().setText(currentDensity.getResourceValue());
    }

    protected boolean updateActions(@NotNull DataContext context) {
        this.removeAll();
        Collection configurations = (Collection)context.getData(DesignerDataKeys.CONFIGURATIONS);
        if (configurations == null || configurations.isEmpty()) {
            return true;
        }
        Configuration configuration = (Configuration)Iterables.getFirst((Iterable)configurations, null);
        Density currentDensity = this.getCurrentDensity(configuration);
        for (Density density : DENSITIES) {
            this.add(new SetDensityAction(density, density == currentDensity));
        }
        return true;
    }

    private Density getCurrentDensity(@NotNull Configuration configuration) {
        int currentValue = configuration.getDensity().getDpiValue();
        for (Density density : DENSITIES) {
            if (density.getDpiValue() < currentValue) continue;
            return density;
        }
        return DENSITIES[DENSITIES.length - 1];
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private static class SetDensityAction
    extends AnAction
    implements Toggleable {
        private final Density myDensity;
        private final boolean myIsCurrentDensity;

        private SetDensityAction(@NotNull Density density, boolean isCurrentDensity) {
            super(density.getResourceValue());
            this.myDensity = density;
            this.myIsCurrentDensity = isCurrentDensity;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Collection configurations = (Collection)e.getData(DesignerDataKeys.CONFIGURATIONS);
            if (configurations == null || configurations.isEmpty()) {
                return;
            }
            configurations.forEach(config -> {
                Device original = config.getCachedDevice();
                if (original == null) {
                    return;
                }
                Device.Builder deviceBuilder = new Device.Builder(original);
                deviceBuilder.setName("Custom");
                deviceBuilder.setId("Custom Density");
                Device device = deviceBuilder.build();
                device.getAllStates().forEach(state -> state.getHardware().getScreen().setPixelDensity(this.myDensity));
                config.setEffectiveDevice(device, device.getDefaultState());
            });
        }

        public void update(@NotNull AnActionEvent e) {
            super.update(e);
            Toggleable.setSelected((Presentation)e.getPresentation(), (boolean)this.myIsCurrentDensity);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }
    }
}

