/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.actions;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.uibuilder.actions.DrawableBackgroundMenuActionKt;
import com.android.tools.idea.uibuilder.actions.DrawableBackgroundType;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/uibuilder/actions/DrawableBackgroundLayer;", "Lcom/android/tools/idea/common/surface/Layer;", "screenView", "Lcom/android/tools/idea/uibuilder/surface/ScreenView;", "backgroundType", "Lcom/android/tools/idea/uibuilder/actions/DrawableBackgroundType;", "<init>", "(Lcom/android/tools/idea/uibuilder/surface/ScreenView;Lcom/android/tools/idea/uibuilder/actions/DrawableBackgroundType;)V", "getBackgroundType", "()Lcom/android/tools/idea/uibuilder/actions/DrawableBackgroundType;", "setBackgroundType", "(Lcom/android/tools/idea/uibuilder/actions/DrawableBackgroundType;)V", "dim", "Ljava/awt/Dimension;", "paint", "", "gc", "Ljava/awt/Graphics2D;", "intellij.android.designer"})
@VisibleForTesting
@StabilityInferred(parameters=0)
public final class DrawableBackgroundLayer
extends Layer {
    @NotNull
    private final ScreenView screenView;
    @NotNull
    private DrawableBackgroundType backgroundType;
    @NotNull
    private final Dimension dim;
    public static final int $stable = 8;

    public DrawableBackgroundLayer(@NotNull ScreenView screenView, @NotNull DrawableBackgroundType backgroundType) {
        Intrinsics.checkNotNullParameter((Object)screenView, (String)"screenView");
        Intrinsics.checkNotNullParameter((Object)((Object)backgroundType), (String)"backgroundType");
        this.screenView = screenView;
        this.backgroundType = backgroundType;
        this.dim = new Dimension();
    }

    @NotNull
    public final DrawableBackgroundType getBackgroundType() {
        return this.backgroundType;
    }

    public final void setBackgroundType(@NotNull DrawableBackgroundType drawableBackgroundType) {
        Intrinsics.checkNotNullParameter((Object)((Object)drawableBackgroundType), (String)"<set-?>");
        this.backgroundType = drawableBackgroundType;
    }

    @Override
    public void paint(@NotNull Graphics2D gc) {
        Intrinsics.checkNotNullParameter((Object)gc, (String)"gc");
        DrawableBackgroundType currentType = this.backgroundType;
        if (currentType == DrawableBackgroundType.NONE) {
            return;
        }
        int startX = this.screenView.getX();
        int startY = this.screenView.getY();
        this.screenView.getScaledContentSize(this.dim);
        int width = this.dim.width;
        int height = this.dim.height;
        gc.clipRect(startX, startY, width, height);
        if (currentType == DrawableBackgroundType.WHITE) {
            gc.setColor(Color.WHITE);
            gc.fillRect(startX, startY, width, height);
            return;
        }
        if (currentType == DrawableBackgroundType.BLACK) {
            gc.setColor(Color.BLACK);
            gc.fillRect(startX, startY, width, height);
            return;
        }
        gc.setColor(Color.WHITE);
        gc.fillRect(startX, startY, width, height);
        boolean isOddRow = false;
        gc.setColor(DrawableBackgroundMenuActionKt.access$getCHECKERED_GRID_GRAY$p());
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)startY, (int)(startY + height))), (int)12);
        int y = intProgression.getFirst();
        int n = intProgression.getLast();
        int n2 = intProgression.getStep();
        if (n2 > 0 && y <= n || n2 < 0 && n <= y) {
            while (true) {
                int shift = isOddRow ? 0 : 12;
                IntProgression intProgression2 = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)(startX + shift), (int)(startX + width))), (int)24);
                int x = intProgression2.getFirst();
                int n3 = intProgression2.getLast();
                int n4 = intProgression2.getStep();
                if (n4 > 0 && x <= n3 || n4 < 0 && n3 <= x) {
                    while (true) {
                        gc.fillRect(x, y, 12, 12);
                        if (x == n3) break;
                        x += n4;
                    }
                }
                boolean bl = isOddRow = !isOddRow;
                if (y == n) break;
                y += n2;
            }
        }
    }
}

