/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.preview.animation.timeline;

import com.android.tools.idea.preview.animation.InspectorColors;
import com.android.tools.idea.preview.animation.InspectorLayout;
import com.android.tools.idea.preview.animation.SupportedAnimationManager;
import com.android.tools.idea.preview.animation.timeline.TimelineElement;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0002R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/preview/animation/timeline/TimelineLine;", "Lcom/android/tools/idea/preview/animation/timeline/TimelineElement;", "frozenState", "Lcom/android/tools/idea/preview/animation/SupportedAnimationManager$FrozenState;", "minX", "", "maxX", "rowMinY", "<init>", "(Lcom/android/tools/idea/preview/animation/SupportedAnimationManager$FrozenState;III)V", "middleY", "rectNoOffset", "Ljava/awt/Rectangle;", "height", "getHeight", "()I", "setHeight", "(I)V", "contains", "", "x", "y", "paint", "", "g", "Ljava/awt/Graphics2D;", "paintCircle", "intellij.android.preview-designer"})
public final class TimelineLine
extends TimelineElement {
    private final int middleY;
    @NotNull
    private final Rectangle rectNoOffset;
    private int height;

    public TimelineLine(@NotNull SupportedAnimationManager.FrozenState frozenState, int minX, int maxX, int rowMinY) {
        Intrinsics.checkNotNullParameter((Object)frozenState, (String)"frozenState");
        super(frozenState, minX, maxX);
        this.middleY = rowMinY + InspectorLayout.INSTANCE.timelineLineRowHeightScaled() / 2;
        this.rectNoOffset = new Rectangle(minX - InspectorLayout.INSTANCE.lineHalfHeightScaled() - InspectorLayout.INSTANCE.outlinePaddingScaled(), this.middleY - InspectorLayout.INSTANCE.lineHalfHeightScaled() - InspectorLayout.INSTANCE.outlinePaddingScaled(), maxX - minX + InspectorLayout.INSTANCE.lineHeightScaled() + 2 * InspectorLayout.INSTANCE.outlinePaddingScaled(), InspectorLayout.INSTANCE.lineHeightScaled() + 2 * InspectorLayout.INSTANCE.outlinePaddingScaled());
        this.height = 75;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean contains(int x, int y) {
        int n = this.rectNoOffset.x + 0;
        if (x > (int)this.rectNoOffset.getMaxX()) return false;
        if (n > x) return false;
        boolean bl = true;
        if (!bl) return false;
        n = this.rectNoOffset.y;
        if (y > (int)this.rectNoOffset.getMaxY()) return false;
        if (n > y) return false;
        return true;
    }

    @Override
    public void paint(@NotNull Graphics2D g) {
        Graphics2D graphics2D;
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D $this$paint_u24lambda_u240 = graphics2D = (Graphics2D)graphics;
        boolean bl = false;
        $this$paint_u24lambda_u240.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Rectangle rect = new Rectangle(this.rectNoOffset.x, this.rectNoOffset.y, this.rectNoOffset.width, this.rectNoOffset.height);
        $this$paint_u24lambda_u240.setColor(InspectorColors.INSTANCE.getLINE_COLOR());
        $this$paint_u24lambda_u240.fillRoundRect(rect.x, rect.y, rect.width, rect.height, InspectorLayout.INSTANCE.lineHeightScaled(), InspectorLayout.INSTANCE.lineHeightScaled());
        this.paintCircle($this$paint_u24lambda_u240, this.getMinX(), this.middleY);
        this.paintCircle($this$paint_u24lambda_u240, this.getMaxX(), this.middleY);
    }

    private final void paintCircle(Graphics2D g, int x, int y) {
        Graphics2D graphics2D;
        Graphics2D $this$paintCircle_u24lambda_u241 = graphics2D = g;
        boolean bl = false;
        $this$paintCircle_u24lambda_u241.setColor((Color)InspectorColors.INSTANCE.getLINE_CIRCLE_OUTLINE_COLOR());
        $this$paintCircle_u24lambda_u241.fillOval(x - InspectorLayout.INSTANCE.lineHalfHeightScaled(), y - InspectorLayout.INSTANCE.lineHalfHeightScaled(), InspectorLayout.INSTANCE.lineHeightScaled(), InspectorLayout.INSTANCE.lineHeightScaled());
        $this$paintCircle_u24lambda_u241.setColor(InspectorColors.INSTANCE.getLINE_CIRCLE_COLOR());
        $this$paintCircle_u24lambda_u241.fillOval(x - InspectorLayout.INSTANCE.lineHalfHeightScaled() + InspectorLayout.INSTANCE.outlinePaddingScaled(), y - InspectorLayout.INSTANCE.lineHalfHeightScaled() + InspectorLayout.INSTANCE.outlinePaddingScaled(), InspectorLayout.INSTANCE.lineHeightScaled() - 2 * InspectorLayout.INSTANCE.outlinePaddingScaled(), InspectorLayout.INSTANCE.lineHeightScaled() - 2 * InspectorLayout.INSTANCE.outlinePaddingScaled());
    }
}

