/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.pickers.preview.enumsupport.devices;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.resources.Density;
import com.android.sdklib.devices.Device;
import com.android.tools.idea.compose.pickers.base.enumsupport.DescriptionEnumValue;
import com.android.tools.idea.compose.pickers.base.enumsupport.PsiEnumValue;
import com.android.tools.idea.compose.pickers.base.enumsupport.PsiEnumValueImpl;
import com.android.tools.idea.compose.pickers.preview.enumsupport.devices.DeviceClass;
import com.android.tools.preview.config.Densities;
import com.android.tools.preview.config.DeviceConfig;
import com.android.tools.preview.config.DimUnit;
import com.android.tools.preview.config.Orientation;
import com.android.tools.preview.config.ReferenceConfigsKt;
import com.android.tools.preview.config.Shape;
import com.android.tools.property.panel.api.EnumValue;
import com.google.wireless.android.sdk.stats.EditorPickerEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J<\u0010\u0011\u001a\u00020\u00002\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J \u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u000bH\u0002J \u0010 \u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J \u0010!\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010#\u001a\u00020$J\u000e\u0010&\u001a\u00020\u00002\u0006\u0010#\u001a\u00020$J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010#\u001a\u00020$J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010#\u001a\u00020$J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010#\u001a\u00020$J\u000e\u0010*\u001a\u00020\u00002\u0006\u0010#\u001a\u00020$J\u000e\u0010+\u001a\u00020\u00002\u0006\u0010#\u001a\u00020$J\u0018\u0010,\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\u000bH\u0002J\u0018\u0010.\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\u000bH\u0002J\u0018\u0010/\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\u000bH\u0002J \u00100\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0006H\u0002J\f\u00101\u001a\b\u0012\u0004\u0012\u00020302J\b\u00104\u001a\u000205H\u0002R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/android/tools/idea/compose/pickers/preview/enumsupport/devices/DeviceEnumValueBuilder;", "", "<init>", "()V", "deviceEnumValues", "", "Lcom/android/tools/idea/compose/pickers/preview/enumsupport/devices/DeviceClass;", "", "Lcom/android/tools/idea/compose/pickers/base/enumsupport/PsiEnumValue;", "addReferenceDevice", "name", "", "description", "immutableDeviceConfig", "Lcom/android/tools/preview/config/DeviceConfig;", "trackableValue", "Lcom/google/wireless/android/sdk/stats/EditorPickerEvent$EditorPickerAction$PreviewPickerModification$PreviewPickerValue;", "addDevicePx", "overrideDisplayName", "type", "widthPx", "", "heightPx", "diagonalIn", "", "orientation", "Lcom/android/tools/preview/config/Orientation;", "addWearDevice", "isRound", "", "chinSizePx", "displayName", "addTvDevice", "addAutoDevice", "addPhone", "device", "Lcom/android/sdklib/devices/Device;", "addTablet", "addWear", "addTv", "addAuto", "addGeneric", "addXr", "addDesktop", "addPhoneById", "id", "addTabletById", "addGenericById", "addById", "includeDefaultsAndBuild", "", "Lcom/android/tools/property/panel/api/EnumValue;", "addDefaultsIfMissing", "", "intellij.android.compose-designer"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDeviceClasses.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceClasses.kt\ncom/android/tools/idea/compose/pickers/preview/enumsupport/devices/DeviceEnumValueBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,284:1\n1869#2:285\n1869#2,2:286\n1870#2:288\n*S KotlinDebug\n*F\n+ 1 DeviceClasses.kt\ncom/android/tools/idea/compose/pickers/preview/enumsupport/devices/DeviceEnumValueBuilder\n*L\n215#1:285\n220#1:286,2\n215#1:288\n*E\n"})
public final class DeviceEnumValueBuilder {
    @NotNull
    private final Map<DeviceClass, List<PsiEnumValue>> deviceEnumValues;
    public static final int $stable = 8;

    public DeviceEnumValueBuilder() {
        Pair[] pairArray = new Pair[]{new Pair((Object)DeviceClass.ReferenceDevice, (Object)new ArrayList()), new Pair((Object)DeviceClass.Phone, (Object)new ArrayList()), new Pair((Object)DeviceClass.Tablet, (Object)new ArrayList()), new Pair((Object)DeviceClass.Desktop, (Object)new ArrayList()), new Pair((Object)DeviceClass.Wear, (Object)new ArrayList()), new Pair((Object)DeviceClass.Tv, (Object)new ArrayList()), new Pair((Object)DeviceClass.Auto, (Object)new ArrayList()), new Pair((Object)DeviceClass.Xr, (Object)new ArrayList()), new Pair((Object)DeviceClass.Generic, (Object)new ArrayList())};
        this.deviceEnumValues = MapsKt.mapOf((Pair[])pairArray);
    }

    private final DeviceEnumValueBuilder addReferenceDevice(String name, String description, DeviceConfig immutableDeviceConfig, EditorPickerEvent.EditorPickerAction.PreviewPickerModification.PreviewPickerValue trackableValue) {
        DeviceEnumValueBuilder deviceEnumValueBuilder;
        block0: {
            DeviceEnumValueBuilder $this$addReferenceDevice_u24lambda_u240 = deviceEnumValueBuilder = this;
            boolean bl = false;
            String deviceSpec = immutableDeviceConfig.deviceSpec();
            DescriptionEnumValue enumValue = PsiEnumValue.Companion.withTooltip(deviceSpec, name, description, trackableValue);
            List<PsiEnumValue> list = $this$addReferenceDevice_u24lambda_u240.deviceEnumValues.get((Object)DeviceClass.ReferenceDevice);
            if (list == null) break block0;
            list.add(enumValue);
        }
        return deviceEnumValueBuilder;
    }

    private final DeviceEnumValueBuilder addDevicePx(String overrideDisplayName, DeviceClass type, int widthPx, int heightPx, double diagonalIn, Orientation orientation) {
        DeviceEnumValueBuilder deviceEnumValueBuilder;
        block1: {
            DeviceEnumValueBuilder $this$addDevicePx_u24lambda_u242 = deviceEnumValueBuilder = this;
            boolean bl = false;
            boolean bl2 = false;
            double dpiCalc = Math.sqrt(1.0 * (double)widthPx * (double)widthPx + 1.0 * (double)heightPx * (double)heightPx) / diagonalIn;
            double dpi = Math.rint(dpiCalc * (double)100) / 100.0;
            Density density = Densities.getCommonScreenDensity((boolean)true, (double)dpi, (int)heightPx);
            String deviceSpec = new DeviceConfig(null, (float)widthPx, (float)heightPx, DimUnit.px, density.getDpiValue(), null, 0.0f, orientation, null, null, null, 1889, null).deviceSpec();
            Object object = overrideDisplayName;
            if (object == null) {
                object = Math.rint(diagonalIn * (double)100) / (double)100 + "\" " + type.name() + " " + heightPx + "p";
            }
            String display = object;
            PsiEnumValueImpl enumValue = PsiEnumValue.Companion.indented(deviceSpec, display, EditorPickerEvent.EditorPickerAction.PreviewPickerModification.PreviewPickerValue.DEVICE_REF_NONE);
            List<PsiEnumValue> list = $this$addDevicePx_u24lambda_u242.deviceEnumValues.get((Object)type);
            if (list == null) break block1;
            list.add(enumValue);
        }
        return deviceEnumValueBuilder;
    }

    static /* synthetic */ DeviceEnumValueBuilder addDevicePx$default(DeviceEnumValueBuilder deviceEnumValueBuilder, String string, DeviceClass deviceClass, int n, int n2, double d, Orientation orientation, int n3, Object object) {
        if ((n3 & 1) != 0) {
            string = null;
        }
        return deviceEnumValueBuilder.addDevicePx(string, deviceClass, n, n2, d, orientation);
    }

    private final DeviceEnumValueBuilder addWearDevice(boolean isRound, int chinSizePx, String displayName) {
        DeviceEnumValueBuilder deviceEnumValueBuilder;
        block0: {
            DeviceEnumValueBuilder $this$addWearDevice_u24lambda_u243 = deviceEnumValueBuilder = this;
            boolean bl = false;
            Density density = Densities.getCommonScreenDensity((boolean)false, (double)224.0, (int)300);
            Shape shape = isRound ? Shape.Round : Shape.Normal;
            String deviceSpec = new DeviceConfig(null, 300.0f, 300.0f, DimUnit.px, density.getDpiValue(), shape, (float)chinSizePx, null, null, null, null, 1921, null).deviceSpec();
            PsiEnumValueImpl enumValue = PsiEnumValue.Companion.indented(deviceSpec, displayName, EditorPickerEvent.EditorPickerAction.PreviewPickerModification.PreviewPickerValue.DEVICE_REF_NONE);
            List<PsiEnumValue> list = $this$addWearDevice_u24lambda_u243.deviceEnumValues.get((Object)DeviceClass.Wear);
            if (list == null) break block0;
            list.add(enumValue);
        }
        return deviceEnumValueBuilder;
    }

    private final DeviceEnumValueBuilder addTvDevice(int widthPx, int heightPx, double diagonalIn) {
        return DeviceEnumValueBuilder.addDevicePx$default(this, null, DeviceClass.Tv, widthPx, heightPx, diagonalIn, Orientation.landscape, 1, null);
    }

    private final DeviceEnumValueBuilder addAutoDevice(int widthPx, int heightPx, double diagonalIn) {
        return DeviceEnumValueBuilder.addDevicePx$default(this, null, DeviceClass.Auto, widthPx, heightPx, diagonalIn, Orientation.landscape, 1, null);
    }

    @NotNull
    public final DeviceEnumValueBuilder addPhone(@NotNull Device device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        String string = device.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
        String string2 = device.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getId(...)");
        return this.addPhoneById(string, string2);
    }

    @NotNull
    public final DeviceEnumValueBuilder addTablet(@NotNull Device device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        String string = device.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
        String string2 = device.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getId(...)");
        return this.addTabletById(string, string2);
    }

    @NotNull
    public final DeviceEnumValueBuilder addWear(@NotNull Device device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        String string = device.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
        String string2 = device.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getId(...)");
        return this.addById(string, string2, DeviceClass.Wear);
    }

    @NotNull
    public final DeviceEnumValueBuilder addTv(@NotNull Device device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        String string = device.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
        String string2 = device.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getId(...)");
        return this.addById(string, string2, DeviceClass.Tv);
    }

    @NotNull
    public final DeviceEnumValueBuilder addAuto(@NotNull Device device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        String string = device.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
        String string2 = device.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getId(...)");
        return this.addById(string, string2, DeviceClass.Auto);
    }

    @NotNull
    public final DeviceEnumValueBuilder addGeneric(@NotNull Device device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        String string = device.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
        String string2 = device.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getId(...)");
        return this.addGenericById(string, string2);
    }

    @NotNull
    public final DeviceEnumValueBuilder addXr(@NotNull Device device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        String string = device.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
        String string2 = device.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getId(...)");
        return this.addById(string, string2, DeviceClass.Xr);
    }

    @NotNull
    public final DeviceEnumValueBuilder addDesktop(@NotNull Device device) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        String string = device.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDisplayName(...)");
        String string2 = device.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getId(...)");
        return this.addById(string, string2, DeviceClass.Desktop);
    }

    private final DeviceEnumValueBuilder addPhoneById(String displayName, String id) {
        return this.addById(displayName, id, DeviceClass.Phone);
    }

    private final DeviceEnumValueBuilder addTabletById(String displayName, String id) {
        return this.addById(displayName, id, DeviceClass.Tablet);
    }

    private final DeviceEnumValueBuilder addGenericById(String displayName, String id) {
        return this.addById(displayName, id, DeviceClass.Generic);
    }

    private final DeviceEnumValueBuilder addById(String displayName, String id, DeviceClass type) {
        DeviceEnumValueBuilder deviceEnumValueBuilder;
        block0: {
            DeviceEnumValueBuilder $this$addById_u24lambda_u244 = deviceEnumValueBuilder = this;
            boolean bl = false;
            PsiEnumValueImpl enumValue = PsiEnumValue.Companion.indented("id:" + id, displayName, EditorPickerEvent.EditorPickerAction.PreviewPickerModification.PreviewPickerValue.DEVICE_REF_NONE);
            List<PsiEnumValue> list = $this$addById_u24lambda_u244.deviceEnumValues.get((Object)type);
            if (list == null) break block0;
            list.add(enumValue);
        }
        return deviceEnumValueBuilder;
    }

    @NotNull
    public final List<EnumValue> includeDefaultsAndBuild() {
        this.addDefaultsIfMissing();
        List enumValues = new ArrayList();
        Iterable $this$forEach$iv = this.deviceEnumValues.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List<PsiEnumValue> values;
            DeviceClass type = (DeviceClass)((Object)element$iv);
            boolean bl = false;
            List<PsiEnumValue> list = values = this.deviceEnumValues.get((Object)type);
            boolean bl2 = list != null ? !((Collection)list).isEmpty() : false;
            if (!bl2) continue;
            if (!((Collection)enumValues).isEmpty()) {
                enumValues.add(EnumValue.Companion.getSEPARATOR());
            }
            enumValues.add(EnumValue.Companion.header(type.getDisplay(), type.getIcon()));
            Iterable $this$forEach$iv2 = values;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                EnumValue p0 = (EnumValue)element$iv2;
                boolean bl3 = false;
                enumValues.add(p0);
            }
        }
        return enumValues;
    }

    private final void addDefaultsIfMissing() {
        block19: {
            block18: {
                block17: {
                    block16: {
                        block15: {
                            block14: {
                                block13: {
                                    block12: {
                                        if (!this.deviceEnumValues.containsKey((Object)DeviceClass.ReferenceDevice)) break block12;
                                        List<PsiEnumValue> list = this.deviceEnumValues.get((Object)DeviceClass.ReferenceDevice);
                                        boolean bl = list != null ? list.isEmpty() : false;
                                        if (!bl) break block13;
                                    }
                                    this.addReferenceDevice("Medium Phone", "This reference device uses the COMPACT width size class, which represents 99% of Android phones in portrait orientation.", ReferenceConfigsKt.getReferencePhoneConfig(), EditorPickerEvent.EditorPickerAction.PreviewPickerModification.PreviewPickerValue.DEVICE_REF_PHONE);
                                    this.addReferenceDevice("Foldable", "This reference device uses the MEDIUM width size class, which represents foldables in unfolded portrait orientation, or 94% of all tablets in portrait orientation.", ReferenceConfigsKt.getReferenceFoldableConfig(), EditorPickerEvent.EditorPickerAction.PreviewPickerModification.PreviewPickerValue.DEVICE_REF_FOLDABLE);
                                    this.addReferenceDevice("Medium Tablet", "This reference device uses the EXPANDED width size class, which represents 97% of Android tablets in landscape orientation.", ReferenceConfigsKt.getReferenceTabletConfig(), EditorPickerEvent.EditorPickerAction.PreviewPickerModification.PreviewPickerValue.DEVICE_REF_TABLET);
                                    this.addReferenceDevice("Desktop", "This reference device uses the EXPANDED width size class, which represents 97% of Android desktops in landscape orientation.", ReferenceConfigsKt.getReferenceDesktopConfig(), EditorPickerEvent.EditorPickerAction.PreviewPickerModification.PreviewPickerValue.DEVICE_REF_DESKTOP);
                                }
                                if (!this.deviceEnumValues.containsKey((Object)DeviceClass.Wear)) break block14;
                                List<PsiEnumValue> list = this.deviceEnumValues.get((Object)DeviceClass.Wear);
                                boolean bl = list != null ? list.isEmpty() : false;
                                if (!bl) break block15;
                            }
                            this.addWearDevice(false, 0, "Square");
                            this.addWearDevice(true, 0, "Round");
                            this.addWearDevice(true, 30, "Round Chin");
                        }
                        if (!this.deviceEnumValues.containsKey((Object)DeviceClass.Tv)) break block16;
                        List<PsiEnumValue> list = this.deviceEnumValues.get((Object)DeviceClass.Tv);
                        boolean bl = list != null ? list.isEmpty() : false;
                        if (!bl) break block17;
                    }
                    this.addTvDevice(3840, 2160, 55.0);
                    this.addTvDevice(1920, 1080, 55.0);
                    this.addTvDevice(1280, 720, 55.0);
                }
                if (!this.deviceEnumValues.containsKey((Object)DeviceClass.Auto)) break block18;
                List<PsiEnumValue> list = this.deviceEnumValues.get((Object)DeviceClass.Auto);
                boolean bl = list != null ? list.isEmpty() : false;
                if (!bl) break block19;
            }
            this.addAutoDevice(1024, 768, 8.4);
        }
    }
}

