/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.pickers.common.editingsupport;

import com.android.tools.adtui.model.stdui.EditingErrorCategory;
import com.android.tools.adtui.model.stdui.EditingSupportKt;
import com.android.tools.idea.compose.preview.ComposePreviewBundle;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\u001a;\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\n\u001a\f\u0010\u000b\u001a\u00020\u0006*\u00020\u0003H\u0002\u00a8\u0006\f"}, d2={"validateFloat", "Lkotlin/Pair;", "Lcom/android/tools/adtui/model/stdui/EditingErrorCategory;", "", "editedValue", "validateSuffix", "", "canBeZero", "maxValueAllowed", "", "(Ljava/lang/String;ZZLjava/lang/Float;)Lkotlin/Pair;", "isValidFloatFormat", "intellij.android.compose-designer"})
public final class FloatValidationUtilKt {
    @NotNull
    public static final Pair<EditingErrorCategory, String> validateFloat(@NotNull String editedValue, boolean validateSuffix, boolean canBeZero, @Nullable Float maxValueAllowed) {
        Intrinsics.checkNotNullParameter((Object)editedValue, (String)"editedValue");
        if (StringsKt.isBlank((CharSequence)editedValue)) {
            return EditingSupportKt.EDITOR_NO_ERROR;
        }
        String trimmedValue = ((Object)StringsKt.trim((CharSequence)editedValue)).toString();
        Float f = StringsKt.toFloatOrNull((String)trimmedValue);
        if (f == null) {
            return new Pair((Object)EditingErrorCategory.ERROR, (Object)ComposePreviewBundle.message("picker.preview.input.validation.float.nan", new Object[0]));
        }
        float numberValue = f.floatValue();
        if (numberValue < 0.0f) {
            return new Pair((Object)EditingErrorCategory.ERROR, (Object)ComposePreviewBundle.message("picker.preview.input.validation.positive.value", new Object[0]));
        }
        if (numberValue < 0.5f && !canBeZero) {
            return new Pair((Object)EditingErrorCategory.ERROR, (Object)ComposePreviewBundle.message("picker.preview.input.validation.positive.value", new Object[0]));
        }
        Float f2 = maxValueAllowed;
        if (f2 != null) {
            float max = ((Number)f2).floatValue();
            boolean bl = false;
            if (numberValue > max) {
                Object[] objectArray = new Object[]{maxValueAllowed};
                return new Pair((Object)EditingErrorCategory.ERROR, (Object)ComposePreviewBundle.message("picker.preview.input.validation.too.big.value", objectArray));
            }
        }
        if (validateSuffix && !FloatValidationUtilKt.isValidFloatFormat(trimmedValue)) {
            return new Pair((Object)EditingErrorCategory.WARNING, (Object)ComposePreviewBundle.message("picker.preview.input.validation.float.format", new Object[0]));
        }
        return EditingSupportKt.EDITOR_NO_ERROR;
    }

    public static /* synthetic */ Pair validateFloat$default(String string, boolean bl, boolean bl2, Float f, int n, Object object) {
        if ((n & 8) != 0) {
            f = null;
        }
        return FloatValidationUtilKt.validateFloat(string, bl, bl2, f);
    }

    private static final boolean isValidFloatFormat(String $this$isValidFloatFormat) {
        int suffixOffset;
        return Character.isDigit(StringsKt.last((CharSequence)$this$isValidFloatFormat)) || (suffixOffset = StringsKt.indexOf$default((CharSequence)$this$isValidFloatFormat, (char)'f', (int)0, (boolean)false, (int)6, null)) > 0 && Character.isDigit($this$isValidFloatFormat.charAt(suffixOffset - 1));
    }
}

