/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.pickers.common.editingsupport;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.adtui.model.stdui.EditingErrorCategory;
import com.android.tools.adtui.model.stdui.EditingSupportKt;
import com.android.tools.idea.compose.preview.ComposePreviewBundle;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c1\u0002\u0018\u00002/\u0012\u0015\u0012\u0013\u0018\u00010\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00020\u00060\u0001j\u0002`\bB\t\b\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00020\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0002H\u0096\u0002\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/compose/pickers/common/editingsupport/ColorValidation;", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "editedValue", "Lkotlin/Pair;", "Lcom/android/tools/adtui/model/stdui/EditingErrorCategory;", "Lcom/android/tools/adtui/model/stdui/EditingValidation;", "<init>", "()V", "invoke", "intellij.android.compose-designer"})
@StabilityInferred(parameters=1)
public final class ColorValidation
implements Function1<String, Pair<? extends EditingErrorCategory, ? extends String>> {
    @NotNull
    public static final ColorValidation INSTANCE = new ColorValidation();
    public static final int $stable;

    private ColorValidation() {
    }

    @NotNull
    public Pair<EditingErrorCategory, String> invoke(@Nullable String editedValue) {
        CharSequence charSequence = editedValue;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return EditingSupportKt.EDITOR_NO_ERROR;
        }
        String trimmedValue = ((Object)StringsKt.trim((CharSequence)editedValue)).toString();
        String colorHexValue = StringsKt.replace((String)trimmedValue, (String)"0x", (String)"", (boolean)true);
        if (StringsKt.contains((CharSequence)trimmedValue, (CharSequence)"0x", (boolean)true) && !StringsKt.startsWith((String)trimmedValue, (String)"0x", (boolean)true)) {
            return new Pair((Object)EditingErrorCategory.ERROR, (Object)ComposePreviewBundle.message("picker.preview.input.validation.color.format", new Object[0]));
        }
        Long l = StringsKt.toLongOrNull((String)colorHexValue, (int)16);
        if (l == null) {
            return new Pair((Object)EditingErrorCategory.ERROR, (Object)ComposePreviewBundle.message("picker.preview.input.validation.color.format", new Object[0]));
        }
        long colorValue = l;
        if (colorValue > 0xFFFFFFFFL) {
            return new Pair((Object)EditingErrorCategory.ERROR, (Object)ComposePreviewBundle.message("picker.preview.input.validation.color.max", new Object[0]));
        }
        if (colorValue < 0L) {
            return new Pair((Object)EditingErrorCategory.ERROR, (Object)ComposePreviewBundle.message("picker.preview.input.validation.color.negative", new Object[0]));
        }
        if (colorHexValue.length() <= 6) {
            return new Pair((Object)EditingErrorCategory.WARNING, (Object)ComposePreviewBundle.message("picker.preview.input.validation.color.alpha", new Object[0]));
        }
        return EditingSupportKt.EDITOR_NO_ERROR;
    }
}

