/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.error;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.idea.common.error.Issue;
import com.android.tools.idea.common.error.IssueSource;
import com.intellij.lang.annotation.HighlightSeverity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/common/error/TooManyIssuesIssue;", "Lcom/android/tools/idea/common/error/Issue;", "extraIssuesCount", "", "<init>", "(I)V", "source", "Lcom/android/tools/idea/common/error/IssueSource;", "getSource", "()Lcom/android/tools/idea/common/error/IssueSource;", "summary", "", "getSummary", "()Ljava/lang/String;", "description", "getDescription", "category", "getCategory", "severity", "Lcom/intellij/lang/annotation/HighlightSeverity;", "getSeverity", "()Lcom/intellij/lang/annotation/HighlightSeverity;", "intellij.android.designer"})
@StabilityInferred(parameters=0)
public final class TooManyIssuesIssue
extends Issue {
    @NotNull
    private final IssueSource source = IssueSource.NONE;
    @NotNull
    private final String summary;
    @NotNull
    private final String description;
    @NotNull
    private final String category;
    @NotNull
    private final HighlightSeverity severity;
    public static final int $stable = 8;

    public TooManyIssuesIssue(int extraIssuesCount) {
        this.summary = "Too many issues found. " + extraIssuesCount + " not shown.";
        this.description = StringsKt.trimIndent((String)("\n    Too many issues were found in this preview, not all of them will be shown in this panel.\n    " + extraIssuesCount + " were found and not displayed.\n  "));
        this.category = "";
        HighlightSeverity highlightSeverity = HighlightSeverity.WEAK_WARNING;
        Intrinsics.checkNotNullExpressionValue((Object)highlightSeverity, (String)"WEAK_WARNING");
        this.severity = highlightSeverity;
    }

    @Override
    @NotNull
    public IssueSource getSource() {
        return this.source;
    }

    @Override
    @NotNull
    public String getSummary() {
        return this.summary;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public String getCategory() {
        return this.category;
    }

    @Override
    @NotNull
    public HighlightSeverity getSeverity() {
        return this.severity;
    }
}

