/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.error;

import com.android.tools.idea.common.error.Issue;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.rendering.errors.ui.MessageTip;
import com.android.tools.idea.uibuilder.error.RenderIssueProvider;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintRenderIssue;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.ui.DescriptionEditorPane;
import com.intellij.profile.codeInspection.ui.DescriptionEditorPaneKt;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\"\u0010\u0014\u001a\u0004\u0018\u00010\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\u001a\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\u0014\u0010\u001c\u001a\u00020\r*\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u001dH\u0002J\b\u0010\u001f\u001a\u00020\u0011H\u0002J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u0018\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020\u00012\u0006\u0010(\u001a\u00020)H\u0002J\u0018\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00132\u0006\u0010-\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/android/tools/idea/common/error/DesignerCommonIssueDetailPanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "project", "Lcom/intellij/openapi/project/Project;", "issue", "Lcom/android/tools/idea/common/error/Issue;", "fixWithAiActionProvider", "Lkotlin/Function0;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/common/error/Issue;Lkotlin/jvm/functions/Function0;)V", "uiDataSnapshot", "", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "createTitle", "Lcom/intellij/ui/components/JBLabel;", "createContent", "Ljavax/swing/JComponent;", "createBottomPanel", "tips", "", "Lcom/android/tools/idea/rendering/errors/ui/MessageTip;", "hyperlinkListener", "Ljavax/swing/event/HyperlinkListener;", "createMessageTip", "tip", "addVisualRenderIssue", "Lcom/android/tools/idea/uibuilder/visual/visuallint/VisualLintRenderIssue;", "createAffectedFilePanel", "createAffectedFilesTitle", "createAffectedFileLink", "Lcom/intellij/ui/components/ActionLink;", "projectBasePath", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "addFixWithAiButton", "panel", "offSetBottom", "", "createToolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "targetComponent", "fixWithAiAction", "intellij.android.designer"})
@SourceDebugExtension(value={"SMAP\nDesignerCommonIssueSidePanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesignerCommonIssueSidePanel.kt\ncom/android/tools/idea/common/error/DesignerCommonIssueDetailPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,275:1\n1#2:276\n1869#3,2:277\n1869#3,2:279\n*S KotlinDebug\n*F\n+ 1 DesignerCommonIssueSidePanel.kt\ncom/android/tools/idea/common/error/DesignerCommonIssueDetailPanel\n*L\n175#1:277,2\n219#1:279,2\n*E\n"})
final class DesignerCommonIssueDetailPanel
extends JPanel
implements UiDataProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final Issue issue;
    @NotNull
    private final Function0<AnAction> fixWithAiActionProvider;

    public DesignerCommonIssueDetailPanel(@NotNull Project project, @NotNull Issue issue, @NotNull Function0<? extends AnAction> fixWithAiActionProvider) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
            Intrinsics.checkNotNullParameter(fixWithAiActionProvider, (String)"fixWithAiActionProvider");
            super(new BorderLayout());
            this.project = project;
            this.issue = issue;
            this.fixWithAiActionProvider = fixWithAiActionProvider;
            this.setBorder((Border)JBUI.Borders.empty((int)18, (int)12, (int)0, (int)0));
            this.add((Component)this.createTitle(), "North");
            this.add((Component)this.createContent(), "Center");
            JComponent jComponent = this.createBottomPanel(this.issue.getMessageTips(), this.issue.getHyperlinkListener());
            if (jComponent == null) break block0;
            JComponent it = jComponent;
            boolean bl = false;
            this.add((Component)it, "South");
        }
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        DataKey dataKey = PlatformDataKeys.VIRTUAL_FILE;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"VIRTUAL_FILE");
        sink.set(dataKey, CollectionsKt.firstOrNull((Iterable)this.issue.getSource().getFiles()));
    }

    private final JBLabel createTitle() {
        JBLabel jBLabel;
        JBLabel $this$createTitle_u24lambda_u241 = jBLabel = new JBLabel(this.issue.getSummary());
        boolean bl = false;
        $this$createTitle_u24lambda_u241.setFont($this$createTitle_u24lambda_u241.getFont().deriveFont(1));
        return jBLabel;
    }

    private final JComponent createContent() {
        JBScrollPane jBScrollPane;
        DescriptionEditorPane descriptionPane = new DescriptionEditorPane();
        descriptionPane.addHyperlinkListener(this.issue.getHyperlinkListener());
        descriptionPane.setAlignmentX(0.0f);
        DescriptionEditorPaneKt.readHTML((JEditorPane)((JEditorPane)descriptionPane), (String)("<html><body>" + this.issue.getDescription() + "</body></html>"));
        if (this.issue instanceof VisualLintRenderIssue) {
            JBScrollPane jBScrollPane2;
            JPanel contentPanel = new JPanel(new BorderLayout());
            contentPanel.add((Component)descriptionPane, "North");
            this.addVisualRenderIssue(contentPanel, (VisualLintRenderIssue)this.issue);
            JBScrollPane $this$createContent_u24lambda_u242 = jBScrollPane2 = new JBScrollPane((Component)contentPanel, 20, 31);
            boolean bl = false;
            $this$createContent_u24lambda_u242.setBorder((Border)JBUI.Borders.emptyTop((int)12));
            return (JComponent)jBScrollPane2;
        }
        JPanel contentPanel = new JPanel((LayoutManager)new VerticalLayout(0));
        if (this.issue instanceof RenderIssueProvider.NlRenderIssueWrapper && ((Boolean)StudioFlags.COMPOSE_RENDER_ERROR_FIX_WITH_AI.get()).booleanValue()) {
            this.addFixWithAiButton(contentPanel, true);
        }
        contentPanel.add((Component)descriptionPane);
        JBScrollPane $this$createContent_u24lambda_u243 = jBScrollPane = new JBScrollPane((Component)contentPanel, 20, 31);
        boolean bl = false;
        $this$createContent_u24lambda_u243.setBorder((Border)JBUI.Borders.emptyTop((int)12));
        return (JComponent)jBScrollPane;
    }

    private final JComponent createBottomPanel(List<MessageTip> tips, HyperlinkListener hyperlinkListener) {
        JBPanel jBPanel;
        if (tips.isEmpty()) {
            return null;
        }
        JBPanel $this$createBottomPanel_u24lambda_u245 = jBPanel = new JBPanel((LayoutManager)new VerticalLayout(1));
        boolean bl = false;
        $this$createBottomPanel_u24lambda_u245.setBorder((Border)JBUI.Borders.empty((int)3, (int)2));
        Iterable $this$forEach$iv = tips;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MessageTip it = (MessageTip)element$iv;
            boolean bl2 = false;
            $this$createBottomPanel_u24lambda_u245.add((Component)this.createMessageTip(it, hyperlinkListener));
        }
        return (JComponent)jBPanel;
    }

    /*
     * WARNING - void declaration
     */
    private final JComponent createMessageTip(MessageTip tip, HyperlinkListener hyperlinkListener) {
        void $this$createMessageTip_u24lambda_u247_u24lambda_u246;
        Object object;
        JBPanel jBPanel;
        JBPanel $this$createMessageTip_u24lambda_u247 = jBPanel = new JBPanel((LayoutManager)new HorizontalLayout(1, 0, 2, null));
        boolean bl = false;
        JBLabel jBLabel = object = new JBLabel(tip.getIcon());
        JBPanel jBPanel2 = $this$createMessageTip_u24lambda_u247;
        boolean bl2 = false;
        $this$createMessageTip_u24lambda_u247_u24lambda_u246.setVerticalAlignment(1);
        $this$createMessageTip_u24lambda_u247_u24lambda_u246.setBorder(JBUI.Borders.empty((int)3));
        jBPanel2.add((Component)object);
        object = tip.getHtmlText();
        $this$createMessageTip_u24lambda_u247.add((Component)new JBLabel(hyperlinkListener, (String)object){
            final /* synthetic */ HyperlinkListener $hyperlinkListener;
            {
                this.$hyperlinkListener = $hyperlinkListener;
                super($super_call_param$1);
                this.setAllowAutoWrapping(true);
                this.setCopyable(true);
            }

            protected HyperlinkListener createHyperlinkListener() {
                HyperlinkListener hyperlinkListener = this.$hyperlinkListener;
                if (hyperlinkListener == null) {
                    HyperlinkListener hyperlinkListener2 = super.createHyperlinkListener();
                    hyperlinkListener = hyperlinkListener2;
                    Intrinsics.checkNotNullExpressionValue((Object)hyperlinkListener2, (String)"createHyperlinkListener(...)");
                }
                return hyperlinkListener;
            }
        });
        return (JComponent)jBPanel;
    }

    private final void addVisualRenderIssue(JPanel $this$addVisualRenderIssue, VisualLintRenderIssue issue) {
        JPanel affectedFilePanel = this.createAffectedFilePanel(issue);
        if (((Boolean)StudioFlags.COMPOSE_UI_CHECK_FIX_WITH_AI.get()).booleanValue()) {
            this.addFixWithAiButton(affectedFilePanel, false);
        }
        $this$addVisualRenderIssue.add((Component)affectedFilePanel, "Center");
    }

    private final JPanel createAffectedFilePanel(VisualLintRenderIssue issue) {
        JPanel jPanel;
        String string = this.project.getBasePath();
        if (string == null) {
            return new JPanel();
        }
        String projectBasePath = string;
        List<VirtualFile> relatedFiles = issue.getAffectedFilesWithNavigatable();
        if (relatedFiles.isEmpty()) {
            return new JPanel();
        }
        JPanel $this$createAffectedFilePanel_u24lambda_u249 = jPanel = new JPanel();
        boolean bl = false;
        $this$createAffectedFilePanel_u24lambda_u249.setBorder((Border)JBUI.Borders.empty((int)4, (int)0));
        $this$createAffectedFilePanel_u24lambda_u249.setLayout(new BoxLayout($this$createAffectedFilePanel_u24lambda_u249, 1));
        $this$createAffectedFilePanel_u24lambda_u249.add((Component)this.createAffectedFilesTitle());
        Iterable $this$forEach$iv = relatedFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile file2 = (VirtualFile)element$iv;
            boolean bl2 = false;
            ActionLink link = this.createAffectedFileLink(projectBasePath, file2);
            ToolTipManager.sharedInstance().registerComponent((JComponent)link);
            $this$createAffectedFilePanel_u24lambda_u249.add((Component)link);
        }
        return jPanel;
    }

    private final JBLabel createAffectedFilesTitle() {
        JBLabel jBLabel;
        JBLabel $this$createAffectedFilesTitle_u24lambda_u2410 = jBLabel = new JBLabel("Affected Files:");
        boolean bl = false;
        $this$createAffectedFilesTitle_u24lambda_u2410.setFont($this$createAffectedFilesTitle_u24lambda_u2410.getFont().deriveFont(1));
        $this$createAffectedFilesTitle_u24lambda_u2410.setAlignmentX(0.0f);
        $this$createAffectedFilesTitle_u24lambda_u2410.setBorder((Border)JBUI.Borders.empty((int)4, (int)0));
        return jBLabel;
    }

    private final ActionLink createAffectedFileLink(String projectBasePath, VirtualFile file2) {
        String string = FileUtilRt.getRelativePath((String)projectBasePath, (String)file2.getPath(), (char)File.separatorChar, (boolean)true);
        if (string == null) {
            String string2 = file2.getPath();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        }
        String pathToDisplay = string;
        Object object = arg_0 -> DesignerCommonIssueDetailPanel.createAffectedFileLink$lambda$11(this, file2, arg_0);
        Object $this$createAffectedFileLink_u24lambda_u2412 = object = new ActionLink(pathToDisplay, (Function1<? super ActionEvent, Unit>)object){
            final /* synthetic */ String $pathToDisplay;
            {
                this.$pathToDisplay = $pathToDisplay;
                super($pathToDisplay, $super_call_param$1);
            }

            public String getToolTipText() {
                return this.getSize().width < this.getMinimumSize().width ? this.$pathToDisplay : null;
            }
        };
        boolean bl = false;
        $this$createAffectedFileLink_u24lambda_u2412.setAlignmentX(0.0f);
        return (ActionLink)object;
    }

    private final void addFixWithAiButton(JPanel panel, boolean offSetBottom) {
        block0: {
            JPanel jPanel;
            AnAction anAction = (AnAction)this.fixWithAiActionProvider.invoke();
            if (anAction == null) break block0;
            AnAction it = anAction;
            boolean bl = false;
            ActionToolbar actionToolbar = this.createToolbar(panel, it);
            JPanel $this$addFixWithAiButton_u24lambda_u2414_u24lambda_u2413 = jPanel = new JPanel(new FlowLayout(0, 0, 0));
            boolean bl2 = false;
            $this$addFixWithAiButton_u24lambda_u2414_u24lambda_u2413.setAlignmentX(0.0f);
            $this$addFixWithAiButton_u24lambda_u2414_u24lambda_u2413.setBorder(offSetBottom ? (Border)JBUI.Borders.emptyBottom((int)8) : (Border)JBUI.Borders.emptyTop((int)8));
            $this$addFixWithAiButton_u24lambda_u2414_u24lambda_u2413.add(actionToolbar.getComponent());
            $this$addFixWithAiButton_u24lambda_u2414_u24lambda_u2413.add(Box.createVerticalGlue());
            JPanel toolbarWrapper = jPanel;
            panel.add(toolbarWrapper);
        }
    }

    private final ActionToolbar createToolbar(JComponent targetComponent, AnAction fixWithAiAction) {
        fixWithAiAction.getTemplatePresentation().putClientProperty(ActionUtil.SHOW_TEXT_IN_TOOLBAR, (Object)true);
        ActionToolbar actionToolbar = new ActionToolbar[]{fixWithAiAction};
        DefaultActionGroup actionGroup = new DefaultActionGroup((AnAction[])actionToolbar);
        ActionToolbar actionToolbar2 = ActionManager.getInstance().createActionToolbar("DesignerCommonIssuesToolbar", (ActionGroup)actionGroup, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar2, (String)"createActionToolbar(...)");
        ActionToolbar $this$createToolbar_u24lambda_u2415 = actionToolbar = actionToolbar2;
        boolean bl = false;
        $this$createToolbar_u24lambda_u2415.setTargetComponent(targetComponent);
        $this$createToolbar_u24lambda_u2415.getComponent().setOpaque(true);
        $this$createToolbar_u24lambda_u2415.getComponent().setBorder((Border)JBUI.Borders.empty());
        return actionToolbar;
    }

    private static final Unit createAffectedFileLink$lambda$11(DesignerCommonIssueDetailPanel this$0, VirtualFile $file, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        new OpenFileDescriptor(this$0.project, $file).navigateInEditor(this$0.project, true);
        return Unit.INSTANCE;
    }
}

