/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.diagnostics;

import com.android.tools.idea.common.diagnostics.NlDiagnosticsRead;
import com.android.tools.idea.common.diagnostics.NlDiagnosticsWrite;
import com.google.common.collect.EvictingQueue;
import com.google.common.math.Quantiles;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0016J\b\u0010\f\u001a\u00020\u0007H\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007H\u0016J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R2\u0010\u0005\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007 \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/common/diagnostics/NlDiagnosticsImpl;", "Lcom/android/tools/idea/common/diagnostics/NlDiagnosticsRead;", "Lcom/android/tools/idea/common/diagnostics/NlDiagnosticsWrite;", "<init>", "()V", "lastRenderTimes", "Lcom/google/common/collect/EvictingQueue;", "", "kotlin.jvm.PlatformType", "lastRenderImageBytes", "lastRenders", "", "lastRenderImageSize", "recordRender", "", "timeMs", "lastRenderSizeBytes", "renderTime", "percentile", "", "intellij.android.designer"})
final class NlDiagnosticsImpl
implements NlDiagnosticsRead,
NlDiagnosticsWrite {
    private final EvictingQueue<Long> lastRenderTimes = EvictingQueue.create((int)100);
    private long lastRenderImageBytes = -1L;

    @Override
    @NotNull
    public List<Long> lastRenders() {
        EvictingQueue<Long> evictingQueue = this.lastRenderTimes;
        Intrinsics.checkNotNullExpressionValue(evictingQueue, (String)"lastRenderTimes");
        return CollectionsKt.toList((Iterable)((Iterable)evictingQueue));
    }

    @Override
    public long lastRenderImageSize() {
        return this.lastRenderImageBytes;
    }

    @Override
    public void recordRender(long timeMs, long lastRenderSizeBytes) {
        this.lastRenderTimes.add((Object)timeMs);
        this.lastRenderImageBytes = lastRenderSizeBytes;
    }

    @Override
    public long renderTime(int percentile) {
        return this.lastRenderTimes.size() > 0 ? (long)Quantiles.percentiles().index(percentile).compute((Collection)this.lastRenderTimes) : -1L;
    }
}

