/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.assistant;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.analytics.UsageTracker;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.DesignEditorHelpPanelEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\rJ\u0006\u0010\u000f\u001a\u00020\rJ\u0006\u0010\u0010\u001a\u00020\rJ\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0017J\u0018\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/common/assistant/AssistantPanelMetricsTracker;", "", "type", "Lcom/google/wireless/android/sdk/stats/DesignEditorHelpPanelEvent$HelpPanelType;", "<init>", "(Lcom/google/wireless/android/sdk/stats/DesignEditorHelpPanelEvent$HelpPanelType;)V", "timer", "Lcom/google/common/base/Stopwatch;", "getTimer$annotations", "()V", "getTimer", "()Lcom/google/common/base/Stopwatch;", "logOpen", "", "logClose", "logButtonClicked", "logReachedEnd", "logEvent", "event", "Lcom/google/wireless/android/sdk/stats/DesignEditorHelpPanelEvent$Builder;", "createEventBuilder", "action", "Lcom/google/wireless/android/sdk/stats/DesignEditorHelpPanelEvent$HelpPanelAction;", "intellij.android.designer"})
@StabilityInferred(parameters=0)
public class AssistantPanelMetricsTracker {
    @NotNull
    private final DesignEditorHelpPanelEvent.HelpPanelType type;
    @NotNull
    private final Stopwatch timer;
    public static final int $stable = 8;

    public AssistantPanelMetricsTracker(@NotNull DesignEditorHelpPanelEvent.HelpPanelType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.type = type;
        Stopwatch stopwatch = Stopwatch.createUnstarted();
        Intrinsics.checkNotNullExpressionValue((Object)stopwatch, (String)"createUnstarted(...)");
        this.timer = stopwatch;
    }

    @NotNull
    public final Stopwatch getTimer() {
        return this.timer;
    }

    @VisibleForTesting
    public static /* synthetic */ void getTimer$annotations() {
    }

    public final void logOpen() {
        if (this.timer.isRunning()) {
            this.timer.stop().reset();
        }
        DesignEditorHelpPanelEvent.Builder event = this.createEventBuilder(this.type, DesignEditorHelpPanelEvent.HelpPanelAction.OPEN);
        this.timer.start();
        this.logEvent(event);
    }

    public final void logClose() {
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
        DesignEditorHelpPanelEvent.Builder event = this.createEventBuilder(this.type, DesignEditorHelpPanelEvent.HelpPanelAction.CLOSE);
        event.setTimeToCloseMs(this.timer.elapsed().toMillis());
        this.logEvent(event);
    }

    public final void logButtonClicked() {
        DesignEditorHelpPanelEvent.Builder event = this.createEventBuilder(this.type, DesignEditorHelpPanelEvent.HelpPanelAction.BUTTON_CLICKED);
        this.logEvent(event);
    }

    public final void logReachedEnd() {
        DesignEditorHelpPanelEvent.Builder event = this.createEventBuilder(this.type, DesignEditorHelpPanelEvent.HelpPanelAction.REACHED_END);
        this.logEvent(event);
    }

    @VisibleForTesting
    public void logEvent(@NotNull DesignEditorHelpPanelEvent.Builder event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        AndroidStudioEvent.Builder builder = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.DESIGN_EDITOR_HELP_PANEL_EVENT).setDesignEditorHelpPanelEvent(event);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setDesignEditorHelpPanelEvent(...)");
        UsageTracker.log((AndroidStudioEvent.Builder)builder);
    }

    private final DesignEditorHelpPanelEvent.Builder createEventBuilder(DesignEditorHelpPanelEvent.HelpPanelType type, DesignEditorHelpPanelEvent.HelpPanelAction action2) {
        DesignEditorHelpPanelEvent.Builder builder = DesignEditorHelpPanelEvent.newBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder(...)");
        DesignEditorHelpPanelEvent.Builder event = builder;
        event.setHelpPanelType(type);
        event.setAction(action2);
        return event;
    }
}

