/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.analytics;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.analytics.UsageTracker;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u0001*\b\b\u0001\u0010\u0002*\u00020\u00032\u00020\u0004B7\u0012&\u0010\u0005\u001a\"\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00018\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0010\n\u001a\u00028\u0000\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u0013\u001a\u00028\u00002\b\u0010\u0014\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0015\u001a\u00020\u0016H\u0007\u00a2\u0006\u0002\u0010\u0017J\u0015\u0010\u0018\u001a\u00028\u00002\b\u0010\u0014\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\u0002\u0010\u0019J\u001d\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00028\u00012\u0006\u0010\u001c\u001a\u00028\u0000H\u0007\u00a2\u0006\u0002\u0010\u001dJ\u0015\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00028\u0001H\u0007\u00a2\u0006\u0002\u0010\u001fR.\u0010\u0005\u001a\"\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00018\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rRN\u0010\u000e\u001aB\u0012\f\u0012\n \u0010*\u0004\u0018\u00018\u00018\u0001\u0012\f\u0012\n \u0010*\u0004\u0018\u00018\u00008\u0000 \u0010* \u0012\f\u0012\n \u0010*\u0004\u0018\u00018\u00018\u0001\u0012\f\u0012\n \u0010*\u0004\u0018\u00018\u00008\u0000\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/android/tools/idea/common/analytics/DesignerUsageTrackerManager;", "T", "K", "Lcom/intellij/openapi/Disposable;", "", "factory", "Lkotlin/Function3;", "Ljava/util/concurrent/Executor;", "Ljava/util/function/Consumer;", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$Builder;", "nopTracker", "<init>", "(Lkotlin/jvm/functions/Function3;Ljava/lang/Object;)V", "Ljava/lang/Object;", "sTrackersCache", "Lcom/google/common/cache/Cache;", "kotlin.jvm.PlatformType", "ourExecutorService", "Ljava/util/concurrent/ThreadPoolExecutor;", "getInstanceInner", "key", "createIfNotExists", "", "(Lcom/intellij/openapi/Disposable;Z)Ljava/lang/Object;", "getInstance", "(Lcom/intellij/openapi/Disposable;)Ljava/lang/Object;", "setInstanceForTest", "", "tracker", "(Lcom/intellij/openapi/Disposable;Ljava/lang/Object;)V", "cleanAfterTesting", "(Lcom/intellij/openapi/Disposable;)V", "intellij.android.designer"})
@StabilityInferred(parameters=0)
public final class DesignerUsageTrackerManager<T, K extends Disposable> {
    @NotNull
    private final Function3<Executor, K, Consumer<AndroidStudioEvent.Builder>, T> factory;
    private final T nopTracker;
    private final Cache<K, T> sTrackersCache;
    @NotNull
    private final ThreadPoolExecutor ourExecutorService;
    public static final int $stable = 8;

    public DesignerUsageTrackerManager(@NotNull Function3<? super Executor, ? super K, ? super Consumer<AndroidStudioEvent.Builder>, ? extends T> factory, T nopTracker) {
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        this.factory = factory;
        this.nopTracker = nopTracker;
        this.sTrackersCache = CacheBuilder.newBuilder().weakKeys().expireAfterAccess(5L, TimeUnit.MINUTES).build();
        this.ourExecutorService = new ThreadPoolExecutor(0, 1, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue(10));
    }

    @VisibleForTesting
    public final T getInstanceInner(@Nullable K key, boolean createIfNotExists) {
        if (key == null || Disposer.isDisposed(key)) {
            return this.nopTracker;
        }
        return (T)this.sTrackersCache.get(key, () -> DesignerUsageTrackerManager.getInstanceInner$lambda$2(createIfNotExists, this, key));
    }

    public final T getInstance(@Nullable K key) {
        return AnalyticsSettings.getOptedIn() ? this.getInstanceInner(key, !ApplicationManager.getApplication().isUnitTestMode()) : this.nopTracker;
    }

    @TestOnly
    public final void setInstanceForTest(@NotNull K key, T tracker) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        this.sTrackersCache.put(key, tracker);
    }

    @TestOnly
    public final void cleanAfterTesting(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        this.sTrackersCache.put(key, this.nopTracker);
        this.sTrackersCache.invalidate(key);
    }

    private static final void getInstanceInner$lambda$2$lambda$0(AndroidStudioEvent.Builder it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        UsageTracker.log((AndroidStudioEvent.Builder)it);
    }

    private static final void getInstanceInner$lambda$2$lambda$1(DesignerUsageTrackerManager this$0, Disposable $key) {
        this$0.sTrackersCache.invalidate((Object)$key);
    }

    /*
     * WARNING - void declaration
     */
    private static final Object getInstanceInner$lambda$2(boolean $createIfNotExists, DesignerUsageTrackerManager this$0, Disposable $key) {
        Object t;
        if ($createIfNotExists) {
            void var3_3;
            Object newTracker = this$0.factory.invoke((Object)this$0.ourExecutorService, (Object)$key, DesignerUsageTrackerManager::getInstanceInner$lambda$2$lambda$0);
            Disposer.register((Disposable)$key, () -> DesignerUsageTrackerManager.getInstanceInner$lambda$2$lambda$1(this$0, $key));
            t = var3_3;
        } else {
            t = this$0.nopTracker;
        }
        return t;
    }
}

